This directory contains some examples of all-atom simulations using the **AMBER** *(GAFF/GAFF2)* force field, prepared using moltemplate.

### Warning

*As of 2022-8-16,
these examples are in a state of transition.*  (See below.)

Use with caution.
There is no gaurantee that simulations prepared using moltemplate
will exactly reproduce the behavior of AmberTools/AMBER.

If you notice a problem with these examples, please report it.
(jewett.aij @ gmail.com)



### Recommended way to make LT files

As of 2022-8-24, all of the LT files in these examples
were created manually (by me).
This is problematic because I had to obtain the atomic charges by other means
and I had to guess the correct AMBER-specific @atom types for each atom
in the molecule (eg "@atom:ca" in "benzene.lt").
This is not feasible for large, complex molecules.
Instead, I suggest using AmberTools to create MOL2 and FRCMOD files
that define your molecule.  These files MOL2 and FRCMOD files will
hopefully contain reasonable charges and @atom types for your molecule
*(although you should still check them before use)*.
Then convert those files into moltemplate format automatically using
[amber2lt.py](../../../doc/doc_amber2lt.md) and [mol22lt.py](../../../doc/doc_mol22lt.md).

For example, suppose you ran AmberTools and it created a file named "benzene.mol2" and "benzene.frcmod" (and some other files).  You can use *amber2lt.py* and *mol22lt.py* to create all of the moltemplate files you need this way:

```
amber2lt.py --in benzene.frcmod --name MyForceField \
  >> my_force_field.lt

mol22lt.py --in benzene.mol2 \
           --out benzene.lt \
           --name Benzene \
           --ff MyForceField \
           --ff-file my_force_field.lt
```
In this case, the "benzene.lt" file generated by *mol22lt.py*
would resemble this file:
```
import "my_force_field.lt"
Benzene inherits MyForceField {
  write('Data Atoms') {
    $atom:c1  $mol  @atom:ca  -0.112739   -0.739   1.189  -0.00733
    $atom:c2  $mol  @atom:ca  -0.112739    0.614   1.208   0.35167
       :        :        :
  }
  write("Data Bond List") {
    $bond:b1 $atom:C1 $atom:C2
       :
  }
}
```
If you have multiple molecules, you can repeat this process for each of them.
(Each time, you do, your "my_force_field.lt" file will grow larger and larger
 as *amber2lt.py* appends more and more atom types and interaction types
 to the existing file.
 *If you need to make changes to the original FRCMOD file, remember to
 delete the "my_force_field.lt" file before you start over again.*)


### *Unfortunately that is not how I created these examples*

These examples were created before the *amber2lt.py* and *mol22lt.py*
tools were available.  Eventually, I will update these examples to
follow this new protocol.  Meanwhile...


### *The atomic charges in these examples are not correct*

*WARNING: (In many of these examples, I obtained partial charges from the OPLSAA
parameter file located [here](http://dasher.wustl.edu/tinker/distribution/params/oplsaa.prm).)*
***PLEASE DO NOT DO THIS!***
This is not how the AMBER force field was intended to be used.
It will probably not result in accurate behavior.


#### It is the user's responsibility to calculate atomic charges correctly.

Charges are often stored in MOL2 files, which can be generated using

* [RED-server](https://upjv.q4md-forcefieldtools.org)
* [AmberTools](https://ambermd.org/AmberTools.php)
(using a
[variety of methods](http://ambermd.org/tutorials/basic/tutorial4b/index.htm))

Again, once generated, the information in the file (including the charges)
can be extracted using the
[mol22lt.py program](../../../doc/doc_mol22lt.md#mol22ltpy),
which is included with moltemplate.
***(WARNING: This program is experimental as of 2022-8-25.)***

Alternatively, you can try using the [OpenForceField tools](https://github.com/openmm/openmmforcefields#partial-charges-for-small-molecules) to [calculate these charges](https://open-forcefield-toolkit.readthedocs.io/en/latest/api/generated/openforcefield.topology.Molecule.html#openforcefield.topology.Molecule.compute_partial_charges_am1bcc).  The OpenForceField tools are not bundled with moltemplate.  If someone submits a script to help convert the files generated by these tools into moltemplate format, I would be happy post it and update these examples.  (-Andrew 2022-8-25)


### Requirements

The AMBER examples require a version of LAMMPS compiled with support for the optional "EXTRA-MOLECULE" package (because the AMBER force field currently uses *dihedral_style fourier*).  If you encounter the error *"Invalid dihedral_style"*, then see [this page](https://docs.lammps.org/Build_package.html) for instructions to compile LAMMPS to support this package.


### Improper angles

The style of improper interaction used by AMBER force fields depends on an angle which depends on the order of the atoms surrounding the central atom.  When multiple atoms have the same type, this creates ambiguity in atom order.  Since there is no guarantee that moltemplate will choose the same atom order as other molecule builders (such as AmberTools), this can lead to small unavoidable discrepancies in energies and forces computed by LAMMPS and AMBER.  But their effect should be neglegible.

### Bloated lammps input scripts

By default, LAMMPS input scripts prepared using moltemplate contain the entire contents of the GAFF or GAFF2 force-field, even when simulating small systems with just a few atom types.

This is harmless, but if you want to get rid of this extra information, follow the instructions in the "README_remove_irrelevant_info.sh" files.
