# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core import AsyncPipelineClient
from azure.core.rest import AsyncHttpResponse, HttpRequest

from .._serialization import Deserializer, Serializer
from ._configuration import FarmBeatsClientConfiguration
from .operations import (
    ApplicationDataOperations,
    AttachmentsOperations,
    BoundariesOperations,
    CropProductsOperations,
    CropsOperations,
    DeviceDataModelsOperations,
    DevicesOperations,
    FarmOperationsOperations,
    FarmsOperations,
    FieldsOperations,
    HarvestDataOperations,
    ImageProcessingOperations,
    InsightAttachmentsOperations,
    InsightsOperations,
    ManagementZonesOperations,
    ModelInferenceOperations,
    NutrientAnalysesOperations,
    OAuthProvidersOperations,
    OAuthTokensOperations,
    PartiesOperations,
    PlantTissueAnalysesOperations,
    PlantingDataOperations,
    PrescriptionMapsOperations,
    PrescriptionsOperations,
    ScenesOperations,
    SeasonalFieldsOperations,
    SeasonsOperations,
    SensorDataModelsOperations,
    SensorEventsOperations,
    SensorMappingsOperations,
    SensorPartnerIntegrationsOperations,
    SensorsOperations,
    SolutionInferenceOperations,
    TillageDataOperations,
    WeatherDataOperations,
    WeatherOperations,
    ZonesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Dict

    from azure.core.credentials_async import AsyncTokenCredential


class FarmBeatsClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """APIs documentation for Azure AgPlatform DataPlane Service.

    :ivar application_data: ApplicationDataOperations operations
    :vartype application_data: azure.agrifood.farming.aio.operations.ApplicationDataOperations
    :ivar attachments: AttachmentsOperations operations
    :vartype attachments: azure.agrifood.farming.aio.operations.AttachmentsOperations
    :ivar boundaries: BoundariesOperations operations
    :vartype boundaries: azure.agrifood.farming.aio.operations.BoundariesOperations
    :ivar crop_products: CropProductsOperations operations
    :vartype crop_products: azure.agrifood.farming.aio.operations.CropProductsOperations
    :ivar crops: CropsOperations operations
    :vartype crops: azure.agrifood.farming.aio.operations.CropsOperations
    :ivar device_data_models: DeviceDataModelsOperations operations
    :vartype device_data_models: azure.agrifood.farming.aio.operations.DeviceDataModelsOperations
    :ivar devices: DevicesOperations operations
    :vartype devices: azure.agrifood.farming.aio.operations.DevicesOperations
    :ivar farm_operations: FarmOperationsOperations operations
    :vartype farm_operations: azure.agrifood.farming.aio.operations.FarmOperationsOperations
    :ivar farms: FarmsOperations operations
    :vartype farms: azure.agrifood.farming.aio.operations.FarmsOperations
    :ivar fields: FieldsOperations operations
    :vartype fields: azure.agrifood.farming.aio.operations.FieldsOperations
    :ivar harvest_data: HarvestDataOperations operations
    :vartype harvest_data: azure.agrifood.farming.aio.operations.HarvestDataOperations
    :ivar image_processing: ImageProcessingOperations operations
    :vartype image_processing: azure.agrifood.farming.aio.operations.ImageProcessingOperations
    :ivar insight_attachments: InsightAttachmentsOperations operations
    :vartype insight_attachments:
     azure.agrifood.farming.aio.operations.InsightAttachmentsOperations
    :ivar insights: InsightsOperations operations
    :vartype insights: azure.agrifood.farming.aio.operations.InsightsOperations
    :ivar management_zones: ManagementZonesOperations operations
    :vartype management_zones: azure.agrifood.farming.aio.operations.ManagementZonesOperations
    :ivar model_inference: ModelInferenceOperations operations
    :vartype model_inference: azure.agrifood.farming.aio.operations.ModelInferenceOperations
    :ivar nutrient_analyses: NutrientAnalysesOperations operations
    :vartype nutrient_analyses: azure.agrifood.farming.aio.operations.NutrientAnalysesOperations
    :ivar oauth_providers: OAuthProvidersOperations operations
    :vartype oauth_providers: azure.agrifood.farming.aio.operations.OAuthProvidersOperations
    :ivar oauth_tokens: OAuthTokensOperations operations
    :vartype oauth_tokens: azure.agrifood.farming.aio.operations.OAuthTokensOperations
    :ivar parties: PartiesOperations operations
    :vartype parties: azure.agrifood.farming.aio.operations.PartiesOperations
    :ivar planting_data: PlantingDataOperations operations
    :vartype planting_data: azure.agrifood.farming.aio.operations.PlantingDataOperations
    :ivar plant_tissue_analyses: PlantTissueAnalysesOperations operations
    :vartype plant_tissue_analyses:
     azure.agrifood.farming.aio.operations.PlantTissueAnalysesOperations
    :ivar prescription_maps: PrescriptionMapsOperations operations
    :vartype prescription_maps: azure.agrifood.farming.aio.operations.PrescriptionMapsOperations
    :ivar prescriptions: PrescriptionsOperations operations
    :vartype prescriptions: azure.agrifood.farming.aio.operations.PrescriptionsOperations
    :ivar scenes: ScenesOperations operations
    :vartype scenes: azure.agrifood.farming.aio.operations.ScenesOperations
    :ivar seasonal_fields: SeasonalFieldsOperations operations
    :vartype seasonal_fields: azure.agrifood.farming.aio.operations.SeasonalFieldsOperations
    :ivar seasons: SeasonsOperations operations
    :vartype seasons: azure.agrifood.farming.aio.operations.SeasonsOperations
    :ivar sensor_data_models: SensorDataModelsOperations operations
    :vartype sensor_data_models: azure.agrifood.farming.aio.operations.SensorDataModelsOperations
    :ivar sensor_events: SensorEventsOperations operations
    :vartype sensor_events: azure.agrifood.farming.aio.operations.SensorEventsOperations
    :ivar sensor_mappings: SensorMappingsOperations operations
    :vartype sensor_mappings: azure.agrifood.farming.aio.operations.SensorMappingsOperations
    :ivar sensor_partner_integrations: SensorPartnerIntegrationsOperations operations
    :vartype sensor_partner_integrations:
     azure.agrifood.farming.aio.operations.SensorPartnerIntegrationsOperations
    :ivar sensors: SensorsOperations operations
    :vartype sensors: azure.agrifood.farming.aio.operations.SensorsOperations
    :ivar solution_inference: SolutionInferenceOperations operations
    :vartype solution_inference: azure.agrifood.farming.aio.operations.SolutionInferenceOperations
    :ivar tillage_data: TillageDataOperations operations
    :vartype tillage_data: azure.agrifood.farming.aio.operations.TillageDataOperations
    :ivar weather: WeatherOperations operations
    :vartype weather: azure.agrifood.farming.aio.operations.WeatherOperations
    :ivar weather_data: WeatherDataOperations operations
    :vartype weather_data: azure.agrifood.farming.aio.operations.WeatherDataOperations
    :ivar zones: ZonesOperations operations
    :vartype zones: azure.agrifood.farming.aio.operations.ZonesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :keyword endpoint: Service URL. Required. Default value is "".
    :paramtype endpoint: str
    :keyword api_version: Api Version. Default value is "2022-11-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(self, credential: "AsyncTokenCredential", *, endpoint: str = "", **kwargs: Any) -> None:
        self._config = FarmBeatsClientConfiguration(credential=credential, **kwargs)
        self._client = AsyncPipelineClient(base_url=endpoint, config=self._config, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.application_data = ApplicationDataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.attachments = AttachmentsOperations(  # type: ignore  # pylint: disable=abstract-class-instantiated
            self._client, self._config, self._serialize, self._deserialize
        )
        self.boundaries = BoundariesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.crop_products = CropProductsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.crops = CropsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.device_data_models = DeviceDataModelsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.devices = DevicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.farm_operations = FarmOperationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.farms = FarmsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.fields = FieldsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.harvest_data = HarvestDataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.image_processing = ImageProcessingOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.insight_attachments = InsightAttachmentsOperations(  # type: ignore  # pylint: disable=abstract-class-instantiated
            self._client, self._config, self._serialize, self._deserialize
        )
        self.insights = InsightsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.management_zones = ManagementZonesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.model_inference = ModelInferenceOperations(self._client, self._config, self._serialize, self._deserialize)
        self.nutrient_analyses = NutrientAnalysesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.oauth_providers = OAuthProvidersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.oauth_tokens = OAuthTokensOperations(self._client, self._config, self._serialize, self._deserialize)
        self.parties = PartiesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.planting_data = PlantingDataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.plant_tissue_analyses = PlantTissueAnalysesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.prescription_maps = PrescriptionMapsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.prescriptions = PrescriptionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scenes = ScenesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.seasonal_fields = SeasonalFieldsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.seasons = SeasonsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sensor_data_models = SensorDataModelsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sensor_events = SensorEventsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sensor_mappings = SensorMappingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sensor_partner_integrations = SensorPartnerIntegrationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sensors = SensorsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.solution_inference = SolutionInferenceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tillage_data = TillageDataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.weather = WeatherOperations(self._client, self._config, self._serialize, self._deserialize)
        self.weather_data = WeatherDataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.zones = ZonesOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client.send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "FarmBeatsClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
