% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clt.ani.R
\name{clt.ani}
\alias{clt.ani}
\title{Demonstration of the Central Limit Theorem}
\usage{
clt.ani(
  obs = 300,
  FUN = rexp,
  mean = 1,
  sd = 1,
  col = c("bisque", "red", "blue", "black"),
  mat = matrix(1:2, 2),
  widths = rep(1, ncol(mat)),
  heights = rep(1, nrow(mat)),
  xlim,
  ...
)
}
\arguments{
\item{obs}{the number of sample means to be generated from the distribution
based on a given sample size \eqn{n}; these sample mean values will be used
to create the histogram}

\item{FUN}{the function to generate \code{n} random numbers from a certain
distribution}

\item{mean, sd}{the expectation and standard deviation of the population
distribution (they will be used to plot the density curve of the
theoretical Normal distribution with mean equal to \code{mean} and sd equal
to \eqn{sd/\sqrt{n}}; if any of them is \code{NA}, the density curve will
be suppressed)}

\item{col}{a vector of length 4 specifying the colors of the histogram, the
density curve of the sample mean, the theoretical density cuve and
P-values.}

\item{mat, widths, heights}{arguments passed to \code{\link{layout}} to set the
layout of the two graphs.}

\item{xlim}{the x-axis limit for the histogram (it has a default value if not
specified)}

\item{\dots}{other arguments passed to \code{\link{plot.default}} to plot the
P-values}
}
\value{
A data frame of P-values.
}
\description{
First of all, a number of \code{obs} observations are generated from a
certain distribution for each variable \eqn{X_j}, \eqn{j = 1, 2, \cdots, n}{j
= 1, 2, ..., n}, and \eqn{n = 1, 2, \cdots, nmax}{n = 1, 2, ..., nmax}, then
the sample means are computed, and at last the density of these sample means
is plotted as the sample size \eqn{n} increases (the theoretical limiting
distribution is denoted by the dashed line), besides, the P-values from the
normality test \code{\link{shapiro.test}} are computed for each \eqn{n} and
plotted at the same time.
}
\details{
As long as the conditions of the Central Limit Theorem (CLT) are satisfied,
the distribution of the sample mean will be approximate to the Normal
distribution when the sample size \code{n} is large enough, no matter what is
the original distribution. The largest sample size is defined by \code{nmax}
in \code{\link{ani.options}}.
}
\references{
Examples at \url{https://yihui.org/animation/example/clt-ani/}
}
\seealso{
\code{\link{hist}}, \code{\link{density}}
}
\author{
Yihui Xie
}
