// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple arm64-none-linux-gnu -target-feature +v8.2a -target-feature +neon -target-feature +fp16fml \
// RUN: -disable-O0-optnone -emit-llvm -o - %s | opt -S -passes=mem2reg,sroa | FileCheck %s

// REQUIRES: aarch64-registered-target

// Test AArch64 Armv8.2-A FP16 Fused Multiply-Add Long intrinsics

#include <arm_neon.h>

// Vector form

// CHECK-LABEL: @test_vfmlal_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CHECK-NEXT:    [[VFMLAL_LOW_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x float>
// CHECK-NEXT:    [[VFMLAL_LOW1_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_LOW2_I:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_LOW3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlal.v2f32.v4f16(<2 x float> [[VFMLAL_LOW_I]], <4 x half> [[VFMLAL_LOW1_I]], <4 x half> [[VFMLAL_LOW2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLAL_LOW3_I]]
//
float32x2_t test_vfmlal_low_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlal_low_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlsl_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CHECK-NEXT:    [[VFMLSL_LOW_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x float>
// CHECK-NEXT:    [[VFMLSL_LOW1_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_LOW2_I:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_LOW3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlsl.v2f32.v4f16(<2 x float> [[VFMLSL_LOW_I]], <4 x half> [[VFMLSL_LOW1_I]], <4 x half> [[VFMLSL_LOW2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLSL_LOW3_I]]
//
float32x2_t test_vfmlsl_low_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlsl_low_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlal_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CHECK-NEXT:    [[VFMLAL_HIGH_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x float>
// CHECK-NEXT:    [[VFMLAL_HIGH1_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH2_I:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlal2.v2f32.v4f16(<2 x float> [[VFMLAL_HIGH_I]], <4 x half> [[VFMLAL_HIGH1_I]], <4 x half> [[VFMLAL_HIGH2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLAL_HIGH3_I]]
//
float32x2_t test_vfmlal_high_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlal_high_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlsl_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[TMP2]] to <8 x i8>
// CHECK-NEXT:    [[VFMLSL_HIGH_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x float>
// CHECK-NEXT:    [[VFMLSL_HIGH1_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH2_I:%.*]] = bitcast <8 x i8> [[TMP5]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlsl2.v2f32.v4f16(<2 x float> [[VFMLSL_HIGH_I]], <4 x half> [[VFMLSL_HIGH1_I]], <4 x half> [[VFMLSL_HIGH2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLSL_HIGH3_I]]
//
float32x2_t test_vfmlsl_high_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlsl_high_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlalq_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CHECK-NEXT:    [[VFMLAL_LOW_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x float>
// CHECK-NEXT:    [[VFMLAL_LOW1_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_LOW2_I:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_LOW3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlal.v4f32.v8f16(<4 x float> [[VFMLAL_LOW_I]], <8 x half> [[VFMLAL_LOW1_I]], <8 x half> [[VFMLAL_LOW2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLAL_LOW3_I]]
//
float32x4_t test_vfmlalq_low_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlalq_low_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlslq_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CHECK-NEXT:    [[VFMLSL_LOW_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x float>
// CHECK-NEXT:    [[VFMLSL_LOW1_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_LOW2_I:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_LOW3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlsl.v4f32.v8f16(<4 x float> [[VFMLSL_LOW_I]], <8 x half> [[VFMLSL_LOW1_I]], <8 x half> [[VFMLSL_LOW2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLSL_LOW3_I]]
//
float32x4_t test_vfmlslq_low_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlslq_low_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlalq_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CHECK-NEXT:    [[VFMLAL_HIGH_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x float>
// CHECK-NEXT:    [[VFMLAL_HIGH1_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH2_I:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlal2.v4f32.v8f16(<4 x float> [[VFMLAL_HIGH_I]], <8 x half> [[VFMLAL_HIGH1_I]], <8 x half> [[VFMLAL_HIGH2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLAL_HIGH3_I]]
//
float32x4_t test_vfmlalq_high_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlalq_high_f16(a, b, c);
}

// CHECK-LABEL: @test_vfmlslq_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP0]] to <16 x i8>
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to <16 x i8>
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to <16 x i8>
// CHECK-NEXT:    [[VFMLSL_HIGH_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x float>
// CHECK-NEXT:    [[VFMLSL_HIGH1_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH2_I:%.*]] = bitcast <16 x i8> [[TMP5]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlsl2.v4f32.v8f16(<4 x float> [[VFMLSL_HIGH_I]], <8 x half> [[VFMLSL_HIGH1_I]], <8 x half> [[VFMLSL_HIGH2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLSL_HIGH3_I]]
//
float32x4_t test_vfmlslq_high_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlslq_high_f16(a, b, c);
}

// Indexed form

// CHECK-LABEL: @test_vfmlal_lane_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 0
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 0
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLAL_LOW_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLAL_LOW1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_LOW2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_LOW3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlal.v2f32.v4f16(<2 x float> [[VFMLAL_LOW_I]], <4 x half> [[VFMLAL_LOW1_I]], <4 x half> [[VFMLAL_LOW2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLAL_LOW3_I]]
//
float32x2_t test_vfmlal_lane_low_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlal_lane_low_f16(a, b, c, 0);
}

// CHECK-LABEL: @test_vfmlal_lane_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 1
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 1
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 1
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 1
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLAL_HIGH_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLAL_HIGH1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlal2.v2f32.v4f16(<2 x float> [[VFMLAL_HIGH_I]], <4 x half> [[VFMLAL_HIGH1_I]], <4 x half> [[VFMLAL_HIGH2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLAL_HIGH3_I]]
//
float32x2_t test_vfmlal_lane_high_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlal_lane_high_f16(a, b, c, 1);
}

// CHECK-LABEL: @test_vfmlalq_lane_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 2
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 2
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 2
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 2
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE39:%.*]] = extractelement <4 x i16> [[TMP8]], i32 2
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGET_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE49:%.*]] = extractelement <4 x i16> [[TMP10]], i32 2
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGET_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE59:%.*]] = extractelement <4 x i16> [[TMP12]], i32 2
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGET_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE69:%.*]] = extractelement <4 x i16> [[TMP14]], i32 2
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGET_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLAL_LOW_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLAL_LOW1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_LOW2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_LOW3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlal.v4f32.v8f16(<4 x float> [[VFMLAL_LOW_I]], <8 x half> [[VFMLAL_LOW1_I]], <8 x half> [[VFMLAL_LOW2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLAL_LOW3_I]]
//
float32x4_t test_vfmlalq_lane_low_f16(float32x4_t a, float16x8_t b, float16x4_t c) {
  return vfmlalq_lane_low_f16(a, b, c, 2);
}

// CHECK-LABEL: @test_vfmlalq_lane_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 3
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 3
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 3
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 3
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE39:%.*]] = extractelement <4 x i16> [[TMP8]], i32 3
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGET_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE49:%.*]] = extractelement <4 x i16> [[TMP10]], i32 3
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGET_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE59:%.*]] = extractelement <4 x i16> [[TMP12]], i32 3
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGET_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE69:%.*]] = extractelement <4 x i16> [[TMP14]], i32 3
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGET_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLAL_HIGH_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLAL_HIGH1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlal2.v4f32.v8f16(<4 x float> [[VFMLAL_HIGH_I]], <8 x half> [[VFMLAL_HIGH1_I]], <8 x half> [[VFMLAL_HIGH2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLAL_HIGH3_I]]
//
float32x4_t test_vfmlalq_lane_high_f16(float32x4_t a, float16x8_t b, float16x4_t c) {
  return vfmlalq_lane_high_f16(a, b, c, 3);
}

// CHECK-LABEL: @test_vfmlal_laneq_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 4
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 4
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 4
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 4
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLAL_LOW_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLAL_LOW1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_LOW2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_LOW3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlal.v2f32.v4f16(<2 x float> [[VFMLAL_LOW_I]], <4 x half> [[VFMLAL_LOW1_I]], <4 x half> [[VFMLAL_LOW2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLAL_LOW3_I]]
//
float32x2_t test_vfmlal_laneq_low_f16(float32x2_t a, float16x4_t b, float16x8_t c) {
  return vfmlal_laneq_low_f16(a, b, c, 4);
}

// CHECK-LABEL: @test_vfmlal_laneq_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 5
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 5
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 5
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 5
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLAL_HIGH_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLAL_HIGH1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlal2.v2f32.v4f16(<2 x float> [[VFMLAL_HIGH_I]], <4 x half> [[VFMLAL_HIGH1_I]], <4 x half> [[VFMLAL_HIGH2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLAL_HIGH3_I]]
//
float32x2_t test_vfmlal_laneq_high_f16(float32x2_t a, float16x4_t b, float16x8_t c) {
  return vfmlal_laneq_high_f16(a, b, c, 5);
}

// CHECK-LABEL: @test_vfmlalq_laneq_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 6
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 6
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 6
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 6
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE39:%.*]] = extractelement <8 x i16> [[TMP8]], i32 6
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGETQ_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE49:%.*]] = extractelement <8 x i16> [[TMP10]], i32 6
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGETQ_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE59:%.*]] = extractelement <8 x i16> [[TMP12]], i32 6
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGETQ_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE69:%.*]] = extractelement <8 x i16> [[TMP14]], i32 6
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGETQ_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLAL_LOW_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLAL_LOW1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_LOW2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_LOW3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlal.v4f32.v8f16(<4 x float> [[VFMLAL_LOW_I]], <8 x half> [[VFMLAL_LOW1_I]], <8 x half> [[VFMLAL_LOW2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLAL_LOW3_I]]
//
float32x4_t test_vfmlalq_laneq_low_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlalq_laneq_low_f16(a, b, c, 6);
}

// CHECK-LABEL: @test_vfmlalq_laneq_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 7
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 7
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 7
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 7
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE39:%.*]] = extractelement <8 x i16> [[TMP8]], i32 7
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGETQ_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE49:%.*]] = extractelement <8 x i16> [[TMP10]], i32 7
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGETQ_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE59:%.*]] = extractelement <8 x i16> [[TMP12]], i32 7
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGETQ_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE69:%.*]] = extractelement <8 x i16> [[TMP14]], i32 7
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGETQ_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLAL_HIGH_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLAL_HIGH1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLAL_HIGH3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlal2.v4f32.v8f16(<4 x float> [[VFMLAL_HIGH_I]], <8 x half> [[VFMLAL_HIGH1_I]], <8 x half> [[VFMLAL_HIGH2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLAL_HIGH3_I]]
//
float32x4_t test_vfmlalq_laneq_high_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlalq_laneq_high_f16(a, b, c, 7);
}

// CHECK-LABEL: @test_vfmlsl_lane_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 0
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 0
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLSL_LOW_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLSL_LOW1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_LOW2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_LOW3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlsl.v2f32.v4f16(<2 x float> [[VFMLSL_LOW_I]], <4 x half> [[VFMLSL_LOW1_I]], <4 x half> [[VFMLSL_LOW2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLSL_LOW3_I]]
//
float32x2_t test_vfmlsl_lane_low_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlsl_lane_low_f16(a, b, c, 0);
}

// CHECK-LABEL: @test_vfmlsl_lane_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 1
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 1
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 1
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 1
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLSL_HIGH_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLSL_HIGH1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlsl2.v2f32.v4f16(<2 x float> [[VFMLSL_HIGH_I]], <4 x half> [[VFMLSL_HIGH1_I]], <4 x half> [[VFMLSL_HIGH2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLSL_HIGH3_I]]
//
float32x2_t test_vfmlsl_lane_high_f16(float32x2_t a, float16x4_t b, float16x4_t c) {
  return vfmlsl_lane_high_f16(a, b, c, 1);
}

// CHECK-LABEL: @test_vfmlslq_lane_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 2
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 2
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 2
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 2
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE39:%.*]] = extractelement <4 x i16> [[TMP8]], i32 2
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGET_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE49:%.*]] = extractelement <4 x i16> [[TMP10]], i32 2
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGET_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE59:%.*]] = extractelement <4 x i16> [[TMP12]], i32 2
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGET_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE69:%.*]] = extractelement <4 x i16> [[TMP14]], i32 2
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGET_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLSL_LOW_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLSL_LOW1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_LOW2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_LOW3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlsl.v4f32.v8f16(<4 x float> [[VFMLSL_LOW_I]], <8 x half> [[VFMLSL_LOW1_I]], <8 x half> [[VFMLSL_LOW2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLSL_LOW3_I]]
//
float32x4_t test_vfmlslq_lane_low_f16(float32x4_t a, float16x8_t b, float16x4_t c) {
  return vfmlslq_lane_low_f16(a, b, c, 2);
}

// CHECK-LABEL: @test_vfmlslq_lane_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <4 x half> [[C:%.*]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <4 x i16> [[TMP0]], i32 3
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGET_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE9:%.*]] = extractelement <4 x i16> [[TMP2]], i32 3
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGET_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE19:%.*]] = extractelement <4 x i16> [[TMP4]], i32 3
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGET_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE29:%.*]] = extractelement <4 x i16> [[TMP6]], i32 3
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGET_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE39:%.*]] = extractelement <4 x i16> [[TMP8]], i32 3
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGET_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE49:%.*]] = extractelement <4 x i16> [[TMP10]], i32 3
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGET_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE59:%.*]] = extractelement <4 x i16> [[TMP12]], i32 3
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGET_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <4 x half> [[C]] to <4 x i16>
// CHECK-NEXT:    [[VGET_LANE69:%.*]] = extractelement <4 x i16> [[TMP14]], i32 3
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGET_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLSL_HIGH_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLSL_HIGH1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlsl2.v4f32.v8f16(<4 x float> [[VFMLSL_HIGH_I]], <8 x half> [[VFMLSL_HIGH1_I]], <8 x half> [[VFMLSL_HIGH2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLSL_HIGH3_I]]
//
float32x4_t test_vfmlslq_lane_high_f16(float32x4_t a, float16x8_t b, float16x4_t c) {
  return vfmlslq_lane_high_f16(a, b, c, 3);
}

// CHECK-LABEL: @test_vfmlsl_laneq_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 4
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 4
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 4
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 4
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLSL_LOW_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLSL_LOW1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_LOW2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_LOW3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlsl.v2f32.v4f16(<2 x float> [[VFMLSL_LOW_I]], <4 x half> [[VFMLSL_LOW1_I]], <4 x half> [[VFMLSL_LOW2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLSL_LOW3_I]]
//
float32x2_t test_vfmlsl_laneq_low_f16(float32x2_t a, float16x4_t b, float16x8_t c) {
  return vfmlsl_laneq_low_f16(a, b, c, 4);
}

// CHECK-LABEL: @test_vfmlsl_laneq_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 5
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <4 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 5
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <4 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 5
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <4 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 5
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <4 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <2 x float> [[A:%.*]] to <2 x i32>
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x half> [[B:%.*]] to <4 x i16>
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <4 x half> [[VECINIT32]] to <4 x i16>
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast <2 x i32> [[TMP8]] to <8 x i8>
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <4 x i16> [[TMP9]] to <8 x i8>
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast <4 x i16> [[TMP10]] to <8 x i8>
// CHECK-NEXT:    [[VFMLSL_HIGH_I:%.*]] = bitcast <8 x i8> [[TMP11]] to <2 x float>
// CHECK-NEXT:    [[VFMLSL_HIGH1_I:%.*]] = bitcast <8 x i8> [[TMP12]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH2_I:%.*]] = bitcast <8 x i8> [[TMP13]] to <4 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH3_I:%.*]] = call <2 x float> @llvm.aarch64.neon.fmlsl2.v2f32.v4f16(<2 x float> [[VFMLSL_HIGH_I]], <4 x half> [[VFMLSL_HIGH1_I]], <4 x half> [[VFMLSL_HIGH2_I]])
// CHECK-NEXT:    ret <2 x float> [[VFMLSL_HIGH3_I]]
//
float32x2_t test_vfmlsl_laneq_high_f16(float32x2_t a, float16x4_t b, float16x8_t c) {
  return vfmlsl_laneq_high_f16(a, b, c, 5);
}

// CHECK-LABEL: @test_vfmlslq_laneq_low_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 6
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 6
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 6
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 6
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE39:%.*]] = extractelement <8 x i16> [[TMP8]], i32 6
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGETQ_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE49:%.*]] = extractelement <8 x i16> [[TMP10]], i32 6
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGETQ_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE59:%.*]] = extractelement <8 x i16> [[TMP12]], i32 6
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGETQ_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE69:%.*]] = extractelement <8 x i16> [[TMP14]], i32 6
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGETQ_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLSL_LOW_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLSL_LOW1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_LOW2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_LOW3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlsl.v4f32.v8f16(<4 x float> [[VFMLSL_LOW_I]], <8 x half> [[VFMLSL_LOW1_I]], <8 x half> [[VFMLSL_LOW2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLSL_LOW3_I]]
//
float32x4_t test_vfmlslq_laneq_low_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlslq_laneq_low_f16(a, b, c, 6);
}

// CHECK-LABEL: @test_vfmlslq_laneq_high_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <8 x half> [[C:%.*]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE:%.*]] = extractelement <8 x i16> [[TMP0]], i32 7
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast i16 [[VGETQ_LANE]] to half
// CHECK-NEXT:    [[VECINIT:%.*]] = insertelement <8 x half> poison, half [[TMP1]], i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE9:%.*]] = extractelement <8 x i16> [[TMP2]], i32 7
// CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[VGETQ_LANE9]] to half
// CHECK-NEXT:    [[VECINIT12:%.*]] = insertelement <8 x half> [[VECINIT]], half [[TMP3]], i32 1
// CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE19:%.*]] = extractelement <8 x i16> [[TMP4]], i32 7
// CHECK-NEXT:    [[TMP5:%.*]] = bitcast i16 [[VGETQ_LANE19]] to half
// CHECK-NEXT:    [[VECINIT22:%.*]] = insertelement <8 x half> [[VECINIT12]], half [[TMP5]], i32 2
// CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE29:%.*]] = extractelement <8 x i16> [[TMP6]], i32 7
// CHECK-NEXT:    [[TMP7:%.*]] = bitcast i16 [[VGETQ_LANE29]] to half
// CHECK-NEXT:    [[VECINIT32:%.*]] = insertelement <8 x half> [[VECINIT22]], half [[TMP7]], i32 3
// CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE39:%.*]] = extractelement <8 x i16> [[TMP8]], i32 7
// CHECK-NEXT:    [[TMP9:%.*]] = bitcast i16 [[VGETQ_LANE39]] to half
// CHECK-NEXT:    [[VECINIT42:%.*]] = insertelement <8 x half> [[VECINIT32]], half [[TMP9]], i32 4
// CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE49:%.*]] = extractelement <8 x i16> [[TMP10]], i32 7
// CHECK-NEXT:    [[TMP11:%.*]] = bitcast i16 [[VGETQ_LANE49]] to half
// CHECK-NEXT:    [[VECINIT52:%.*]] = insertelement <8 x half> [[VECINIT42]], half [[TMP11]], i32 5
// CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE59:%.*]] = extractelement <8 x i16> [[TMP12]], i32 7
// CHECK-NEXT:    [[TMP13:%.*]] = bitcast i16 [[VGETQ_LANE59]] to half
// CHECK-NEXT:    [[VECINIT62:%.*]] = insertelement <8 x half> [[VECINIT52]], half [[TMP13]], i32 6
// CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[C]] to <8 x i16>
// CHECK-NEXT:    [[VGETQ_LANE69:%.*]] = extractelement <8 x i16> [[TMP14]], i32 7
// CHECK-NEXT:    [[TMP15:%.*]] = bitcast i16 [[VGETQ_LANE69]] to half
// CHECK-NEXT:    [[VECINIT72:%.*]] = insertelement <8 x half> [[VECINIT62]], half [[TMP15]], i32 7
// CHECK-NEXT:    [[TMP16:%.*]] = bitcast <4 x float> [[A:%.*]] to <4 x i32>
// CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x half> [[B:%.*]] to <8 x i16>
// CHECK-NEXT:    [[TMP18:%.*]] = bitcast <8 x half> [[VECINIT72]] to <8 x i16>
// CHECK-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP16]] to <16 x i8>
// CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x i16> [[TMP17]] to <16 x i8>
// CHECK-NEXT:    [[TMP21:%.*]] = bitcast <8 x i16> [[TMP18]] to <16 x i8>
// CHECK-NEXT:    [[VFMLSL_HIGH_I:%.*]] = bitcast <16 x i8> [[TMP19]] to <4 x float>
// CHECK-NEXT:    [[VFMLSL_HIGH1_I:%.*]] = bitcast <16 x i8> [[TMP20]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH2_I:%.*]] = bitcast <16 x i8> [[TMP21]] to <8 x half>
// CHECK-NEXT:    [[VFMLSL_HIGH3_I:%.*]] = call <4 x float> @llvm.aarch64.neon.fmlsl2.v4f32.v8f16(<4 x float> [[VFMLSL_HIGH_I]], <8 x half> [[VFMLSL_HIGH1_I]], <8 x half> [[VFMLSL_HIGH2_I]])
// CHECK-NEXT:    ret <4 x float> [[VFMLSL_HIGH3_I]]
//
float32x4_t test_vfmlslq_laneq_high_f16(float32x4_t a, float16x8_t b, float16x8_t c) {
  return vfmlslq_laneq_high_f16(a, b, c, 7);
}
