% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlab.r
\name{extractlabs}
\alias{extractlabs}
\title{extractlabs}
\usage{
extractlabs(..., print = TRUE)
}
\arguments{
\item{...}{one ore more data frames or data tables}

\item{print}{set to \code{FALSE} to not print details about variables with conflicting attributes}
}
\value{
a data table
}
\description{
Extract Labels and Units From Multiple Datasets
}
\details{
For one or more data frames/tables extracts all labels and units and comb ines them over dataset, dropping any variables not having either labels or units defined.  The resulting data table is returned and is used by the \code{hlab} function if the user stores the result in an objectnamed \code{LabelsUnits}.  The result is \code{NULL} if no variable in any dataset has a non-blank \code{label} or \code{units}.  Variables found in more than one dataset with duplicate \code{label} and \code{units} are consolidated.  A warning message is issued when duplicate variables have conflicting labels or units, and by default, details are printed.  No attempt is made to resolve these conflicts.
}
\examples{
d <- data.frame(x=1:10, y=(1:10)/10)
d <- upData(d, labels=c(x='X', y='Y'), units=c(x='mmHg'), print=FALSE)
d2 <- d
units(d2$x) <- 'cm'
LabelsUnits <- extractlabs(d, d2)
LabelsUnits
}
\seealso{
\code{\link[=label]{label()}}, \code{\link[=contents]{contents()}}, \code{\link[=units]{units()}}, \code{\link[=hlab]{hlab()}}
}
\author{
Frank Harrell
}
