/********************************************************************************/
/*                                                                              */
/* Papyrus 3 library.                                                           */
/* This library constitutes a DICOM file system which helps reading and writing */
/* DICOM files and DICOMDIR files.                                              */
/*                                                                              */
/* Copyright (C) 2004 - Service of  Medical Informatics -                       */
/* University Hospitals of Geneva (HUG), Geneva, Switzerland                    */
/*                                                                              */
/* This library is a free software; you can redistribute it and/or modify it    */
/* under the terms of the GNU Lesser General Public License as published by the */
/*  Free Software Foundation; either version 2.1 of the License, or             */
/* (at your option) any later version.                                          */
/*                                                                              */
/* This library is distributed in the hope that it will be useful,              */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                         */
/* See the GNU Lesser General Public License for more details.                  */
/*                                                                              */
/* You should have received a copy of the GNU Lesser General Public License     */
/* along with this library; if not, write to                                    */
/* the Free Software Foundation, Inc.,                                          */
/* 59 Temple Place, Suite 330,                                                  */
/* Boston, MA 02111-1307 USA                                                    */
/*                                                                              */
/* You can contact us for more information at osiris@sim.hcuge.ch               */
/* or by writing to Papyrus,                                                    */
/* Unite d'Imagerie Numerique / Service d'Informatique Medicale / HUG,          */
/* 24, Micheli-du-Crest street, 1211 Geneva 14, Switzerland.                    */
/*                                                                              */
/* The University Hopitals of Geneva, hereby disclaims all copyright interest   */
/* in the library `Papyrus' (a library for reading and writing DICOM files).    */
/*                                                                              */
/* Geneva, april 2004                                                           */
/* Antoine Geissbuhler, head of the Service of Medical Informatics,             */
/* University Hospitals of Geneva, Switzerland                                  */
/*                                                                              */
/********************************************************************************/

/********************************************************************************/
/*                                                                              */
/*	Project  : P A P Y R U S  Toolkit                                           */
/*	File     : PapyEnumImageGroups3.h                                           */
/*	Function : contains the declarations of the groups names and of the         */
/*             elements names                                                   */
/*	Authors  : Christian Girard                                                 */
/*                                                                              */
/*	History  : 04.1994	version 3.0                                             */
/*             06.1995	version 3.1                                             */
/*             02.1996	version 3.3                                             */
/*             02.1999	version 3.6                                             */
/*             04.2001	version 3.7                                             */
/*             09.2001  version 3.7  on CVS                                     */
/*             10.2001  version 3.71 MAJ Dicom par CHG                          */
/*                                                                              */
/********************************************************************************/

#ifndef PapyEnumImageGroups3H 
#define PapyEnumImageGroups3H



/*	Group2		*/

enum {
papGroupLength,
papFileMetaInformationVersionGr,
papMediaStorageSOPClassUIDGr,
papMediaStorageSOPInstanceUIDGr,
papTransferSyntaxUIDGr,
papImplementationClassUIDGr,
papImplementationVersionNameGr,
papSourceApplicationEntityTitleGr,
papPrivateInformationCreatorUIDGr,
papPrivateInformationGr,
papEndGroup2
};

/*	Group4		*/

enum {
papFilesetIDGr = 1,
papFileIDofFilesetDescriptorFileGr,
papFormatofFilesetDescriptorFileGr,
papOffsetofTheFirstDirectoryRecordGr,
papOffsetofTheLastDirectoryRecordGr,
papFilesetConsistencyFlagGr,
papDirectoryRecordSequenceGr,
papOffsetofNextDirectoryRecordGr,
papRecordInuseGr,
papOffsetofReferencedLowerLevelDirectoryEntityGr,
papDirectoryRecordTypeGr,
papPrivateRecordUIDGr,
papReferencedFileIDGr,
papMRDRDirectoryRecordOffsetGr,
papReferencedSOPClassUIDinFileGr,
papReferencedSOPInstanceUIDinFileGr,
papReferencedTransferSyntaxUIDinFileGr,
papNumberOfReferencesGr,
papEndGroup4
};

/*	Group8		*/

enum {
papLengthtoEndGr = 1,
papSpecificCharacterSetGr,
papImageTypeGr,
papRecognitionCodeGr,
papInstanceCreationDateGr,
papInstanceCreationTimeGr,
papInstanceCreatorUIDGr,
papSOPClassUIDGr,
papSOPInstanceUIDGr,
papStudyDateGr,
papSeriesDateGr,
papAcquisitionDateGr,
papImageDateGr,
papOverlayDateGr,
papCurveDateGr,
papAcquisitionDatetimeGr,
papStudyTimeGr,
papSeriesTimeGr,
papAcquisitionTimeGr,
papImageTimeGr,
papOverlayTimeGr,
papCurveTimeGr,
papDataSetTypeGr,
papDataSetSubtypeGr,
papNuclearMedicineSeriesTypeGr,
papAccessionNumberGr,
papQueryRetrieveLevelGr,
papRetrieveAETitleGr,
papInstanceAvailabilityGr,
papFailedSOPInstanceUIDListGr,
papModalityGr,
papModalitiesInStudyGr,
papConversionTypeGr,
papPresentationIndentTypeGr,
papManufacturerGr,
papInstitutionNameGr,
papInstitutionAddressGr,
papInstitutionCodeSequenceGr,
papReferringPhysiciansNameGr,
papReferringPhysiciansAddressGr,
papReferringPhysiciansTelephoneNumbersGr,
papCodeValueGr,
papCodingSchemeDesignatorGr,
papCodingSchemeVersionGr,
papCodeMeaningGr,
papMappingResourceGr,
papContextGroupVersionGr,
papContextgroupLocalVersionGr,
papCodeSetExtensionFlagGr,
papPrivateCodingSchemeCreatorUIDGr,
papCodeSetExtensionCreatorUIDGr,
papContextIdentifierGr,
papTimezoneOffsetFromUTCGr,
papNetworkIDGr,
papStationNameGr,
papStudyDescriptionGr,
papProcedureCodeSequenceGr,
papSeriesDescriptionGr,
papInstitutionalDepartmentNameGr,
papPhysiciansOfRecordGr,
papPerformingPhysiciansNameGr,
papNameofPhysiciansReadingStudyGr,
papOperatorsNameGr,
papAdmittingDiagnosesDescriptionGr,
papAdmittingDiagnosisCodeSequenceGr,
papManufacturersModelNameGr,
papReferencedResultsSequenceGr,
papReferencedStudySequenceGr,
papReferencedStudyComponentSequenceGr,
papReferencedSeriesSequenceGr,
papReferencedPatientSequenceGr,
papReferencedVisitSequenceGr,
papReferencedOverlaySequenceGr,
papReferencedImageSequenceGr,
papReferencedCurveSequenceGr,
papReferencedSOPClassUID8Gr,
papReferencedSOPInstanceUID8Gr,
papSOPClassesSupporedGr,
papReferencedFrameNumberGr,
papReferencedCalibrationSequenceGr,
papTransactionUIDGr,
papFailureReasonGr,
papFailedSOPSequenceGr,
papReferencedSOPSequenceGr,
papLossyImageCompression8Gr,
papDerivationDescriptionGr,
papSourceImageSequenceGr,
papStageNameGr,
papStageNumberGr,
papNumberofStagesGr,
papViewNameGr,
papViewNumberGr,
papNumberofEventTimersGr,
papNumberofViewsinStageGr,
papEventElapsedTimesGr,
papEventTimerNamesGr,
papStartTrimGr,
papStopTrimGr,
papRecommendedDisplayFrameRateGr,
papTransducerPositionGr,
papTransducerOrientationGr,
papAnatomicStructureGr,
papAnatomicRegionSequenceGr,
papAnatomicRegionModifierSequenceGr,
papPrimaryAnatomicStructureSequenceGr,
papAnatomicStructureSpaceOrRegionSequenceGr,
papPrimaryAnatomicStructureModifierSequenceGr,
papTransducerPositionSequenceGr,
papTransducerPositionModifierSequenceGr,
papTransducerOrientationSequenceGr,
papTransducerOrientationModifierSequenceGr,
papComments8Gr,
papEndGroup8
};

/*	Group10		*/

enum {
papPatientsNameGr = 1,
papPatientIDGr,
papIssuerofPatientIDGr,
papPatientsBirthDateGr,
papPatientsBirthTimeGr,
papPatientsSexGr,
papPatientsInsurancePlanCodeSequenceGr,
papOtherPatientIDsGr,
papOtherPatientNamesGr,
papPatientsBirthNameGr,
papPatientsAgeGr,
papPatientsSizeGr,
papPatientsWeightGr,
papPatientsAddressGr,
papInsurancePlanIdentificationGr,
papPatientsMothersBirthNameGr,
papMilitaryRankGr,
papBranchofServiceGr,
papMedicalRecordLocatorGr,
papMedicalAlertsGr,
papContrastAllergiesGr,
papCountryofResidenceGr,
papRegionofResidenceGr,
papPatientsTelephoneNumbersGr,
papEthnicGroupGr,
papOccupationGr,
papSmokingStatusGr,
papAdditionalPatientHistoryGr,
papPregnancyStatusGr,
papLastMenstrualDateGr,
papPatientsReligiousPreferenceGr,
papPatientCommentsGr,
papEndGroup10
};

/*	Group18		*/

enum {
papContrastBolusAgentGr = 1,
papContrastBolusAgentSequenceGr,
papContrastBolusAdministrationRouteSequenceGr,
papBodyPartExaminedGr,
papScanningSequenceGr,
papSequenceVariantGr,
papScanOptionsGr,
papMRAcquisitionTypeGr,
papSequenceNameGr,
papAngioFlagGr,
papInterventionDrugInformationSequenceGr,
papInterventionDrugStopTimeGr,
papInterventionDrugDoseGr,
papInterventionDrugCodeSequenceGr,
papAdditionalDrugSequenceGr,
papRadionuclideGr,
papRadiopharmaceuticalGr,
papEnergyWindowCenterlineGr,
papEnergyWindowTotalWidthGr,
papInterventionDrugNameGr,
papInterventionDrugStartTimeGr,
papInterventionalTherapySequenceGr,
papTherapyTypeGr,
papInterventionalStatusGr,
papTherapyDescriptionGr,
papCineRateGr,
papSliceThicknessGr,
papKVPGr,
papCountsAccumulatedGr,
papAcquisitionTerminationConditionGr,
papEffectiveSeriesDurationGr,
papAcquisitionStartConditionGr,
papAcquisitionStartConditionDataGr,
papAcquisitionTerminationConditionDataGr,
papRepetitionTimeGr,
papEchoTimeGr,
papInversionTimeGr,
papNumberofAveragesGr,
papImagingFrequencyGr,
papImagedNucleusGr,
papEchoNumbersGr,
papMagneticFieldStrengthGr,
papSpacingBetweenSlicesGr,
papNumberofPhaseEncodingStepsGr,
papDataCollectionDiameterGr,
papEchoTrainLengthGr,
papPercentSamplingGr,
papPercentPhaseFieldofViewGr,
papPixelBandwidthGr,
papDeviceSerialNumberGr,
papPlateIDGr,
papSecondaryCaptureDeviceIDGr,
papHardcopyCreationDeviceIDGr,
papDateofSecondaryCaptureGr,
papTimeofSecondaryCaptureGr,
papSecondaryCaptureDeviceManufacturerGr,
papHardcopyDeviceManufacturerGr,
papSecondaryCaptureDeviceManufacturersModelNameGr,
papSecondaryCaptureDeviceSoftwareVersionsGr,
papHardcopyDeviceSoftwareVersionsGr,
papHardcopyDeviceManufacturersModelNameGr,
papSoftwareVersionsGr,
papVideoImageFormatAcquiredGr,
papDigitalImageFormatAcquiredGr,
papProtocolNameGr,
papContrastBolusRouteGr,
papContrastBolusVolumeGr,
papContrastBolusStartTimeGr,
papContrastBolusStopTimeGr,
papContrastBolusTotalDoseGr,
papSyringecountsGr,
papContrastFlowRatesGr,
papContrastFlowDurationsGr,
papContrastBolusIngredientGr,
papContrastBolusIngredientConcentrationGr,
papSpatialResolutionGr,
papTriggerTimeGr,
papTriggerSourceorTypeGr,
papNominalIntervalGr,
papFrameTimeGr,
papFramingTypeGr,
papFrameTimeVectorGr,
papFrameDelayGr,
papImageTriggerDelayGr,
papMultiplexgroupTimeOffsetGr,
papTriggerTimeOffsetGr,
papSynchronizationTriggerGr,
papSynchronizationChannelGr,
papTriggerSamplePositionGr,
papRadiopharmaceuticalRouteGr,
papRadiopharmaceuticalVolumeGr,
papRadiopharmaceuticalStartTimeGr,
papRadiopharmaceuticalStopTimeGr,
papRadionuclideTotalDoseGr,
papRadionuclideHalfLifeGr,
papRadionuclidePositronFractionGr,
papRadiopharmaceuticalSpecificactivityGr,
papBeatRejectionFlagGr,
papLowRRValueGr,
papHighRRValueGr,
papIntervalsAcquiredGr,
papIntervalsRejectedGr,
papPVCRejectionGr,
papSkipBeatsGr,
papHeartRateGr,
papCardiacNumberofImagesGr,
papTriggerWindowGr,
papReconstructionDiameterGr,
papDistanceSourcetoDetectorGr,
papDistanceSourcetoPatientGr,
papEstimatedRadiographicMagnificationFactorGr,
papGantryDetectorTiltGr,
papGantryDetectorSlewGr,
papTableHeightGr,
papTableTraverseGr,
papTableMotionGr,
papTableVerticalIncrementGr,
papTableLateralIncrementGr,
papTableLongitudinalIncrementGr,
papTableAngleGr,
papTableTypeGr,
papRotationDirectionGr,
papAngularPositionGr,
papRadialPositionGr,
papScanArcGr,
papAngularStepGr,
papCenterofRotationOffsetGr,
papRotationOffsetGr,
papFieldofViewShapeGr,
papFieldofViewDimensionsGr,
papExposureTimeGr,
papXrayTubeCurrentGr,
papExposureGr,
papExposureinmAsGr,
papAveragePulseWidthGr,
papRadiationSettingGr,
papRectificationTypeGr,
papRadiationModeGr,
papImageAreaDoseProductGr,
papFilterTypeGr,
papTypeofFiltersGr,
papIntensifierSizeGr,
papImagerPixelSpacingGr,
papGridGr,
papGeneratorPowerGr,
papCollimatorgridNameGr,
papCollimatorTypeGr,
papFocalDistanceGr,
papXFocusCenterGr,
papYFocusCenterGr,
papFocalSpotsGr,
papAnodeTargetMaterialGr,
papBodyPartThicknessGr,
papCompressionForceGr,
papDateofLastCalibrationGr,
papTimeofLastCalibrationGr,
papConvolutionKernelGr,
papUpperLowerPixelValuesGr,
papActualFrameDurationGr,
papCountRateGr,
papPreferredPlaybackSequencingGr,
papReceivingCoilGr,
papTransmittingCoilGr,
papPlateTypeGr,
papPhosphorTypeGr,
papScanVelocityGr,
papWholeBodyTechniqueGr,
papScanLengthGr,
papAcquisitionMatrixGr,
papPhaseEncodingDirectionGr,
papFlipAngleGr,
papVariableFlipAngleFlagGr,
papSARGr,
papdBdtGr,
papAcquisitionDeviceProcessingDescriptionGr,
papAcquisitionDeviceProcessingCodeGr,
papCassetteOrientationGr,
papCassetteSizeGr,
papExposuresonPlateGr,
papRelativeXrayExposureGr,
papColumnAngulationGr,
papTornoLayerHeightGr,
papTornoAngleGr,
papTornoTimeGr,
papTornoTypeGr,
papTornoClassGr,
papNumberofTornosynthesisSourceImagesGr,
papPositionerMotionGr,
papPositionerTypeGr,
papPositionerPrimaryAngleGr,
papPositionerSecondaryAngleGr,
papPositionerPrimaryAngleIncrementGr,
papPositionerSecondaryAngleIncrementGr,
papDetectorPrimaryAngleGr,
papDetectorSecondaryAngleGr,
papShutterShapeGr,
papShutterLeftVerticalEdgeGr,
papShutterRightVerticalEdgeGr,
papShutterUpperHorizontalEdgeGr,
papShutterLowerHorizontalEdgeGr,
papCenterofCircularShutterGr,
papRadiusofCircularShutterGr,
papVerticesofthePolygonalShutterGr,
papShutterPaddingValueGr,
papShutterOverlayGroupGr,
papCollimatorShapeGr,
papCollimatorLeftVerticalEdgeGr,
papCollimatorRightVerticalEdgeGr,
papCollimatorUpperHorizontalEdgeGr,
papCollimatorLowerHorizontalEdgeGr,
papCenterofCircularCollimatorGr,
papRadiusofCircularCollimatorGr,
papVerticesofthePolygonalCollimatorGr,
papAcquisitionTimeSynchronizedGr,
papTimeSourceGr,
papTimeDistributionProtocolGr,
papPageNumberVectorGr,
papFrameLabelVectorGr,
papFramePrimaryAngleVectorGr,
papFrameSecondaryAngleVectorGr,
papSliceLocationVectorGr,
papDisplayWindowLabelVectorGr,
papNominalScannedPixelSpacingGr,
papDigitizingDeviceTransportDirectionGr,
papRotationOfScannedFilmGr,
papComments18Gr,
papOutputPowerGr,
papTransducerDataGr,
papFocusDepthGr,
papPreprocessingFunctionGr,
papPostprocessingFunctionGr,
papMechanicalIndexGr,
papThermalIndexGr,
papCranialThermalIndexGr,
papSoftTissueThermalIndexGr,
papSoftTissuefocusThermalIndexGr,
papSoftTissuesurfaceThermalIndexGr,
papDynamicRangeGr,
papTotalGainGr,
papDepthofScanFieldGr,
papPatientPositionGr,
papViewPositionGr,
papProjectionEponymousNameCodeSequenceGr,
papImageTransformationMatrixGr,
papImageTranslationVectorGr,
papSensitivityGr,
papSequenceofUltrasoundRegionsGr,
papRegionSpatialFormatGr,
papRegionDataTypeGr,
papRegionFlagsGr,
papRegionLocationMinX0Gr,
papRegionLocationMinY0Gr,
papRegionLocationMaxX1Gr,
papRegionLocationMaxY1Gr,
papReferencePixelX0Gr,
papReferencePixelY0Gr,
papPhysicalUnitsXDirectionGr,
papPhysicalUnitsYDirectionGr,
papReferencePixelPhysicalValueXGr,
papReferencePixelPhysicalValueYGr,
papPhysicalDeltaXGr,
papPhysicalDeltaYGr,
papTransducerFrequencyGr,
papTransducerTypeGr,
papPulseRepetitionFrequencyGr,
papDopplerCorrectionAngleGr,
papSterringAngleGr,
papDopplerSampleVolumeXPositionGr,
papDopplerSampleVolumeYPositionGr,
papTMLinePositionX0Gr,
papTMLinePositionY0Gr,
papTMLinePositionX1Gr,
papTMLinePositionY1Gr,
papPixelComponentOrganizationGr,
papPixelComponentMaskGr,
papPixelComponentRangeStartGr,
papPixelComponentRangeStopGr,
papPixelComponentPhysicalUnitsGr,
papPixelComponentDataTypeGr,
papNumberofTableBreakPointsGr,
papTableofXBreakPointsGr,
papTableofYBreakPointsGr,
papNumberofTableEntriesGr,
papTableofPixelValuesGr,
papTableofParameterValuesGr,
papDetectorConditionsNominalFlagGr,
papDetectorTemperatureGr,
papDetectorTypeGr,
papDetectorConfigurationGr,
papDetectorDescriptionGr,
papDetectorModeGr,
papDetectorIDGr,
papDateofLastDetectorCalibrationGr,
papTimeofLastDetectorCalibrationGr,
papExposuresonDetectorSinceLastCalibrationGr,
papExposuresonDetectorSinceManufacturedGr,
papDetectorTimeSinceLastExposureGr,
papDetectorActiveTimeGr,
papDetectorActivationOffsetFromExposureGr,
papDetectorBinningGr,
papDetectorElementPhysicalSizeGr,
papDetectorElementSpacingGr,
papDetectorActiveShapeGr,
papDetectorActiveDimensionsGr,
papDetectorActiveOriginGr,
papFieldofViewOriginGr,
papFieldofViewRotationGr,
papFieldofViewHorizontalFlipGr,
papGridAbsorbingMaterialGr,
papGridSpacingMaterialGr,
papGridThicknessGr,
papGridPitchGr,
papGridAspectRatioGr,
papGridPeriodGr,
papGridFocalDistanceGr,
papFilterMaterialGr,
papFilterThicknessMinimumGr,
papFilterThicknessMaximumGr,
papExposureControlModeGr,
papExposureControlModeDescriptionGr,
papExposureStatusGr,
papPhototimerSettingGr,
papExposureTimeInMSGr,
papXRayTubeCurrentInMAGr,
papEndGroup18
};

/*	Group20		*/

enum {
papStudyInstanceUIDGr = 1,
papSeriesInstanceUIDGr,
papStudyIDGr,
papSeriesNumberGr,
papAcquisitionNumberGr,
papImageNumberGr,
papIsotopeNumberGr,
papPhaseNumberGr,
papIntervalNumberGr,
papTimeSlotNumberGr,
papAngleNumberGr,
papItemNumberGr,
papPatientOrientationGr,
papOverlayNumberGr,
papCurveNumberGr,
papLUTNumberGr,
papImagePosition20Gr,
papImagePositionPatientGr,
papImageOrientationGr,
papImageOrientationPatientGr,
papLocationGr,
papFrameofReferenceUIDGr,
papLateralityGr,
papImageLateralityGr,
papImageGeometryTypeGr,
papMaskingImageGr,
papTemporalPositionIdentifierGr,
papNumberofTemporalPositionsGr,
papTemporalResolutionGr,
papSeriesinStudyGr,
papAcquisitionsinSeriesGr,
papImagesinAcquisitionGr,
papImagesinSeriesGr,
papAcquisitioninStudyGr,
papImagesinStudyGr,
papReferenceGr,
papPositionReferenceIndicatorGr,
papSliceLocationGr,
papOtherStudyNumbersGr,
papNumberofPatientRelatedStudiesGr,
papNumberofPatientRelatedSeriesGr,
papNumberofPatientRelatedImagesGr,
papNumberofStudyRelatedSeriesGr,
papNumberofStudyRelatedImagesGr,
papNumberofSeriesRelatedImagesGr,
papSourceImageIDsGr,
papModifyingDeviceIDGr,
papModifiedImageIDGr,
papModifiedImageDateGr,
papModifyingDeviceManufacturerGr,
papModifiedImageTimeGr,
papModifiedImageDescriptionGr,
papImageCommentsGr,
papOriginalImageIdentificationGr,
papOriginalImageIdentificationNomenclatureGr,
papEndGroup20
};

/*	Group28		*/

enum {
papSamplesperPixelGr = 1,
papPhotometricInterpretationGr,
papImageDimensionsGr,
papPlanarConfigurationGr,
papNumberofFramesGr,
papFrameIncrementPointerGr,
papRowsGr,
papColumnsGr,
papPlanesGr,
papUltrasoundColorDataPresentGr,
papPixelSpacingGr,
papZoomFactorGr,
papZoomCenterGr,
papPixelAspectRatioGr,
papImageFormatGr,
papManipulatedImageGr,
papCorrectedImageGr,
papCompressionCodeGr,
papBitsAllocatedGr,
papBitsStoredGr,
papHighBitGr,
papPixelRepresentationGr,
papSmallestValidPixelValueGr,
papLargestValidPixelValueGr,
papSmallestImagePixelValueGr,
papLargestImagePixelValueGr,
papSmallestPixelValueinSeriesGr,
papLargestPixelValueinSeriesGr,
papSmallestImagePixelValueinPlaneGr,
papLargestImagePixelValueinPlaneGr,
papPixelPaddingValueGr,
papImageLocationGr,
papQualityControlImageGr,
papBurnedInAnnotationGr,
papPixelIntensityRelationshipGr,
papPixelIntensityRelationshipSignGr,
papWindowCenterGr,
papWindowWidthGr,
papRescaleInterceptGr,
papRescaleSlopeGr,
papRescaleTypeGr,
papWindowCenterWidthExplanationGr,
papGrayScaleGr,
papRecommendedViewingModeGr,
papGrayLookupTableDescriptorGr,
papRedPaletteColorLookupTableDescriptorGr,
papGreenPaletteColorLookupTableDescriptorGr,
papBluePaletteColorLookupTableDescriptorGr,
papPaletteColorLookupTableUIDGr,
papGrayLookupTableDataGr,
papRedPaletteCLUTDataGr,
papGreenPaletteCLUTDataGr,
papBluePaletteCLUTDataGr,
papSegmentedRedPaletteColorLookupTableDataGr,
papSegmentedGreenPaletteColorLookupTableDataGr,
papSegmentedBluePaletteColorLookupTableDataGr,
papImplantPresentGr,
papPartialViewGr,
papPartialViewDescriptionGr,
papLossyImageCompressionGr,
papLossyImageCompressionRatioGr,
papModalityLUTSequenceGr,
papLUTDescriptorGr,
papLUTExplanationGr,
papModalityLUTTypeGr,
papLUTDataGr,
papVOILUTSequenceGr,
papSoftcopyVOILUTSequenceGr,
papComments28Gr,
papBiPlaneAcquisitionSequenceGr,
papRepresentativeFrameNumberGr,
papFrameNumbersofInterestGr,
papFramesofInterestDescriptionGr,
papMaskPointersGr,
papRWavePointerGr,
papMaskSubtractionSequenceGr,
papMaskOperationGr,
papApplicableFrameRangeGr,
papMaskFrameNumbersGr,
papContrastFrameAveragingGr,
papMaskSubpixelShiftGr,
papTIDOffsetGr,
papMaskOperationExplanationGr,
papEndGroup28
};

/*	Group32		*/

enum {
papStudyStatusIDGr = 1,
papStudyPriorityIDGr,
papStudyIDIssuerGr,
papStudyVerifiedDateGr,
papStudyVerifiedTimeGr,
papStudyReadDateGr,
papStudyReadTimeGr,
papScheduledStudyStartDateGr,
papScheduledStudyStartTimeGr,
papScheduledStudyStopDateGr,
papScheduledStudyStopTimeGr,
papScheduledStudyLocationGr,
papScheduledStudyLocationAETitlesGr,
papReasonforStudyGr,
papRequestingPhysicianGr,
papRequestingServiceGr,
papStudyArrivalDateGr,
papStudyArrivalTimeGr,
papStudyCompletionDateGr,
papStudyCompletionTimeGr,
papStudyComponentStatusIDGr,
papRequestedProcedureDescriptionGr,
papRequestedProcedureCodeSequenceGr,
papRequestedContrastAgentGr,
papStudyCommentsGr,
papEndGroup32
};

/*	Group38		*/

enum {
papReferencedPatientAliasSequenceGr = 1,
papVisitStatusIDGr,
papAdmissionIDGr,
papIssuerofAdmissionIDGr,
papRouteofAdmissionsGr,
papScheduledAdmissionDateGr,
papScheduledAdmissionTimeGr,
papScheduledDischargeDateGr,
papScheduledDischargeTimeGr,
papScheduledPatientInstitutionResidenceGr,
papAdmittingDateGr,
papAdmittingTimeGr,
papDischargeDateGr,
papDischargeTimeGr,
papDischargeDiagnosisDescriptionGr,
papDischargeDiagnosisCodeSequenceGr,
papSpecialNeedsGr,
papCurrentPatientLocationGr,
papPatientsInstitutionResidenceGr,
papPatientStateGr,
papVisitCommentsGr,
papEndGroup38
};

/*	Group3A		*/

enum {
papWaveformOriginalityGr = 1,
papNumberOfWaveformChannelsGr,
papNumberOfWaveformSamplesGr,
papSamplingFrequencyGr,
papMultiplexGroupLabelGr,
papChannelDefinitionSequenceGr,
papWaveformChannelNumberGr,
papChannelLabelGr,
papChannelStatusGr,
papChannelSourceSequenceGr,
papChannelSourceModifiersSequenceGr,
papSourceWaveformSequenceGr,
papChannelDerivationDescriptionGr,
papChannelSensitivityGr,
papChannelSensitivityUnitsSequenceGr,
papChannelSensitivityCorrectionFactorGr,
papChannelBaselineGr,
papChannelTimeSkewGr,
papChannelSampleSkewGr,
papChannelOffsetGr,
papWaveformBitsStoredGr,
papFilterLowFrequencyGr,
papFilterHighFrequencyGr,
papNotchFilterFrequencyGr,
papNotchFilterBandwidthGr,
papEndGroup3A
};

/*	Group40 	*/

enum {
papScheduledStationAETitleGr = 1,
papScheduledProcedureStepStartDateGr,
papScheduledProcedureStepStartTimeGr,
papScheduledProcedureStepEndDateGr,
papScheduledProcedureStepEndTimeGr,
papScheduledPerformingPhysiciansNameGr,
papScheduledProcedureStepDescriptionGr,
papScheduledActionItemCodeSequenceGr,
papScheduledProcedureStepIDGr,
papStageCodeSequenceGr,
papScheduledStationNameGr,
papScheduledProcedureStepLocationGr,
papPreMedicationGr,
papScheduledProcedureStepStatusGr,
papScheduledProcedureStepSequenceGr,
papReferencedStandaloneSOPInstanceSequenceGr,
papPerformedStationAETitleGr,
papPerformedStationNameGr,
papPerformedLocationGr,
papPerformedProcedureStepStartDateGr,
papPerformedProcedureStepStartTimeGr,
papPerformedProcedureStepEndDateGr,
papPerformedProcedureStepEndTimeGr,
papPerformedProcedureStepStatusGr,
papPerformedProcedureStepIDGr,
papPerformedProcedureStepDescriptionGr,
papPerformedProcedureStepTypeGr,
papPerformedActionItemSequenceGr,
papScheduledStepAttributesSequenceGr,
papRequestedAttributesSequenceGr,
papCommentsOnThePerformedProcedureStepsGr,
papQuantitySequenceGr,
papQuantityGr,
papMeasuringUnitsSequenceGr,
papBillingItemSequenceGr,
papTotalTimeOfFluoroscopyGr,
papTotalNumberOfExposuresGr,
papEntranceDoseGr,
papExposedAreaGr,
papDistanceSourcetoEntranceGr,
papDistanceSourcetoSupportGr,
papCommentsonRadiationDoseGr,
papXRayOutputGr,
papHalfValueLayerGr,
papOrganDoseGr,
papOrganExposedGr,
papBillingProcedureStepSequenceGr,
papFilmConsumptionSequenceGr,
papBillingSuppliesAndDevicesSequenceGr,
papReferencedProcedureStepSequenceGr,
papPerformedSeriesSequenceGr,
papCommentsontheScheduledProcedureStepGr,
papSpecimenAccessionNumberGr,
papSpecimenSequenceGr,
papSpecimenIdentifierGr,
papAcquisitionContextSequenceGr,
papAcquisitionContextDescriptionGr,
papSpecimenTypeCodeSequenceGr,
papSlideIdentifierGr,
papImageCenterPointCoordinatesSequenceGr,
papXOffsetInSlideCoordinateSystemGr,
papYOffsetInSlideCoordinateSystemGr,
papZOffsetInSlideCoordinateSystemGr,
papPixelSpacingSequenceGr,
papCoordinateSystemAxisCodeSequenceGr,
papMeasurementUnitsCodeSequenceGr,
papRequestedProcedureIDGr,
papReasonfortheRequestedProcedureGr,
papRequestedProcedurePriorityGr,
papPatientTransportArrangementsGr,
papRequestedProcedureLocationGr,
papPlacerOrderNumberProcedureGr,
papFillerOrderNumberProcedureGr,
papConfidentialityCodeGr,
papReportingPriorityGr,
papNamesofIntendedRecipientsofResultsGr,
papRequestedProcedureCommentsGr,
papReasonfortheImagingServiceRequestGr,
papIssueDateofImagingServiceRequestGr,
papIssueTimeofImagingServiceRequestGr,
papPlacerOrderNumberImagingServiceRequestGr,
papFillerOrderNumberImagingServiceRequestGr,
papOrderEnteredByGr,
papOrderEnterersLocationGr,
papOrderCallbackPhoneNumberGr,
papImagingServiceRequestCommentsGr,
papConfidentialityConstraintonPatientDataDescriptionGr,
papEntranceDoseInMyGyGr,
papRelationshipTypeGr,
papVerifyingOrganizationGr,
papVerificationDateTimeGr,
papObservationDateTimeGr,
papValueTypeGr,
papConceptNameCodeSequenceGr,
papContinuityOfContentGr,
papVerifyingObserverSequenceGr,
papVerifyingObserverNameGr,
papVerifyingObserverIdentificationCodeSequenceGr,
papReferencedWaveformChannelsGr,
papDateTimeGr,
papDateGr,
papTimeGr,
papPersonNameGr,
papUIDGr,
papTemporalRangeTypeGr,
papReferencedSamplePositionsGr,
papReferencesFrameNumbersGr,
papReferencedTimeOffsetsGr,
papReferencedDatetimeGr,
papTextValueGr,
papConceptCodeSequenceGr,
papAnnotationGroupNumberGr,
papModifierCodeSequenceGr,
papMeasuredValueSequenceGr,
papNumericValueGr,
papPredecessorDocumentsSequenceGr,
papReferencedRequestSequenceGr,
papPerformedProcedureCodeSequenceGr,
papCurentRequestedProcedureEvidenceSequenceGr,
papPertinentOtherEvidenceSequenceGr,
papCompletionFlagGr,
papCompletionFlagDescriptionGr,
papVerificationFlagGr,
papContentTemplateSequenceGr,
papIdenticalDocumentsSequenceGr,
papContentSequenceGr,
papAnnotationSequenceGr,
papTemplateIdentifierGr,
papTemplateVersionGr,
papTemplateLocalVersionGr,
papTemplateExtensionFlagGr,
paptemplateExtensionOrganizationUIDGr,
paptemplateExtensionCreatorUIDGr,
papReferencedContentItemIdentifierGr,
papEndGroup40
};

/*	Group41		*/

enum {
papOwnerIDGr = 1,
papComments41Gr,
papPointerSequenceGr,
papImagePointerGr,
papPixelOffsetGr,
papImageIdentifierSequenceGr,
papExternalPAPYRUSFileReferenceSequenceGr,
papNumberofimagesGr,
papReferencedSOPClassUID41Gr,
papReferencedSOPInstanceUID41Gr,
papReferencedFileNameGr,
papReferencedFilePathGr,
papReferencedImageSOPClassUIDGr,
papReferencedImageSOPInstanceUIDGr,
papImageSequenceGr,
papEndGroup41
};

/*	Group50		*/

enum {
papCalibrationObjectGr = 1,
papDeviceSequenceGr,
papDeviceLengthGr,
papDeviceDiameterGr,
papDeviceDiameterUnitsGr,
papDeviceVolumeGr,
papIntermarkerDistanceGr,
papDeviceDescriptionGr,
papEndGroup50
};

/*	Group54		*/

enum {
papEnergyWindowVectorGr = 1,
papNumberofEnergyWindowsGr,
papEnergyWindowInformationSequenceGr,
papEnergyWindowRangeSequenceGr,
papEnergyWindowLowerLimitGr,
papEnergyWindowUpperLimitGr,
papRadiopharmaceuticalInformationSequenceGr,
papResidualSyringeCountsGr,
papEnergyWindowNameGr,
papDetectorVectorGr,
papNumberofDetectorsGr,
papDetectorInformationSequenceGr,
papPhaseVectorGr,
papNumberofPhasesGr,
papPhaseInformationSequenceGr,
papNumberofFramesinPhaseGr,
papPhaseDelayGr,
papPauseBetweenFramesGr,
papRotationVectorGr,
papNumberofRotationsGr,
papRotationInformationSequenceGr,
papNumberofFramesinRotationGr,
papRRIntervalVectorGr,
papNumberofRRIntervalsGr,
papGatedInformationSequenceGr,
papDataInformationSequenceGr,
papTimeSlotVectorGr,
papNumberofTimeSlotsGr,
papTimeSlotInformationSequenceGr,
papTimeSlotTimeGr,
papSliceVectorGr,
papNumberofSlicesGr,
papAngularViewVectorGr,
papTimeSliceVectorGr,
papNumberOfTimeSlicesGr,
papStartAngleGr,
papTypeofDetectorMotionGr,
papTriggerVectorGr,
papNumberofTriggersinPhaseGr,
papViewCodeSequenceGr,
papViewModifierCodeSequenceGr,
papRadionuclideCodeSequenceGr,
papAdministrationRouteCodeSequenceGr,
papRadiopharmaceuticalCodeSequenceGr,
papCalibrationDataSequenceGr,
papEnergyWindowNumberGr,
papImageIDGr,
papPatientOrientationCodeSequenceGr,
papPatientOrientationModifierCodeSequenceGr,
papPatientGantryRelationshipCodeSequenceGr,
papSeriesTypeGr,
papUnitsGr,
papCountsSourceGr,
papReprojectionMethodGr,
papRandomsCorrectionMethodGr,
papAttenuationCorrectionMethodGr,
papDecayCorrectionGr,
papReconstructionMethodGr,
papDetectorLinesOfResponseUsedGr,
papScatterCorrectionMethodGr,
papAxialAcceptanceGr,
papAxialMashGr,
papTransverseMashGr,
papDetectorElementSizeGr,
papCoincidenceWindowWidthGr,
papSecondaryCountsTypeGr,
papFrameReferenceTimeGr,
papPrimaryCountsAccumulatedGr,
papSecondaryCountsAccumulatedGr,
papSliceSensitivityFactorGr,
papDecayFactorGr,
papDoseCalibrationFactorGr,
papScatterFractionFactorGr,
papDeadTimeFactorGr,
papImageIndexGr,
papCountsIncludedGr,
papDeadTimeCorrectionFlagGr,
papEndGroup54
};


/*	Group60         */ 

enum {
papHistogramSequenceGr = 1,
papHistogramNumberofBinsGr,
papHistogramFirstBinValueGr,
papHistogramLastBinValueGr,
papHistogramBinWidthGr,
papHistogramExplanationGr,
papHistogramDataGr,
papEndGroup60
};


/*	Group70         */ 

enum {
papGraphicAnnotationSequenceGr = 1,
papGraphicLayerGr,
papBoundingBoxAnnotationUnitsGr,
papAnchorPointAnnotationUnitsGr,
papGraphicAnnotationUnitsGr,
papUnformattedTexValueGr,
papTextObjectSequenceGr,
papBoundingBoxTopLeftHandCornerGr,
papBoundingBoxBottomRightHandCornerGr,
papBoundingBoxTextHorizontalJustificationGr,
papAnchorPoint70Gr,
papAnchorPointVisibilityGr,
papGraphicDimensionsGr,
papNumberOfGraphicPointsGr,
papGraphicDataGr,
papGraphicTypeGr,
papGraphicFilledGr,
papImageHorizontalFlipGr,
papImageRotationGr,
papDisplayedAreaTopLeftHandCornerGr,
papDisplayedAreaBottomRightHandCornerGr,
papDisplayedAreaSelectionSequenceGr,
papGraphicLayerSequenceGr,
papGraphicLayerOrderGr,
papGraphicLayerRecommendedDisplayGrayscaleValueGr,
papGraphicLayerRecommendedDisplayRGBValueGr,
papGraphicLayerDescriptionGr,
papPresentationLabelGr,
papPresentationDescriptionGr,
papPresentationCreationDateGr,
papPresentationCreationTimeGr,
papPresentationCreatorsNameGr,
papPresentationSizeModeGr,
papPresentationPixelSpacingGr,
papPresentationPixelAspectRationGr,
papPresentationPixelMagnificationRatioGr,
papEndGroup70
};


/*	Group88		*/

enum {
papStorageMediaFilesetIDGr = 1,
papStorageMediaFilesetUIDGr,
papIconImageSequenceGr,
papTopicTitleGr,
papTopicSubjectGr,
papTopicAuthorGr,
papTopicKeyWordsGr,
papEndGroup88
};

/*	Group100		*/

enum {
papSOPInstanceStatusGr = 1,
papSOPAuthorizationDateAndTimeGr,
papSOPAuthorizationCommentGr,
papAuthorizationEquipmentCertificationNumberGr,
papEndGroup100
};

/*	Group2000		*/

enum {
papNumberOfCopiesGr = 1,
papPrinterConfigurationSequenceGr,
papPrintPriorityGr,
papMediumTypeGr,
papFilmDestinationGr,
papFilmSessionLabelGr,
papMemoryAllocationGr,
papMaximumMemoryAllocationGr,
papColorImagePrintingFlagGr,
papCollationFlagGr,
papAnnotationFlagGr,
papImageOverlayFlagGr,
papPresentationLUTFlagGr,
papImageBoxPresentationLUTFlagGr,
papMemoryBitDepthGr,
papPrintingBitDepthGr,
papMediaInstalledSequenceGr,
papOtherMediaInstalledSequenceGr,
papSupportedImageDisplayFormatsSequenceGr,
papReferencedFilmBoxSequenceGr,
papReferencedStoredPrintSequenceGr,
papEndGroup2000
};

/*	Group2010		*/

enum {
papImageDisplayFormatGr = 1,
papAnnotationDisplayFormatIDGr,
papFilmOrientationGr,
papFilmSizeIDGr,
papMagnificationTypeGr,
papSmoothingTypeGr,
papDefaultMagnificationTypeGr,
papOtherMagnificationTypesAvailableGr,
papDefaultSmoothingTypeGr,
papOtherSmoothingTypesAvailableGr,
papBorderDensityGr,
papEmptyImageDensityGr,
papMinDensityGr,
papMaxDensityGr,
papTrimGr,
papConfigurationInformationGr,
papConfigurationInformationDescriptionGr,
papMaximumCollatedFilmsGr,
papIlluminationGr,
papReflectedAmbientLightGr,
papPrinterPixelSpacingGr,
papReferencedFilmSessionSequenceGr,
papReferencedImageBoxSequence2010Gr,
papReferencedBasicAnnotationBoxSequenceGr,
papEndGroup2010
};

/*	Group2020		*/

enum {
papImagePosition2020Gr = 1,
papPolarityGr,
papRequestedImageSizeGr,
papRequestedDecimateCropBehaviorGr,
papRequestedResolutionIDGr,
papRequestedImageSizeFlagGr,
papDecimateCropResultGr,
papPreformattedGrayscaleImageSequenceGr,
papPreformattedColorImageSequenceGr,
papReferencedImageOverlayBoxSequenceGr,
papReferencedVOILUTBoxSequenceGr,
papEndGroup2020
};

/*	Group2030		*/

enum {
papAnnotationPositionGr = 1,
papTextStringGr,
papEndGroup2030
};

/*	Group2040		*/

enum {
papReferencedOverlayPlaneSequenceGr = 1,
papOverlayPixelDataSequenceGr,
papReferencedOverlayPlaneGroupsGr,
papOverlayMagnificationTypeGr,
papOverlayMagnificationGr,
papOverlaySmoothingTypeGr,
papOverlayOrImageMagnificationGr,
papMagnifyToNumberOfColumnsGr,
papOverlayForegroundDensityGr,
papOverlayBackgroundDensityGr,
papOverlayModeGr,
papThresholdDensityGr,
papReferencedImageBoxSequence2040Gr,
papEndGroup2040
};

/*	Group2050		*/

enum {
papPresentationLUTSequenceGr,
papPresentationLUTShapeGr,
papReferencedPresentationLUTSequenceGr,
papEndGroup2050
};

/*	Group2100		*/

enum {
papExecutionStatusGr = 1,
papExecutionStatusInfoGr,
papCreationDateGr,
papCreationTimeGr,
papOriginatorGr,
papDestinationAEGr,
papReferencedPrintJobSequenceGr,
papNumberOfFilmsGr,
papEndGroup2100
};

/*	Group2110		*/

enum {
papPrinterStatusGr = 1,
papPrinterStatusInfoGr,
papPrinterNameGr,
papPrintQueueIDGr,
papEndGroup2110
};

/*	Group2120		*/

enum {
papQueueStatusGr = 1,
papPrintJobDescriptionSequenceGr,
papreferencedPrintJobSequenceGr,
papEndGroup2120
};

/*	Group2130		*/

enum {
papPrintManagementCapabilitiesSequenceGr = 1,
papPrintCharacteristicsSequenceGr,
papFilmBoxContentSequenceGr,
papImageBoxContentSequenceGr,
papAnnotationContentSequenceGr,
papImageOverlayBoxContentSequenceGr,
papPresentationLUTContentSequenceGr,
papProposedStudySequenceGr,
papOrigianlImageSequenceGr,
papEndGroup2130
};

/*	Group3002		*/

enum {
papRTImageLabelGr,
papRTImageNameGr,
papRTImageDescriptionGr,
papReportedValuesOriginGr,
papRTImagePlaneGr,
papXRayImageReceptortranslationGr,
papXRayImageReceptorAngleGr,
papRTImageOrientationGr,
papImagePlanePixelSpacingGr,
papRTImagePositionGr,
papRadiationMachineNameGr,
papRadiationMachineSADGr,
papRadiationMachineSSDGr,
papRTImageSIDGr,
papSourcetoReferenceObjectDistanceGr,
papFractionNumberGr,
papExposureSequenceGr,
papMetersetExposureGr,
papDiaphragmPositionGr,
papEndGroup3002
};

/*	Group3004		*/

enum {
papDVHTypeGr,
papDoseUnitsGr,
papDoseTypeGr,
papDoseCommentGr,
papNormalizationPointGr,
papDoseSummationTypeGr,
papGridFrameOffsetVectorGr,
papDoseGridScalingGr,
papRTDoseROISequenceGr,
papDoseValueGr,
papDVHNormalizationPointGr,
papDVHNormalizationDoseValueGr,
papDVHSequenceGr,
papDVHDoseScalingGr,
papDVHVolumeUnitsGr,
papDVHNumberofBinsGr,
papDVHDataGr,
papDVHReferencedROISequenceGr,
papDVHROIContributionTypeGr,
papDVHMinimumDoseGr,
papDVHMaximumDoseGr,
papDVHMeanDoseGr,
papEndGroup3004
};

/*	Group3006		*/

enum {
papStructureSetLabelGr,
papStructureSetNameGr,
papStructureSetDescriptionGr,
papStructureSetDateGr,
papStructureSetTimeGr,
papReferencedFrameofReferenceSequenceGr,
papRTReferencedStudySequenceGr,
papRTReferencedSeriesSequenceGr,
papContourImageSequenceGr,
papStructureSetROISequenceGr,
papROINumberGr,
papReferencedFrameofReferenceUIDGr,
papROINameGr,
papROIDescriptionGr,
papROIDisplayColorGr,
papROIVolumeGr,
papRTRelatedROISequenceGr,
papRTROIRelationshipGr,
papROIGenerationAlgorithmGr,
papROIGenerationDescriptionGr,
papROIContourSequenceGr,
papContourSequenceGr,
papContourGeometricTypeGr,
papContourSlabThicknessGr,
papContourOffsetVectorGr,
papNumberofContourPointsGr,
papContourNumberGr,
papAttachedContoursGr,
papContourDataGr,
papRTROIObservationsSequenceGr,
papObservationNumberGr,
papReferencedROINumberGr,
papROIObservationLabelGr,
papRTROIIdentificationCodeSequenceGr,
papROIObservationDescriptionGr,
papRelatedRTROIObservationsSequenceGr,
papRTROIInterpretedTypeGr,
papROIInterpreterGr,
papROIPhysicalPropertiesSequenceGr,
papROIPhysicalPropertyGr,
papROIPhysicalPropertyValueGr,
papFrameofReferenceRelationshipSequenceGr,
papRelatedFrameofReferenceUIDGr,
papFrameofReferenceTransformationTypeGr,
papFrameofReferenceTransformationMatrixGr,
papFrameofReferenceTransformationCommentGr,
papEndGroup3006
};

/*	Group3008		*/

enum {
papMeasuredDoseReferenceSequenceGr = 1,
papMeasuredDoseDescriptionGr,
papMeasuredDoseTypeGr,
papMeasuredDoseValueGr,
papTreatmentSessionBeamSequenceGr,
papCurrentFractionNumberGr,
papTreatmentControlPointDateGr,
papTreatmentControlPointTimeGr,
papTreatmentControlTerminationStatusGr,
papTreatmentControlTerminationCodeGr,
papTreatmentVerificationStatusGr,
papReferencedTreatmentRecordSequenceGr,
papSpecifiedPrimaryMetersetGr,
papSpecifiedSecondaryMetersetGr,
papDeliveredPrimaryMetersetGr,
papDeliveredSecondaryMetersetGr,
papSpecifiedTreatmentTimeGr,
papDeliveredTreatmentTimeGr,
papControlPointDeliverySequenceGr,
papSpecifiedMetersetGr,
papDeliveredMetersetGr,
papDoseRateDeliveredGr,
papTreatmentSummaryCalculatedDoseReferenceSequenceGr,
papCumulativeDoseToDoseReferenceGr,
papFirstTreatmentDateGr,
papMostRecentTreatmentDateGr,
papNumberOfFractionsDeliveredGr,
papOverrideSequenceGr,
papOverrideParameterPointerGr,
papMeasuredDoseReferenceNumberGr,
papOverrideReasonGr,
papCalculatedDoseReferenceSequenceGr,
papCalculatedDoseReferenceNumberGr,
papCalculatedDoseReferenceDescriptionGr,
papCalculatedDoseReferenceDoseValueGr,
papStartMetersetGr,
papEndMetersetGr,
papReferencedMeasuredDoseReferenceSequenceGr,
papReferencedMeasuredDoseReferenceNumberGr,
papReferencedCalculatedDoseReferenceSequenceGr,
papReferencedCalculatedDoseReferenceNumberGr,
papBeamLimitingDeviceLeafPairsSequenceGr,
papRecordedWedgeSequenceGr,
papRecordedCompensatorSequenceGr,
papRecordedBlockSequenceGr,
papRecordedSourceSequenceGr,
papSourceSerialNumberGr,
papTreatmentSessionApplicationSetupSequenceGr,
papApplicationSetupCheckGr,
papRecordedBrachyAccessoryDeviceSequenceGr,
papreferencedBrachyAccessoryDeviceNumberGr,
papRecordedChannelSequenceGr,
papSpecifiedChannelTotalTimeGr,
papDeliveredChannelTotalTimeGr,
papSpecifiedNumberOfPulsesGr,
papDeliveredNumberOfPulsesGr,
papSpecifiedPulseRepetitionIntervalGr,
papDeliveredPulseRepetitionIntervalGr,
papRecordedSourceApplicatorSequenceGr,
papReferencedSourceApplicatorNumberGr,
papRecordedChannelShieldSequenceGr,
papReferencedCahnnelShieldNumberGr,
papBrachyControlPointDeliveredSequenceGr,
papSafePositionExitDateGr,
papSafePositionExitTimeGr,
papSafePositionReturnDateGr,
papSafePositionReturnTimeGr,
papCurrentTreatmentStatusGr,
papTreatmentStatusCommentGr,
papFractionGropSummarySequenceGr,
papReferencedFractionNumberGr,
papFractionGroupTypeGr,
papBeamStopperPositionGr,
papFractionStatusSummarySequenceGr,
papTreatmentDateGr,
papTreatmentTimeGr,
papEndGroup3008
};

/*	Group300A		*/

enum {
papRTPlanLabelGr = 1,
papRTPlanNameGr,
papRTPlanDescriptionGr,
papRTPlanDateGr,
papRTPlanTimeGr,
papTreatmentProtocolsGr,
papTreatmentIntentGr,
papTreatmentSitesGr,
papRTPlanGeometryGr,
papPrescriptionDescriptionGr,
papDoseReferenceSequenceGr,
papDoseReferenceNumberGr,
papDoseReferenceStructureTypeGr,
papNominalBeamEnergyUnitGr,
papDoseReferenceDescriptionGr,
papDoseReferencePointCoordinatesGr,
papNominalPriorDoseGr,
papDoseReferenceTypeGr,
papConstraintWeightGr,
papDeliveryWarningDoseGr,
papDeliveryMaximumDoseGr,
papTargetMinimumDoseGr,
papTargetPrescriptionDoseGr,
papTargetMaximumDoseGr,
papTargetUnderdoseVolumeFractionGr,
papOrganatRiskFullvolumeDoseGr,
papOrganatRiskLimitDoseGr,
papOrganatRiskMaximumDoseGr,
papOrganatRiskOverdoseVolumeFractionGr,
papToleranceTableSequenceGr,
papToleranceTableNumberGr,
papToleranceTableLabelGr,
papGantryAngleToleranceGr,
papBeamLimitingDeviceAngleToleranceGr,
papBeamLimitingDeviceToleranceSequenceGr,
papBeamLimitingDevicePositionToleranceGr,
papPatientSupportAngleToleranceGr,
papTableTopEccentricAngleToleranceGr,
papTableTopVerticalPositionToleranceGr,
papTableTopLongitudinalPositionToleranceGr,
papTableTopLateralPositionToleranceGr,
papRTPlanRelationshipGr,
papFractionGroupSequenceGr,
papFractionGroupNumberGr,
papNumberofFractionsPlannedGr,
papNumberofFractionsPerDayGr,
papRepeatFractionCycleLengthGr,
papFractionPatternGr,
papNumberofBeamsGr,
papBeamDoseSpecificationPointGr,
papBeamDoseGr,
papBeamMetersetGr,
papNumberofBrachyApplicationSetupsGr,
papBrachyApplicationSetupDoseSpecificationPointGr,
papBrachyApplicationSetupDoseGr,
papBeamSequenceGr,
papTreatmentMachineNameGr,
papPrimaryDosimeterUnitGr,
papSourceAxisDistanceGr,
papBeamLimitingDeviceSequenceGr,
papRTBeamLimitingDeviceTypeGr,
papSourcetoBeamLimitingDeviceDistanceGr,
papNumberofLeafJawPairsGr,
papLeafPositionBoundariesGr,
papBeamNumberGr,
papBeamNameGr,
papBeamDescriptionGr,
papBeamTypeGr,
papRadiationTypeGr,
papHighDoseTechniqueTypeGr,
papReferenceImageNumberGr,
papPlannedVerificationImageSequenceGr,
papImagingDeviceSpecificAcquisitionParametersGr,
papTreatmentDeliveryTypeGr,
papNumberofWedgesGr,
papWedgeSequenceGr,
papWedgeNumberGr,
papWedgeTypeGr,
papWedgeIDGr,
papWedgeAngleGr,
papWedgeFactorGr,
papWedgeOrientationGr,
papSourcetoWedgeTrayDistanceGr,
papNumberofCompensatorsGr,
papMaterialIDGr,
papTotalCompensatorTrayFactorGr,
papCompensatorSequenceGr,
papCompensatorNumberGr,
papCompensatorIDGr,
papSourcetoCompensatorTrayDistanceGr,
papCompensatorRowsGr,
papCompensatorColumnsGr,
papCompensatorPixelSpacingGr,
papCompensatorPositionGr,
papCompensatorTransmissionDataGr,
papCompensatorThicknessDataGr,
papNumberofBoliGr,
papCompensatorTypeGr,
papNumberofBlocksGr,
papTotalBlockTrayFactorGr,
papBlockSequenceGr,
papBlockTrayIDGr,
papSourcetoBlockTrayDistanceGr,
papBlockTypeGr,
papBlockDivergenceGr,
papBlockNumberGr,
papBlockNameGr,
papBlockThicknessGr,
papBlockTransmissionGr,
papBlockNumberofPointsGr,
papBlockDataGr,
papApplicatorSequenceGr,
papApplicatorIDGr,
papApplicatorTypeGr,
papApplicatorDescriptionGr,
papCumulativeDoseReferenceCoefficientGr,
papFinalCumulativeMetersetWeightGr,
papNumberofControlPointsGr,
papControlPointSequenceGr,
papControlPointIndexGr,
papNominalBeamEnergyGr,
papDoseRateSetGr,
papWedgePositionSequenceGr,
papWedgePositionGr,
papBeamLimitingDevicePositionSequenceGr,
papLeafJawPositionsGr,
papGantryAngleGr,
papGantryRotationDirectionGr,
papBeamLimitingDeviceAngleGr,
papBeamLimitingDeviceRotationDirectionGr,
papPatientSupportAngleGr,
papPatientSupportRotationDirectionGr,
papTableTopEccentricAxisDistanceGr,
papTableTopEccentricAngleGr,
papTableTopEccentricRotationDirectionGr,
papTableTopVerticalPositionGr,
papTableTopLongitudinalPositionGr,
papTableTopLateralPositionGr,
papIsocenterPositionGr,
papSurfaceEntryPointGr,
papSourcetoSurfaceDistanceGr,
papCumulativeMetersetWeightGr,
papPatientSetupSequenceGr,
papPatientSetupNumberGr,
papPatientAdditionalPositionGr,
papFixationDeviceSequenceGr,
papFixationDeviceTypeGr,
papFixationDeviceLabelGr,
papFixationDeviceDescriptionGr,
papFixationDevicePositionGr,
papShieldingDeviceSequenceGr,
papShieldingDeviceTypeGr,
papShieldingDeviceLabelGr,
papShieldingDeviceDescriptionGr,
papShieldingDevicePositionGr,
papSetupTechniqueGr,
papSetupTechniqueDescriptionGr,
papSetupDeviceSequenceGr,
papSetupDeviceTypeGr,
papSetupDeviceLabelGr,
papSetupDeviceDescriptionGr,
papSetupDeviceParameterGr,
papSetupReferenceDescriptionGr,
papTableTopVerticalSetupDisplacementGr,
papTableTopLongitudinalSetupDisplacementGr,
papTableTopLateralSetupDisplacementGr,
papBrachyTreatmentTechniqueGr,
papBrachyTreatmentTypeGr,
papTreatmentMachineSequenceGr,
papSourceSequenceGr,
papSourceNumberGr,
papSourceTypeGr,
papSourceManufacturerGr,
papActiveSourceDiameterGr,
papActiveSourceLengthGr,
papSourceEncapsulationNominalThicknessGr,
papSourceEncapsulationNominalTransmissionGr,
papSourceIsotopeNameGr,
papSourceIsotopeHalfLifeGr,
papReferenceAirKermaRateGr,
papAirKermaRateReferenceDateGr,
papAirKermaRateReferenceTimeGr,
papApplicationSetupSequenceGr,
papApplicationSetupTypeGr,
papApplicationSetupNumberGr,
papApplicationSetupNameGr,
papApplicationSetupManufacturerGr,
papTemplateNumberGr,
papTemplateTypeGr,
papTemplateNameGr,
papTotalReferenceAirKermaGr,
papBrachyAccessoryDeviceSequenceGr,
papBrachyAccessoryDeviceNumberGr,
papBrachyAccessoryDeviceIDGr,
papBrachyAccessoryDeviceTypeGr,
papBrachyAccessoryDeviceNameGr,
papBrachyAccessoryDeviceNominalThicknessGr,
papBrachyAccessoryDeviceNominalTransmissionGr,
papChannelSequenceGr,
papChannelNumberGr,
papChannelLengthGr,
papChannelTotalTimeGr,
papSourceMovementTypeGr,
papNumberofPulsesGr,
papPulseRepetitionIntervalGr,
papSourceApplicatorNumberGr,
papSourceApplicatorIDGr,
papSourceApplicatorTypeGr,
papSourceApplicatorNameGr,
papSourceApplicatorLengthGr,
papSourceApplicatorManufacturerGr,
papSourceApplicatorWallNominalThicknessGr,
papSourceApplicatorWallNominalTransmissionGr,
papSourceApplicatorStepSizeGr,
papTransferTubeNumberGr,
papTransferTubeLengthGr,
papChannelShieldSequenceGr,
papChannelShieldNumberGr,
papChannelShieldIDGr,
papChannelShieldNameGr,
papChannelShieldNominalThicknessGr,
papChannelShieldNominalTransmissionGr,
papFinalCumulativeTimeWeightGr,
papBrachyControlPointSequenceGr,
papControlPointRelativePositionGr,
papControlPoint3DPositionGr,
papCumulativeTimeWeightGr,
papEndGroup300A
};

/*	Group300C		*/

enum {
papReferencedRTPlanSequenceGr,
papReferencedBeamSequenceGr,
papReferencedBeamNumberGr,
papReferencedReferenceImageNumberGr,
papStartCumulativeMetersetWeightGr,
papEndCumulativeMetersetWeightGr,
papReferencedBrachyApplicationSetupSequenceGr,
papReferencedBrachyApplicationSetupNumberGr,
papReferencedSourceNumberGr,
papReferencedFractionGroupSequenceGr,
papReferencedFractionGroupNumberGr,
papReferencedVerificationImageSequenceGr,
papReferencedReferenceImageSequenceGr,
papReferencedDoseReferenceSequenceGr,
papReferencedDoseReferenceNumberGr,
papBrachyReferencedDoseReferenceSequenceGr,
papReferencedStructureSetSequenceGr,
papReferencedPatientSetupNumberGr,
papReferencedDoseSequenceGr,
papReferencedToleranceTableNumberGr,
papReferencedBolusSequenceGr,
papReferencedWedgeNumberGr,
papReferencedCompensatorNumberGr,
papReferencedBlockNumberGr,
papReferencedControlPointIndexGr,
papEndGroup300C
};

/*	Group300E		*/

enum {
papApprovalStatusGr,
papReviewDateGr,
papReviewTimeGr,
papReviewerNameGr,
papEndGroup300E
};

/*	Group4000		*/

enum {
papArbitraryGr = 1,
papCommentsGr,
papEndGroup4000
};

/*	Group4008		*/

enum {
papResultsIDGr = 1,
papResultsIDIssuerGr,
papReferencedInterpretationSequenceGr,
papInterpretationRecordedDateGr,
papInterpretationRecordedTimeGr,
papInterpretationRecorderGr,
papReferencetoRecordedSoundGr,
papInterpretationTranscriptionDateGr,
papInterpretationTranscriptionTimeGr,
papInterpretationTranscriberGr,
papInterpretationTextGr,
papInterpretationAuthorGr,
papInterpretationApproverSequenceGr,
papInterpretationApprovalDateGr,
papInterpretationApprovalTimeGr,
papPhysicianApprovingInterpretationGr,
papInterpretationDiagnosisDescriptionGr,
papDiagnosisCodeSequenceGr,
papResultsDistributionListSequenceGr,
papDistributionNameGr,
papDistributionAddressGr,
papInterpretationIDGr,
papInterpretationIDIssuerGr,
papInterpretationTypeIDGr,
papInterpretationStatusIDGr,
papImpressionsGr,
papResultsCommentsGr,
papEndGroup4008
};

/*	Group5000		*/

enum {
papCurveDimensionsGr = 1,
papNumberofPointsGr,
papTypeofDataGr,
papCurveDescriptionGr,
papAxisUnitsGr,
papAxisLabelsGr,
papDataValueRepresentationGr,
papMinimumCoordinateValueGr,
papMaximumCoordinateValueGr,
papCurveRangeGr,
papCurveDataDescriptorGr,
papCoordinateStartValueGr,
papCoordinateStepValueGr,
papCurveActivationLayerGr,
papAudioTypeGr,
papAudioSampleFormatGr,
papNumberofChannelsGr,
papNumberofSamplesGr,
papSampleRateGr,
papTotalTimeGr,
papAudioSampleDataGr,
papAudioCommentsGr,
papCurveLabelGr,
papReferencedOverlaySequence5000Gr,
papReferencedOverlayGroupGr,
papCurveDataGr,
papEndGroup5000
};

/*	Group5400		*/

enum {
papWaveformSequenceGr = 1,
papChannelMinimumValueGr,
papChannelMaximumValueGr,
papWaveformBitsAllocatedGr,
papWaveformSampleInterpretationGr,
papWaveformPaddingValueGr,
papWaveformDataGr,
papEndGroup5400
};

/*	Group6000		*/

enum {
papOverlayRows6000Gr = 1,
papOverlayColumns6000Gr,
papOverlayPlanesGr,
papNumberofFramesinOverlayGr,
papOverlayDescriptionGr,
papOverlayTypeGr,
papOverlaySubtypeGr,
papOriginGr,
papImageFrameOriginGr,
papOverlayPlaneOriginGr,
papCompressionCode6000Gr,
papOverlayBitsAllocatedGr,
papBitPositionGr,
papOverlayFormatGr,
papOverlayLocationGr,
papOverlayActivationLayerGr,
papOverlayDescriptorGrayGr,
papOverlayDescriptorRedGr,
papOverlayDescriptorGreenGr,
papOverlayDescriptorBlueGr,
papOverlaysGrayGr,
papOverlaysRedGr,
papOverlaysGreenGr,
papOverlaysBlueGr,
papROIAreaGr,
papROIMeanGr,
papROIStandardDeviationGr,
papOverlayLabelGr,
papOverlayDataGr,
papComments6000Gr,
papEndGroup6000
};

/*	UINOVERLAY	 Group 6XXX (odd)	*/

enum {
/* papGroupLength */
/* papOwnerId */
papOverlayIdGr = 2,
papLinkedOverlaysGr,
papOverlayRowsGr,
papOverlayColumnsGr,
papUINOverlayTypeGr,
papOverlayOriginGr,
papEditableGr,
papOverlayFontGr,
papOverlayStyleGr,
papOverlayFontSizeGr,
papOverlayColorGr,
papShadowSizeGr,
papFillPatternGr,
papOverlayPenSizeGr,
papLabelGr,
papPostItTextGr,
papAnchorPointGr,
papRoiTypeGr,
papAttachedAnnotationGr,
papContourPointsGr,
papInfoIntGr,
papInfoFloatGr,
papMaskDataGr,
papUINOverlaySequenceGr,
papEndUINOverlay
};

/*	Group7FE0		*/

enum {
papPixelDataGr = 1,
papEndGroup7FE0
};


#endif
