# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cognitiveservices import CognitiveServicesManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCognitiveServicesManagementQuotaTiersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CognitiveServicesManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_tiers_list_by_subscription(self, resource_group):
        response = self.client.quota_tiers.list_by_subscription(
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_tiers_get(self, resource_group):
        response = self.client.quota_tiers.get(
            default="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_tiers_update(self, resource_group):
        response = self.client.quota_tiers.update(
            default="str",
            tier={
                "id": "str",
                "name": "str",
                "properties": {
                    "assignmentDate": "2020-02-20 00:00:00",
                    "currentTierName": "str",
                    "tierUpgradeEligibilityInfo": {
                        "nextTierName": "str",
                        "upgradeApplicableDate": "2020-02-20 00:00:00",
                        "upgradeAvailabilityStatus": "str",
                        "upgradeUnavailabilityReason": "str",
                    },
                    "tierUpgradePolicy": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_quota_tiers_create_or_update(self, resource_group):
        response = self.client.quota_tiers.create_or_update(
            default="str",
            tier={
                "id": "str",
                "name": "str",
                "properties": {
                    "assignmentDate": "2020-02-20 00:00:00",
                    "currentTierName": "str",
                    "tierUpgradeEligibilityInfo": {
                        "nextTierName": "str",
                        "upgradeApplicableDate": "2020-02-20 00:00:00",
                        "upgradeAvailabilityStatus": "str",
                        "upgradeUnavailabilityReason": "str",
                    },
                    "tierUpgradePolicy": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...
