# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class AccessPolicyEntity(ProxyResource):
    """Access policies help define the authentication rules, and control access to specific video resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param role: Defines the access level granted by this policy. Possible values include:
     "Reader".
    :type role: str or ~video_analyzer.models.AccessPolicyRole
    :param authentication: Authentication method to be used when validating client API access.
    :type authentication: ~video_analyzer.models.AuthenticationBase
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'authentication': {'key': 'properties.authentication', 'type': 'AuthenticationBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessPolicyEntity, self).__init__(**kwargs)
        self.role = kwargs.get('role', None)
        self.authentication = kwargs.get('authentication', None)


class AccessPolicyEntityCollection(msrest.serialization.Model):
    """A collection of AccessPolicyEntity items.

    :param value: A collection of AccessPolicyEntity items.
    :type value: list[~video_analyzer.models.AccessPolicyEntity]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AccessPolicyEntity]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessPolicyEntityCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AccountEncryption(msrest.serialization.Model):
    """Defines how the Video Analyzer account is (optionally) encrypted.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of key used to encrypt the Account Key. Possible values
     include: "SystemKey", "CustomerKey".
    :type type: str or ~video_analyzer.models.AccountEncryptionKeyType
    :param key_vault_properties: The properties of the key used to encrypt the account.
    :type key_vault_properties: ~video_analyzer.models.KeyVaultProperties
    :param identity: The Key Vault identity.
    :type identity: ~video_analyzer.models.ResourceIdentity
    :ivar status: The current status of the Key Vault mapping.
    :vartype status: str
    """

    _validation = {
        'type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountEncryption, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.identity = kwargs.get('identity', None)
        self.status = None


class AudioEncoderBase(msrest.serialization.Model):
    """Base type for all audio encoder presets, which define the recipe or instructions on how audio should be processed.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AudioEncoderAac.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param bitrate_kbps: Bitrate, in kilobits per second or Kbps, at which audio should be encoded
     (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160,
     192, 224, and 256. If omitted, the bitrate of the input audio is used.
    :type bitrate_kbps: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'bitrate_kbps': {'key': 'bitrateKbps', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.AudioEncoderAac': 'AudioEncoderAac'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AudioEncoderBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.bitrate_kbps = kwargs.get('bitrate_kbps', None)


class AudioEncoderAac(AudioEncoderBase):
    """A custom preset for encoding audio with the AAC codec.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param bitrate_kbps: Bitrate, in kilobits per second or Kbps, at which audio should be encoded
     (2-channel stereo audio at a sampling rate of 48 kHz). Allowed values are 96, 112, 128, 160,
     192, 224, and 256. If omitted, the bitrate of the input audio is used.
    :type bitrate_kbps: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'bitrate_kbps': {'key': 'bitrateKbps', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AudioEncoderAac, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.AudioEncoderAac'  # type: str


class AuthenticationBase(msrest.serialization.Model):
    """Base class for access policies authentication methods.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JwtAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.JwtAuthentication': 'JwtAuthentication'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthenticationBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CertificateSource(msrest.serialization.Model):
    """Base class for certificate sources.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PemCertificateList.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.PemCertificateList': 'PemCertificateList'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateSource, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """The check availability request body.

    :param name: The name of the resource for which availability needs to be checked.
    :type name: str
    :param type: The resource type.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class CheckNameAvailabilityResponse(msrest.serialization.Model):
    """The check availability result.

    :param name_available: Indicates if the resource name is available.
    :type name_available: bool
    :param reason: The reason why the given name is not available. Possible values include:
     "Invalid", "AlreadyExists".
    :type reason: str or ~video_analyzer.models.CheckNameAvailabilityReason
    :param message: Detailed reason why the given name is available.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class CredentialsBase(msrest.serialization.Model):
    """Base class for credential objects.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: UsernamePasswordCredentials.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.UsernamePasswordCredentials': 'UsernamePasswordCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CredentialsBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class TokenKey(msrest.serialization.Model):
    """Key properties for JWT token validation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EccTokenKey, RsaTokenKey.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param kid: Required. JWT token key id. Validation keys are looked up based on the key id
     present on the JWT token header.
    :type kid: str
    """

    _validation = {
        'type': {'required': True},
        'kid': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.EccTokenKey': 'EccTokenKey', '#Microsoft.VideoAnalyzer.RsaTokenKey': 'RsaTokenKey'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenKey, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.kid = kwargs['kid']


class EccTokenKey(TokenKey):
    """Required validation properties for tokens generated with Elliptical Curve algorithm.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param kid: Required. JWT token key id. Validation keys are looked up based on the key id
     present on the JWT token header.
    :type kid: str
    :param alg: Required. Elliptical curve algorithm to be used: ES256, ES384 or ES512. Possible
     values include: "ES256", "ES384", "ES512".
    :type alg: str or ~video_analyzer.models.AccessPolicyEccAlgo
    :param x: Required. X coordinate.
    :type x: str
    :param y: Required. Y coordinate.
    :type y: str
    """

    _validation = {
        'type': {'required': True},
        'kid': {'required': True},
        'alg': {'required': True},
        'x': {'required': True},
        'y': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'alg': {'key': 'alg', 'type': 'str'},
        'x': {'key': 'x', 'type': 'str'},
        'y': {'key': 'y', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EccTokenKey, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.EccTokenKey'  # type: str
        self.alg = kwargs['alg']
        self.x = kwargs['x']
        self.y = kwargs['y']


class EdgeModuleEntity(ProxyResource):
    """The representation of an edge module.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :ivar edge_module_id: Internal ID generated for the instance of the Video Analyzer edge module.
    :vartype edge_module_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'edge_module_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'edge_module_id': {'key': 'properties.edgeModuleId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EdgeModuleEntity, self).__init__(**kwargs)
        self.edge_module_id = None


class EdgeModuleEntityCollection(msrest.serialization.Model):
    """A collection of EdgeModuleEntity items.

    :param value: A collection of EdgeModuleEntity items.
    :type value: list[~video_analyzer.models.EdgeModuleEntity]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EdgeModuleEntity]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EdgeModuleEntityCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class EdgeModuleProvisioningToken(msrest.serialization.Model):
    """Provisioning token properties. A provisioning token allows for a single instance of Azure Video analyzer IoT edge module to be initialized and authorized to the cloud account. The provisioning token itself is short lived and it is only used for the initial handshake between IoT edge module and the cloud. After the initial handshake, the IoT edge module will agree on a set of authentication keys which will be auto-rotated as long as the module is able to periodically connect to the cloud. A new provisioning token can be generated for the same IoT edge module in case the module state lost or reset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_date: The expiration date of the registration token. The Azure Video Analyzer
     IoT edge module must be initialized and connected to the Internet prior to the token expiration
     date.
    :vartype expiration_date: ~datetime.datetime
    :ivar token: The token blob to be provided to the Azure Video Analyzer IoT edge module through
     the Azure IoT Edge module twin properties.
    :vartype token: str
    """

    _validation = {
        'expiration_date': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EdgeModuleProvisioningToken, self).__init__(**kwargs)
        self.expiration_date = None
        self.token = None


class EncoderPresetBase(msrest.serialization.Model):
    """Base type for all encoder presets, which define the recipe or instructions on how the input content should be processed.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EncoderCustomPreset, EncoderSystemPreset.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.EncoderCustomPreset': 'EncoderCustomPreset', '#Microsoft.VideoAnalyzer.EncoderSystemPreset': 'EncoderSystemPreset'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncoderPresetBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class EncoderCustomPreset(EncoderPresetBase):
    """Describes a custom preset for encoding the input content using the encoder processor.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param audio_encoder: Describes a custom preset for encoding audio.
    :type audio_encoder: ~video_analyzer.models.AudioEncoderBase
    :param video_encoder: Describes a custom preset for encoding video.
    :type video_encoder: ~video_analyzer.models.VideoEncoderBase
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'audio_encoder': {'key': 'audioEncoder', 'type': 'AudioEncoderBase'},
        'video_encoder': {'key': 'videoEncoder', 'type': 'VideoEncoderBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncoderCustomPreset, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.EncoderCustomPreset'  # type: str
        self.audio_encoder = kwargs.get('audio_encoder', None)
        self.video_encoder = kwargs.get('video_encoder', None)


class NodeBase(msrest.serialization.Model):
    """Base class for nodes.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ProcessorNodeBase, SinkNodeBase, SourceNodeBase.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.ProcessorNodeBase': 'ProcessorNodeBase', '#Microsoft.VideoAnalyzer.SinkNodeBase': 'SinkNodeBase', '#Microsoft.VideoAnalyzer.SourceNodeBase': 'SourceNodeBase'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.name = kwargs['name']


class ProcessorNodeBase(NodeBase):
    """Base class for topology processor nodes.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EncoderProcessor.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    :param inputs: Required. An array of upstream node references within the topology to be used as
     inputs for this node.
    :type inputs: list[~video_analyzer.models.NodeInput]
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[NodeInput]'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.EncoderProcessor': 'EncoderProcessor'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessorNodeBase, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.ProcessorNodeBase'  # type: str
        self.inputs = kwargs['inputs']


class EncoderProcessor(ProcessorNodeBase):
    """Encoder processor allows for encoding of the input content. For example, it can used to change the resolution from 4K to 1280x720.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    :param inputs: Required. An array of upstream node references within the topology to be used as
     inputs for this node.
    :type inputs: list[~video_analyzer.models.NodeInput]
    :param preset: Required. The encoder preset, which defines the recipe or instructions on how
     the input content should be processed.
    :type preset: ~video_analyzer.models.EncoderPresetBase
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'preset': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[NodeInput]'},
        'preset': {'key': 'preset', 'type': 'EncoderPresetBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncoderProcessor, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.EncoderProcessor'  # type: str
        self.preset = kwargs['preset']


class EncoderSystemPreset(EncoderPresetBase):
    """Describes a built-in preset for encoding the input content using the encoder processor.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Name of the built-in encoding preset. Possible values include:
     "SingleLayer_540p_H264_AAC", "SingleLayer_720p_H264_AAC", "SingleLayer_1080p_H264_AAC",
     "SingleLayer_2160p_H264_AAC".
    :type name: str or ~video_analyzer.models.EncoderSystemPresetType
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncoderSystemPreset, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.EncoderSystemPreset'  # type: str
        self.name = kwargs['name']


class Endpoint(msrest.serialization.Model):
    """The endpoint details.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_url: The URL of the endpoint.
    :type endpoint_url: str
    :param type: Required. The type of the endpoint. Possible values include: "ClientApi".
    :type type: str or ~video_analyzer.models.VideoAnalyzerEndpointType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Endpoint, self).__init__(**kwargs)
        self.endpoint_url = kwargs.get('endpoint_url', None)
        self.type = kwargs['type']


class EndpointBase(msrest.serialization.Model):
    """Base class for endpoints.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TlsEndpoint, UnsecuredEndpoint.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param credentials: Required. Credentials to be presented to the endpoint.
    :type credentials: ~video_analyzer.models.CredentialsBase
    :param url: Required. The endpoint URL for Video Analyzer to connect to.
    :type url: str
    :param tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint
     URL. This is an optional property, typically used when the endpoint is behind a firewall.
    :type tunnel: ~video_analyzer.models.TunnelBase
    """

    _validation = {
        'type': {'required': True},
        'credentials': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CredentialsBase'},
        'url': {'key': 'url', 'type': 'str'},
        'tunnel': {'key': 'tunnel', 'type': 'TunnelBase'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.TlsEndpoint': 'TlsEndpoint', '#Microsoft.VideoAnalyzer.UnsecuredEndpoint': 'UnsecuredEndpoint'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.credentials = kwargs['credentials']
        self.url = kwargs['url']
        self.tunnel = kwargs.get('tunnel', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~video_analyzer.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~video_analyzer.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~video_analyzer.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class GroupLevelAccessControl(msrest.serialization.Model):
    """Group level network access control.

    :param public_network_access: Whether or not public network access is allowed for specified
     resources under the Video Analyzer account. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~video_analyzer.models.PublicNetworkAccess
    """

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupLevelAccessControl, self).__init__(**kwargs)
        self.public_network_access = kwargs.get('public_network_access', None)


class IotHub(msrest.serialization.Model):
    """The IoT Hub details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The IoT Hub resource identifier.
    :type id: str
    :param identity: Required. The IoT Hub identity.
    :type identity: ~video_analyzer.models.ResourceIdentity
    :ivar status: The current status of the Iot Hub mapping.
    :vartype status: str
    """

    _validation = {
        'id': {'required': True},
        'identity': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHub, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.identity = kwargs['identity']
        self.status = None


class JwtAuthentication(AuthenticationBase):
    """Properties for access validation based on JSON Web Tokens (JWT).

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param issuers: List of expected token issuers. Token issuer is valid if it matches at least
     one of the given values.
    :type issuers: list[str]
    :param audiences: List of expected token audiences. Token audience is valid if it matches at
     least one of the given values.
    :type audiences: list[str]
    :param claims: List of additional token claims to be validated. Token must contains all claims
     and respective values for it to be valid.
    :type claims: list[~video_analyzer.models.TokenClaim]
    :param keys: List of keys which can be used to validate access tokens. Having multiple keys
     allow for seamless key rotation of the token signing key. Token signature must match exactly
     one key.
    :type keys: list[~video_analyzer.models.TokenKey]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'issuers': {'key': 'issuers', 'type': '[str]'},
        'audiences': {'key': 'audiences', 'type': '[str]'},
        'claims': {'key': 'claims', 'type': '[TokenClaim]'},
        'keys': {'key': 'keys', 'type': '[TokenKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JwtAuthentication, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.JwtAuthentication'  # type: str
        self.issuers = kwargs.get('issuers', None)
        self.audiences = kwargs.get('audiences', None)
        self.claims = kwargs.get('claims', None)
        self.keys = kwargs.get('keys', None)


class KeyVaultProperties(msrest.serialization.Model):
    """The details for accessing the encryption keys in Key Vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param key_identifier: Required. The URL of the Key Vault key used to encrypt the account. The
     key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key
     without a version (for example https://vault/keys/mykey).
    :type key_identifier: str
    :ivar current_key_identifier: The current key used to encrypt Video Analyzer account, including
     the key version.
    :vartype current_key_identifier: str
    """

    _validation = {
        'key_identifier': {'required': True},
        'current_key_identifier': {'readonly': True},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'current_key_identifier': {'key': 'currentKeyIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = kwargs['key_identifier']
        self.current_key_identifier = None


class ListProvisioningTokenInput(msrest.serialization.Model):
    """The input parameters to generate registration token for the Azure Video Analyzer IoT edge module.

    All required parameters must be populated in order to send to Azure.

    :param expiration_date: Required. The desired expiration date of the registration token. The
     Azure Video Analyzer IoT edge module must be initialized and connected to the Internet prior to
     the token expiration date.
    :type expiration_date: ~datetime.datetime
    """

    _validation = {
        'expiration_date': {'required': True},
    }

    _attribute_map = {
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListProvisioningTokenInput, self).__init__(**kwargs)
        self.expiration_date = kwargs['expiration_date']


class LivePipeline(ProxyResource):
    """Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and publishing of content for a unique RTSP camera.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param topology_name: The reference to an existing pipeline topology defined for real-time
     content processing. When activated, this live pipeline will process content according to the
     pipeline topology definition.
    :type topology_name: str
    :param description: An optional description for the pipeline.
    :type description: str
    :param bitrate_kbps: Maximum bitrate capacity in Kbps reserved for the live pipeline. The
     allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds
     this capacity, then the service will disconnect temporarily from the camera. It will retry to
     re-establish connection (with exponential backoff), checking to see if the camera bitrate is
     now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect
     other live pipelines in your account.
    :type bitrate_kbps: int
    :ivar state: Current state of the pipeline (read-only). Possible values include: "Inactive",
     "Activating", "Active", "Deactivating".
    :vartype state: str or ~video_analyzer.models.LivePipelineState
    :param parameters: List of the instance level parameter values for the user-defined topology
     parameters. A pipeline can only define or override parameters values for parameters which have
     been declared in the referenced topology. Topology parameters without a default value must be
     defined. Topology parameters with a default value can be optionally be overridden.
    :type parameters: list[~video_analyzer.models.ParameterDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'topology_name': {'key': 'properties.topologyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'bitrate_kbps': {'key': 'properties.bitrateKbps', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ParameterDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivePipeline, self).__init__(**kwargs)
        self.topology_name = kwargs.get('topology_name', None)
        self.description = kwargs.get('description', None)
        self.bitrate_kbps = kwargs.get('bitrate_kbps', None)
        self.state = None
        self.parameters = kwargs.get('parameters', None)


class LivePipelineCollection(msrest.serialization.Model):
    """A collection of LivePipeline items.

    :param value: A collection of LivePipeline items.
    :type value: list[~video_analyzer.models.LivePipeline]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LivePipeline]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivePipelineCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class LivePipelineOperationStatus(msrest.serialization.Model):
    """Used for tracking the status of an operation on the live pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the live pipeline operation.
    :vartype name: str
    :ivar status: The status of the live pipeline operation.
    :vartype status: str
    :ivar error: The error details for the live pipeline operation.
    :vartype error: ~video_analyzer.models.ErrorDetail
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivePipelineOperationStatus, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.error = None


class LivePipelineUpdate(ProxyResource):
    """Live pipeline represents a unique instance of a live topology, used for real-time ingestion, archiving and publishing of content for a unique RTSP camera.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param topology_name: The reference to an existing pipeline topology defined for real-time
     content processing. When activated, this live pipeline will process content according to the
     pipeline topology definition.
    :type topology_name: str
    :param description: An optional description for the pipeline.
    :type description: str
    :param bitrate_kbps: Maximum bitrate capacity in Kbps reserved for the live pipeline. The
     allowed range is from 500 to 3000 Kbps in increments of 100 Kbps. If the RTSP camera exceeds
     this capacity, then the service will disconnect temporarily from the camera. It will retry to
     re-establish connection (with exponential backoff), checking to see if the camera bitrate is
     now below the reserved capacity. Doing so will ensure that one 'noisy neighbor' does not affect
     other live pipelines in your account.
    :type bitrate_kbps: int
    :ivar state: Current state of the pipeline (read-only). Possible values include: "Inactive",
     "Activating", "Active", "Deactivating".
    :vartype state: str or ~video_analyzer.models.LivePipelineState
    :param parameters: List of the instance level parameter values for the user-defined topology
     parameters. A pipeline can only define or override parameters values for parameters which have
     been declared in the referenced topology. Topology parameters without a default value must be
     defined. Topology parameters with a default value can be optionally be overridden.
    :type parameters: list[~video_analyzer.models.ParameterDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'topology_name': {'key': 'properties.topologyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'bitrate_kbps': {'key': 'properties.bitrateKbps', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ParameterDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivePipelineUpdate, self).__init__(**kwargs)
        self.topology_name = kwargs.get('topology_name', None)
        self.description = kwargs.get('description', None)
        self.bitrate_kbps = kwargs.get('bitrate_kbps', None)
        self.state = None
        self.parameters = kwargs.get('parameters', None)


class LogSpecification(msrest.serialization.Model):
    """A diagnostic log emitted by service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The diagnostic log category name.
    :vartype name: str
    :ivar display_name: The diagnostic log category display name.
    :vartype display_name: str
    :ivar blob_duration: The time range for requests in each blob.
    :vartype blob_duration: str
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'blob_duration': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.blob_duration = None


class MetricDimension(msrest.serialization.Model):
    """A metric dimension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The metric dimension name.
    :vartype name: str
    :ivar display_name: The display name for the dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Whether to export metric to shoebox.
    :vartype to_be_exported_for_shoebox: bool
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'to_be_exported_for_shoebox': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.to_be_exported_for_shoebox = None


class MetricSpecification(msrest.serialization.Model):
    """A metric emitted by service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The metric name.
    :vartype name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar display_description: The metric display description.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: "Bytes", "Count", "Milliseconds".
    :vartype unit: str or ~video_analyzer.models.MetricUnit
    :ivar aggregation_type: The metric aggregation type. Possible values include: "Average",
     "Count", "Total".
    :vartype aggregation_type: str or ~video_analyzer.models.MetricAggregationType
    :ivar lock_aggregation_type: The metric lock aggregation type. Possible values include:
     "Average", "Count", "Total".
    :vartype lock_aggregation_type: str or ~video_analyzer.models.MetricAggregationType
    :param supported_aggregation_types: Supported aggregation types.
    :type supported_aggregation_types: list[str]
    :ivar dimensions: The metric dimensions.
    :vartype dimensions: list[~video_analyzer.models.MetricDimension]
    :ivar enable_regional_mdm_account: Indicates whether regional MDM account is enabled.
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar supported_time_grain_types: The supported time grain types.
    :vartype supported_time_grain_types: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'display_description': {'readonly': True},
        'unit': {'readonly': True},
        'aggregation_type': {'readonly': True},
        'lock_aggregation_type': {'readonly': True},
        'dimensions': {'readonly': True},
        'enable_regional_mdm_account': {'readonly': True},
        'source_mdm_account': {'readonly': True},
        'source_mdm_namespace': {'readonly': True},
        'supported_time_grain_types': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'lock_aggregation_type': {'key': 'lockAggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.display_description = None
        self.unit = None
        self.aggregation_type = None
        self.lock_aggregation_type = None
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.dimensions = None
        self.enable_regional_mdm_account = None
        self.source_mdm_account = None
        self.source_mdm_namespace = None
        self.supported_time_grain_types = None


class NetworkAccessControl(msrest.serialization.Model):
    """Network access control for video analyzer account.

    :param integration: Public network access for integration group.
    :type integration: ~video_analyzer.models.GroupLevelAccessControl
    :param ingestion: Public network access for ingestion group.
    :type ingestion: ~video_analyzer.models.GroupLevelAccessControl
    :param consumption: Public network access for consumption group.
    :type consumption: ~video_analyzer.models.GroupLevelAccessControl
    """

    _attribute_map = {
        'integration': {'key': 'integration', 'type': 'GroupLevelAccessControl'},
        'ingestion': {'key': 'ingestion', 'type': 'GroupLevelAccessControl'},
        'consumption': {'key': 'consumption', 'type': 'GroupLevelAccessControl'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkAccessControl, self).__init__(**kwargs)
        self.integration = kwargs.get('integration', None)
        self.ingestion = kwargs.get('ingestion', None)
        self.consumption = kwargs.get('consumption', None)


class NodeInput(msrest.serialization.Model):
    """Describes an input signal to be used on a pipeline node.

    All required parameters must be populated in order to send to Azure.

    :param node_name: Required. The name of the upstream node in the pipeline which output is used
     as input of the current node.
    :type node_name: str
    """

    _validation = {
        'node_name': {'required': True},
    }

    _attribute_map = {
        'node_name': {'key': 'nodeName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeInput, self).__init__(**kwargs)
        self.node_name = kwargs['node_name']


class Operation(msrest.serialization.Model):
    """An operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The operation name.
    :type name: str
    :param display: The operation display name.
    :type display: ~video_analyzer.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Operation properties format.
    :type properties: ~video_analyzer.models.Properties
    :param is_data_action: Whether the operation applies to data-plane.
    :type is_data_action: bool
    :param action_type: Indicates the action type. Possible values include: "Internal".
    :type action_type: str or ~video_analyzer.models.ActionType
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Properties'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.action_type = kwargs.get('action_type', None)


class OperationCollection(msrest.serialization.Model):
    """A collection of Operation items.

    :param value: A collection of Operation items.
    :type value: list[~video_analyzer.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class OperationDisplay(msrest.serialization.Model):
    """Operation details.

    :param provider: The service provider.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: The operation type.
    :type operation: str
    :param description: The operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class ParameterDeclaration(msrest.serialization.Model):
    """Single topology parameter declaration. Declared parameters can and must be referenced throughout the topology and can optionally have default values to be used when they are not defined in the pipelines.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the parameter.
    :type name: str
    :param type: Required. Type of the parameter. Possible values include: "String",
     "SecretString", "Int", "Double", "Bool".
    :type type: str or ~video_analyzer.models.ParameterType
    :param description: Description of the parameter.
    :type description: str
    :param default: The default value for the parameter to be used if the pipeline does not specify
     a value.
    :type default: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParameterDeclaration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.description = kwargs.get('description', None)
        self.default = kwargs.get('default', None)


class ParameterDefinition(msrest.serialization.Model):
    """Defines the parameter value of an specific pipeline topology parameter. See pipeline topology parameters for more information.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the parameter declared in the pipeline topology.
    :type name: str
    :param value: Parameter value to be applied on this specific pipeline.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParameterDefinition, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs.get('value', None)


class PemCertificateList(CertificateSource):
    """A list of PEM formatted certificates.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param certificates: Required. PEM formatted public certificates. One certificate per entry.
    :type certificates: list[str]
    """

    _validation = {
        'type': {'required': True},
        'certificates': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'certificates': {'key': 'certificates', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PemCertificateList, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.PemCertificateList'  # type: str
        self.certificates = kwargs['certificates']


class PipelineJob(ProxyResource):
    """Pipeline job represents a unique instance of a batch topology, used for offline processing of selected portions of archived content.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param topology_name: Reference to an existing pipeline topology. When activated, this pipeline
     job will process content according to the pipeline topology definition.
    :type topology_name: str
    :param description: An optional description for the pipeline.
    :type description: str
    :ivar state: Current state of the pipeline (read-only). Possible values include: "Processing",
     "Canceled", "Completed", "Failed".
    :vartype state: str or ~video_analyzer.models.PipelineJobState
    :ivar expiration: The date-time by when this pipeline job will be automatically deleted from
     your account.
    :vartype expiration: ~datetime.datetime
    :ivar error: Details about the error, in case the pipeline job fails.
    :vartype error: ~video_analyzer.models.PipelineJobError
    :param parameters: List of the instance level parameter values for the user-defined topology
     parameters. A pipeline can only define or override parameters values for parameters which have
     been declared in the referenced topology. Topology parameters without a default value must be
     defined. Topology parameters with a default value can be optionally be overridden.
    :type parameters: list[~video_analyzer.models.ParameterDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'state': {'readonly': True},
        'expiration': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'topology_name': {'key': 'properties.topologyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'expiration': {'key': 'properties.expiration', 'type': 'iso-8601'},
        'error': {'key': 'properties.error', 'type': 'PipelineJobError'},
        'parameters': {'key': 'properties.parameters', 'type': '[ParameterDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineJob, self).__init__(**kwargs)
        self.topology_name = kwargs.get('topology_name', None)
        self.description = kwargs.get('description', None)
        self.state = None
        self.expiration = None
        self.error = None
        self.parameters = kwargs.get('parameters', None)


class PipelineJobCollection(msrest.serialization.Model):
    """A collection of PipelineJob items.

    :param value: A collection of PipelineJob items.
    :type value: list[~video_analyzer.models.PipelineJob]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PipelineJob]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineJobCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PipelineJobError(msrest.serialization.Model):
    """Details about the error for a failed pipeline job.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineJobError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class PipelineJobOperationStatus(msrest.serialization.Model):
    """Used for tracking the status of an operation on the pipeline job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the pipeline job operation.
    :vartype name: str
    :ivar status: The status of the pipeline job operation.
    :vartype status: str
    :ivar error: The error details for the pipeline job operation.
    :vartype error: ~video_analyzer.models.ErrorDetail
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineJobOperationStatus, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.error = None


class PipelineJobUpdate(ProxyResource):
    """Pipeline job represents a unique instance of a batch topology, used for offline processing of selected portions of archived content.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param topology_name: Reference to an existing pipeline topology. When activated, this pipeline
     job will process content according to the pipeline topology definition.
    :type topology_name: str
    :param description: An optional description for the pipeline.
    :type description: str
    :ivar state: Current state of the pipeline (read-only). Possible values include: "Processing",
     "Canceled", "Completed", "Failed".
    :vartype state: str or ~video_analyzer.models.PipelineJobState
    :ivar expiration: The date-time by when this pipeline job will be automatically deleted from
     your account.
    :vartype expiration: ~datetime.datetime
    :ivar error: Details about the error, in case the pipeline job fails.
    :vartype error: ~video_analyzer.models.PipelineJobError
    :param parameters: List of the instance level parameter values for the user-defined topology
     parameters. A pipeline can only define or override parameters values for parameters which have
     been declared in the referenced topology. Topology parameters without a default value must be
     defined. Topology parameters with a default value can be optionally be overridden.
    :type parameters: list[~video_analyzer.models.ParameterDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'state': {'readonly': True},
        'expiration': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'topology_name': {'key': 'properties.topologyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'expiration': {'key': 'properties.expiration', 'type': 'iso-8601'},
        'error': {'key': 'properties.error', 'type': 'PipelineJobError'},
        'parameters': {'key': 'properties.parameters', 'type': '[ParameterDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineJobUpdate, self).__init__(**kwargs)
        self.topology_name = kwargs.get('topology_name', None)
        self.description = kwargs.get('description', None)
        self.state = None
        self.expiration = None
        self.error = None
        self.parameters = kwargs.get('parameters', None)


class PipelineTopology(ProxyResource):
    """Pipeline topology describes the processing steps to be applied when processing content for a particular outcome. The topology should be defined according to the scenario to be achieved and can be reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology which captures content from a RTSP camera and archives the content can be reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual instance properties can be defined through the use of user-defined parameters, which allow for a topology to be parameterized. This allows  individual pipelines refer to different values, such as individual cameras' RTSP endpoints and credentials. Overall a topology is composed of the following:


* Parameters: list of user defined parameters that can be references across the topology nodes.
* Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
* Processors: list of nodes which perform data analysis or transformations.
* Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param kind: Required. Topology kind. Possible values include: "Live", "Batch".
    :type kind: str or ~video_analyzer.models.Kind
    :param sku: Required. Describes the properties of a SKU.
    :type sku: ~video_analyzer.models.Sku
    :param description: An optional description of the pipeline topology. It is recommended that
     the expected use of the topology to be described here.
    :type description: str
    :param parameters: List of the topology parameter declarations. Parameters declared here can be
     referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern.
     Parameters can have optional default values and can later be defined in individual instances of
     the pipeline.
    :type parameters: list[~video_analyzer.models.ParameterDeclaration]
    :param sources: List of the topology source nodes. Source nodes enable external data to be
     ingested by the pipeline.
    :type sources: list[~video_analyzer.models.SourceNodeBase]
    :param processors: List of the topology processor nodes. Processor nodes enable pipeline data
     to be analyzed, processed or transformed.
    :type processors: list[~video_analyzer.models.ProcessorNodeBase]
    :param sinks: List of the topology sink nodes. Sink nodes allow pipeline data to be stored or
     exported.
    :type sinks: list[~video_analyzer.models.SinkNodeBase]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ParameterDeclaration]'},
        'sources': {'key': 'properties.sources', 'type': '[SourceNodeBase]'},
        'processors': {'key': 'properties.processors', 'type': '[ProcessorNodeBase]'},
        'sinks': {'key': 'properties.sinks', 'type': '[SinkNodeBase]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineTopology, self).__init__(**kwargs)
        self.kind = kwargs['kind']
        self.sku = kwargs['sku']
        self.description = kwargs.get('description', None)
        self.parameters = kwargs.get('parameters', None)
        self.sources = kwargs.get('sources', None)
        self.processors = kwargs.get('processors', None)
        self.sinks = kwargs.get('sinks', None)


class PipelineTopologyCollection(msrest.serialization.Model):
    """A collection of PipelineTopology items.

    :param value: A collection of PipelineTopology items.
    :type value: list[~video_analyzer.models.PipelineTopology]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PipelineTopology]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineTopologyCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PipelineTopologyUpdate(ProxyResource):
    """Pipeline topology describes the processing steps to be applied when processing content for a particular outcome. The topology should be defined according to the scenario to be achieved and can be reused across many pipeline instances which share the same processing characteristics. For instance, a pipeline topology which captures content from a RTSP camera and archives the content can be reused across many different cameras, as long as the same processing is to be applied across all the cameras. Individual instance properties can be defined through the use of user-defined parameters, which allow for a topology to be parameterized. This allows  individual pipelines refer to different values, such as individual cameras' RTSP endpoints and credentials. Overall a topology is composed of the following:


* Parameters: list of user defined parameters that can be references across the topology nodes.
* Sources: list of one or more data sources nodes such as an RTSP source which allows for content to be ingested from cameras.
* Processors: list of nodes which perform data analysis or transformations.
* Sinks: list of one or more data sinks which allow for data to be stored or exported to other destinations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param kind: Topology kind. Possible values include: "Live", "Batch".
    :type kind: str or ~video_analyzer.models.Kind
    :param sku: Describes the properties of a SKU.
    :type sku: ~video_analyzer.models.Sku
    :param description: An optional description of the pipeline topology. It is recommended that
     the expected use of the topology to be described here.
    :type description: str
    :param parameters: List of the topology parameter declarations. Parameters declared here can be
     referenced throughout the topology nodes through the use of "${PARAMETER_NAME}" string pattern.
     Parameters can have optional default values and can later be defined in individual instances of
     the pipeline.
    :type parameters: list[~video_analyzer.models.ParameterDeclaration]
    :param sources: List of the topology source nodes. Source nodes enable external data to be
     ingested by the pipeline.
    :type sources: list[~video_analyzer.models.SourceNodeBase]
    :param processors: List of the topology processor nodes. Processor nodes enable pipeline data
     to be analyzed, processed or transformed.
    :type processors: list[~video_analyzer.models.ProcessorNodeBase]
    :param sinks: List of the topology sink nodes. Sink nodes allow pipeline data to be stored or
     exported.
    :type sinks: list[~video_analyzer.models.SinkNodeBase]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ParameterDeclaration]'},
        'sources': {'key': 'properties.sources', 'type': '[SourceNodeBase]'},
        'processors': {'key': 'properties.processors', 'type': '[ProcessorNodeBase]'},
        'sinks': {'key': 'properties.sinks', 'type': '[SinkNodeBase]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineTopologyUpdate, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.sku = kwargs.get('sku', None)
        self.description = kwargs.get('description', None)
        self.parameters = kwargs.get('parameters', None)
        self.sources = kwargs.get('sources', None)
        self.processors = kwargs.get('processors', None)
        self.sinks = kwargs.get('sinks', None)


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~video_analyzer.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~video_analyzer.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~video_analyzer.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :param value: Array of private endpoint connections.
    :type value: list[~video_analyzer.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~video_analyzer.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or ~video_analyzer.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class Properties(msrest.serialization.Model):
    """Metric properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_specification: The service specifications.
    :vartype service_specification: ~video_analyzer.models.ServiceSpecification
    """

    _validation = {
        'service_specification': {'readonly': True},
    }

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Properties, self).__init__(**kwargs)
        self.service_specification = None


class ResourceIdentity(msrest.serialization.Model):
    """The user assigned managed identity to use when accessing a resource.

    All required parameters must be populated in order to send to Azure.

    :param user_assigned_identity: Required. The user assigned managed identity's resource
     identifier to use when accessing a resource.
    :type user_assigned_identity: str
    """

    _validation = {
        'user_assigned_identity': {'required': True},
    }

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.user_assigned_identity = kwargs['user_assigned_identity']


class RsaTokenKey(TokenKey):
    """Required validation properties for tokens generated with RSA algorithm.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param kid: Required. JWT token key id. Validation keys are looked up based on the key id
     present on the JWT token header.
    :type kid: str
    :param alg: Required. RSA algorithm to be used: RS256, RS384 or RS512. Possible values include:
     "RS256", "RS384", "RS512".
    :type alg: str or ~video_analyzer.models.AccessPolicyRsaAlgo
    :param n: Required. RSA public key modulus.
    :type n: str
    :param e: Required. RSA public key exponent.
    :type e: str
    """

    _validation = {
        'type': {'required': True},
        'kid': {'required': True},
        'alg': {'required': True},
        'n': {'required': True},
        'e': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'alg': {'key': 'alg', 'type': 'str'},
        'n': {'key': 'n', 'type': 'str'},
        'e': {'key': 'e', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RsaTokenKey, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.RsaTokenKey'  # type: str
        self.alg = kwargs['alg']
        self.n = kwargs['n']
        self.e = kwargs['e']


class SourceNodeBase(NodeBase):
    """Base class for topology source nodes.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RtspSource, VideoSource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.RtspSource': 'RtspSource', '#Microsoft.VideoAnalyzer.VideoSource': 'VideoSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceNodeBase, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.SourceNodeBase'  # type: str


class RtspSource(SourceNodeBase):
    """RTSP source allows for media from an RTSP camera or generic RTSP server to be ingested into a pipeline.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    :param transport: Network transport utilized by the RTSP and RTP exchange: TCP or HTTP. When
     using TCP, the RTP packets are interleaved on the TCP RTSP connection. When using HTTP, the
     RTSP messages are exchanged through long lived HTTP connections, and the RTP packages are
     interleaved in the HTTP connections alongside the RTSP messages. Possible values include:
     "Http", "Tcp".
    :type transport: str or ~video_analyzer.models.RtspTransport
    :param endpoint: Required. RTSP endpoint information for Video Analyzer to connect to. This
     contains the required information for Video Analyzer to connect to RTSP cameras and/or generic
     RTSP servers.
    :type endpoint: ~video_analyzer.models.EndpointBase
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'endpoint': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'transport': {'key': 'transport', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'EndpointBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RtspSource, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.RtspSource'  # type: str
        self.transport = kwargs.get('transport', None)
        self.endpoint = kwargs['endpoint']


class TunnelBase(msrest.serialization.Model):
    """Base class for tunnel objects.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecureIotDeviceRemoteTunnel.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel': 'SecureIotDeviceRemoteTunnel'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TunnelBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class SecureIotDeviceRemoteTunnel(TunnelBase):
    """A remote tunnel securely established using IoT Hub device information.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param iot_hub_name: Required. Name of the IoT Hub.
    :type iot_hub_name: str
    :param device_id: Required. The IoT device id to use when establishing the remote tunnel. This
     string is case-sensitive.
    :type device_id: str
    """

    _validation = {
        'type': {'required': True},
        'iot_hub_name': {'required': True},
        'device_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'iot_hub_name': {'key': 'iotHubName', 'type': 'str'},
        'device_id': {'key': 'deviceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecureIotDeviceRemoteTunnel, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel'  # type: str
        self.iot_hub_name = kwargs['iot_hub_name']
        self.device_id = kwargs['device_id']


class ServiceSpecification(msrest.serialization.Model):
    """The service metric specifications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar log_specifications: List of log specifications.
    :vartype log_specifications: list[~video_analyzer.models.LogSpecification]
    :ivar metric_specifications: List of metric specifications.
    :vartype metric_specifications: list[~video_analyzer.models.MetricSpecification]
    """

    _validation = {
        'log_specifications': {'readonly': True},
        'metric_specifications': {'readonly': True},
    }

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = None
        self.metric_specifications = None


class SinkNodeBase(NodeBase):
    """Base class for topology sink nodes.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VideoSink.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    :param inputs: Required. An array of upstream node references within the topology to be used as
     inputs for this node.
    :type inputs: list[~video_analyzer.models.NodeInput]
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[NodeInput]'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.VideoSink': 'VideoSink'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SinkNodeBase, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.SinkNodeBase'  # type: str
        self.inputs = kwargs['inputs']


class Sku(msrest.serialization.Model):
    """The SKU details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name. Possible values include: "Live_S1", "Batch_S1".
    :type name: str or ~video_analyzer.models.SkuName
    :ivar tier: The SKU tier. Possible values include: "Standard".
    :vartype tier: str or ~video_analyzer.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None


class StorageAccount(msrest.serialization.Model):
    """The details about the associated storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the storage account resource. Video Analyzer relies on tables,
     queues, and blobs. The primary storage account must be a Standard Storage account (either
     Microsoft.ClassicStorage or Microsoft.Storage).
    :type id: str
    :param identity: A managed identity that Video Analyzer will use to access the storage account.
    :type identity: ~video_analyzer.models.ResourceIdentity
    :ivar status: The current status of the storage account mapping.
    :vartype status: str
    """

    _validation = {
        'id': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.identity = kwargs.get('identity', None)
        self.status = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~video_analyzer.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~video_analyzer.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TimeSequenceBase(msrest.serialization.Model):
    """A sequence of datetime ranges as a string.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VideoSequenceAbsoluteTimeMarkers.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers': 'VideoSequenceAbsoluteTimeMarkers'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeSequenceBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class TlsEndpoint(EndpointBase):
    """TLS endpoint describes an endpoint that the pipeline can connect to over TLS transport (data is encrypted in transit).

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param credentials: Required. Credentials to be presented to the endpoint.
    :type credentials: ~video_analyzer.models.CredentialsBase
    :param url: Required. The endpoint URL for Video Analyzer to connect to.
    :type url: str
    :param tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint
     URL. This is an optional property, typically used when the endpoint is behind a firewall.
    :type tunnel: ~video_analyzer.models.TunnelBase
    :param trusted_certificates: List of trusted certificate authorities when authenticating a TLS
     connection. A null list designates that Azure Video Analyzer's list of trusted authorities
     should be used.
    :type trusted_certificates: ~video_analyzer.models.CertificateSource
    :param validation_options: Validation options to use when authenticating a TLS connection. By
     default, strict validation is used.
    :type validation_options: ~video_analyzer.models.TlsValidationOptions
    """

    _validation = {
        'type': {'required': True},
        'credentials': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CredentialsBase'},
        'url': {'key': 'url', 'type': 'str'},
        'tunnel': {'key': 'tunnel', 'type': 'TunnelBase'},
        'trusted_certificates': {'key': 'trustedCertificates', 'type': 'CertificateSource'},
        'validation_options': {'key': 'validationOptions', 'type': 'TlsValidationOptions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TlsEndpoint, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.TlsEndpoint'  # type: str
        self.trusted_certificates = kwargs.get('trusted_certificates', None)
        self.validation_options = kwargs.get('validation_options', None)


class TlsValidationOptions(msrest.serialization.Model):
    """Options for controlling the validation of TLS endpoints.

    :param ignore_hostname: When set to 'true' causes the certificate subject name validation to be
     skipped. Default is 'false'.
    :type ignore_hostname: str
    :param ignore_signature: When set to 'true' causes the certificate chain trust validation to be
     skipped. Default is 'false'.
    :type ignore_signature: str
    """

    _attribute_map = {
        'ignore_hostname': {'key': 'ignoreHostname', 'type': 'str'},
        'ignore_signature': {'key': 'ignoreSignature', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TlsValidationOptions, self).__init__(**kwargs)
        self.ignore_hostname = kwargs.get('ignore_hostname', None)
        self.ignore_signature = kwargs.get('ignore_signature', None)


class TokenClaim(msrest.serialization.Model):
    """Properties for expected token claims.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the claim which must be present on the token.
    :type name: str
    :param value: Required. Expected value of the claim to be present on the token.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenClaim, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class UnsecuredEndpoint(EndpointBase):
    """Unsecured endpoint describes an endpoint that the pipeline can connect to over clear transport (no encryption in transit).

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param credentials: Required. Credentials to be presented to the endpoint.
    :type credentials: ~video_analyzer.models.CredentialsBase
    :param url: Required. The endpoint URL for Video Analyzer to connect to.
    :type url: str
    :param tunnel: Describes the tunnel through which Video Analyzer can connect to the endpoint
     URL. This is an optional property, typically used when the endpoint is behind a firewall.
    :type tunnel: ~video_analyzer.models.TunnelBase
    """

    _validation = {
        'type': {'required': True},
        'credentials': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'CredentialsBase'},
        'url': {'key': 'url', 'type': 'str'},
        'tunnel': {'key': 'tunnel', 'type': 'TunnelBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnsecuredEndpoint, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.UnsecuredEndpoint'  # type: str


class UserAssignedManagedIdentity(msrest.serialization.Model):
    """The details of the user assigned managed identity used by the Video Analyzer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar client_id: The client ID.
    :vartype client_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    """

    _validation = {
        'client_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedManagedIdentity, self).__init__(**kwargs)
        self.client_id = None
        self.principal_id = None


class UsernamePasswordCredentials(CredentialsBase):
    """Username and password credentials.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param username: Required. Username to be presented as part of the credentials.
    :type username: str
    :param password: Required. Password to be presented as part of the credentials. It is
     recommended that this value is parameterized as a secret string in order to prevent this value
     to be returned as part of the resource on API requests.
    :type password: str
    """

    _validation = {
        'type': {'required': True},
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsernamePasswordCredentials, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.UsernamePasswordCredentials'  # type: str
        self.username = kwargs['username']
        self.password = kwargs['password']


class VideoAnalyzer(TrackedResource):
    """The Video Analyzer account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The identities associated to the Video Analyzer resource.
    :type identity: ~video_analyzer.models.VideoAnalyzerIdentity
    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~video_analyzer.models.StorageAccount]
    :ivar endpoints: The endpoints associated with this resource.
    :vartype endpoints: list[~video_analyzer.models.Endpoint]
    :param encryption: The account encryption properties.
    :type encryption: ~video_analyzer.models.AccountEncryption
    :param iot_hubs: The IoT Hubs for this resource.
    :type iot_hubs: list[~video_analyzer.models.IotHub]
    :param public_network_access: Whether or not public network access is allowed for resources
     under the Video Analyzer account. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~video_analyzer.models.PublicNetworkAccess
    :param network_access_control: Network access control for Video Analyzer.
    :type network_access_control: ~video_analyzer.models.NetworkAccessControl
    :ivar provisioning_state: Provisioning state of the Video Analyzer account. Possible values
     include: "Failed", "InProgress", "Succeeded".
    :vartype provisioning_state: str or ~video_analyzer.models.ProvisioningState
    :ivar private_endpoint_connections: Private Endpoint Connections created under Video Analyzer
     account.
    :vartype private_endpoint_connections: list[~video_analyzer.models.PrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'endpoints': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'VideoAnalyzerIdentity'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[Endpoint]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
        'iot_hubs': {'key': 'properties.iotHubs', 'type': '[IotHub]'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'network_access_control': {'key': 'properties.networkAccessControl', 'type': 'NetworkAccessControl'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoAnalyzer, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.storage_accounts = kwargs.get('storage_accounts', None)
        self.endpoints = None
        self.encryption = kwargs.get('encryption', None)
        self.iot_hubs = kwargs.get('iot_hubs', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.network_access_control = kwargs.get('network_access_control', None)
        self.provisioning_state = None
        self.private_endpoint_connections = None


class VideoAnalyzerCollection(msrest.serialization.Model):
    """A collection of VideoAnalyzer items.

    :param value: A collection of VideoAnalyzer items.
    :type value: list[~video_analyzer.models.VideoAnalyzer]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VideoAnalyzer]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoAnalyzerCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VideoAnalyzerIdentity(msrest.serialization.Model):
    """The managed identity for the Video Analyzer resource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The identity type.
    :type type: str
    :param user_assigned_identities: The User Assigned Managed Identities.
    :type user_assigned_identities: dict[str, ~video_analyzer.models.UserAssignedManagedIdentity]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedManagedIdentity}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoAnalyzerIdentity, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class VideoAnalyzerOperationStatus(msrest.serialization.Model):
    """Status of video analyzer operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Operation identifier.
    :type name: str
    :param id: Operation resource ID.
    :type id: str
    :param start_time: Operation start time.
    :type start_time: str
    :param end_time: Operation end time.
    :type end_time: str
    :param status: Operation status.
    :type status: str
    :param error: The error detail.
    :type error: ~video_analyzer.models.ErrorDetail
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoAnalyzerOperationStatus, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.id = kwargs.get('id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class VideoAnalyzerPrivateEndpointConnectionOperationStatus(msrest.serialization.Model):
    """Status of private endpoint connection operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Operation identifier.
    :type name: str
    :param id: Operation resource ID.
    :type id: str
    :param start_time: Operation start time.
    :type start_time: str
    :param end_time: Operation end time.
    :type end_time: str
    :param status: Operation status.
    :type status: str
    :param error: The error detail.
    :type error: ~video_analyzer.models.ErrorDetail
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoAnalyzerPrivateEndpointConnectionOperationStatus, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.id = kwargs.get('id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class VideoAnalyzerUpdate(msrest.serialization.Model):
    """The update operation for a Video Analyzer account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The identities associated to the Video Analyzer resource.
    :type identity: ~video_analyzer.models.VideoAnalyzerIdentity
    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~video_analyzer.models.StorageAccount]
    :ivar endpoints: The endpoints associated with this resource.
    :vartype endpoints: list[~video_analyzer.models.Endpoint]
    :param encryption: The account encryption properties.
    :type encryption: ~video_analyzer.models.AccountEncryption
    :param iot_hubs: The IoT Hubs for this resource.
    :type iot_hubs: list[~video_analyzer.models.IotHub]
    :param public_network_access: Whether or not public network access is allowed for resources
     under the Video Analyzer account. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~video_analyzer.models.PublicNetworkAccess
    :param network_access_control: Network access control for Video Analyzer.
    :type network_access_control: ~video_analyzer.models.NetworkAccessControl
    :ivar provisioning_state: Provisioning state of the Video Analyzer account. Possible values
     include: "Failed", "InProgress", "Succeeded".
    :vartype provisioning_state: str or ~video_analyzer.models.ProvisioningState
    :ivar private_endpoint_connections: Private Endpoint Connections created under Video Analyzer
     account.
    :vartype private_endpoint_connections: list[~video_analyzer.models.PrivateEndpointConnection]
    """

    _validation = {
        'endpoints': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'VideoAnalyzerIdentity'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[Endpoint]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
        'iot_hubs': {'key': 'properties.iotHubs', 'type': '[IotHub]'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'network_access_control': {'key': 'properties.networkAccessControl', 'type': 'NetworkAccessControl'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoAnalyzerUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.storage_accounts = kwargs.get('storage_accounts', None)
        self.endpoints = None
        self.encryption = kwargs.get('encryption', None)
        self.iot_hubs = kwargs.get('iot_hubs', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.network_access_control = kwargs.get('network_access_control', None)
        self.provisioning_state = None
        self.private_endpoint_connections = None


class VideoArchival(msrest.serialization.Model):
    """Video archival properties.

    :param retention_period: Video retention period indicates the maximum age of the video archive
     segments which are intended to be kept in storage. It must be provided in the ISO8601 duration
     format in the granularity of days, up to a maximum of 10 years. For example, if this is set to
     P30D (30 days), content older than 30 days will be periodically deleted. This value can be
     updated at any time and the new desired retention period will be effective within 24 hours.
    :type retention_period: str
    """

    _attribute_map = {
        'retention_period': {'key': 'retentionPeriod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoArchival, self).__init__(**kwargs)
        self.retention_period = kwargs.get('retention_period', None)


class VideoContentToken(msrest.serialization.Model):
    """"Video content token grants access to the video content URLs.".

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_date: The content token expiration date in ISO8601 format (eg.
     2021-01-01T00:00:00Z).
    :vartype expiration_date: ~datetime.datetime
    :ivar token: The content token value to be added to the video content URL as the value for the
     "token" query string parameter. The token is specific to a single video.
    :vartype token: str
    """

    _validation = {
        'expiration_date': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoContentToken, self).__init__(**kwargs)
        self.expiration_date = None
        self.token = None


class VideoContentUrls(msrest.serialization.Model):
    """Set of URLs to the video content.

    :param download_url: Video file download URL. This URL can be used in conjunction with the
     video content authorization token to download the video MP4 file. The resulting MP4 file can be
     played on any standard media player. It is available when the video type is 'file' and video
     file is available for consumption.
    :type download_url: str
    :param archive_base_url: Video archive streaming base URL. The archived content can be
     automatically played by the Azure Video Analyzer player widget. Alternatively, this URL can be
     used in conjunction with the video content authorization token on any compatible DASH or HLS
     players by appending the following to the base URL:
    
     .. code-block::
    
        - HLSv4:     /manifest(format=m3u8-aapl).m3u8
        - HLS CMAF:  /manifest(format=m3u8-cmaf)
        - DASH CMAF: /manifest(format=mpd-time-cmaf)
    
        Moreover, an ongoing video recording can be played in "live mode" with latencies which are
     approximately double of the chosen video segment length. It is available when the video type is
     'archive' and video archiving is enabled.
    :type archive_base_url: str
    :param rtsp_tunnel_url: Video low-latency streaming URL. The live content can be automatically
     played by the Azure Video Analyzer player widget. Alternatively, this URL can be used in
     conjunction with the video content authorization token to expose a WebSocket tunneled RTSP
     stream. It is available when the video type is 'archive' and a live, low-latency feed is
     available from the source.
    :type rtsp_tunnel_url: str
    :param preview_image_urls: Video preview image URLs. These URLs can be used in conjunction with
     the video content authorization token to download the most recent still image from the video
     archive in different resolutions. They are available when the video type is 'archive' and
     preview images are enabled.
    :type preview_image_urls: ~video_analyzer.models.VideoPreviewImageUrls
    """

    _attribute_map = {
        'download_url': {'key': 'downloadUrl', 'type': 'str'},
        'archive_base_url': {'key': 'archiveBaseUrl', 'type': 'str'},
        'rtsp_tunnel_url': {'key': 'rtspTunnelUrl', 'type': 'str'},
        'preview_image_urls': {'key': 'previewImageUrls', 'type': 'VideoPreviewImageUrls'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoContentUrls, self).__init__(**kwargs)
        self.download_url = kwargs.get('download_url', None)
        self.archive_base_url = kwargs.get('archive_base_url', None)
        self.rtsp_tunnel_url = kwargs.get('rtsp_tunnel_url', None)
        self.preview_image_urls = kwargs.get('preview_image_urls', None)


class VideoCreationProperties(msrest.serialization.Model):
    """Optional properties to be used in case a new video resource needs to be created on the service. These will not take effect if the video already exists.

    :param title: Optional title provided by the user. Value can be up to 256 characters long.
    :type title: str
    :param description: Optional description provided by the user. Value can be up to 2048
     characters long.
    :type description: str
    :param segment_length: Segment length indicates the length of individual content files
     (segments) which are persisted to storage. Smaller segments provide lower archive playback
     latency but generate larger volume of storage transactions. Larger segments reduce the amount
     of storage transactions while increasing the archive playback latency. Value must be specified
     in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to
     5 minutes, in 30 seconds increments. Changing this value after the initial call to create the
     video resource can lead to errors when uploading content to the archive. Default value is 30
     seconds. This property is only allowed for topologies where "kind" is set to "live".
    :type segment_length: str
    :param retention_period: Video retention period indicates how long the video is kept in
     storage. Value must be specified in ISO8601 duration format (i.e. "P1D" equals 1 day) and can
     vary between 1 day to 10 years, in 1 day increments. When absent (null), all video content is
     retained indefinitely. This property is only allowed for topologies where "kind" is set to
     "live".
    :type retention_period: str
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'segment_length': {'key': 'segmentLength', 'type': 'str'},
        'retention_period': {'key': 'retentionPeriod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoCreationProperties, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.segment_length = kwargs.get('segment_length', None)
        self.retention_period = kwargs.get('retention_period', None)


class VideoEncoderBase(msrest.serialization.Model):
    """Base type for all video encoding presets, which define the recipe or instructions on how the input video should be processed.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VideoEncoderH264.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param bitrate_kbps: The maximum bitrate, in kilobits per second or Kbps, at which video should
     be encoded. If omitted, encoder sets it automatically to try and match the quality of the input
     video.
    :type bitrate_kbps: str
    :param frame_rate: The frame rate (in frames per second) of the encoded video. The value must
     be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average
     frame rate of the input video.
    :type frame_rate: str
    :param scale: Describes the resolution of the encoded video. If omitted, the encoder uses the
     resolution of the input video.
    :type scale: ~video_analyzer.models.VideoScale
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'bitrate_kbps': {'key': 'bitrateKbps', 'type': 'str'},
        'frame_rate': {'key': 'frameRate', 'type': 'str'},
        'scale': {'key': 'scale', 'type': 'VideoScale'},
    }

    _subtype_map = {
        'type': {'#Microsoft.VideoAnalyzer.VideoEncoderH264': 'VideoEncoderH264'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoEncoderBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.bitrate_kbps = kwargs.get('bitrate_kbps', None)
        self.frame_rate = kwargs.get('frame_rate', None)
        self.scale = kwargs.get('scale', None)


class VideoEncoderH264(VideoEncoderBase):
    """A custom preset for encoding video with the H.264 (AVC) codec.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param bitrate_kbps: The maximum bitrate, in kilobits per second or Kbps, at which video should
     be encoded. If omitted, encoder sets it automatically to try and match the quality of the input
     video.
    :type bitrate_kbps: str
    :param frame_rate: The frame rate (in frames per second) of the encoded video. The value must
     be greater than zero, and less than or equal to 300. If omitted, the encoder uses the average
     frame rate of the input video.
    :type frame_rate: str
    :param scale: Describes the resolution of the encoded video. If omitted, the encoder uses the
     resolution of the input video.
    :type scale: ~video_analyzer.models.VideoScale
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'bitrate_kbps': {'key': 'bitrateKbps', 'type': 'str'},
        'frame_rate': {'key': 'frameRate', 'type': 'str'},
        'scale': {'key': 'scale', 'type': 'VideoScale'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoEncoderH264, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.VideoEncoderH264'  # type: str


class VideoEntity(ProxyResource):
    """Represents a video resource within Azure Video Analyzer. Videos can be ingested from RTSP cameras through live pipelines or can be created by exporting sequences from existing captured video through a pipeline job. Videos ingested through live pipelines can be streamed through Azure Video Analyzer Player Widget or compatible players. Exported videos can be downloaded as MP4 files.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~video_analyzer.models.SystemData
    :param title: Optional video title provided by the user. Value can be up to 256 characters
     long.
    :type title: str
    :param description: Optional video description provided by the user. Value can be up to 2048
     characters long.
    :type description: str
    :ivar type_properties_type: Video content type. Different content types are suitable for
     different applications and scenarios. Possible values include: "Archive", "File".
    :vartype type_properties_type: str or ~video_analyzer.models.VideoType
    :ivar flags: Video flags contain information about the available video actions and its dynamic
     properties based on the current video state.
    :vartype flags: ~video_analyzer.models.VideoFlags
    :ivar content_urls: Set of URLs to the video content.
    :vartype content_urls: ~video_analyzer.models.VideoContentUrls
    :param media_info: Contains information about the video and audio content.
    :type media_info: ~video_analyzer.models.VideoMediaInfo
    :param archival: Video archival properties.
    :type archival: ~video_analyzer.models.VideoArchival
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'flags': {'readonly': True},
        'content_urls': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'flags': {'key': 'properties.flags', 'type': 'VideoFlags'},
        'content_urls': {'key': 'properties.contentUrls', 'type': 'VideoContentUrls'},
        'media_info': {'key': 'properties.mediaInfo', 'type': 'VideoMediaInfo'},
        'archival': {'key': 'properties.archival', 'type': 'VideoArchival'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoEntity, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.type_properties_type = None
        self.flags = None
        self.content_urls = None
        self.media_info = kwargs.get('media_info', None)
        self.archival = kwargs.get('archival', None)


class VideoEntityCollection(msrest.serialization.Model):
    """A collection of VideoEntity items.

    :param value: A collection of VideoEntity items.
    :type value: list[~video_analyzer.models.VideoEntity]
    :param next_link: A link to the next page of the collection (when the collection contains too
     many results to return in one response).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VideoEntity]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoEntityCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VideoFlags(msrest.serialization.Model):
    """Video flags contain information about the available video actions and its dynamic properties based on the current video state.

    All required parameters must be populated in order to send to Azure.

    :param can_stream: Required. Value indicating whether or not the video can be streamed. Only
     "archive" type videos can be streamed.
    :type can_stream: bool
    :param has_data: Required. Value indicating whether or not there has ever been data recorded or
     uploaded into the video. Newly created videos have this value set to false.
    :type has_data: bool
    :param is_in_use: Required. Value indicating whether or not the video is currently being
     referenced be an active pipeline. The fact that is being referenced, doesn't necessarily
     indicate that data is being received. For example, video recording may be gated on events or
     camera may not be accessible at the time.
    :type is_in_use: bool
    """

    _validation = {
        'can_stream': {'required': True},
        'has_data': {'required': True},
        'is_in_use': {'required': True},
    }

    _attribute_map = {
        'can_stream': {'key': 'canStream', 'type': 'bool'},
        'has_data': {'key': 'hasData', 'type': 'bool'},
        'is_in_use': {'key': 'isInUse', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoFlags, self).__init__(**kwargs)
        self.can_stream = kwargs['can_stream']
        self.has_data = kwargs['has_data']
        self.is_in_use = kwargs['is_in_use']


class VideoMediaInfo(msrest.serialization.Model):
    """Contains information about the video and audio content.

    :param segment_length: Video segment length indicates the length of individual video files
     (segments) which are persisted to storage. Smaller segments provide lower archive playback
     latency but generate larger volume of storage transactions. Larger segments reduce the amount
     of storage transactions while increasing the archive playback latency. Value must be specified
     in ISO8601 duration format (i.e. "PT30S" equals 30 seconds) and can vary between 30 seconds to
     5 minutes, in 30 seconds increments.
    :type segment_length: str
    """

    _attribute_map = {
        'segment_length': {'key': 'segmentLength', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoMediaInfo, self).__init__(**kwargs)
        self.segment_length = kwargs.get('segment_length', None)


class VideoPreviewImageUrls(msrest.serialization.Model):
    """Video preview image URLs. These URLs can be used in conjunction with the video content authorization token to download the most recent still image from the video archive in different resolutions. They are available when the video type is 'archive' and preview images are enabled.

    :param small: Low resolution preview image URL.
    :type small: str
    :param medium: Medium resolution preview image URL.
    :type medium: str
    :param large: High resolution preview image URL.
    :type large: str
    """

    _attribute_map = {
        'small': {'key': 'small', 'type': 'str'},
        'medium': {'key': 'medium', 'type': 'str'},
        'large': {'key': 'large', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoPreviewImageUrls, self).__init__(**kwargs)
        self.small = kwargs.get('small', None)
        self.medium = kwargs.get('medium', None)
        self.large = kwargs.get('large', None)


class VideoPublishingOptions(msrest.serialization.Model):
    """Optional flags used to change how video is published. These are only allowed for topologies where "kind" is set to "live".

    :param disable_archive: When set to 'true' content will not be archived or recorded. This is
     used, for example, when the topology is used only for low latency video streaming. Default is
     'false'.  If set to 'true', then "disableRtspPublishing" must be set to 'false'.
    :type disable_archive: str
    :param disable_rtsp_publishing: When set to 'true' the RTSP playback URL will not be published,
     disabling low latency streaming. This is used, for example, when the topology is used only for
     archiving content. Default is 'false'.  If set to 'true', then "disableArchive" must be set to
     'false'.
    :type disable_rtsp_publishing: str
    """

    _attribute_map = {
        'disable_archive': {'key': 'disableArchive', 'type': 'str'},
        'disable_rtsp_publishing': {'key': 'disableRtspPublishing', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoPublishingOptions, self).__init__(**kwargs)
        self.disable_archive = kwargs.get('disable_archive', None)
        self.disable_rtsp_publishing = kwargs.get('disable_rtsp_publishing', None)


class VideoScale(msrest.serialization.Model):
    """The video scaling information.

    :param height: The desired output video height.
    :type height: str
    :param width: The desired output video width.
    :type width: str
    :param mode: Describes the video scaling mode to be applied. Default mode is 'Pad'. If the mode
     is 'Pad' or 'Stretch' then both width and height must be specified. Else if the mode is
     'PreserveAspectRatio' then only one of width or height need be provided. Possible values
     include: "Pad", "PreserveAspectRatio", "Stretch".
    :type mode: str or ~video_analyzer.models.VideoScaleMode
    """

    _attribute_map = {
        'height': {'key': 'height', 'type': 'str'},
        'width': {'key': 'width', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoScale, self).__init__(**kwargs)
        self.height = kwargs.get('height', None)
        self.width = kwargs.get('width', None)
        self.mode = kwargs.get('mode', None)


class VideoSequenceAbsoluteTimeMarkers(TimeSequenceBase):
    """A sequence of absolute datetime ranges as a string. The datetime values should follow IS08601, and the sum of the ranges should add up to 24 hours or less. Currently, there can be only one range specified in the sequence.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param ranges: Required. The sequence of datetime ranges. Example: '[["2021-10-05T03:30:00Z",
     "2021-10-05T03:40:00Z"]]'.
    :type ranges: str
    """

    _validation = {
        'type': {'required': True},
        'ranges': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'ranges': {'key': 'ranges', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoSequenceAbsoluteTimeMarkers, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers'  # type: str
        self.ranges = kwargs['ranges']


class VideoSink(SinkNodeBase):
    """Video sink in a live topology allows for video and audio to be captured, optionally archived, and published via a video resource. If archiving is enabled, this results in a video of type 'archive'. If used in a batch topology, this allows for video and audio to be stored as a file, and published via a video resource of type 'file'.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    :param inputs: Required. An array of upstream node references within the topology to be used as
     inputs for this node.
    :type inputs: list[~video_analyzer.models.NodeInput]
    :param video_name: Required. Name of a new or existing video resource used to capture and
     publish content. Note: if downstream of RTSP source, and if disableArchive is set to true, then
     no content is archived.
    :type video_name: str
    :param video_creation_properties: Optional video properties to be used in case a new video
     resource needs to be created on the service.
    :type video_creation_properties: ~video_analyzer.models.VideoCreationProperties
    :param video_publishing_options: Options to change how the video sink publishes content via the
     video resource. This property is only allowed for topologies where "kind" is set to "live".
    :type video_publishing_options: ~video_analyzer.models.VideoPublishingOptions
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'inputs': {'required': True},
        'video_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[NodeInput]'},
        'video_name': {'key': 'videoName', 'type': 'str'},
        'video_creation_properties': {'key': 'videoCreationProperties', 'type': 'VideoCreationProperties'},
        'video_publishing_options': {'key': 'videoPublishingOptions', 'type': 'VideoPublishingOptions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoSink, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.VideoSink'  # type: str
        self.video_name = kwargs['video_name']
        self.video_creation_properties = kwargs.get('video_creation_properties', None)
        self.video_publishing_options = kwargs.get('video_publishing_options', None)


class VideoSource(SourceNodeBase):
    """Video source allows for content from a Video Analyzer video resource to be ingested into a pipeline. Currently supported only with batch pipelines.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The discriminator for derived types.Constant filled by server.
    :type type: str
    :param name: Required. Node name. Must be unique within the topology.
    :type name: str
    :param video_name: Required. Name of the Video Analyzer video resource to be used as the
     source.
    :type video_name: str
    :param time_sequences: Required. Describes a sequence of datetime ranges. The video source only
     picks up recorded media within these ranges.
    :type time_sequences: ~video_analyzer.models.TimeSequenceBase
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'video_name': {'required': True},
        'time_sequences': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '@type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'video_name': {'key': 'videoName', 'type': 'str'},
        'time_sequences': {'key': 'timeSequences', 'type': 'TimeSequenceBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VideoSource, self).__init__(**kwargs)
        self.type = '#Microsoft.VideoAnalyzer.VideoSource'  # type: str
        self.video_name = kwargs['video_name']
        self.time_sequences = kwargs['time_sequences']
