#
# PySNMP MIB module MALLOC-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/MALLOC-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:19:58 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( SingleValueConstraint, ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "SingleValueConstraint", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint", "ConstraintsUnion")
( IANAmallocRangeSource, IANAscopeSource, ) = mibBuilder.importSymbols("IANA-MALLOC-MIB", "IANAmallocRangeSource", "IANAscopeSource")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( LanguageTag, ) = mibBuilder.importSymbols("IPMROUTE-STD-MIB", "LanguageTag")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup", "NotificationGroup")
( Counter64, mib_2, iso, Bits, Integer32, IpAddress, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, ModuleIdentity, Counter32, Gauge32, TimeTicks, Unsigned32, ObjectIdentity, NotificationType, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter64", "mib-2", "iso", "Bits", "Integer32", "IpAddress", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "ModuleIdentity", "Counter32", "Gauge32", "TimeTicks", "Unsigned32", "ObjectIdentity", "NotificationType")
( StorageType, TextualConvention, TruthValue, DisplayString, RowStatus, ) = mibBuilder.importSymbols("SNMPv2-TC", "StorageType", "TextualConvention", "TruthValue", "DisplayString", "RowStatus")
mallocMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 101)).setRevisions(("2003-06-09 00:00",))
if mibBuilder.loadTexts: mallocMIB.setLastUpdated('200306090000Z')
if mibBuilder.loadTexts: mallocMIB.setOrganization('IETF MALLOC Working Group')
if mibBuilder.loadTexts: mallocMIB.setContactInfo(' WG-EMail:   malloc@catarina.usc.edu\n              Subscribe:  malloc-request@catarina.usc.edu\n              Archive:    catarina.usc.edu/pub/multicast/malloc/\n\n              Co-chair/editor:\n              Dave Thaler\n              Microsoft Corporation\n              One Microsoft Way\n              Redmond, WA 98052\n              EMail: dthaler@microsoft.com\n\n              Co-chair:\n              Steve Hanna\n              Sun Microsystems, Inc.\n              One Network Drive\n              Burlington, MA 01803\n              EMail: steve.hanna@sun.com')
if mibBuilder.loadTexts: mallocMIB.setDescription('The MIB module for management of multicast address\n            allocation.\n\n            Copyright (C) The Internet Society (2003).  This version of\n            this MIB module is part of RFC 3559; see the RFC itself for\n            full legal notices.')
mallocMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 1))
malloc = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 1, 1))
madcap = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 1, 2))
mallocCapabilities = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 1, 1), Bits().clone(namedValues=NamedValues(("startTime", 0), ("serverMobility", 1), ("retryAfter", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocCapabilities.setDescription('This object describes the capabilities which a client or\n            server supports.  The startTime bit indicates that\n            allocations with a future start time are supported.  The\n            serverMobility bit indicates that allocations can be renewed\n            or released from a server other than the one granting the\n            original allocation.  The retryAfter bit indicates support\n            for a waiting state where the client may check back at a\n            later time to get the status of its request.')
mallocScopeTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 2), )
if mibBuilder.loadTexts: mallocScopeTable.setDescription('The (conceptual) table containing information on multicast\n            scopes from which addresses may be allocated.  Entries in\n            this table may be dynamically discovered via some other\n\n\n\n            protocol, such as MZAP, or may be statically configured,\n            such as in an isolated network environment.  Each scope is\n            associated with a range of multicast addresses, and ranges\n            for different rows must be disjoint.')
mallocScopeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1), ).setIndexNames((0, "MALLOC-MIB", "mallocScopeAddressType"), (0, "MALLOC-MIB", "mallocScopeFirstAddress"))
if mibBuilder.loadTexts: mallocScopeEntry.setDescription('An entry (conceptual row) containing the information on a\n            particular multicast scope.')
mallocScopeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 1), InetAddressType())
if mibBuilder.loadTexts: mallocScopeAddressType.setDescription('The type of the addresses in the multicast scope range.\n            Legal values correspond to the subset of address families\n            for which multicast address allocation is supported.')
mallocScopeFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 2), InetAddress().subtype(subtypeSpec=ValueSizeConstraint(0,20)))
if mibBuilder.loadTexts: mallocScopeFirstAddress.setDescription('The first address in the multicast scope range.  The type\n            of this address is determined by the value of the\n            mallocScopeAddressType object.')
mallocScopeLastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 3), InetAddress().subtype(subtypeSpec=ValueSizeConstraint(0,20))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeLastAddress.setDescription('The last address in the multicast scope range.  The type of\n            this address is determined by the value of the\n            mallocScopeAddressType object.')
mallocScopeHopLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255)).clone(255)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeHopLimit.setDescription('The default IPv4 TTL or IPv6 hop limit which applications\n            should use for groups within the scope.')
mallocScopeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeStatus.setDescription("The status of this row, by which new entries may be\n            created, or old entries deleted from this table.  If write\n            access is supported, the other writable objects in this\n            table may be modified even while the status is `active'.")
mallocScopeSource = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 6), IANAscopeSource()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocScopeSource.setDescription('The method by which this entry was learned.')
mallocScopeDivisible = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 7), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeDivisible.setDescription('If false, the server may allocate addresses out of the\n            entire range.  If true, the server must not allocate\n\n\n\n            addresses out of the entire range, but may only allocate\n            addresses out of a subrange learned via another method.\n            Creating or deleting a scope which is not divisible has the\n            side effect of creating or deleting the corresponding entry\n            in the mallocAllocRangeTable.  Deleting a scope which is\n            divisible has the side effect of deleting any corresponding\n            entries in the mallocAllocRangeTable, and the\n            mallocRequestTable.')
mallocScopeServerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 8), InetAddressType().clone('unknown')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeServerAddressType.setDescription('The type of the address of a multicast address allocation\n            server to which a request may be sent.')
mallocScopeServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 9), InetAddress().clone(hexValue="")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeServerAddress.setDescription('The address of a multicast address allocation server to\n            which a request may be sent.  The default value is an zero-\n            length address, indicating that no server is known.  The\n            type of this address is determined by the value of the\n            mallocScopeServerAddressType object.')
mallocScopeSSM = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 10), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeSSM.setDescription('Indicates whether the scope is a Source-Specific Multicast\n            (SSM) range.')
mallocScopeStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 2, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\n            having the value 'permanent' need not allow write-access to\n            any columnar objects in the row.")
mallocScopeNameTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 3), )
if mibBuilder.loadTexts: mallocScopeNameTable.setDescription('The (conceptual) table containing information on multicast\n            scope names.  Entries in this table may be dynamically\n            discovered via some other protocol, such as MZAP, or may be\n            statically configured, such as in an isolated network\n            environment.')
mallocScopeNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1), ).setIndexNames((0, "MALLOC-MIB", "mallocScopeAddressType"), (0, "MALLOC-MIB", "mallocScopeFirstAddress"), (1, "MALLOC-MIB", "mallocScopeNameLangName"))
if mibBuilder.loadTexts: mallocScopeNameEntry.setDescription('An entry (conceptual row) containing the information on a\n            particular multicast scope name.')
mallocScopeNameLangName = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 1), LanguageTag().subtype(subtypeSpec=ValueSizeConstraint(1,94)))
if mibBuilder.loadTexts: mallocScopeNameLangName.setDescription('The RFC 3066 language tag for the language of the scope\n            name.')
mallocScopeNameScopeName = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameScopeName.setDescription('The textual name associated with the multicast scope.  The\n            value of this object should be suitable for displaying to\n            end-users, such as when allocating a multicast address in\n            this scope.  If the scope is an IPv4 scope, and no name is\n            specified, the default value of this object should be the\n            string 239.x.x.x/y with x and y replaced appropriately to\n            describe the address and mask length associated with the\n            scope.  If the scope is an IPv6 scope, and no name is\n            specified, the default value of this object should\n            generically describe the scope level (e.g., site).')
mallocScopeNameDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 3), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameDefault.setDescription('If true, indicates a preference that the name in the\n            associated language should be used by applications if no\n            name is available in a desired language.')
mallocScopeNameStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameStatus.setDescription("The status of this row, by which new entries may be\n            created, or old entries deleted from this table.  If write\n            access is supported, the other writable objects in this\n            table may be modified even while the status is `active'.")
mallocScopeNameStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 3, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocScopeNameStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\n            having the value 'permanent' need not allow write-access to\n            any columnar objects in the row.")
mallocAllocRangeTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 4), )
if mibBuilder.loadTexts: mallocAllocRangeTable.setDescription("The (conceptual) table containing information on subranges\n            of addresses from which the device may allocate addresses,\n            if it is a MAAS.  If the device is a Prefix Coordinator, any\n            ranges which the device is advertising to MAAS's will be in\n            this table.  Note that the device may be both a MAAS and a\n            Prefix Coordinator.\n\n            Address ranges for different rows must be disjoint, and must\n            be contained with the address range of the corresponding row\n            of the mallocScopeTable.\n\n            Deleting an allocation range has the side effect of deleting\n            any entries within that range from the mallocAddressTable.")
mallocAllocRangeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1), ).setIndexNames((0, "MALLOC-MIB", "mallocScopeAddressType"), (0, "MALLOC-MIB", "mallocScopeFirstAddress"), (0, "MALLOC-MIB", "mallocAllocRangeFirstAddress"))
if mibBuilder.loadTexts: mallocAllocRangeEntry.setDescription('An entry (conceptual row) containing the information on a\n            particular allocation range.')
mallocAllocRangeFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 1), InetAddress().subtype(subtypeSpec=ValueSizeConstraint(0,20)))
if mibBuilder.loadTexts: mallocAllocRangeFirstAddress.setDescription('The first address in the allocation range.  The type of\n            this address is determined by the value of the\n            mallocScopeAddressType object.')
mallocAllocRangeLastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 2), InetAddress().subtype(subtypeSpec=ValueSizeConstraint(0,20))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeLastAddress.setDescription('The last address in the allocation range.  The type of this\n            address is determined by the value of the\n            mallocScopeAddressType object.')
mallocAllocRangeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeStatus.setDescription("The status of this row, by which new entries may be\n            created, or old entries deleted from this table.  If write\n            access is supported, the other writable objects in this\n            table may be modified even while the status is `active'.")
mallocAllocRangeSource = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 4), IANAmallocRangeSource()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeSource.setDescription('The means by which this entry was learned.')
mallocAllocRangeLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 5), Unsigned32()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeLifetime.setDescription('The number of seconds remaining in the lifetime of the\n            (sub)range out of which addresses are being allocated.  A\n            value of 0 indicates that the range is not subject to\n            aging.')
mallocAllocRangeMaxLeaseAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 6), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeMaxLeaseAddrs.setDescription('The maximum number of addresses which the server is willing\n            to grant for each future request in this range.  A value of\n            0 means that no specific limit is enforced, as long as the\n            server has valid addresses to allocate.')
mallocAllocRangeMaxLeaseTime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 7), Unsigned32()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeMaxLeaseTime.setDescription('The maximum lifetime which the server will grant for future\n            requests in this range.  A value of 0 means that no\n            additional limit is enforced beyond that of\n            mallocAllocRangeLifetime.')
mallocAllocRangeNumAllocatedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumAllocatedAddrs.setDescription('The number of addresses in the range which have been\n            allocated.  This value can be used to determine the current\n            address space utilization within the scoped range.  This\n\n\n\n            should match the total number of addresses for this scope\n            covered by entries in the mallocAddressTable.')
mallocAllocRangeNumOfferedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumOfferedAddrs.setDescription('The number of addresses in the range which have been\n            offered.  This number should match the sum of\n            mallocRequestNumAddrs for all entries in the\n            mallocRequestTable in the offered state.  Together with\n            mallocAllocRangeNumAllocatedAddrs and\n            mallocAllocRangeNumTryingAddrs, this can be used to\n            determine the address space utilization within the scoped\n            range in the immediate future.')
mallocAllocRangeNumWaitingAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumWaitingAddrs.setDescription('The number of addresses in the range which have been\n            requested, but whose state is waiting, while the server\n            attempts to acquire more address space.')
mallocAllocRangeNumTryingAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeNumTryingAddrs.setDescription('The number of addresses in the scope covered by entries in\n            the mallocRequestTable in the trying state.')
mallocAllocRangeAdvertisable = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 12), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeAdvertisable.setDescription('The value of this object is true if the range is eligible\n            to be advertised to other MAASs.  When the row is first\n            created, the default value of this object is true if the\n            scope is divisible, and is false otherwise.')
mallocAllocRangeTotalAllocatedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeTotalAllocatedAddrs.setDescription('The approximate number of addresses in the range which have\n            been allocated by any MAAS, as determined by a Prefix\n            Coordinator.  This object need only be present if\n            mallocAllocRangeAdvertisable is true.  If the number is\n            unknown, a value of 0 may be reported.')
mallocAllocRangeTotalRequestedAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAllocRangeTotalRequestedAddrs.setDescription('The approximate number of addresses in the range for which\n            there is potential demand among MAASs, as determined by a\n            Prefix Coordinator.  This object need only be present if\n            mallocAllocRangeAdvertisable is true.  If the number is\n            unknown, a value of 0 may be reported.')
mallocAllocRangeStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 4, 1, 15), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mallocAllocRangeStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\n            having the value 'permanent' need not allow write-access to\n            any columnar objects in the row.")
mallocRequestTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 5), )
if mibBuilder.loadTexts: mallocRequestTable.setDescription('The (conceptual) table containing information on allocation\n            requests, whether allocated or in progress.  This table may\n            also be used to determine which clients are responsible for\n            high address space utilization within a given scope.\n\n\n\n            Entries in this table reflect requests dynamically received\n            by an address allocation protocol.')
mallocRequestEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1), ).setIndexNames((0, "MALLOC-MIB", "mallocRequestId"))
if mibBuilder.loadTexts: mallocRequestEntry.setDescription('An entry (conceptual row) containing the information on a\n            particular allocation request.')
mallocRequestId = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: mallocRequestId.setDescription('An arbitrary value identifying this row.')
mallocRequestScopeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestScopeAddressType.setDescription('The type of the first address of the scope to which the\n            request applies.  Legal values correspond to the subset of\n            address families for which multicast address allocation is\n            supported.')
mallocRequestScopeFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestScopeFirstAddress.setDescription('The first address of the scope to which the request\n            applies.  This must match mallocScopeFirstAddress for some\n            row in the mallocScopeTable.  The type of this address is\n            determined by the value of the mallocRequestScopeAddressType\n            object.')
mallocRequestStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 4), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestStartTime.setDescription('The number of seconds remaining before the start time of\n            the request.  A value of 0 means that the allocation is\n            currently in effect.')
mallocRequestEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 5), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestEndTime.setDescription('The number of seconds remaining before the end time of the\n            request.')
mallocRequestNumAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestNumAddrs.setDescription('The number of addresses requested.  If the addresses have\n            been allocated, this number should match the total number of\n            addresses for this request covered by entries in the\n            mallocAddressTable.')
mallocRequestState = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("allocated", 1), ("offered", 2), ("waiting", 3), ("trying", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestState.setDescription('The state of the request.  A value of allocated(1)\n            indicates that one or more entries for this request are\n            present in the mallocAddressTable.  A value of offered(2)\n            indicates that addresses have been offered to the client\n            (e.g. via a MADCAP OFFER message), but the allocation has\n            not been committed.  A value of waiting(3) indicates that\n            the allocation is blocked while the server attempts to\n            acquire more space from which it can allocate addresses.  A\n            value of trying(4) means that no addresses have been offered\n            to the client, but that an attempt to allocate is in\n            progress.')
mallocRequestClientAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 8), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestClientAddressType.setDescription('The type of the address of the client that (last) requested\n            this allocation.')
mallocRequestClientAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 9), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestClientAddress.setDescription('The address of the client that (last) requested this\n            allocation.  The type of this address is determined by the\n            value of the mallocRequestClientAddressType object.')
mallocRequestServerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 10), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestServerAddressType.setDescription('The type of the address of the server to which the request\n            was (last) sent.')
mallocRequestServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 11), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestServerAddress.setDescription('The address of the server to which the request was (last)\n            sent.  The type of this address is determined by the value\n            of the mallocRequestServerAddressType object.')
mallocRequestLeaseIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 5, 1, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocRequestLeaseIdentifier.setDescription('The Lease Identifier of this request.  If the allocation\n            mechanism in use does not use Lease Identifiers, then the\n            value is a 0-length string.')
mallocAddressTable = MibTable((1, 3, 6, 1, 2, 1, 101, 1, 1, 6), )
if mibBuilder.loadTexts: mallocAddressTable.setDescription('The (conceptual) table containing information on blocks of\n            allocated addresses.  This table may be used to map a given\n            multicast group address to the associated request.')
mallocAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1), ).setIndexNames((0, "MALLOC-MIB", "mallocAddressAddressType"), (0, "MALLOC-MIB", "mallocAddressFirstAddress"))
if mibBuilder.loadTexts: mallocAddressEntry.setDescription('An entry (conceptual row) containing the information on a\n            particular block of allocated addresses.  The block of\n            addresses covered by each entry in this table must fall\n            within a range corresponding to an entry in the\n            mallocAllocRangeTable.')
mallocAddressAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 1), InetAddressType())
if mibBuilder.loadTexts: mallocAddressAddressType.setDescription('The type of the first address in the allocated block.\n            Legal values correspond to the subset of address families\n            for which multicast address allocation is supported.')
mallocAddressFirstAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 2), InetAddress().subtype(subtypeSpec=ValueSizeConstraint(0,20)))
if mibBuilder.loadTexts: mallocAddressFirstAddress.setDescription('The first address in the allocated block.  The type of this\n            address is determined by the value of the\n            mallocAddressAddressType object.')
mallocAddressNumAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAddressNumAddrs.setDescription('The number of addresses in the allocated block.')
mallocAddressRequestId = MibTableColumn((1, 3, 6, 1, 2, 1, 101, 1, 1, 6, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mallocAddressRequestId.setDescription('The index of the request which caused this block of\n            addresses to be allocated.  This value must match the value\n            of mallocRequestId for some entry in the\n            mallocRequestTable.')
madcapConfig = ObjectIdentity((1, 3, 6, 1, 2, 1, 101, 1, 2, 1))
if mibBuilder.loadTexts: madcapConfig.setDescription('Group of objects that count various MADCAP events.')
madcapConfigExtraAllocationTime = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 1), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: madcapConfigExtraAllocationTime.setDescription('The amount of extra time on either side of a lease which\n            the MADCAP server allocates to allow for clock skew among\n            clients.')
madcapConfigNoResponseDelay = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 2), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: madcapConfigNoResponseDelay.setDescription('The amount of time the MADCAP client allows for receiving a\n            response from a MADCAP server.')
madcapConfigOfferHold = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 3), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: madcapConfigOfferHold.setDescription('The amount of time the MADCAP server will reserve an\n            address for after sending an OFFER message in anticipation\n            of receiving a REQUEST message.')
madcapConfigResponseCacheInterval = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,300))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: madcapConfigResponseCacheInterval.setDescription('The amount of time the MADCAP server uses to detect\n            duplicate messages.')
madcapConfigClockSkewAllowance = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 1, 5), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: madcapConfigClockSkewAllowance.setDescription('The clock skew threshold used by the MADCAP server to\n            generate Excessive Clock Skew errors.')
madcapCounters = ObjectIdentity((1, 3, 6, 1, 2, 1, 101, 1, 2, 2))
if mibBuilder.loadTexts: madcapCounters.setDescription('A group of objects that count various MADCAP events.')
madcapTotalErrors = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapTotalErrors.setDescription('The total number of transactions for which the MADCAP\n            server has detected an error of any type, regardless of\n            whether the server ignored the request or generated a NAK.')
madcapRequestsDenied = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapRequestsDenied.setDescription('The number of valid requests for which the MADCAP server\n            could not complete an allocation, regardless of whether NAKs\n            were sent.  This corresponds to the Valid Request Could Not\n            Be Completed error code in MADCAP.')
madcapInvalidRequests = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapInvalidRequests.setDescription('The number of invalid requests received by the MADCAP\n            server, regardless of whether NAKs were sent.  This\n            corresponds to the Invalid Request error code in MADCAP.')
madcapExcessiveClockSkews = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapExcessiveClockSkews.setDescription('The number of requests received by the MADCAP server with\n            an excessive clock skew, regardless of whether NAKs were\n            sent.  This corresponds to the Excessive Clock Skew error\n            code in MADCAP.')
madcapBadLeaseIds = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapBadLeaseIds.setDescription('The number of requests received by the MADCAP server with\n            an unrecognized Lease Identifier, regardless of whether NAKs\n            were sent.  This corresponds to the Lease Identifier Not\n            Recognized error code in MADCAP.')
madcapDiscovers = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapDiscovers.setDescription('The number of DISCOVER messages received by the MADCAP\n            server.')
madcapInforms = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapInforms.setDescription('The number of INFORM messages received by the MADCAP\n            server.')
madcapRequests = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapRequests.setDescription('The number of REQUEST messages received by the MADCAP\n            server.')
madcapRenews = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapRenews.setDescription('The number of RENEW messages received by the MADCAP\n            server.')
madcapReleases = MibScalar((1, 3, 6, 1, 2, 1, 101, 1, 2, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: madcapReleases.setDescription('The number of RELEASE messages received by the MADCAP\n            server.')
mallocConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 2))
mallocCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 2, 1))
mallocGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 101, 2, 2))
mallocServerReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 101, 2, 1, 1)).setObjects(*(("MALLOC-MIB", "mallocBasicGroup"), ("MALLOC-MIB", "mallocServerGroup"),))
if mibBuilder.loadTexts: mallocServerReadOnlyCompliance.setDescription('The compliance statement for multicast address allocation\n            servers implementing the MALLOC MIB without support for\n            read-create (i.e., in read-only mode).  Such a server can\n            then be monitored but can not be configured with this MIB.')
mallocClientReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 101, 2, 1, 2)).setObjects(*(("MALLOC-MIB", "mallocBasicGroup"), ("MALLOC-MIB", "mallocClientGroup"), ("MALLOC-MIB", "mallocClientScopeGroup"), ("MALLOC-MIB", "madcapClientGroup"),))
if mibBuilder.loadTexts: mallocClientReadOnlyCompliance.setDescription('The compliance statement for clients implementing the\n            MALLOC MIB without support for read-create (i.e., in read-\n            only mode).  Such clients can then be monitored but can not\n            be configured with this MIB.')
mallocPrefixCoordinatorReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 101, 2, 1, 3)).setObjects(*(("MALLOC-MIB", "mallocBasicGroup"), ("MALLOC-MIB", "mallocPrefixCoordinatorGroup"),))
if mibBuilder.loadTexts: mallocPrefixCoordinatorReadOnlyCompliance.setDescription('The compliance statement for prefix coordinators\n            implementing the MALLOC MIB without support for read-create\n            (i.e., in read-only mode).  Such devices can then be\n            monitored but can not be configured with this MIB.')
mallocServerFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 101, 2, 1, 4)).setObjects(*(("MALLOC-MIB", "mallocBasicGroup"), ("MALLOC-MIB", "mallocServerGroup"), ("MALLOC-MIB", "madcapServerGroup"),))
if mibBuilder.loadTexts: mallocServerFullCompliance.setDescription('The compliance statement for multicast address allocation\n            servers implementing the MALLOC MIB with support for read-\n            create.  Such servers can then be both monitored and\n            configured with this MIB.')
mallocClientFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 101, 2, 1, 5)).setObjects(*(("MALLOC-MIB", "mallocBasicGroup"), ("MALLOC-MIB", "mallocClientGroup"), ("MALLOC-MIB", "mallocClientScopeGroup"), ("MALLOC-MIB", "madcapClientGroup"),))
if mibBuilder.loadTexts: mallocClientFullCompliance.setDescription('The compliance statement for hosts implementing the MALLOC\n            MIB with support for read-create.  Such clients can then be\n            both monitored and configured with this MIB.')
mallocPrefixCoordinatorFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 101, 2, 1, 6)).setObjects(*(("MALLOC-MIB", "mallocBasicGroup"), ("MALLOC-MIB", "mallocPrefixCoordinatorGroup"),))
if mibBuilder.loadTexts: mallocPrefixCoordinatorFullCompliance.setDescription('The compliance statement for prefix coordinators\n            implementing the MALLOC MIB with support for read-create.\n            Such devices can then be both monitored and configured with\n            this MIB.')
mallocBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 1)).setObjects(*(("MALLOC-MIB", "mallocCapabilities"), ("MALLOC-MIB", "mallocRequestScopeAddressType"), ("MALLOC-MIB", "mallocRequestScopeFirstAddress"), ("MALLOC-MIB", "mallocRequestStartTime"), ("MALLOC-MIB", "mallocRequestEndTime"), ("MALLOC-MIB", "mallocRequestNumAddrs"), ("MALLOC-MIB", "mallocRequestState"), ("MALLOC-MIB", "mallocAddressNumAddrs"), ("MALLOC-MIB", "mallocAddressRequestId"),))
if mibBuilder.loadTexts: mallocBasicGroup.setDescription('The basic collection of objects providing management of IP\n            multicast address allocation.')
mallocServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 2)).setObjects(*(("MALLOC-MIB", "mallocScopeLastAddress"), ("MALLOC-MIB", "mallocScopeHopLimit"), ("MALLOC-MIB", "mallocScopeSSM"), ("MALLOC-MIB", "mallocScopeStatus"), ("MALLOC-MIB", "mallocScopeStorage"), ("MALLOC-MIB", "mallocAllocRangeLastAddress"), ("MALLOC-MIB", "mallocAllocRangeLifetime"), ("MALLOC-MIB", "mallocAllocRangeNumAllocatedAddrs"), ("MALLOC-MIB", "mallocAllocRangeNumOfferedAddrs"), ("MALLOC-MIB", "mallocAllocRangeNumWaitingAddrs"), ("MALLOC-MIB", "mallocAllocRangeNumTryingAddrs"), ("MALLOC-MIB", "mallocAllocRangeMaxLeaseAddrs"), ("MALLOC-MIB", "mallocAllocRangeMaxLeaseTime"), ("MALLOC-MIB", "mallocAllocRangeSource"), ("MALLOC-MIB", "mallocAllocRangeStatus"), ("MALLOC-MIB", "mallocAllocRangeStorage"), ("MALLOC-MIB", "mallocScopeDivisible"), ("MALLOC-MIB", "mallocScopeSource"), ("MALLOC-MIB", "mallocScopeNameScopeName"), ("MALLOC-MIB", "mallocScopeNameDefault"), ("MALLOC-MIB", "mallocScopeNameStatus"), ("MALLOC-MIB", "mallocScopeNameStorage"), ("MALLOC-MIB", "mallocRequestClientAddressType"), ("MALLOC-MIB", "mallocRequestClientAddress"),))
if mibBuilder.loadTexts: mallocServerGroup.setDescription('A collection of objects providing management of multicast\n            address allocation in servers.')
mallocClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 3)).setObjects(*(("MALLOC-MIB", "mallocRequestServerAddressType"), ("MALLOC-MIB", "mallocRequestServerAddress"),))
if mibBuilder.loadTexts: mallocClientGroup.setDescription('A collection of objects providing management of multicast\n            address allocation in clients.')
madcapServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 4)).setObjects(*(("MALLOC-MIB", "madcapConfigClockSkewAllowance"), ("MALLOC-MIB", "madcapConfigExtraAllocationTime"), ("MALLOC-MIB", "madcapConfigOfferHold"), ("MALLOC-MIB", "madcapConfigResponseCacheInterval"), ("MALLOC-MIB", "madcapTotalErrors"), ("MALLOC-MIB", "madcapRequestsDenied"), ("MALLOC-MIB", "madcapInvalidRequests"), ("MALLOC-MIB", "madcapBadLeaseIds"), ("MALLOC-MIB", "madcapExcessiveClockSkews"), ("MALLOC-MIB", "madcapDiscovers"), ("MALLOC-MIB", "madcapInforms"), ("MALLOC-MIB", "madcapRequests"), ("MALLOC-MIB", "madcapRenews"), ("MALLOC-MIB", "madcapReleases"),))
if mibBuilder.loadTexts: madcapServerGroup.setDescription('A collection of objects providing management of MADCAP\n            servers.')
madcapClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 5)).setObjects(*(("MALLOC-MIB", "mallocRequestLeaseIdentifier"), ("MALLOC-MIB", "madcapConfigNoResponseDelay"),))
if mibBuilder.loadTexts: madcapClientGroup.setDescription('A collection of objects providing management of MADCAP\n            clients.')
mallocClientScopeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 6)).setObjects(*(("MALLOC-MIB", "mallocScopeLastAddress"), ("MALLOC-MIB", "mallocScopeHopLimit"), ("MALLOC-MIB", "mallocScopeStatus"), ("MALLOC-MIB", "mallocScopeStorage"), ("MALLOC-MIB", "mallocScopeSource"), ("MALLOC-MIB", "mallocScopeServerAddressType"), ("MALLOC-MIB", "mallocScopeServerAddress"), ("MALLOC-MIB", "mallocScopeSSM"), ("MALLOC-MIB", "mallocScopeNameScopeName"), ("MALLOC-MIB", "mallocScopeNameDefault"), ("MALLOC-MIB", "mallocScopeNameStatus"), ("MALLOC-MIB", "mallocScopeNameStorage"),))
if mibBuilder.loadTexts: mallocClientScopeGroup.setDescription('A collection of objects providing management of multicast\n            scope information in clients.')
mallocPrefixCoordinatorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 101, 2, 2, 7)).setObjects(*(("MALLOC-MIB", "mallocAllocRangeLastAddress"), ("MALLOC-MIB", "mallocAllocRangeLifetime"), ("MALLOC-MIB", "mallocAllocRangeStatus"), ("MALLOC-MIB", "mallocAllocRangeStorage"), ("MALLOC-MIB", "mallocAllocRangeSource"), ("MALLOC-MIB", "mallocAllocRangeTotalAllocatedAddrs"), ("MALLOC-MIB", "mallocAllocRangeTotalRequestedAddrs"), ("MALLOC-MIB", "mallocAllocRangeAdvertisable"), ("MALLOC-MIB", "mallocScopeLastAddress"), ("MALLOC-MIB", "mallocScopeDivisible"), ("MALLOC-MIB", "mallocScopeSource"),))
if mibBuilder.loadTexts: mallocPrefixCoordinatorGroup.setDescription('A collection of objects for managing Prefix Coordinators.')
mibBuilder.exportSymbols("MALLOC-MIB", mallocRequestScopeFirstAddress=mallocRequestScopeFirstAddress, mallocRequestLeaseIdentifier=mallocRequestLeaseIdentifier, madcapInvalidRequests=madcapInvalidRequests, mallocAllocRangeNumWaitingAddrs=mallocAllocRangeNumWaitingAddrs, mallocAllocRangeStatus=mallocAllocRangeStatus, mallocAddressFirstAddress=mallocAddressFirstAddress, mallocClientReadOnlyCompliance=mallocClientReadOnlyCompliance, mallocAddressAddressType=mallocAddressAddressType, mallocCompliances=mallocCompliances, mallocScopeHopLimit=mallocScopeHopLimit, madcapRequestsDenied=madcapRequestsDenied, mallocRequestClientAddress=mallocRequestClientAddress, PYSNMP_MODULE_ID=mallocMIB, mallocRequestState=mallocRequestState, mallocAllocRangeLastAddress=mallocAllocRangeLastAddress, mallocScopeLastAddress=mallocScopeLastAddress, mallocAllocRangeEntry=mallocAllocRangeEntry, mallocAllocRangeStorage=mallocAllocRangeStorage, mallocAllocRangeTable=mallocAllocRangeTable, madcapClientGroup=madcapClientGroup, mallocServerFullCompliance=mallocServerFullCompliance, mallocClientGroup=mallocClientGroup, mallocScopeSSM=mallocScopeSSM, mallocAddressTable=mallocAddressTable, mallocScopeNameScopeName=mallocScopeNameScopeName, mallocScopeTable=mallocScopeTable, mallocRequestScopeAddressType=mallocRequestScopeAddressType, mallocScopeFirstAddress=mallocScopeFirstAddress, mallocAllocRangeNumAllocatedAddrs=mallocAllocRangeNumAllocatedAddrs, mallocRequestClientAddressType=mallocRequestClientAddressType, madcapCounters=madcapCounters, madcapExcessiveClockSkews=madcapExcessiveClockSkews, mallocCapabilities=mallocCapabilities, mallocClientScopeGroup=mallocClientScopeGroup, mallocAllocRangeNumOfferedAddrs=mallocAllocRangeNumOfferedAddrs, mallocRequestNumAddrs=mallocRequestNumAddrs, madcapTotalErrors=madcapTotalErrors, mallocAllocRangeTotalAllocatedAddrs=mallocAllocRangeTotalAllocatedAddrs, mallocRequestServerAddress=mallocRequestServerAddress, mallocServerGroup=mallocServerGroup, mallocPrefixCoordinatorFullCompliance=mallocPrefixCoordinatorFullCompliance, malloc=malloc, mallocAddressRequestId=mallocAddressRequestId, mallocBasicGroup=mallocBasicGroup, mallocAllocRangeNumTryingAddrs=mallocAllocRangeNumTryingAddrs, mallocScopeNameEntry=mallocScopeNameEntry, mallocAllocRangeAdvertisable=mallocAllocRangeAdvertisable, mallocConformance=mallocConformance, mallocScopeNameLangName=mallocScopeNameLangName, mallocPrefixCoordinatorReadOnlyCompliance=mallocPrefixCoordinatorReadOnlyCompliance, mallocPrefixCoordinatorGroup=mallocPrefixCoordinatorGroup, madcapInforms=madcapInforms, madcapConfigResponseCacheInterval=madcapConfigResponseCacheInterval, mallocAllocRangeMaxLeaseAddrs=mallocAllocRangeMaxLeaseAddrs, mallocRequestStartTime=mallocRequestStartTime, mallocRequestEntry=mallocRequestEntry, madcapConfigNoResponseDelay=madcapConfigNoResponseDelay, mallocClientFullCompliance=mallocClientFullCompliance, mallocAllocRangeTotalRequestedAddrs=mallocAllocRangeTotalRequestedAddrs, madcapServerGroup=madcapServerGroup, madcapConfigExtraAllocationTime=madcapConfigExtraAllocationTime, madcapConfigOfferHold=madcapConfigOfferHold, mallocAddressEntry=mallocAddressEntry, madcapRequests=madcapRequests, madcapConfig=madcapConfig, mallocScopeDivisible=mallocScopeDivisible, mallocScopeServerAddress=mallocScopeServerAddress, mallocScopeStorage=mallocScopeStorage, madcapReleases=madcapReleases, mallocAllocRangeFirstAddress=mallocAllocRangeFirstAddress, mallocScopeSource=mallocScopeSource, mallocRequestTable=mallocRequestTable, mallocGroups=mallocGroups, mallocScopeAddressType=mallocScopeAddressType, mallocRequestEndTime=mallocRequestEndTime, madcapConfigClockSkewAllowance=madcapConfigClockSkewAllowance, mallocScopeStatus=mallocScopeStatus, mallocAddressNumAddrs=mallocAddressNumAddrs, mallocScopeNameDefault=mallocScopeNameDefault, mallocScopeServerAddressType=mallocScopeServerAddressType, mallocRequestServerAddressType=mallocRequestServerAddressType, mallocAllocRangeSource=mallocAllocRangeSource, madcapBadLeaseIds=madcapBadLeaseIds, mallocScopeEntry=mallocScopeEntry, madcapDiscovers=madcapDiscovers, mallocAllocRangeLifetime=mallocAllocRangeLifetime, mallocMIBObjects=mallocMIBObjects, madcap=madcap, mallocScopeNameStorage=mallocScopeNameStorage, mallocScopeNameTable=mallocScopeNameTable, mallocAllocRangeMaxLeaseTime=mallocAllocRangeMaxLeaseTime, mallocRequestId=mallocRequestId, madcapRenews=madcapRenews, mallocScopeNameStatus=mallocScopeNameStatus, mallocServerReadOnlyCompliance=mallocServerReadOnlyCompliance, mallocMIB=mallocMIB)
