% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_status}
\alias{ps_status}
\title{Current process status}
\usage{
ps_status(p = ps_handle())
}
\arguments{
\item{p}{Process handle.}
}
\value{
Character scalar.
}
\description{
One of the following:
\itemize{
\item \code{"idle"}: Process being created by fork, or process has been sleeping
for a long time. macOS only.
\item \code{"running"}: Currently runnable on macOS and Windows. Actually
running on Linux.
\item \code{"sleeping"} Sleeping on a wait or poll.
\item \code{"disk_sleep"} Uninterruptible sleep, waiting for an I/O operation
(Linux only).
\item \code{"stopped"} Stopped, either by a job control signal or because it
is being traced.
\item \code{"uninterruptible"} Process is in uninterruptible wait. macOS only.
\item \code{"tracing_stop"} Stopped for tracing (Linux only).
\item \code{"zombie"} Zombie. Finished, but parent has not read out the exit
status yet.
\item \code{"dead"} Should never be seen (Linux).
\item \code{"wake_kill"} Received fatal signal (Linux only).
\item \code{"waking"} Paging (Linux only, not valid since the 2.6.xx kernel).
}
}
\details{
It might return \code{NA_character_} on macOS.

Works for zombie processes.
}
\section{Note on macOS}{

On macOS \code{ps_status()} often falls back to calling the external \code{ps}
program, because macOS does not let R access the status of most other
processes. Notably, it is usually able to access the status of other R
processes.

The external \code{ps} program always runs as the root user, and
it also has special entitlements, so it can typically access the status
of most processes.

If this behavior is problematic for you, e.g. because calling an
external program is too slow, set the \code{ps.no_external_ps} option to
\code{TRUE}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(ps.no_external_ps = TRUE)
}\if{html}{\out{</div>}}

Note that setting this option to \code{TRUE} will cause \code{ps_status()} to
return \code{NA_character_} for most processes.
}

\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
p <- ps_handle()
p
ps_status(p)
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_descent}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_shared_libs}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}
}
\concept{process handle functions}
