% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{extractors}
\alias{extractors}
\alias{sparse_positions}
\alias{sparse_values}
\alias{sparse_default}
\title{Information extraction from sparse vectors}
\usage{
sparse_positions(x)

sparse_values(x)

sparse_default(x)
}
\arguments{
\item{x}{vector to be extracted from.}
}
\value{
vectors of requested attributes
}
\description{
Extract positions, values, and default from sparse vectors without the need
to materialize vector.
}
\details{
\code{sparse_default()} returns \code{NA} when applied to non-sparse vectors. This is
done to have an indicator of non-sparsity.

for ease of use, these functions also works on non-sparse variables.
}
\examples{
x_sparse <- sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 10)
x_dense <- c(0, pi, 0, 0, 0.5, 0, 0, 0, 0, 0.1)

sparse_positions(x_sparse)
sparse_values(x_sparse)
sparse_default(x_sparse)

sparse_positions(x_dense)
sparse_values(x_dense)
sparse_default(x_dense)

x_sparse_3 <- sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 10, default = 3)
sparse_default(x_sparse_3)
}
