/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file TrayIcon.hxx
    \author Romain BONDUE
    \date 08/07/2005
    \warning This file should only be included from TrayIcon.h */
inline void nsGUI::CTrayIcon::SetIcon (const std::string& FileName) throw()
{
    if (FileName != m_CurrentIconFileName)
    {
        if (m_pIcon)
            ::gtk_image_set_from_file (m_pIcon, FileName.c_str());
        m_CurrentIconFileName = FileName;
    }

} // SetIcon()


inline void nsGUI::CTrayIcon::SetTooltip (const std::string& Text) throw()
{
    if (m_pTrayIcon)
        ::gtk_tooltips_set_tip (m_pToolTipsGroup, m_pTrayIcon,
                                Text.c_str(), 0);

} // SetTooltip()


inline bool nsGUI::CTrayIcon::IsVisible () const throw()
{
    return m_pTrayIcon;

} // IsVisible()
