%define OT_ComplexMatrix_doc
R"RAW(Complex Matrix.

Parameters
----------
nr : int
    The number of rows of the complex matrix.
nc : int
    The number of columns of the complex matrix.
values : sequence of complex number, optional
    The sequence must have :math:`n_r \times n_c` elements. It might be a
    :class:`~openturns.ComplexCollection` or a :class:`~openturns.ScalarCollection`. Default is (0, 0).

See also
--------
ComplexTensor

Examples
--------
>>> import openturns as ot
>>> m = ot.ComplexMatrix(2, 2, [1+2j, 3+4j , 5+6j, 7+8j])
>>> print(m)
[[ (1,2) (5,6) ]
 [ (3,4) (7,8) ]]
>>> m = ot.ComplexMatrix(2, 3, range(2*3))
>>> print(m)
[[ (0,0) (2,0) (4,0) ]
 [ (1,0) (3,0) (5,0) ]]

Create a matrix from a numpy array:

>>> import numpy as np
>>> array = np.array([[1, 2], [3, 4], [5, 6]])
>>> m = ot.ComplexMatrix(array)
>>> print(m)
[[ (1,0) (2,0) ]
 [ (3,0) (4,0) ]
 [ (5,0) (6,0) ]]
)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix
OT_ComplexMatrix_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_clean_doc
"Clean the matrix according to a specific threshold.

Parameters
----------
threshold : positive float
    Numerical sample which is the collection of points stored by the history
    strategy."
%enddef
%feature("docstring") OT::ComplexMatrix::clean
OT_ComplexMatrix_clean_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_conjugate_doc
R"RAW(Accessor to the conjugate complex matrix.

Returns
-------
N : :class:`~openturns.ComplexMatrix`
    The conjugate matrix :math:`\mat{N}` of size :math:`n_r \times n_c`
    associated with the given complex matrix :math:`\mat{M}` such as
    :math:`N_{i, j} = \overline{M}_{i, j}`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::conjugate
OT_ComplexMatrix_conjugate_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_conjugateTranspose_doc
R"RAW(Accessor to the transposed conjugate complex matrix.

Returns
-------
N : :class:`~openturns.ComplexMatrix`
    The transposed conjugate matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
    associated with the given complex matrix :math:`\mat{M}` such as
    :math:`N_{i, j} = \overline{M}_{j, i}`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::conjugateTranspose
OT_ComplexMatrix_conjugateTranspose_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_getNbColumns_doc
R"RAW(Accessor to the number of columns.

Returns
-------
nc : int
    The number of columns of :math:`\mat{M}`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::getNbColumns
OT_ComplexMatrix_getNbColumns_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_getNbRows_doc
R"RAW(Accessor to the number of rows.

Returns
-------
nr : int
    The number of rows of :math:`\mat{M}`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::getNbRows
OT_ComplexMatrix_getNbRows_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_imag_doc
R"RAW(Accessor to the imaginary part.

Returns
-------
imat : :class:`~openturns.Matrix`
    A real matrix :math:`\mat{A}` of size :math:`n_r \times n_c` such
    :math:`A_{i, j} = \mathrm{Im} (M_{i, j})`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::imag
OT_ComplexMatrix_imag_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_isEmpty_doc
"Test whether the matrix is empty or not.

Returns
-------
isEmpty : bool
    Flag telling whether the dimensions of the matrix is zero."
%enddef
%feature("docstring") OT::ComplexMatrix::isEmpty
OT_ComplexMatrix_isEmpty_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_real_doc
R"RAW(Accessor to the real part.

Returns
-------
rmat : :class:`~openturns.Matrix`
    A real matrix :math:`\mat{A}` of size :math:`n_r \times n_c` such
    :math:`A_{i, j} = \mathrm{Re} (M_{i, j})`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::real
OT_ComplexMatrix_real_doc

// ---------------------------------------------------------------------

%define OT_ComplexMatrix_transpose_doc
R"RAW(Accessor to the transposed complex matrix.

Returns
-------
N : :class:`~openturns.ComplexMatrix`
    The transposed matrix :math:`\mat{N}` of size :math:`n_c \times n_r`
    associated with the given complex matrix :math:`\mat{M}` such as
    :math:`N_{i, j} = M_{j, i}`.)RAW"
%enddef
%feature("docstring") OT::ComplexMatrix::transpose
OT_ComplexMatrix_transpose_doc

// ---------------------------------------------------------------------

%feature("docstring") OT::ComplexMatrix::solveLinearSystem
"Solve a system of linear equations.

Parameters
----------
B : :class:`~openturns.ComplexMatrix`
    Second member

Returns
-------
X : :class:`~openturns.ComplexMatrix`
    The solution to A * X = B."

// ---------------------------------------------------------------------

%feature("docstring") OT::ComplexMatrix::solveLinearSystem
"Solve a system of linear equations.

Parameters
----------
B : :class:`~openturns.ComplexMatrix`
    Second member

Returns
-------
X : :class:`~openturns.ComplexMatrix`
    The solution to A * X = B."

// ---------------------------------------------------------------------

%feature("docstring") OT::ComplexMatrix::solveLinearSystemInPlace
"Solve a system of linear equations.

Parameters
----------
B : :class:`~openturns.ComplexMatrix`
    Second member

Returns
-------
X : :class:`~openturns.ComplexMatrix`
    The solution to A * X = B.
    
Notes
-----
Unlike :meth:`solveLinearSystem` this method does not copy the matrix A
and alters it in-place during the resolution, so the content of A may change."
