# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights.aio import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementWebTestsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_list_by_resource_group(self, resource_group):
        response = self.client.web_tests.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_get(self, resource_group):
        response = await self.client.web_tests.get(
            resource_group_name=resource_group.name,
            web_test_name="str",
            api_version="2022-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_create_or_update(self, resource_group):
        response = await self.client.web_tests.create_or_update(
            resource_group_name=resource_group.name,
            web_test_name="str",
            web_test_definition={
                "location": "str",
                "Configuration": {"WebTest": "str"},
                "Description": "str",
                "Enabled": bool,
                "Frequency": 300,
                "Kind": "str",
                "Locations": [{"Id": "str"}],
                "Name": "str",
                "Request": {
                    "FollowRedirects": bool,
                    "Headers": [{"key": "str", "value": "str"}],
                    "HttpVerb": "str",
                    "ParseDependentRequests": bool,
                    "RequestBody": "str",
                    "RequestUrl": "str",
                },
                "RetryEnabled": bool,
                "SyntheticMonitorId": "str",
                "Timeout": 30,
                "ValidationRules": {
                    "ContentValidation": {"ContentMatch": "str", "IgnoreCase": bool, "PassIfTextFound": bool},
                    "ExpectedHttpStatusCode": 0,
                    "IgnoreHttpStatusCode": bool,
                    "SSLCertRemainingLifetimeCheck": 0,
                    "SSLCheck": bool,
                },
                "id": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2022-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_update_tags(self, resource_group):
        response = await self.client.web_tests.update_tags(
            resource_group_name=resource_group.name,
            web_test_name="str",
            web_test_tags={"tags": {"str": "str"}},
            api_version="2022-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_delete(self, resource_group):
        response = await self.client.web_tests.delete(
            resource_group_name=resource_group.name,
            web_test_name="str",
            api_version="2022-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_list(self, resource_group):
        response = self.client.web_tests.list(
            api_version="2022-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_web_tests_list_by_component(self, resource_group):
        response = self.client.web_tests.list_by_component(
            component_name="str",
            resource_group_name=resource_group.name,
            api_version="2022-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
