#' Australian monthly gas production
#'
#' Australian monthly gas production: 1956--1995.
#'
#'
#' @format Time series data
#' @source Australian Bureau of Statistics.
#' @keywords datasets
#' @examples
#' plot(gas)
#' seasonplot(gas)
#' tsdisplay(gas)
#'
"gas"

#' Daily morning gold prices
#'
#' Daily morning gold prices in US dollars. 1 January 1985 -- 31 March 1989.
#'
#'
#' @format Time series data
#' @keywords datasets
#' @examples
#' tsdisplay(gold)
#'
"gold"

#' Half-hourly electricity demand
#'
#' Half-hourly electricity demand in England and Wales from Monday 5 June 2000
#' to Sunday 27 August 2000. Discussed in Taylor (2003), and kindly provided by
#' James W Taylor. Units: Megawatts
#'
#'
#' @format Time series data
#' @references Taylor, J.W. (2003) Short-term electricity demand forecasting
#' using double seasonal exponential smoothing. \emph{Journal of the
#' Operational Research Society}, \bold{54}, 799-805.
#' @source James W Taylor
#' @keywords datasets
#' @examples
#' plot(taylor)
#'
"taylor"

#' Australian total wine sales
#'
#' Australian total wine sales by wine makers in bottles <= 1 litre. Jan 1980
#' -- Aug 1994.
#'
#'
#' @format Time series data
#' @source Time Series Data Library. \url{https://pkg.yangzhuoranyang.com/tsdl/}
#' @keywords datasets
#' @examples
#' tsdisplay(wineind)
#'
"wineind"

#' Quarterly production of woollen yarn in Australia
#'
#' Quarterly production of woollen yarn in Australia: tonnes. Mar 1965 -- Sep
#' 1994.
#'
#'
#' @format Time series data
#' @source Time Series Data Library. \url{https://pkg.yangzhuoranyang.com/tsdl/}
#' @keywords datasets
#' @examples
#' tsdisplay(woolyrnq)
#'
"woolyrnq"
