% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.ci.R
\name{publish.ci}
\alias{publish.ci}
\title{Publish tables with confidence intervals}
\usage{
\method{publish}{ci}(object, format = "[u;l]", se = FALSE, ...)
}
\arguments{
\item{object}{Object of class ci containing point estimates and the
corresponding confidence intervals}

\item{format}{A string which indicates the format used for
confidence intervals.  The string is passed to
\link{formatCI} with two arguments: the lower and the upper
limit. For example \code{'(l;u)'} yields confidence intervals with
round parenthesis in which the upper and the lower limits are
separated by semicolon.}

\item{se}{If \code{TRUE} add standard error.}

\item{...}{passed to \code{publish}}
}
\value{
table with confidence intervals
}
\description{
Publish tables with confidence intervals
}
\details{
This function calls summary.ci with print=FALSE and then publish
}
\examples{

data(Diabetes)
publish(ci.mean(chol~location+gender,data=Diabetes),org=TRUE)

}
\seealso{
summary.ci
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
