% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-special.R
\name{env_name}
\alias{env_name}
\alias{env_label}
\title{Label of an environment}
\usage{
env_name(env)

env_label(env)
}
\arguments{
\item{env}{An environment.}
}
\description{
Special environments like the global environment have their own
names. \code{env_name()} returns:
\itemize{
\item "global" for the global environment.
\item "empty" for the empty environment.
\item "base" for the base package environment (the last environment on
the search path).
\item "namespace:pkg" if \code{env} is the namespace of the package "pkg".
\item The \code{name} attribute of \code{env} if it exists. This is how the
\link[=search_envs]{package environments} and the \link[=ns_imports_env]{imports environments} store their names. The name of package
environments is typically "package:pkg".
\item The empty string \code{""} otherwise.
}

\code{env_label()} is exactly like \code{env_name()} but returns the memory
address of anonymous environments as fallback.
}
\examples{
# Some environments have specific names:
env_name(global_env())
env_name(ns_env("rlang"))

# Anonymous environments don't have names but are labelled by their
# address in memory:
env_name(env())
env_label(env())
}
