; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2,+gfni | FileCheck %s --check-prefixes=GFNISSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX1OR2,GFNIAVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+gfni | FileCheck %s --check-prefixes=GFNIAVX,GFNIAVX512,GFNIAVX512BW

;
; 128 Bit Vector Funnel Shifts
;

define <16 x i8> @var_fshl_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_fshl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; GFNISSE-NEXT:    pxor %xmm3, %xmm3
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm6 = [1065353216,1065353216,1065353216,1065353216]
; GFNISSE-NEXT:    paddd %xmm6, %xmm2
; GFNISSE-NEXT:    cvttps2dq %xmm2, %xmm2
; GFNISSE-NEXT:    pslld $23, %xmm3
; GFNISSE-NEXT:    paddd %xmm6, %xmm3
; GFNISSE-NEXT:    cvttps2dq %xmm3, %xmm3
; GFNISSE-NEXT:    packusdw %xmm2, %xmm3
; GFNISSE-NEXT:    movdqa %xmm1, %xmm7
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm0[8],xmm7[9],xmm0[9],xmm7[10],xmm0[10],xmm7[11],xmm0[11],xmm7[12],xmm0[12],xmm7[13],xmm0[13],xmm7[14],xmm0[14],xmm7[15],xmm0[15]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm7
; GFNISSE-NEXT:    psrlw $8, %xmm7
; GFNISSE-NEXT:    pslld $23, %xmm4
; GFNISSE-NEXT:    paddd %xmm6, %xmm4
; GFNISSE-NEXT:    cvttps2dq %xmm4, %xmm2
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm5
; GFNISSE-NEXT:    paddd %xmm6, %xmm5
; GFNISSE-NEXT:    cvttps2dq %xmm5, %xmm3
; GFNISSE-NEXT:    packusdw %xmm3, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNISSE-NEXT:    pmullw %xmm1, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm7, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_fshl_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm2[8],xmm3[8],xmm2[9],xmm3[9],xmm2[10],xmm3[10],xmm2[11],xmm3[11],xmm2[12],xmm3[12],xmm2[13],xmm3[13],xmm2[14],xmm3[14],xmm2[15],xmm3[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm3[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [1065353216,1065353216,1065353216,1065353216]
; GFNIAVX1-NEXT:    vpaddd %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpaddd %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vcvttps2dq %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm4, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpaddd %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddd %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackusdw %xmm2, %xmm4, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_fshl_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX2-NEXT:    vpmovzxwd {{.*#+}} ymm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm4[8],xmm2[9],xmm4[9],xmm2[10],xmm4[10],xmm2[11],xmm4[11],xmm2[12],xmm4[12],xmm2[13],xmm4[13],xmm2[14],xmm4[14],xmm2[15],xmm4[15]
; GFNIAVX2-NEXT:    vpmovzxwd {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; GFNIAVX2-NEXT:    vpsllvd %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; GFNIAVX2-NEXT:    vpshufb %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNIAVX2-NEXT:    vpmovzxbd {{.*#+}} ymm1 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero
; GFNIAVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpshufb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; GFNIAVX2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vzeroupper
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_fshl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero,xmm4[8],zero,zero,zero,xmm4[9],zero,zero,zero,xmm4[10],zero,zero,zero,xmm4[11],zero,zero,zero,xmm4[12],zero,zero,zero,xmm4[13],zero,zero,zero,xmm4[14],zero,zero,zero,xmm4[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm1, %xmm1
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_fshl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm2, %xmm1
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpsllvw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %amt)
  ret <16 x i8> %res
}

define <16 x i8> @var_fshr_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_fshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    movdqa %xmm0, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pand %xmm5, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    movdqa %xmm0, %xmm4
; GFNISSE-NEXT:    paddb %xmm0, %xmm4
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm6
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm6
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm6
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm6, %xmm1
; GFNISSE-NEXT:    pandn %xmm5, %xmm3
; GFNISSE-NEXT:    psllw $5, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    paddb %xmm3, %xmm4
; GFNISSE-NEXT:    paddb %xmm2, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm5
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    paddb %xmm2, %xmm3
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm3, %xmm2
; GFNISSE-NEXT:    por %xmm1, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_fshr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX1-NEXT:    vpand %xmm3, %xmm2, %xmm4
; GFNIAVX1-NEXT:    vpsllw $5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm4, %xmm4, %xmm5
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm4, %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm4
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpblendvb %xmm3, %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_fshr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; GFNIAVX2-NEXT:    vpsllw $5, %xmm4, %xmm4
; GFNIAVX2-NEXT:    vpaddb %xmm4, %xmm4, %xmm5
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm6
; GFNIAVX2-NEXT:    vpblendvb %xmm4, %xmm6, %xmm1, %xmm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm4
; GFNIAVX2-NEXT:    vpblendvb %xmm5, %xmm4, %xmm1, %xmm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm4
; GFNIAVX2-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX2-NEXT:    vpblendvb %xmm5, %xmm4, %xmm1, %xmm1
; GFNIAVX2-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpaddb %xmm2, %xmm2, %xmm3
; GFNIAVX2-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm4
; GFNIAVX2-NEXT:    vpblendvb %xmm2, %xmm4, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; GFNIAVX2-NEXT:    vpblendvb %xmm3, %xmm2, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpaddb %xmm0, %xmm0, %xmm2
; GFNIAVX2-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpblendvb %xmm3, %xmm2, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_fshr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm4
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero,xmm4[8],zero,zero,zero,xmm4[9],zero,zero,zero,xmm4[10],zero,zero,zero,xmm4[11],zero,zero,zero,xmm4[12],zero,zero,zero,xmm4[13],zero,zero,zero,xmm4[14],zero,zero,zero,xmm4[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; GFNIAVX512VL-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; GFNIAVX512VL-NEXT:    vzeroupper
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_fshr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm2, %xmm1
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpsrlvw %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %amt)
  ret <16 x i8> %res
}

define <16 x i8> @splatvar_fshl_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_fshl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm3
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; GFNISSE-NEXT:    psllw %xmm2, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNISSE-NEXT:    psllw %xmm2, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX-LABEL: splatvar_fshl_v16i8:
; GFNIAVX:       # %bb.0:
; GFNIAVX-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX-NEXT:    vpsllw %xmm2, %xmm0, %xmm0
; GFNIAVX-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX-NEXT:    retq
  %splat = shufflevector <16 x i8> %amt, <16 x i8> undef, <16 x i32> zeroinitializer
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %splat)
  ret <16 x i8> %res
}

define <16 x i8> @splatvar_fshr_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_fshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm4
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm0[8],xmm4[9],xmm0[9],xmm4[10],xmm0[10],xmm4[11],xmm0[11],xmm4[12],xmm0[12],xmm4[13],xmm0[13],xmm4[14],xmm0[14],xmm4[15],xmm0[15]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; GFNISSE-NEXT:    psrlw %xmm2, %xmm4
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm3, %xmm4
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNISSE-NEXT:    psrlw %xmm2, %xmm1
; GFNISSE-NEXT:    pand %xmm1, %xmm3
; GFNISSE-NEXT:    packuswb %xmm4, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_fshr_v16i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_fshr_v16i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX2-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_fshr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; GFNIAVX512VL-NEXT:    vpand %xmm4, %xmm3, %xmm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpand %xmm4, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_fshr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} xmm3 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX512BW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm1
; GFNIAVX512BW-NEXT:    vpsrlw %xmm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <16 x i8> %amt, <16 x i8> undef, <16 x i32> zeroinitializer
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %splat)
  ret <16 x i8> %res
}

define <16 x i8> @constant_fshl_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: constant_fshl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2 # [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: constant_fshl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2 # [1,128,64,32,16,8,4,2]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1OR2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_fshl_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2 # [1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_fshl_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <16 x i8> %res
}

define <16 x i8> @constant_fshr_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: constant_fshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2 # [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNISSE-NEXT:    pmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1 # [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: constant_fshr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2 # [1,128,64,32,16,8,4,2]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1OR2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1OR2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX1OR2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_fshr_v16i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2 # [1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # [1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_fshr_v16i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpmovwb %ymm0, %xmm0
; GFNIAVX512BW-NEXT:    vzeroupper
; GFNIAVX512BW-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <16 x i8> %res
}

define <16 x i8> @splatconstant_fshl_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: splatconstant_fshl_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; GFNISSE-NEXT:    por %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_fshl_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_fshl_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpsllw $3, %xmm0, %xmm2
; GFNIAVX512-NEXT:    vpsrlw $5, %xmm1, %xmm0
; GFNIAVX512-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm0 ^ (m32bcst & (xmm0 ^ xmm2))
; GFNIAVX512-NEXT:    retq
  %res = call <16 x i8> @llvm.fshl.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>)
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.fshl.v16i8(<16 x i8>, <16 x i8>, <16 x i8>)

define <16 x i8> @splatconstant_fshr_v16i8(<16 x i8> %a, <16 x i8> %b) nounwind {
; GFNISSE-LABEL: splatconstant_fshr_v16i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    por %xmm1, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1OR2-LABEL: splatconstant_fshr_v16i8:
; GFNIAVX1OR2:       # %bb.0:
; GFNIAVX1OR2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; GFNIAVX1OR2-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; GFNIAVX1OR2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_fshr_v16i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpaddw %xmm0, %xmm0, %xmm2
; GFNIAVX512-NEXT:    vpsrlw $7, %xmm1, %xmm0
; GFNIAVX512-NEXT:    vpternlogd {{.*#+}} xmm0 = xmm0 ^ (m32bcst & (xmm0 ^ xmm2))
; GFNIAVX512-NEXT:    retq
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>)
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.fshr.v16i8(<16 x i8>, <16 x i8>, <16 x i8>)

;
; 256 Bit Vector Funnel Shifts
;

define <32 x i8> @var_fshl_v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_fshl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm0, %xmm6
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNISSE-NEXT:    pand %xmm8, %xmm4
; GFNISSE-NEXT:    pxor %xmm7, %xmm7
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm9 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; GFNISSE-NEXT:    movdqa %xmm4, %xmm10
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm7[8],xmm10[9],xmm7[9],xmm10[10],xmm7[10],xmm10[11],xmm7[11],xmm10[12],xmm7[12],xmm10[13],xmm7[13],xmm10[14],xmm7[14],xmm10[15],xmm7[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm11 = xmm10[0],zero,xmm10[1],zero,xmm10[2],zero,xmm10[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm10
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [1065353216,1065353216,1065353216,1065353216]
; GFNISSE-NEXT:    paddd %xmm4, %xmm10
; GFNISSE-NEXT:    cvttps2dq %xmm10, %xmm10
; GFNISSE-NEXT:    pslld $23, %xmm11
; GFNISSE-NEXT:    paddd %xmm4, %xmm11
; GFNISSE-NEXT:    cvttps2dq %xmm11, %xmm11
; GFNISSE-NEXT:    packusdw %xmm10, %xmm11
; GFNISSE-NEXT:    movdqa %xmm2, %xmm10
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm6[8],xmm10[9],xmm6[9],xmm10[10],xmm6[10],xmm10[11],xmm6[11],xmm10[12],xmm6[12],xmm10[13],xmm6[13],xmm10[14],xmm6[14],xmm10[15],xmm6[15]
; GFNISSE-NEXT:    pmullw %xmm11, %xmm10
; GFNISSE-NEXT:    psrlw $8, %xmm10
; GFNISSE-NEXT:    pslld $23, %xmm0
; GFNISSE-NEXT:    paddd %xmm4, %xmm0
; GFNISSE-NEXT:    cvttps2dq %xmm0, %xmm0
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm9
; GFNISSE-NEXT:    paddd %xmm4, %xmm9
; GFNISSE-NEXT:    cvttps2dq %xmm9, %xmm9
; GFNISSE-NEXT:    packusdw %xmm9, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; GFNISSE-NEXT:    pmullw %xmm2, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm10, %xmm0
; GFNISSE-NEXT:    pand %xmm8, %xmm5
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm7[8],xmm5[9],xmm7[9],xmm5[10],xmm7[10],xmm5[11],xmm7[11],xmm5[12],xmm7[12],xmm5[13],xmm7[13],xmm5[14],xmm7[14],xmm5[15],xmm7[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm7 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm5
; GFNISSE-NEXT:    paddd %xmm4, %xmm5
; GFNISSE-NEXT:    cvttps2dq %xmm5, %xmm5
; GFNISSE-NEXT:    pslld $23, %xmm7
; GFNISSE-NEXT:    paddd %xmm4, %xmm7
; GFNISSE-NEXT:    cvttps2dq %xmm7, %xmm7
; GFNISSE-NEXT:    packusdw %xmm5, %xmm7
; GFNISSE-NEXT:    movdqa %xmm3, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm1[8],xmm5[9],xmm1[9],xmm5[10],xmm1[10],xmm5[11],xmm1[11],xmm5[12],xmm1[12],xmm5[13],xmm1[13],xmm5[14],xmm1[14],xmm5[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    pslld $23, %xmm2
; GFNISSE-NEXT:    paddd %xmm4, %xmm2
; GFNISSE-NEXT:    cvttps2dq %xmm2, %xmm2
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm6
; GFNISSE-NEXT:    paddd %xmm4, %xmm6
; GFNISSE-NEXT:    cvttps2dq %xmm6, %xmm4
; GFNISSE-NEXT:    packusdw %xmm4, %xmm2
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_fshl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; GFNIAVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm4[8],xmm5[8],xmm4[9],xmm5[9],xmm4[10],xmm5[10],xmm4[11],xmm5[11],xmm4[12],xmm5[12],xmm4[13],xmm5[13],xmm4[14],xmm5[14],xmm4[15],xmm5[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm6[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm3, %xmm7
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1065353216,1065353216,1065353216,1065353216]
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vcvttps2dq %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vcvttps2dq %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpackusdw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm8
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm9 = xmm8[8],xmm7[8],xmm8[9],xmm7[9],xmm8[10],xmm7[10],xmm8[11],xmm7[11],xmm8[12],xmm7[12],xmm8[13],xmm7[13],xmm8[14],xmm7[14],xmm8[15],xmm7[15]
; GFNIAVX1-NEXT:    vpmullw %xmm6, %xmm9, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm9 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vcvttps2dq %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm4[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpackusdw %xmm4, %xmm9, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3],xmm8[4],xmm7[4],xmm8[5],xmm7[5],xmm8[6],xmm7[6],xmm8[7],xmm7[7]
; GFNIAVX1-NEXT:    vpmullw %xmm4, %xmm7, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm2[8],xmm5[8],xmm2[9],xmm5[9],xmm2[10],xmm5[10],xmm2[11],xmm5[11],xmm2[12],xmm5[12],xmm2[13],xmm5[13],xmm2[14],xmm5[14],xmm2[15],xmm5[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm5[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vcvttps2dq %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vcvttps2dq %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpackusdw %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm6, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm6 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vcvttps2dq %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackusdw %xmm2, %xmm6, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_fshl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm4[4],ymm3[4],ymm4[5],ymm3[5],ymm4[6],ymm3[6],ymm4[7],ymm3[7],ymm4[12],ymm3[12],ymm4[13],ymm3[13],ymm4[14],ymm3[14],ymm4[15],ymm3[15]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm6 = ymm2[8],ymm4[8],ymm2[9],ymm4[9],ymm2[10],ymm4[10],ymm2[11],ymm4[11],ymm2[12],ymm4[12],ymm2[13],ymm4[13],ymm2[14],ymm4[14],ymm2[15],ymm4[15],ymm2[24],ymm4[24],ymm2[25],ymm4[25],ymm2[26],ymm4[26],ymm2[27],ymm4[27],ymm2[28],ymm4[28],ymm2[29],ymm4[29],ymm2[30],ymm4[30],ymm2[31],ymm4[31]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm7 = ymm6[4],ymm4[4],ymm6[5],ymm4[5],ymm6[6],ymm4[6],ymm6[7],ymm4[7],ymm6[12],ymm4[12],ymm6[13],ymm4[13],ymm6[14],ymm4[14],ymm6[15],ymm4[15]
; GFNIAVX2-NEXT:    vpsllvd %ymm7, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpsrld $16, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm3 = ymm4[0],ymm3[0],ymm4[1],ymm3[1],ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[8],ymm3[8],ymm4[9],ymm3[9],ymm4[10],ymm3[10],ymm4[11],ymm3[11]
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm6 = ymm6[0],ymm4[0],ymm6[1],ymm4[1],ymm6[2],ymm4[2],ymm6[3],ymm4[3],ymm6[8],ymm4[8],ymm6[9],ymm4[9],ymm6[10],ymm4[10],ymm6[11],ymm4[11]
; GFNIAVX2-NEXT:    vpsllvd %ymm6, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpackusdw %ymm5, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm1 = ymm4[4],ymm0[4],ymm4[5],ymm0[5],ymm4[6],ymm0[6],ymm4[7],ymm0[7],ymm4[12],ymm0[12],ymm4[13],ymm0[13],ymm4[14],ymm0[14],ymm4[15],ymm0[15]
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[1],ymm4[1],ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[4],ymm4[4],ymm2[5],ymm4[5],ymm2[6],ymm4[6],ymm2[7],ymm4[7],ymm2[16],ymm4[16],ymm2[17],ymm4[17],ymm2[18],ymm4[18],ymm2[19],ymm4[19],ymm2[20],ymm4[20],ymm2[21],ymm4[21],ymm2[22],ymm4[22],ymm2[23],ymm4[23]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm2[4],ymm4[4],ymm2[5],ymm4[5],ymm2[6],ymm4[6],ymm2[7],ymm4[7],ymm2[12],ymm4[12],ymm2[13],ymm4[13],ymm2[14],ymm4[14],ymm2[15],ymm4[15]
; GFNIAVX2-NEXT:    vpsllvd %ymm5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm4[0],ymm0[0],ymm4[1],ymm0[1],ymm4[2],ymm0[2],ymm4[3],ymm0[3],ymm4[8],ymm0[8],ymm4[9],ymm0[9],ymm4[10],ymm0[10],ymm4[11],ymm0[11]
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[1],ymm4[1],ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[8],ymm4[8],ymm2[9],ymm4[9],ymm2[10],ymm4[10],ymm2[11],ymm4[11]
; GFNIAVX2-NEXT:    vpsllvd %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_fshl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX512VL-NEXT:    vpandn %ymm3, %ymm2, %ymm4
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm6
; GFNIAVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm5
; GFNIAVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm4, %ymm5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_fshl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm1
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %amt)
  ret <32 x i8> %res
}

define <32 x i8> @var_fshr_v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_fshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm4, %xmm6
; GFNISSE-NEXT:    movdqa %xmm0, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm9
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm9
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pand %xmm7, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm9, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm9 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm10
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm10
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm10, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm10 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    movdqa %xmm2, %xmm11
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm11
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm11, %xmm2
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm11 = [16909320,16909320]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm12
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm12
; GFNISSE-NEXT:    pandn %xmm7, %xmm6
; GFNISSE-NEXT:    psllw $5, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm12, %xmm4
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm12 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    movdqa %xmm4, %xmm13
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm13
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm13, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm13
; GFNISSE-NEXT:    paddb %xmm4, %xmm13
; GFNISSE-NEXT:    paddb %xmm6, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm13, %xmm4
; GFNISSE-NEXT:    por %xmm2, %xmm4
; GFNISSE-NEXT:    movdqa %xmm3, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pand %xmm7, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm2
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm10, %xmm2
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm3
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm2
; GFNISSE-NEXT:    pandn %xmm7, %xmm5
; GFNISSE-NEXT:    psllw $5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm12, %xmm2
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    paddb %xmm1, %xmm2
; GFNISSE-NEXT:    paddb %xmm5, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; GFNISSE-NEXT:    por %xmm3, %xmm1
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_fshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm5 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm5 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm4, %xmm6
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX1-NEXT:    vandps %ymm3, %ymm2, %ymm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm7, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm6, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm6 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX1-NEXT:    # xmm6 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm4, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm9, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm9 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    # xmm9 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm4, %xmm10
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpblendvb %xmm8, %xmm10, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm10 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm10 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm10, %xmm8, %xmm11
; GFNIAVX1-NEXT:    vpxor %xmm3, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm11, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm11 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm11 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm11, %xmm8, %xmm12
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm12, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpaddb %xmm8, %xmm8, %xmm12
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm12, %xmm8, %xmm7
; GFNIAVX1-NEXT:    vpor %xmm4, %xmm7, %xmm4
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm5, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm6, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm1, %xmm5
; GFNIAVX1-NEXT:    vpaddb %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpblendvb %xmm6, %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm10, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm11, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_fshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; GFNIAVX2-NEXT:    vpsllw $5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm6
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm4
; GFNIAVX2-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_fshr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm4
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm4, %ymm6, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpblendvb %ymm3, %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_fshr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm2, %ymm1
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %amt)
  ret <32 x i8> %res
}

define <32 x i8> @splatvar_fshl_v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_fshl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; GFNISSE-NEXT:    psllw %xmm4, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNISSE-NEXT:    psllw %xmm4, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    psllw %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNISSE-NEXT:    psllw %xmm4, %xmm3
; GFNISSE-NEXT:    psrlw $8, %xmm3
; GFNISSE-NEXT:    packuswb %xmm0, %xmm3
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_fshl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpsllw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_fshl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX2-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatvar_fshl_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; GFNIAVX512-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512-NEXT:    retq
  %splat = shufflevector <32 x i8> %amt, <32 x i8> undef, <32 x i32> zeroinitializer
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %splat)
  ret <32 x i8> %res
}

define <32 x i8> @splatvar_fshr_v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_fshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm6
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4
; GFNISSE-NEXT:    psrlw %xmm4, %xmm6
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm5, %xmm6
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm2
; GFNISSE-NEXT:    pand %xmm5, %xmm2
; GFNISSE-NEXT:    packuswb %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm0
; GFNISSE-NEXT:    pand %xmm5, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNISSE-NEXT:    psrlw %xmm4, %xmm3
; GFNISSE-NEXT:    pand %xmm3, %xmm5
; GFNISSE-NEXT:    packuswb %xmm0, %xmm5
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_fshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm4[8],xmm3[8],xmm4[9],xmm3[9],xmm4[10],xmm3[10],xmm4[11],xmm3[11],xmm4[12],xmm3[12],xmm4[13],xmm3[13],xmm4[14],xmm3[14],xmm4[15],xmm3[15]
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3],xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_fshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX2-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_fshr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpand %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_fshr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpand %ymm4, %ymm3, %ymm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512BW-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpand %ymm4, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <32 x i8> %amt, <32 x i8> undef, <32 x i32> zeroinitializer
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %splat)
  ret <32 x i8> %res
}

define <32 x i8> @constant_fshl_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: constant_fshl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm6 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm6, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm6, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm0, %xmm4
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm4, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_fshl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_fshl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_fshl_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_fshl_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <32 x i8> %res
}

define <32 x i8> @constant_fshr_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: constant_fshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm2, %xmm5
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm6 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm6, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm4 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm2
; GFNISSE-NEXT:    psrlw $8, %xmm2
; GFNISSE-NEXT:    packuswb %xmm5, %xmm2
; GFNISSE-NEXT:    movdqa %xmm3, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm6, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNISSE-NEXT:    pmullw %xmm3, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm0, %xmm4
; GFNISSE-NEXT:    movdqa %xmm2, %xmm0
; GFNISSE-NEXT:    movdqa %xmm4, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_fshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm3 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm3, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_fshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX2-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_fshr_v32i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2 # [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpmullw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0 # [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_fshr_v32i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; GFNIAVX512BW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; GFNIAVX512BW-NEXT:    vpsllw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <32 x i8> %res
}

define <32 x i8> @splatconstant_fshl_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: splatconstant_fshl_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm5 = [16909320,16909320]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm0
; GFNISSE-NEXT:    por %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm1
; GFNISSE-NEXT:    por %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_fshl_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_fshl_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_fshl_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpsllw $4, %ymm0, %ymm2
; GFNIAVX512-NEXT:    vpsrlw $4, %ymm1, %ymm0
; GFNIAVX512-NEXT:    vpternlogd {{.*#+}} ymm0 = ymm0 ^ (m32bcst & (ymm0 ^ ymm2))
; GFNIAVX512-NEXT:    retq
  %res = call <32 x i8> @llvm.fshl.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.fshl.v32i8(<32 x i8>, <32 x i8>, <32 x i8>)

define <32 x i8> @splatconstant_fshr_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; GFNISSE-LABEL: splatconstant_fshr_v32i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,0,0,0,0,0,128,64,0,0,0,0,0,0,128,64]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm2
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm5 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm0
; GFNISSE-NEXT:    por %xmm2, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm4, %xmm3
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm5, %xmm1
; GFNISSE-NEXT:    por %xmm3, %xmm1
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_fshr_v32i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_fshr_v32i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512-LABEL: splatconstant_fshr_v32i8:
; GFNIAVX512:       # %bb.0:
; GFNIAVX512-NEXT:    vpsllw $2, %ymm0, %ymm2
; GFNIAVX512-NEXT:    vpsrlw $6, %ymm1, %ymm0
; GFNIAVX512-NEXT:    vpternlogd {{.*#+}} ymm0 = ymm0 ^ (m32bcst & (ymm0 ^ ymm2))
; GFNIAVX512-NEXT:    retq
  %res = call <32 x i8> @llvm.fshr.v32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>)
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.fshr.v32i8(<32 x i8>, <32 x i8>, <32 x i8>)

;
; 512 Bit Vector Funnel Shifts
;

define <64 x i8> @var_fshl_v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_fshl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm9 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; GFNISSE-NEXT:    pand %xmm9, %xmm0
; GFNISSE-NEXT:    pxor %xmm10, %xmm10
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm12 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm13 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm10[8],xmm0[9],xmm10[9],xmm0[10],xmm10[10],xmm0[11],xmm10[11],xmm0[12],xmm10[12],xmm0[13],xmm10[13],xmm0[14],xmm10[14],xmm0[15],xmm10[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm14 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm0
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm11 = [1065353216,1065353216,1065353216,1065353216]
; GFNISSE-NEXT:    paddd %xmm11, %xmm0
; GFNISSE-NEXT:    cvttps2dq %xmm0, %xmm0
; GFNISSE-NEXT:    pslld $23, %xmm14
; GFNISSE-NEXT:    paddd %xmm11, %xmm14
; GFNISSE-NEXT:    cvttps2dq %xmm14, %xmm14
; GFNISSE-NEXT:    packusdw %xmm0, %xmm14
; GFNISSE-NEXT:    movdqa %xmm4, %xmm15
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm1[8],xmm15[9],xmm1[9],xmm15[10],xmm1[10],xmm15[11],xmm1[11],xmm15[12],xmm1[12],xmm15[13],xmm1[13],xmm15[14],xmm1[14],xmm15[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm14, %xmm15
; GFNISSE-NEXT:    psrlw $8, %xmm15
; GFNISSE-NEXT:    pslld $23, %xmm12
; GFNISSE-NEXT:    paddd %xmm11, %xmm12
; GFNISSE-NEXT:    cvttps2dq %xmm12, %xmm0
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm13 = xmm13[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm13
; GFNISSE-NEXT:    paddd %xmm11, %xmm13
; GFNISSE-NEXT:    cvttps2dq %xmm13, %xmm12
; GFNISSE-NEXT:    packusdw %xmm12, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1],xmm4[2],xmm1[2],xmm4[3],xmm1[3],xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; GFNISSE-NEXT:    pmullw %xmm4, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    packuswb %xmm15, %xmm0
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; GFNISSE-NEXT:    pand %xmm9, %xmm1
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm4 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm12 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm10[8],xmm1[9],xmm10[9],xmm1[10],xmm10[10],xmm1[11],xmm10[11],xmm1[12],xmm10[12],xmm1[13],xmm10[13],xmm1[14],xmm10[14],xmm1[15],xmm10[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm13 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm1
; GFNISSE-NEXT:    paddd %xmm11, %xmm1
; GFNISSE-NEXT:    cvttps2dq %xmm1, %xmm1
; GFNISSE-NEXT:    pslld $23, %xmm13
; GFNISSE-NEXT:    paddd %xmm11, %xmm13
; GFNISSE-NEXT:    cvttps2dq %xmm13, %xmm13
; GFNISSE-NEXT:    packusdw %xmm1, %xmm13
; GFNISSE-NEXT:    movdqa %xmm5, %xmm14
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm14 = xmm14[8],xmm8[8],xmm14[9],xmm8[9],xmm14[10],xmm8[10],xmm14[11],xmm8[11],xmm14[12],xmm8[12],xmm14[13],xmm8[13],xmm14[14],xmm8[14],xmm14[15],xmm8[15]
; GFNISSE-NEXT:    pmullw %xmm13, %xmm14
; GFNISSE-NEXT:    psrlw $8, %xmm14
; GFNISSE-NEXT:    pslld $23, %xmm4
; GFNISSE-NEXT:    paddd %xmm11, %xmm4
; GFNISSE-NEXT:    cvttps2dq %xmm4, %xmm1
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm12 = xmm12[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm12
; GFNISSE-NEXT:    paddd %xmm11, %xmm12
; GFNISSE-NEXT:    cvttps2dq %xmm12, %xmm4
; GFNISSE-NEXT:    packusdw %xmm4, %xmm1
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3],xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm1
; GFNISSE-NEXT:    psrlw $8, %xmm1
; GFNISSE-NEXT:    packuswb %xmm14, %xmm1
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4
; GFNISSE-NEXT:    pand %xmm9, %xmm4
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm8 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm10[8],xmm4[9],xmm10[9],xmm4[10],xmm10[10],xmm4[11],xmm10[11],xmm4[12],xmm10[12],xmm4[13],xmm10[13],xmm4[14],xmm10[14],xmm4[15],xmm10[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm12 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm4
; GFNISSE-NEXT:    paddd %xmm11, %xmm4
; GFNISSE-NEXT:    cvttps2dq %xmm4, %xmm4
; GFNISSE-NEXT:    pslld $23, %xmm12
; GFNISSE-NEXT:    paddd %xmm11, %xmm12
; GFNISSE-NEXT:    cvttps2dq %xmm12, %xmm12
; GFNISSE-NEXT:    packusdw %xmm4, %xmm12
; GFNISSE-NEXT:    movdqa %xmm6, %xmm13
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm2[8],xmm13[9],xmm2[9],xmm13[10],xmm2[10],xmm13[11],xmm2[11],xmm13[12],xmm2[12],xmm13[13],xmm2[13],xmm13[14],xmm2[14],xmm13[15],xmm2[15]
; GFNISSE-NEXT:    pmullw %xmm12, %xmm13
; GFNISSE-NEXT:    psrlw $8, %xmm13
; GFNISSE-NEXT:    pslld $23, %xmm5
; GFNISSE-NEXT:    paddd %xmm11, %xmm5
; GFNISSE-NEXT:    cvttps2dq %xmm5, %xmm4
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm8
; GFNISSE-NEXT:    paddd %xmm11, %xmm8
; GFNISSE-NEXT:    cvttps2dq %xmm8, %xmm5
; GFNISSE-NEXT:    packusdw %xmm5, %xmm4
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; GFNISSE-NEXT:    pmullw %xmm6, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm13, %xmm4
; GFNISSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm9
; GFNISSE-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm6 = xmm9[0],zero,xmm9[1],zero,xmm9[2],zero,xmm9[3],zero,xmm9[4],zero,xmm9[5],zero,xmm9[6],zero,xmm9[7],zero
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm10[8],xmm9[9],xmm10[9],xmm9[10],xmm10[10],xmm9[11],xmm10[11],xmm9[12],xmm10[12],xmm9[13],xmm10[13],xmm9[14],xmm10[14],xmm9[15],xmm10[15]
; GFNISSE-NEXT:    pmovzxwd {{.*#+}} xmm5 = xmm9[0],zero,xmm9[1],zero,xmm9[2],zero,xmm9[3],zero
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm9
; GFNISSE-NEXT:    paddd %xmm11, %xmm9
; GFNISSE-NEXT:    cvttps2dq %xmm9, %xmm8
; GFNISSE-NEXT:    pslld $23, %xmm5
; GFNISSE-NEXT:    paddd %xmm11, %xmm5
; GFNISSE-NEXT:    cvttps2dq %xmm5, %xmm5
; GFNISSE-NEXT:    packusdw %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa %xmm7, %xmm8
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm3[8],xmm8[9],xmm3[9],xmm8[10],xmm3[10],xmm8[11],xmm3[11],xmm8[12],xmm3[12],xmm8[13],xmm3[13],xmm8[14],xmm3[14],xmm8[15],xmm3[15]
; GFNISSE-NEXT:    pmullw %xmm5, %xmm8
; GFNISSE-NEXT:    psrlw $8, %xmm8
; GFNISSE-NEXT:    pslld $23, %xmm2
; GFNISSE-NEXT:    paddd %xmm11, %xmm2
; GFNISSE-NEXT:    cvttps2dq %xmm2, %xmm5
; GFNISSE-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4,4,5,5,6,6,7,7]
; GFNISSE-NEXT:    pslld $23, %xmm6
; GFNISSE-NEXT:    paddd %xmm11, %xmm6
; GFNISSE-NEXT:    cvttps2dq %xmm6, %xmm2
; GFNISSE-NEXT:    packusdw %xmm2, %xmm5
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    packuswb %xmm8, %xmm5
; GFNISSE-NEXT:    movdqa %xmm4, %xmm2
; GFNISSE-NEXT:    movdqa %xmm5, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_fshl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} ymm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX1-NEXT:    vandps %ymm7, %ymm4, %ymm8
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm8, %xmm9
; GFNIAVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm9[8],xmm6[8],xmm9[9],xmm6[9],xmm9[10],xmm6[10],xmm9[11],xmm6[11],xmm9[12],xmm6[12],xmm9[13],xmm6[13],xmm9[14],xmm6[14],xmm9[15],xmm6[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm4 = xmm10[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm4, %xmm11
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [1065353216,1065353216,1065353216,1065353216]
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vcvttps2dq %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm10 = xmm10[0],zero,xmm10[1],zero,xmm10[2],zero,xmm10[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vcvttps2dq %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpackusdw %xmm11, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm11
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm12
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm13 = xmm12[8],xmm11[8],xmm12[9],xmm11[9],xmm12[10],xmm11[10],xmm12[11],xmm11[11],xmm12[12],xmm11[12],xmm12[13],xmm11[13],xmm12[14],xmm11[14],xmm12[15],xmm11[15]
; GFNIAVX1-NEXT:    vpmullw %xmm10, %xmm13, %xmm10
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm13 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vcvttps2dq %xmm13, %xmm13
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm9 = xmm9[0],zero,xmm9[1],zero,xmm9[2],zero,xmm9[3],zero,xmm9[4],zero,xmm9[5],zero,xmm9[6],zero,xmm9[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vcvttps2dq %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpackusdw %xmm9, %xmm13, %xmm9
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm11 = xmm12[0],xmm11[0],xmm12[1],xmm11[1],xmm12[2],xmm11[2],xmm12[3],xmm11[3],xmm12[4],xmm11[4],xmm12[5],xmm11[5],xmm12[6],xmm11[6],xmm12[7],xmm11[7]
; GFNIAVX1-NEXT:    vpmullw %xmm9, %xmm11, %xmm9
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpackuswb %xmm10, %xmm9, %xmm9
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm8[8],xmm6[8],xmm8[9],xmm6[9],xmm8[10],xmm6[10],xmm8[11],xmm6[11],xmm8[12],xmm6[12],xmm8[13],xmm6[13],xmm8[14],xmm6[14],xmm8[15],xmm6[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm11 = xmm10[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vcvttps2dq %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm10 = xmm10[0],zero,xmm10[1],zero,xmm10[2],zero,xmm10[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vcvttps2dq %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpackusdw %xmm11, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm11 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm10, %xmm11, %xmm10
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm11 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vcvttps2dq %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm8 = xmm8[0],zero,xmm8[1],zero,xmm8[2],zero,xmm8[3],zero,xmm8[4],zero,xmm8[5],zero,xmm8[6],zero,xmm8[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vcvttps2dq %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpackusdw %xmm8, %xmm11, %xmm8
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm0, %xmm8, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm10, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vandps %ymm7, %ymm5, %ymm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm8 = xmm7[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vcvttps2dq %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm7 = xmm7[0],zero,xmm7[1],zero,xmm7[2],zero,xmm7[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vcvttps2dq %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpackusdw %xmm8, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm8
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm9
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm10 = xmm9[8],xmm8[8],xmm9[9],xmm8[9],xmm9[10],xmm8[10],xmm9[11],xmm8[11],xmm9[12],xmm8[12],xmm9[13],xmm8[13],xmm9[14],xmm8[14],xmm9[15],xmm8[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm10, %xmm7
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm10 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vcvttps2dq %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vcvttps2dq %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpackusdw %xmm5, %xmm10, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm8, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpackuswb %xmm7, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm7 = xmm6[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vcvttps2dq %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpmovzxwd {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vcvttps2dq %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpackusdw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNIAVX1-NEXT:    vpmullw %xmm6, %xmm7, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpmovzxbd {{.*#+}} xmm7 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; GFNIAVX1-NEXT:    vpslld $23, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vcvttps2dq %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; GFNIAVX1-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4,4,5,5,6,6,7,7]
; GFNIAVX1-NEXT:    vpslld $23, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddd %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vcvttps2dq %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackusdw %xmm2, %xmm7, %xmm2
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNIAVX1-NEXT:    vpmullw %xmm2, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_fshl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm7 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; GFNIAVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm8 = ymm6[4],ymm7[4],ymm6[5],ymm7[5],ymm6[6],ymm7[6],ymm6[7],ymm7[7],ymm6[12],ymm7[12],ymm6[13],ymm7[13],ymm6[14],ymm7[14],ymm6[15],ymm7[15]
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm9 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX2-NEXT:    vpand %ymm4, %ymm9, %ymm4
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm10 = ymm4[8],ymm6[8],ymm4[9],ymm6[9],ymm4[10],ymm6[10],ymm4[11],ymm6[11],ymm4[12],ymm6[12],ymm4[13],ymm6[13],ymm4[14],ymm6[14],ymm4[15],ymm6[15],ymm4[24],ymm6[24],ymm4[25],ymm6[25],ymm4[26],ymm6[26],ymm4[27],ymm6[27],ymm4[28],ymm6[28],ymm4[29],ymm6[29],ymm4[30],ymm6[30],ymm4[31],ymm6[31]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm11 = ymm10[4],ymm6[4],ymm10[5],ymm6[5],ymm10[6],ymm6[6],ymm10[7],ymm6[7],ymm10[12],ymm6[12],ymm10[13],ymm6[13],ymm10[14],ymm6[14],ymm10[15],ymm6[15]
; GFNIAVX2-NEXT:    vpsllvd %ymm11, %ymm8, %ymm8
; GFNIAVX2-NEXT:    vpsrld $16, %ymm8, %ymm8
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm7 = ymm6[0],ymm7[0],ymm6[1],ymm7[1],ymm6[2],ymm7[2],ymm6[3],ymm7[3],ymm6[8],ymm7[8],ymm6[9],ymm7[9],ymm6[10],ymm7[10],ymm6[11],ymm7[11]
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm10 = ymm10[0],ymm6[0],ymm10[1],ymm6[1],ymm10[2],ymm6[2],ymm10[3],ymm6[3],ymm10[8],ymm6[8],ymm10[9],ymm6[9],ymm10[10],ymm6[10],ymm10[11],ymm6[11]
; GFNIAVX2-NEXT:    vpsllvd %ymm10, %ymm7, %ymm7
; GFNIAVX2-NEXT:    vpsrld $16, %ymm7, %ymm7
; GFNIAVX2-NEXT:    vpackusdw %ymm8, %ymm7, %ymm7
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm7, %ymm7
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm2 = ymm6[4],ymm0[4],ymm6[5],ymm0[5],ymm6[6],ymm0[6],ymm6[7],ymm0[7],ymm6[12],ymm0[12],ymm6[13],ymm0[13],ymm6[14],ymm0[14],ymm6[15],ymm0[15]
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm4 = ymm4[0],ymm6[0],ymm4[1],ymm6[1],ymm4[2],ymm6[2],ymm4[3],ymm6[3],ymm4[4],ymm6[4],ymm4[5],ymm6[5],ymm4[6],ymm6[6],ymm4[7],ymm6[7],ymm4[16],ymm6[16],ymm4[17],ymm6[17],ymm4[18],ymm6[18],ymm4[19],ymm6[19],ymm4[20],ymm6[20],ymm4[21],ymm6[21],ymm4[22],ymm6[22],ymm4[23],ymm6[23]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm8 = ymm4[4],ymm6[4],ymm4[5],ymm6[5],ymm4[6],ymm6[6],ymm4[7],ymm6[7],ymm4[12],ymm6[12],ymm4[13],ymm6[13],ymm4[14],ymm6[14],ymm4[15],ymm6[15]
; GFNIAVX2-NEXT:    vpsllvd %ymm8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrld $16, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm6[0],ymm0[0],ymm6[1],ymm0[1],ymm6[2],ymm0[2],ymm6[3],ymm0[3],ymm6[8],ymm0[8],ymm6[9],ymm0[9],ymm6[10],ymm0[10],ymm6[11],ymm0[11]
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm4 = ymm4[0],ymm6[0],ymm4[1],ymm6[1],ymm4[2],ymm6[2],ymm4[3],ymm6[3],ymm4[8],ymm6[8],ymm4[9],ymm6[9],ymm4[10],ymm6[10],ymm4[11],ymm6[11]
; GFNIAVX2-NEXT:    vpsllvd %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrld $16, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackusdw %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm7, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm3[8],ymm1[8],ymm3[9],ymm1[9],ymm3[10],ymm1[10],ymm3[11],ymm1[11],ymm3[12],ymm1[12],ymm3[13],ymm1[13],ymm3[14],ymm1[14],ymm3[15],ymm1[15],ymm3[24],ymm1[24],ymm3[25],ymm1[25],ymm3[26],ymm1[26],ymm3[27],ymm1[27],ymm3[28],ymm1[28],ymm3[29],ymm1[29],ymm3[30],ymm1[30],ymm3[31],ymm1[31]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm6[4],ymm2[4],ymm6[5],ymm2[5],ymm6[6],ymm2[6],ymm6[7],ymm2[7],ymm6[12],ymm2[12],ymm6[13],ymm2[13],ymm6[14],ymm2[14],ymm6[15],ymm2[15]
; GFNIAVX2-NEXT:    vpand %ymm5, %ymm9, %ymm5
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm7 = ymm5[8],ymm6[8],ymm5[9],ymm6[9],ymm5[10],ymm6[10],ymm5[11],ymm6[11],ymm5[12],ymm6[12],ymm5[13],ymm6[13],ymm5[14],ymm6[14],ymm5[15],ymm6[15],ymm5[24],ymm6[24],ymm5[25],ymm6[25],ymm5[26],ymm6[26],ymm5[27],ymm6[27],ymm5[28],ymm6[28],ymm5[29],ymm6[29],ymm5[30],ymm6[30],ymm5[31],ymm6[31]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm8 = ymm7[4],ymm6[4],ymm7[5],ymm6[5],ymm7[6],ymm6[6],ymm7[7],ymm6[7],ymm7[12],ymm6[12],ymm7[13],ymm6[13],ymm7[14],ymm6[14],ymm7[15],ymm6[15]
; GFNIAVX2-NEXT:    vpsllvd %ymm8, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsrld $16, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm6[0],ymm2[0],ymm6[1],ymm2[1],ymm6[2],ymm2[2],ymm6[3],ymm2[3],ymm6[8],ymm2[8],ymm6[9],ymm2[9],ymm6[10],ymm2[10],ymm6[11],ymm2[11]
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm7 = ymm7[0],ymm6[0],ymm7[1],ymm6[1],ymm7[2],ymm6[2],ymm7[3],ymm6[3],ymm7[8],ymm6[8],ymm7[9],ymm6[9],ymm7[10],ymm6[10],ymm7[11],ymm6[11]
; GFNIAVX2-NEXT:    vpsllvd %ymm7, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrld $16, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpackusdw %ymm4, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm3[0],ymm1[0],ymm3[1],ymm1[1],ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[4],ymm1[4],ymm3[5],ymm1[5],ymm3[6],ymm1[6],ymm3[7],ymm1[7],ymm3[16],ymm1[16],ymm3[17],ymm1[17],ymm3[18],ymm1[18],ymm3[19],ymm1[19],ymm3[20],ymm1[20],ymm3[21],ymm1[21],ymm3[22],ymm1[22],ymm3[23],ymm1[23]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm3 = ymm6[4],ymm1[4],ymm6[5],ymm1[5],ymm6[6],ymm1[6],ymm6[7],ymm1[7],ymm6[12],ymm1[12],ymm6[13],ymm1[13],ymm6[14],ymm1[14],ymm6[15],ymm1[15]
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm4 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[4],ymm6[4],ymm5[5],ymm6[5],ymm5[6],ymm6[6],ymm5[7],ymm6[7],ymm5[16],ymm6[16],ymm5[17],ymm6[17],ymm5[18],ymm6[18],ymm5[19],ymm6[19],ymm5[20],ymm6[20],ymm5[21],ymm6[21],ymm5[22],ymm6[22],ymm5[23],ymm6[23]
; GFNIAVX2-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm4[4],ymm6[4],ymm4[5],ymm6[5],ymm4[6],ymm6[6],ymm4[7],ymm6[7],ymm4[12],ymm6[12],ymm4[13],ymm6[13],ymm4[14],ymm6[14],ymm4[15],ymm6[15]
; GFNIAVX2-NEXT:    vpsllvd %ymm5, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpsrld $16, %ymm3, %ymm3
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm6[0],ymm1[0],ymm6[1],ymm1[1],ymm6[2],ymm1[2],ymm6[3],ymm1[3],ymm6[8],ymm1[8],ymm6[9],ymm1[9],ymm6[10],ymm1[10],ymm6[11],ymm1[11]
; GFNIAVX2-NEXT:    vpunpcklwd {{.*#+}} ymm4 = ymm4[0],ymm6[0],ymm4[1],ymm6[1],ymm4[2],ymm6[2],ymm4[3],ymm6[3],ymm4[8],ymm6[8],ymm4[9],ymm6[9],ymm4[10],ymm6[10],ymm4[11],ymm6[11]
; GFNIAVX2-NEXT:    vpsllvd %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrld $16, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackusdw %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_fshl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm3, %ymm6
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} zmm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX512VL-NEXT:    vpandq %zmm7, %zmm2, %zmm2
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm8
; GFNIAVX512VL-NEXT:    vpxor %ymm7, %ymm8, %ymm9
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm9, %ymm9
; GFNIAVX512VL-NEXT:    vpblendvb %ymm9, %ymm6, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm3, %ymm10
; GFNIAVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; GFNIAVX512VL-NEXT:    vpblendvb %ymm9, %ymm10, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm10
; GFNIAVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; GFNIAVX512VL-NEXT:    vpblendvb %ymm9, %ymm10, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm5
; GFNIAVX512VL-NEXT:    vpxor %ymm7, %ymm2, %ymm7
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm7, %ymm7
; GFNIAVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm6, %ymm1, %ymm5
; GFNIAVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm5
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm8, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm3, %ymm7
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm7, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm7
; GFNIAVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; GFNIAVX512VL-NEXT:    vpblendvb %ymm6, %ymm7, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_fshl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm0[8],zmm1[9],zmm0[9],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[12],zmm0[12],zmm1[13],zmm0[13],zmm1[14],zmm0[14],zmm1[15],zmm0[15],zmm1[24],zmm0[24],zmm1[25],zmm0[25],zmm1[26],zmm0[26],zmm1[27],zmm0[27],zmm1[28],zmm0[28],zmm1[29],zmm0[29],zmm1[30],zmm0[30],zmm1[31],zmm0[31],zmm1[40],zmm0[40],zmm1[41],zmm0[41],zmm1[42],zmm0[42],zmm1[43],zmm0[43],zmm1[44],zmm0[44],zmm1[45],zmm0[45],zmm1[46],zmm0[46],zmm1[47],zmm0[47],zmm1[56],zmm0[56],zmm1[57],zmm0[57],zmm1[58],zmm0[58],zmm1[59],zmm0[59],zmm1[60],zmm0[60],zmm1[61],zmm0[61],zmm1[62],zmm0[62],zmm1[63],zmm0[63]
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm5 = zmm2[8],zmm4[8],zmm2[9],zmm4[9],zmm2[10],zmm4[10],zmm2[11],zmm4[11],zmm2[12],zmm4[12],zmm2[13],zmm4[13],zmm2[14],zmm4[14],zmm2[15],zmm4[15],zmm2[24],zmm4[24],zmm2[25],zmm4[25],zmm2[26],zmm4[26],zmm2[27],zmm4[27],zmm2[28],zmm4[28],zmm2[29],zmm4[29],zmm2[30],zmm4[30],zmm2[31],zmm4[31],zmm2[40],zmm4[40],zmm2[41],zmm4[41],zmm2[42],zmm4[42],zmm2[43],zmm4[43],zmm2[44],zmm4[44],zmm2[45],zmm4[45],zmm2[46],zmm4[46],zmm2[47],zmm4[47],zmm2[56],zmm4[56],zmm2[57],zmm4[57],zmm2[58],zmm4[58],zmm2[59],zmm4[59],zmm2[60],zmm4[60],zmm2[61],zmm4[61],zmm2[62],zmm4[62],zmm2[63],zmm4[63]
; GFNIAVX512BW-NEXT:    vpsllvw %zmm5, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm1[0],zmm0[0],zmm1[1],zmm0[1],zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[4],zmm0[4],zmm1[5],zmm0[5],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[16],zmm0[16],zmm1[17],zmm0[17],zmm1[18],zmm0[18],zmm1[19],zmm0[19],zmm1[20],zmm0[20],zmm1[21],zmm0[21],zmm1[22],zmm0[22],zmm1[23],zmm0[23],zmm1[32],zmm0[32],zmm1[33],zmm0[33],zmm1[34],zmm0[34],zmm1[35],zmm0[35],zmm1[36],zmm0[36],zmm1[37],zmm0[37],zmm1[38],zmm0[38],zmm1[39],zmm0[39],zmm1[48],zmm0[48],zmm1[49],zmm0[49],zmm1[50],zmm0[50],zmm1[51],zmm0[51],zmm1[52],zmm0[52],zmm1[53],zmm0[53],zmm1[54],zmm0[54],zmm1[55],zmm0[55]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm2[0],zmm4[0],zmm2[1],zmm4[1],zmm2[2],zmm4[2],zmm2[3],zmm4[3],zmm2[4],zmm4[4],zmm2[5],zmm4[5],zmm2[6],zmm4[6],zmm2[7],zmm4[7],zmm2[16],zmm4[16],zmm2[17],zmm4[17],zmm2[18],zmm4[18],zmm2[19],zmm4[19],zmm2[20],zmm4[20],zmm2[21],zmm4[21],zmm2[22],zmm4[22],zmm2[23],zmm4[23],zmm2[32],zmm4[32],zmm2[33],zmm4[33],zmm2[34],zmm4[34],zmm2[35],zmm4[35],zmm2[36],zmm4[36],zmm2[37],zmm4[37],zmm2[38],zmm4[38],zmm2[39],zmm4[39],zmm2[48],zmm4[48],zmm2[49],zmm4[49],zmm2[50],zmm4[50],zmm2[51],zmm4[51],zmm2[52],zmm4[52],zmm2[53],zmm4[53],zmm2[54],zmm4[54],zmm2[55],zmm4[55]
; GFNIAVX512BW-NEXT:    vpsllvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %amt)
  ret <64 x i8> %res
}

define <64 x i8> @var_fshr_v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: var_fshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm7, %xmm10
; GFNISSE-NEXT:    movdqa %xmm6, %xmm7
; GFNISSE-NEXT:    movdqa %xmm5, %xmm6
; GFNISSE-NEXT:    movdqa %xmm4, %xmm5
; GFNISSE-NEXT:    movdqa %xmm3, %xmm4
; GFNISSE-NEXT:    movdqa %xmm2, %xmm3
; GFNISSE-NEXT:    movdqa %xmm1, %xmm2
; GFNISSE-NEXT:    movdqa %xmm0, %xmm1
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; GFNISSE-NEXT:    movdqa %xmm5, %xmm12
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm12
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm11 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm11, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm12, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm13
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm13
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm13, %xmm5
; GFNISSE-NEXT:    movdqa %xmm5, %xmm14
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm14
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm14, %xmm5
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm15
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm15
; GFNISSE-NEXT:    movdqa %xmm11, %xmm12
; GFNISSE-NEXT:    pandn %xmm11, %xmm9
; GFNISSE-NEXT:    psllw $5, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm15, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa %xmm1, %xmm8
; GFNISSE-NEXT:    paddb %xmm1, %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm1
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; GFNISSE-NEXT:    movdqa %xmm6, %xmm8
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm11 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm8
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm12, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm8
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm13 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm8
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm6
; GFNISSE-NEXT:    movdqa %xmm6, %xmm8
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm14 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm14, %xmm8
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm6
; GFNISSE-NEXT:    paddb %xmm2, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm8
; GFNISSE-NEXT:    pmovsxdq {{.*#+}} xmm15 = [16909320,16909320]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm15, %xmm8
; GFNISSE-NEXT:    pandn %xmm12, %xmm9
; GFNISSE-NEXT:    psllw $5, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm8
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm0 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm0, %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa %xmm2, %xmm8
; GFNISSE-NEXT:    paddb %xmm2, %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm2
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; GFNISSE-NEXT:    movdqa %xmm7, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm8
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm12, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm8
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm7
; GFNISSE-NEXT:    movdqa %xmm7, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm14, %xmm8
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm7
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm15, %xmm8
; GFNISSE-NEXT:    pandn %xmm12, %xmm9
; GFNISSE-NEXT:    psllw $5, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm3
; GFNISSE-NEXT:    movdqa %xmm3, %xmm8
; GFNISSE-NEXT:    paddb %xmm3, %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm3
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; GFNISSE-NEXT:    movdqa %xmm10, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm11, %xmm8
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm12, %xmm0
; GFNISSE-NEXT:    psllw $5, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm10
; GFNISSE-NEXT:    movdqa %xmm10, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm13, %xmm8
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm10
; GFNISSE-NEXT:    movdqa %xmm10, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm14, %xmm8
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm10
; GFNISSE-NEXT:    paddb %xmm4, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm15, %xmm8
; GFNISSE-NEXT:    pandn %xmm12, %xmm9
; GFNISSE-NEXT:    psllw $5, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    gf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm4
; GFNISSE-NEXT:    movdqa %xmm4, %xmm8
; GFNISSE-NEXT:    paddb %xmm4, %xmm8
; GFNISSE-NEXT:    paddb %xmm9, %xmm9
; GFNISSE-NEXT:    movdqa %xmm9, %xmm0
; GFNISSE-NEXT:    pblendvb %xmm0, %xmm8, %xmm4
; GFNISSE-NEXT:    por %xmm5, %xmm1
; GFNISSE-NEXT:    por %xmm6, %xmm2
; GFNISSE-NEXT:    por %xmm7, %xmm3
; GFNISSE-NEXT:    por %xmm10, %xmm4
; GFNISSE-NEXT:    movdqa %xmm1, %xmm0
; GFNISSE-NEXT:    movdqa %xmm2, %xmm1
; GFNISSE-NEXT:    movdqa %xmm3, %xmm2
; GFNISSE-NEXT:    movdqa %xmm4, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: var_fshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm8
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm7 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX1-NEXT:    # xmm7 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm8, %xmm9
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} ymm6 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX1-NEXT:    vandps %ymm6, %ymm4, %ymm11
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm11, %xmm10
; GFNIAVX1-NEXT:    vpsllw $5, %xmm10, %xmm12
; GFNIAVX1-NEXT:    vpblendvb %xmm12, %xmm9, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX1-NEXT:    # xmm4 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm8, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm12, %xmm12, %xmm12
; GFNIAVX1-NEXT:    vpblendvb %xmm12, %xmm9, %xmm8, %xmm9
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm8 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    # xmm8 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm9, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm12, %xmm12, %xmm12
; GFNIAVX1-NEXT:    vpblendvb %xmm12, %xmm13, %xmm9, %xmm12
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm9
; GFNIAVX1-NEXT:    vpaddb %xmm9, %xmm9, %xmm13
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm9 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX1-NEXT:    # xmm9 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm13, %xmm14
; GFNIAVX1-NEXT:    vpxor %xmm6, %xmm10, %xmm10
; GFNIAVX1-NEXT:    vpsllw $5, %xmm10, %xmm15
; GFNIAVX1-NEXT:    vpblendvb %xmm15, %xmm14, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vmovddup {{.*#+}} xmm10 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX1-NEXT:    # xmm10 = mem[0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm10, %xmm13, %xmm14
; GFNIAVX1-NEXT:    vpaddb %xmm15, %xmm15, %xmm15
; GFNIAVX1-NEXT:    vpblendvb %xmm15, %xmm14, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm13, %xmm13, %xmm14
; GFNIAVX1-NEXT:    vpaddb %xmm15, %xmm15, %xmm15
; GFNIAVX1-NEXT:    vpblendvb %xmm15, %xmm14, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vpor %xmm12, %xmm13, %xmm12
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm2, %xmm13
; GFNIAVX1-NEXT:    vpsllw $5, %xmm11, %xmm14
; GFNIAVX1-NEXT:    vpblendvb %xmm14, %xmm13, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm2, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm14, %xmm14, %xmm14
; GFNIAVX1-NEXT:    vpblendvb %xmm14, %xmm13, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm2, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm14, %xmm14, %xmm14
; GFNIAVX1-NEXT:    vpblendvb %xmm14, %xmm13, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm0, %xmm13
; GFNIAVX1-NEXT:    vpxor %xmm6, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpsllw $5, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm13, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm10, %xmm0, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm11, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm13, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm11, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm13, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm11
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm11, %xmm12
; GFNIAVX1-NEXT:    vandps %ymm6, %ymm5, %ymm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; GFNIAVX1-NEXT:    vpsllw $5, %xmm5, %xmm13
; GFNIAVX1-NEXT:    vpblendvb %xmm13, %xmm12, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm11, %xmm12
; GFNIAVX1-NEXT:    vpaddb %xmm13, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vpblendvb %xmm13, %xmm12, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm11, %xmm12
; GFNIAVX1-NEXT:    vpaddb %xmm13, %xmm13, %xmm13
; GFNIAVX1-NEXT:    vpblendvb %xmm13, %xmm12, %xmm11, %xmm11
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm12
; GFNIAVX1-NEXT:    vpaddb %xmm12, %xmm12, %xmm12
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm12, %xmm13
; GFNIAVX1-NEXT:    vpxor %xmm6, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsllw $5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm13, %xmm12, %xmm12
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm10, %xmm12, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm13, %xmm12, %xmm12
; GFNIAVX1-NEXT:    vpaddb %xmm12, %xmm12, %xmm13
; GFNIAVX1-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpblendvb %xmm5, %xmm13, %xmm12, %xmm5
; GFNIAVX1-NEXT:    vpor %xmm5, %xmm11, %xmm5
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm7, %xmm3, %xmm7
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm11
; GFNIAVX1-NEXT:    vpblendvb %xmm11, %xmm7, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm4, %xmm3, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm11, %xmm11, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm8, %xmm3, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm7, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpblendvb %xmm7, %xmm4, %xmm3, %xmm3
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm9, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpxor %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsllw $5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %xmm10, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm4
; GFNIAVX1-NEXT:    vpaddb %xmm2, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpblendvb %xmm2, %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpor %xmm3, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: var_fshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm7 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm2, %ymm8
; GFNIAVX2-NEXT:    vpbroadcastb {{.*#+}} ymm6 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX2-NEXT:    vpand %ymm6, %ymm4, %ymm9
; GFNIAVX2-NEXT:    vpsllw $5, %ymm9, %ymm9
; GFNIAVX2-NEXT:    vpblendvb %ymm9, %ymm8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm8 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm2, %ymm10
; GFNIAVX2-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; GFNIAVX2-NEXT:    vpblendvb %ymm9, %ymm10, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm10 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm10, %ymm2, %ymm11
; GFNIAVX2-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; GFNIAVX2-NEXT:    vpblendvb %ymm9, %ymm11, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm9 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm9, %ymm0, %ymm11
; GFNIAVX2-NEXT:    vpandn %ymm6, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsllw $5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm11, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm11 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm11, %ymm0, %ymm12
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm12, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm12
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm12, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm7, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpand %ymm6, %ymm5, %ymm4
; GFNIAVX2-NEXT:    vpsllw $5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm8, %ymm2, %ymm3
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm10, %ymm2, %ymm3
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm3, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm9, %ymm1, %ymm3
; GFNIAVX2-NEXT:    vpandn %ymm6, %ymm5, %ymm4
; GFNIAVX2-NEXT:    vpsllw $5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm11, %ymm1, %ymm3
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm3
; GFNIAVX2-NEXT:    vpaddb %ymm4, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpblendvb %ymm4, %ymm3, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: var_fshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16,0,0,0,0,128,64,32,16]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm5
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} zmm6 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; GFNIAVX512VL-NEXT:    vpandq %zmm6, %zmm2, %zmm2
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm7
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm7, %ymm8
; GFNIAVX512VL-NEXT:    vpblendvb %ymm8, %ymm5, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm3, %ymm9
; GFNIAVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm8
; GFNIAVX512VL-NEXT:    vpblendvb %ymm8, %ymm9, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm9 = [0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2,0,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm9, %ymm3, %ymm10
; GFNIAVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm8
; GFNIAVX512VL-NEXT:    vpblendvb %ymm8, %ymm10, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm8
; GFNIAVX512VL-NEXT:    vpblendvb %ymm8, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm9, %ymm1, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0,8,4,2,1,0,0,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm5
; GFNIAVX512VL-NEXT:    vpxor %ymm6, %ymm7, %ymm7
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm7, %ymm7
; GFNIAVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0,32,16,8,4,2,1,0,0]
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm3, %ymm8
; GFNIAVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; GFNIAVX512VL-NEXT:    vpblendvb %ymm7, %ymm8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm8
; GFNIAVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; GFNIAVX512VL-NEXT:    vpblendvb %ymm7, %ymm8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpxor %ymm6, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; GFNIAVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: var_fshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm0[8],zmm1[9],zmm0[9],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[12],zmm0[12],zmm1[13],zmm0[13],zmm1[14],zmm0[14],zmm1[15],zmm0[15],zmm1[24],zmm0[24],zmm1[25],zmm0[25],zmm1[26],zmm0[26],zmm1[27],zmm0[27],zmm1[28],zmm0[28],zmm1[29],zmm0[29],zmm1[30],zmm0[30],zmm1[31],zmm0[31],zmm1[40],zmm0[40],zmm1[41],zmm0[41],zmm1[42],zmm0[42],zmm1[43],zmm0[43],zmm1[44],zmm0[44],zmm1[45],zmm0[45],zmm1[46],zmm0[46],zmm1[47],zmm0[47],zmm1[56],zmm0[56],zmm1[57],zmm0[57],zmm1[58],zmm0[58],zmm1[59],zmm0[59],zmm1[60],zmm0[60],zmm1[61],zmm0[61],zmm1[62],zmm0[62],zmm1[63],zmm0[63]
; GFNIAVX512BW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm5 = zmm2[8],zmm4[8],zmm2[9],zmm4[9],zmm2[10],zmm4[10],zmm2[11],zmm4[11],zmm2[12],zmm4[12],zmm2[13],zmm4[13],zmm2[14],zmm4[14],zmm2[15],zmm4[15],zmm2[24],zmm4[24],zmm2[25],zmm4[25],zmm2[26],zmm4[26],zmm2[27],zmm4[27],zmm2[28],zmm4[28],zmm2[29],zmm4[29],zmm2[30],zmm4[30],zmm2[31],zmm4[31],zmm2[40],zmm4[40],zmm2[41],zmm4[41],zmm2[42],zmm4[42],zmm2[43],zmm4[43],zmm2[44],zmm4[44],zmm2[45],zmm4[45],zmm2[46],zmm4[46],zmm2[47],zmm4[47],zmm2[56],zmm4[56],zmm2[57],zmm4[57],zmm2[58],zmm4[58],zmm2[59],zmm4[59],zmm2[60],zmm4[60],zmm2[61],zmm4[61],zmm2[62],zmm4[62],zmm2[63],zmm4[63]
; GFNIAVX512BW-NEXT:    vpsrlvw %zmm5, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} zmm5 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpandq %zmm5, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm1[0],zmm0[0],zmm1[1],zmm0[1],zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[4],zmm0[4],zmm1[5],zmm0[5],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[16],zmm0[16],zmm1[17],zmm0[17],zmm1[18],zmm0[18],zmm1[19],zmm0[19],zmm1[20],zmm0[20],zmm1[21],zmm0[21],zmm1[22],zmm0[22],zmm1[23],zmm0[23],zmm1[32],zmm0[32],zmm1[33],zmm0[33],zmm1[34],zmm0[34],zmm1[35],zmm0[35],zmm1[36],zmm0[36],zmm1[37],zmm0[37],zmm1[38],zmm0[38],zmm1[39],zmm0[39],zmm1[48],zmm0[48],zmm1[49],zmm0[49],zmm1[50],zmm0[50],zmm1[51],zmm0[51],zmm1[52],zmm0[52],zmm1[53],zmm0[53],zmm1[54],zmm0[54],zmm1[55],zmm0[55]
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm2[0],zmm4[0],zmm2[1],zmm4[1],zmm2[2],zmm4[2],zmm2[3],zmm4[3],zmm2[4],zmm4[4],zmm2[5],zmm4[5],zmm2[6],zmm4[6],zmm2[7],zmm4[7],zmm2[16],zmm4[16],zmm2[17],zmm4[17],zmm2[18],zmm4[18],zmm2[19],zmm4[19],zmm2[20],zmm4[20],zmm2[21],zmm4[21],zmm2[22],zmm4[22],zmm2[23],zmm4[23],zmm2[32],zmm4[32],zmm2[33],zmm4[33],zmm2[34],zmm4[34],zmm2[35],zmm4[35],zmm2[36],zmm4[36],zmm2[37],zmm4[37],zmm2[38],zmm4[38],zmm2[39],zmm4[39],zmm2[48],zmm4[48],zmm2[49],zmm4[49],zmm2[50],zmm4[50],zmm2[51],zmm4[51],zmm2[52],zmm4[52],zmm2[53],zmm4[53],zmm2[54],zmm4[54],zmm2[55],zmm4[55]
; GFNIAVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandq %zmm5, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshr.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %amt)
  ret <64 x i8> %res
}

define <64 x i8> @splatvar_fshl_v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_fshl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; GFNISSE-NEXT:    movdqa %xmm4, %xmm9
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm0[8],xmm9[9],xmm0[9],xmm9[10],xmm0[10],xmm9[11],xmm0[11],xmm9[12],xmm0[12],xmm9[13],xmm0[13],xmm9[14],xmm0[14],xmm9[15],xmm0[15]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm8
; GFNISSE-NEXT:    psllw %xmm8, %xmm9
; GFNISSE-NEXT:    psrlw $8, %xmm9
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; GFNISSE-NEXT:    psllw %xmm8, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm9, %xmm4
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    psllw %xmm8, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; GFNISSE-NEXT:    psllw %xmm8, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    packuswb %xmm0, %xmm5
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNISSE-NEXT:    psllw %xmm8, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; GFNISSE-NEXT:    psllw %xmm8, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    packuswb %xmm0, %xmm6
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm3[8],xmm0[9],xmm3[9],xmm0[10],xmm3[10],xmm0[11],xmm3[11],xmm0[12],xmm3[12],xmm0[13],xmm3[13],xmm0[14],xmm3[14],xmm0[15],xmm3[15]
; GFNISSE-NEXT:    psllw %xmm8, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; GFNISSE-NEXT:    psllw %xmm8, %xmm7
; GFNISSE-NEXT:    psrlw $8, %xmm7
; GFNISSE-NEXT:    packuswb %xmm0, %xmm7
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm7, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_fshl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm5[8],xmm6[9],xmm5[9],xmm6[10],xmm5[10],xmm6[11],xmm5[11],xmm6[12],xmm5[12],xmm6[13],xmm5[13],xmm6[14],xmm5[14],xmm6[15],xmm5[15]
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3],xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpackuswb %xmm7, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8],xmm2[8],xmm5[9],xmm2[9],xmm5[10],xmm2[10],xmm5[11],xmm2[11],xmm5[12],xmm2[12],xmm5[13],xmm2[13],xmm5[14],xmm2[14],xmm5[15],xmm2[15]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3],xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm5, %xmm5
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNIAVX1-NEXT:    vpsllw %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_fshl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4, %xmm4
; GFNIAVX2-NEXT:    vpsllw %xmm4, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; GFNIAVX2-NEXT:    vpsllw %xmm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm3[8],ymm1[8],ymm3[9],ymm1[9],ymm3[10],ymm1[10],ymm3[11],ymm1[11],ymm3[12],ymm1[12],ymm3[13],ymm1[13],ymm3[14],ymm1[14],ymm3[15],ymm1[15],ymm3[24],ymm1[24],ymm3[25],ymm1[25],ymm3[26],ymm1[26],ymm3[27],ymm1[27],ymm3[28],ymm1[28],ymm3[29],ymm1[29],ymm3[30],ymm1[30],ymm3[31],ymm1[31]
; GFNIAVX2-NEXT:    vpsllw %xmm4, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm3[0],ymm1[0],ymm3[1],ymm1[1],ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[4],ymm1[4],ymm3[5],ymm1[5],ymm3[6],ymm1[6],ymm3[7],ymm1[7],ymm3[16],ymm1[16],ymm3[17],ymm1[17],ymm3[18],ymm1[18],ymm3[19],ymm1[19],ymm3[20],ymm1[20],ymm3[21],ymm1[21],ymm3[22],ymm1[22],ymm3[23],ymm1[23]
; GFNIAVX2-NEXT:    vpsllw %xmm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_fshl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm4[8],ymm3[8],ymm4[9],ymm3[9],ymm4[10],ymm3[10],ymm4[11],ymm3[11],ymm4[12],ymm3[12],ymm4[13],ymm3[13],ymm4[14],ymm3[14],ymm4[15],ymm3[15],ymm4[24],ymm3[24],ymm4[25],ymm3[25],ymm4[26],ymm3[26],ymm4[27],ymm3[27],ymm4[28],ymm3[28],ymm4[29],ymm3[29],ymm4[30],ymm3[30],ymm4[31],ymm3[31]
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsllw %xmm2, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm4[0],ymm3[0],ymm4[1],ymm3[1],ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[4],ymm3[4],ymm4[5],ymm3[5],ymm4[6],ymm3[6],ymm4[7],ymm3[7],ymm4[16],ymm3[16],ymm4[17],ymm3[17],ymm4[18],ymm3[18],ymm4[19],ymm3[19],ymm4[20],ymm3[20],ymm4[21],ymm3[21],ymm4[22],ymm3[22],ymm4[23],ymm3[23]
; GFNIAVX512VL-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpackuswb %ymm5, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpsllw %xmm2, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_fshl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm0[8],zmm1[9],zmm0[9],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[12],zmm0[12],zmm1[13],zmm0[13],zmm1[14],zmm0[14],zmm1[15],zmm0[15],zmm1[24],zmm0[24],zmm1[25],zmm0[25],zmm1[26],zmm0[26],zmm1[27],zmm0[27],zmm1[28],zmm0[28],zmm1[29],zmm0[29],zmm1[30],zmm0[30],zmm1[31],zmm0[31],zmm1[40],zmm0[40],zmm1[41],zmm0[41],zmm1[42],zmm0[42],zmm1[43],zmm0[43],zmm1[44],zmm0[44],zmm1[45],zmm0[45],zmm1[46],zmm0[46],zmm1[47],zmm0[47],zmm1[56],zmm0[56],zmm1[57],zmm0[57],zmm1[58],zmm0[58],zmm1[59],zmm0[59],zmm1[60],zmm0[60],zmm1[61],zmm0[61],zmm1[62],zmm0[62],zmm1[63],zmm0[63]
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpsllw %xmm2, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm1[0],zmm0[0],zmm1[1],zmm0[1],zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[4],zmm0[4],zmm1[5],zmm0[5],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[16],zmm0[16],zmm1[17],zmm0[17],zmm1[18],zmm0[18],zmm1[19],zmm0[19],zmm1[20],zmm0[20],zmm1[21],zmm0[21],zmm1[22],zmm0[22],zmm1[23],zmm0[23],zmm1[32],zmm0[32],zmm1[33],zmm0[33],zmm1[34],zmm0[34],zmm1[35],zmm0[35],zmm1[36],zmm0[36],zmm1[37],zmm0[37],zmm1[38],zmm0[38],zmm1[39],zmm0[39],zmm1[48],zmm0[48],zmm1[49],zmm0[49],zmm1[50],zmm0[50],zmm1[51],zmm0[51],zmm1[52],zmm0[52],zmm1[53],zmm0[53],zmm1[54],zmm0[54],zmm1[55],zmm0[55]
; GFNIAVX512BW-NEXT:    vpsllw %xmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %splat)
  ret <64 x i8> %res
}

define <64 x i8> @splatvar_fshr_v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %amt) nounwind {
; GFNISSE-LABEL: splatvar_fshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; GFNISSE-NEXT:    movdqa %xmm4, %xmm10
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm0[8],xmm10[9],xmm0[9],xmm10[10],xmm0[10],xmm10[11],xmm0[11],xmm10[12],xmm0[12],xmm10[13],xmm0[13],xmm10[14],xmm0[14],xmm10[15],xmm0[15]
; GFNISSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm9
; GFNISSE-NEXT:    psrlw %xmm9, %xmm10
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm8 = [255,255,255,255,255,255,255,255]
; GFNISSE-NEXT:    pand %xmm8, %xmm10
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm4
; GFNISSE-NEXT:    pand %xmm8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm10, %xmm4
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm5
; GFNISSE-NEXT:    pand %xmm8, %xmm5
; GFNISSE-NEXT:    packuswb %xmm0, %xmm5
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm6
; GFNISSE-NEXT:    pand %xmm8, %xmm6
; GFNISSE-NEXT:    packuswb %xmm0, %xmm6
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm3[8],xmm0[9],xmm3[9],xmm0[10],xmm3[10],xmm0[11],xmm3[11],xmm0[12],xmm3[12],xmm0[13],xmm3[13],xmm0[14],xmm3[14],xmm0[15],xmm3[15]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm0
; GFNISSE-NEXT:    pand %xmm8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; GFNISSE-NEXT:    psrlw %xmm9, %xmm7
; GFNISSE-NEXT:    pand %xmm7, %xmm8
; GFNISSE-NEXT:    packuswb %xmm0, %xmm8
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm8, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatvar_fshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; GFNIAVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm5, %xmm8
; GFNIAVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm8, %xmm8
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3],xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpackuswb %xmm8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm7, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm6
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm2[8],xmm6[9],xmm2[9],xmm6[10],xmm2[10],xmm6[11],xmm2[11],xmm6[12],xmm2[12],xmm6[13],xmm2[13],xmm6[14],xmm2[14],xmm6[15],xmm2[15]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm7, %xmm7
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm7, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNIAVX1-NEXT:    vpsrlw %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpand %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatvar_fshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; GFNIAVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm4, %xmm4
; GFNIAVX2-NEXT:    vpsrlw %xmm4, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpbroadcastw {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX2-NEXT:    vpand %ymm6, %ymm5, %ymm5
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; GFNIAVX2-NEXT:    vpsrlw %xmm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpand %ymm6, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm3[8],ymm1[8],ymm3[9],ymm1[9],ymm3[10],ymm1[10],ymm3[11],ymm1[11],ymm3[12],ymm1[12],ymm3[13],ymm1[13],ymm3[14],ymm1[14],ymm3[15],ymm1[15],ymm3[24],ymm1[24],ymm3[25],ymm1[25],ymm3[26],ymm1[26],ymm3[27],ymm1[27],ymm3[28],ymm1[28],ymm3[29],ymm1[29],ymm3[30],ymm1[30],ymm3[31],ymm1[31]
; GFNIAVX2-NEXT:    vpsrlw %xmm4, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpand %ymm6, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm3[0],ymm1[0],ymm3[1],ymm1[1],ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[4],ymm1[4],ymm3[5],ymm1[5],ymm3[6],ymm1[6],ymm3[7],ymm1[7],ymm3[16],ymm1[16],ymm3[17],ymm1[17],ymm3[18],ymm1[18],ymm3[19],ymm1[19],ymm3[20],ymm1[20],ymm3[21],ymm1[21],ymm3[22],ymm1[22],ymm3[23],ymm1[23]
; GFNIAVX2-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpand %ymm6, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatvar_fshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm4[8],ymm3[8],ymm4[9],ymm3[9],ymm4[10],ymm3[10],ymm4[11],ymm3[11],ymm4[12],ymm3[12],ymm4[13],ymm3[13],ymm4[14],ymm3[14],ymm4[15],ymm3[15],ymm4[24],ymm3[24],ymm4[25],ymm3[25],ymm4[26],ymm3[26],ymm4[27],ymm3[27],ymm4[28],ymm3[28],ymm4[29],ymm3[29],ymm4[30],ymm3[30],ymm4[31],ymm3[31]
; GFNIAVX512VL-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpbroadcastd {{.*#+}} ymm6 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm4[0],ymm3[0],ymm4[1],ymm3[1],ymm4[2],ymm3[2],ymm4[3],ymm3[3],ymm4[4],ymm3[4],ymm4[5],ymm3[5],ymm4[6],ymm3[6],ymm4[7],ymm3[7],ymm4[16],ymm3[16],ymm4[17],ymm3[17],ymm4[18],ymm3[18],ymm4[19],ymm3[19],ymm4[20],ymm3[20],ymm4[21],ymm3[21],ymm4[22],ymm3[22],ymm4[23],ymm3[23]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpand %ymm6, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpackuswb %ymm5, %ymm3, %ymm3
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpand %ymm6, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpsrlw %xmm2, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpand %ymm6, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatvar_fshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm0[8],zmm1[9],zmm0[9],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[12],zmm0[12],zmm1[13],zmm0[13],zmm1[14],zmm0[14],zmm1[15],zmm0[15],zmm1[24],zmm0[24],zmm1[25],zmm0[25],zmm1[26],zmm0[26],zmm1[27],zmm0[27],zmm1[28],zmm0[28],zmm1[29],zmm0[29],zmm1[30],zmm0[30],zmm1[31],zmm0[31],zmm1[40],zmm0[40],zmm1[41],zmm0[41],zmm1[42],zmm0[42],zmm1[43],zmm0[43],zmm1[44],zmm0[44],zmm1[45],zmm0[45],zmm1[46],zmm0[46],zmm1[47],zmm0[47],zmm1[56],zmm0[56],zmm1[57],zmm0[57],zmm1[58],zmm0[58],zmm1[59],zmm0[59],zmm1[60],zmm0[60],zmm1[61],zmm0[61],zmm1[62],zmm0[62],zmm1[63],zmm0[63]
; GFNIAVX512BW-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2, %xmm2
; GFNIAVX512BW-NEXT:    vpsrlw %xmm2, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpbroadcastw {{.*#+}} zmm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; GFNIAVX512BW-NEXT:    vpandq %zmm4, %zmm3, %zmm3
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm1[0],zmm0[0],zmm1[1],zmm0[1],zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[4],zmm0[4],zmm1[5],zmm0[5],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[16],zmm0[16],zmm1[17],zmm0[17],zmm1[18],zmm0[18],zmm1[19],zmm0[19],zmm1[20],zmm0[20],zmm1[21],zmm0[21],zmm1[22],zmm0[22],zmm1[23],zmm0[23],zmm1[32],zmm0[32],zmm1[33],zmm0[33],zmm1[34],zmm0[34],zmm1[35],zmm0[35],zmm1[36],zmm0[36],zmm1[37],zmm0[37],zmm1[38],zmm0[38],zmm1[39],zmm0[39],zmm1[48],zmm0[48],zmm1[49],zmm0[49],zmm1[50],zmm0[50],zmm1[51],zmm0[51],zmm1[52],zmm0[52],zmm1[53],zmm0[53],zmm1[54],zmm0[54],zmm1[55],zmm0[55]
; GFNIAVX512BW-NEXT:    vpsrlw %xmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpandq %zmm4, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshr.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> %splat)
  ret <64 x i8> %res
}

define <64 x i8> @constant_fshl_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: constant_fshl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm4, %xmm10
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm0[8],xmm10[9],xmm0[9],xmm10[10],xmm0[10],xmm10[11],xmm0[11],xmm10[12],xmm0[12],xmm10[13],xmm0[13],xmm10[14],xmm0[14],xmm10[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm9 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm10
; GFNISSE-NEXT:    psrlw $8, %xmm10
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm8 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm10, %xmm4
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    packuswb %xmm0, %xmm5
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    packuswb %xmm0, %xmm6
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm3[8],xmm0[9],xmm3[9],xmm0[10],xmm3[10],xmm0[11],xmm3[11],xmm0[12],xmm3[12],xmm0[13],xmm3[13],xmm0[14],xmm3[14],xmm0[15],xmm3[15]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm8
; GFNISSE-NEXT:    psrlw $8, %xmm8
; GFNISSE-NEXT:    packuswb %xmm0, %xmm8
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm8, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_fshl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm7 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3],xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm4[8],xmm2[8],xmm4[9],xmm2[9],xmm4[10],xmm2[10],xmm4[11],xmm2[11],xmm4[12],xmm2[12],xmm4[13],xmm2[13],xmm4[14],xmm2[14],xmm4[15],xmm2[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_fshl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm1[8],ymm3[9],ymm1[9],ymm3[10],ymm1[10],ymm3[11],ymm1[11],ymm3[12],ymm1[12],ymm3[13],ymm1[13],ymm3[14],ymm1[14],ymm3[15],ymm1[15],ymm3[24],ymm1[24],ymm3[25],ymm1[25],ymm3[26],ymm1[26],ymm3[27],ymm1[27],ymm3[28],ymm1[28],ymm3[29],ymm1[29],ymm3[30],ymm1[30],ymm3[31],ymm1[31]
; GFNIAVX2-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm3[0],ymm1[0],ymm3[1],ymm1[1],ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[4],ymm1[4],ymm3[5],ymm1[5],ymm3[6],ymm1[6],ymm3[7],ymm1[7],ymm3[16],ymm1[16],ymm3[17],ymm1[17],ymm3[18],ymm1[18],ymm3[19],ymm1[19],ymm3[20],ymm1[20],ymm3[21],ymm1[21],ymm3[22],ymm1[22],ymm3[23],ymm1[23]
; GFNIAVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_fshl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm2[8],ymm3[9],ymm2[9],ymm3[10],ymm2[10],ymm3[11],ymm2[11],ymm3[12],ymm2[12],ymm3[13],ymm2[13],ymm3[14],ymm2[14],ymm3[15],ymm2[15],ymm3[24],ymm2[24],ymm3[25],ymm2[25],ymm3[26],ymm2[26],ymm3[27],ymm2[27],ymm3[28],ymm2[28],ymm3[29],ymm2[29],ymm3[30],ymm2[30],ymm3[31],ymm2[31]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[4],ymm2[4],ymm3[5],ymm2[5],ymm3[6],ymm2[6],ymm3[7],ymm2[7],ymm3[16],ymm2[16],ymm3[17],ymm2[17],ymm3[18],ymm2[18],ymm3[19],ymm2[19],ymm3[20],ymm2[20],ymm3[21],ymm2[21],ymm3[22],ymm2[22],ymm3[23],ymm2[23]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpackuswb %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_fshl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm1[8],zmm0[8],zmm1[9],zmm0[9],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[12],zmm0[12],zmm1[13],zmm0[13],zmm1[14],zmm0[14],zmm1[15],zmm0[15],zmm1[24],zmm0[24],zmm1[25],zmm0[25],zmm1[26],zmm0[26],zmm1[27],zmm0[27],zmm1[28],zmm0[28],zmm1[29],zmm0[29],zmm1[30],zmm0[30],zmm1[31],zmm0[31],zmm1[40],zmm0[40],zmm1[41],zmm0[41],zmm1[42],zmm0[42],zmm1[43],zmm0[43],zmm1[44],zmm0[44],zmm1[45],zmm0[45],zmm1[46],zmm0[46],zmm1[47],zmm0[47],zmm1[56],zmm0[56],zmm1[57],zmm0[57],zmm1[58],zmm0[58],zmm1[59],zmm0[59],zmm1[60],zmm0[60],zmm1[61],zmm0[61],zmm1[62],zmm0[62],zmm1[63],zmm0[63]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm1[0],zmm0[0],zmm1[1],zmm0[1],zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[4],zmm0[4],zmm1[5],zmm0[5],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[16],zmm0[16],zmm1[17],zmm0[17],zmm1[18],zmm0[18],zmm1[19],zmm0[19],zmm1[20],zmm0[20],zmm1[21],zmm0[21],zmm1[22],zmm0[22],zmm1[23],zmm0[23],zmm1[32],zmm0[32],zmm1[33],zmm0[33],zmm1[34],zmm0[34],zmm1[35],zmm0[35],zmm1[36],zmm0[36],zmm1[37],zmm0[37],zmm1[38],zmm0[38],zmm1[39],zmm0[39],zmm1[48],zmm0[48],zmm1[49],zmm0[49],zmm1[50],zmm0[50],zmm1[51],zmm0[51],zmm1[52],zmm0[52],zmm1[53],zmm0[53],zmm1[54],zmm0[54],zmm1[55],zmm0[55]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

define <64 x i8> @constant_fshr_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: constant_fshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa %xmm4, %xmm10
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8],xmm0[8],xmm10[9],xmm0[9],xmm10[10],xmm0[10],xmm10[11],xmm0[11],xmm10[12],xmm0[12],xmm10[13],xmm0[13],xmm10[14],xmm0[14],xmm10[15],xmm0[15]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm9 = [1,128,64,32,16,8,4,2]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm10
; GFNISSE-NEXT:    psrlw $8, %xmm10
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm0[0],xmm4[1],xmm0[1],xmm4[2],xmm0[2],xmm4[3],xmm0[3],xmm4[4],xmm0[4],xmm4[5],xmm0[5],xmm4[6],xmm0[6],xmm4[7],xmm0[7]
; GFNISSE-NEXT:    pmovzxbw {{.*#+}} xmm8 = [1,2,4,8,16,32,64,128]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm4
; GFNISSE-NEXT:    psrlw $8, %xmm4
; GFNISSE-NEXT:    packuswb %xmm10, %xmm4
; GFNISSE-NEXT:    movdqa %xmm5, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm5
; GFNISSE-NEXT:    psrlw $8, %xmm5
; GFNISSE-NEXT:    packuswb %xmm0, %xmm5
; GFNISSE-NEXT:    movdqa %xmm6, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; GFNISSE-NEXT:    pmullw %xmm8, %xmm6
; GFNISSE-NEXT:    psrlw $8, %xmm6
; GFNISSE-NEXT:    packuswb %xmm0, %xmm6
; GFNISSE-NEXT:    movdqa %xmm7, %xmm0
; GFNISSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm3[8],xmm0[9],xmm3[9],xmm0[10],xmm3[10],xmm0[11],xmm3[11],xmm0[12],xmm3[12],xmm0[13],xmm3[13],xmm0[14],xmm3[14],xmm0[15],xmm3[15]
; GFNISSE-NEXT:    pmullw %xmm9, %xmm0
; GFNISSE-NEXT:    psrlw $8, %xmm0
; GFNISSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; GFNISSE-NEXT:    pmullw %xmm7, %xmm8
; GFNISSE-NEXT:    psrlw $8, %xmm8
; GFNISSE-NEXT:    packuswb %xmm0, %xmm8
; GFNISSE-NEXT:    movdqa %xmm4, %xmm0
; GFNISSE-NEXT:    movdqa %xmm5, %xmm1
; GFNISSE-NEXT:    movdqa %xmm6, %xmm2
; GFNISSE-NEXT:    movdqa %xmm8, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: constant_fshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8],xmm4[8],xmm5[9],xmm4[9],xmm5[10],xmm4[10],xmm5[11],xmm4[11],xmm5[12],xmm4[12],xmm5[13],xmm4[13],xmm5[14],xmm4[14],xmm5[15],xmm4[15]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm7 = [1,128,64,32,16,8,4,2]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3],xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; GFNIAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = [1,2,4,8,16,32,64,128]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1],xmm2[2],xmm0[2],xmm2[3],xmm0[3],xmm2[4],xmm0[4],xmm2[5],xmm0[5],xmm2[6],xmm0[6],xmm2[7],xmm0[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm4[8],xmm2[8],xmm4[9],xmm2[9],xmm4[10],xmm2[10],xmm4[11],xmm2[11],xmm4[12],xmm2[12],xmm4[13],xmm2[13],xmm4[14],xmm2[14],xmm4[15],xmm2[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm6, %xmm6
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm2 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpackuswb %xmm6, %xmm2, %xmm2
; GFNIAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; GFNIAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; GFNIAVX1-NEXT:    vpunpcklbw {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; GFNIAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpsrlw $8, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: constant_fshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; GFNIAVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX2-NEXT:    # ymm2 = mem[0,1,0,1]
; GFNIAVX2-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm1[8],ymm3[9],ymm1[9],ymm3[10],ymm1[10],ymm3[11],ymm1[11],ymm3[12],ymm1[12],ymm3[13],ymm1[13],ymm3[14],ymm1[14],ymm3[15],ymm1[15],ymm3[24],ymm1[24],ymm3[25],ymm1[25],ymm3[26],ymm1[26],ymm3[27],ymm1[27],ymm3[28],ymm1[28],ymm3[29],ymm1[29],ymm3[30],ymm1[30],ymm3[31],ymm1[31]
; GFNIAVX2-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm3[0],ymm1[0],ymm3[1],ymm1[1],ymm3[2],ymm1[2],ymm3[3],ymm1[3],ymm3[4],ymm1[4],ymm3[5],ymm1[5],ymm3[6],ymm1[6],ymm3[7],ymm1[7],ymm3[16],ymm1[16],ymm3[17],ymm1[17],ymm3[18],ymm1[18],ymm3[19],ymm1[19],ymm3[20],ymm1[20],ymm3[21],ymm1[21],ymm3[22],ymm1[22],ymm3[23],ymm1[23]
; GFNIAVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpsrlw $8, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpackuswb %ymm4, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: constant_fshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm2[8],ymm3[9],ymm2[9],ymm3[10],ymm2[10],ymm3[11],ymm2[11],ymm3[12],ymm2[12],ymm3[13],ymm2[13],ymm3[14],ymm2[14],ymm3[15],ymm2[15],ymm3[24],ymm2[24],ymm3[25],ymm2[25],ymm3[26],ymm2[26],ymm3[27],ymm2[27],ymm3[28],ymm2[28],ymm3[29],ymm2[29],ymm3[30],ymm2[30],ymm3[31],ymm2[31]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,128,64,32,16,8,4,2,1,128,64,32,16,8,4,2]
; GFNIAVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[4],ymm2[4],ymm3[5],ymm2[5],ymm3[6],ymm2[6],ymm3[7],ymm2[7],ymm3[16],ymm2[16],ymm3[17],ymm2[17],ymm3[18],ymm2[18],ymm3[19],ymm2[19],ymm3[20],ymm2[20],ymm3[21],ymm2[21],ymm3[22],ymm2[22],ymm3[23],ymm2[23]
; GFNIAVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128,1,2,4,8,16,32,64,128]
; GFNIAVX512VL-NEXT:    # ymm3 = mem[0,1,0,1]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpackuswb %ymm4, %ymm2, %ymm2
; GFNIAVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; GFNIAVX512VL-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; GFNIAVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; GFNIAVX512VL-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: constant_fshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm1[8],zmm0[8],zmm1[9],zmm0[9],zmm1[10],zmm0[10],zmm1[11],zmm0[11],zmm1[12],zmm0[12],zmm1[13],zmm0[13],zmm1[14],zmm0[14],zmm1[15],zmm0[15],zmm1[24],zmm0[24],zmm1[25],zmm0[25],zmm1[26],zmm0[26],zmm1[27],zmm0[27],zmm1[28],zmm0[28],zmm1[29],zmm0[29],zmm1[30],zmm0[30],zmm1[31],zmm0[31],zmm1[40],zmm0[40],zmm1[41],zmm0[41],zmm1[42],zmm0[42],zmm1[43],zmm0[43],zmm1[44],zmm0[44],zmm1[45],zmm0[45],zmm1[46],zmm0[46],zmm1[47],zmm0[47],zmm1[56],zmm0[56],zmm1[57],zmm0[57],zmm1[58],zmm0[58],zmm1[59],zmm0[59],zmm1[60],zmm0[60],zmm1[61],zmm0[61],zmm1[62],zmm0[62],zmm1[63],zmm0[63]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; GFNIAVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm1[0],zmm0[0],zmm1[1],zmm0[1],zmm1[2],zmm0[2],zmm1[3],zmm0[3],zmm1[4],zmm0[4],zmm1[5],zmm0[5],zmm1[6],zmm0[6],zmm1[7],zmm0[7],zmm1[16],zmm0[16],zmm1[17],zmm0[17],zmm1[18],zmm0[18],zmm1[19],zmm0[19],zmm1[20],zmm0[20],zmm1[21],zmm0[21],zmm1[22],zmm0[22],zmm1[23],zmm0[23],zmm1[32],zmm0[32],zmm1[33],zmm0[33],zmm1[34],zmm0[34],zmm1[35],zmm0[35],zmm1[36],zmm0[36],zmm1[37],zmm0[37],zmm1[38],zmm0[38],zmm1[39],zmm0[39],zmm1[48],zmm0[48],zmm1[49],zmm0[49],zmm1[50],zmm0[50],zmm1[51],zmm0[51],zmm1[52],zmm0[52],zmm1[53],zmm0[53],zmm1[54],zmm0[54],zmm1[55],zmm0[55]
; GFNIAVX512BW-NEXT:    vpsllvw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    vpackuswb %zmm2, %zmm0, %zmm0
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

define <64 x i8> @splatconstant_fshl_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: splatconstant_fshl_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm4
; GFNISSE-NEXT:    paddb %xmm0, %xmm0
; GFNISSE-NEXT:    por %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm5
; GFNISSE-NEXT:    paddb %xmm1, %xmm1
; GFNISSE-NEXT:    por %xmm5, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm6
; GFNISSE-NEXT:    paddb %xmm2, %xmm2
; GFNISSE-NEXT:    por %xmm6, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm7
; GFNISSE-NEXT:    paddb %xmm3, %xmm3
; GFNISSE-NEXT:    por %xmm7, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_fshl_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm2
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm5
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; GFNIAVX1-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; GFNIAVX1-NEXT:    vorps %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm2
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm3
; GFNIAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; GFNIAVX1-NEXT:    vpaddb %xmm1, %xmm1, %xmm1
; GFNIAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm3, %ymm1
; GFNIAVX1-NEXT:    vorps %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_fshl_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,128]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatconstant_fshl_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm2
; GFNIAVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; GFNIAVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; GFNIAVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatconstant_fshl_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpaddw %zmm0, %zmm0, %zmm2
; GFNIAVX512BW-NEXT:    vpsrlw $7, %zmm1, %zmm0
; GFNIAVX512BW-NEXT:    vpternlogd {{.*#+}} zmm0 = zmm0 ^ (m32bcst & (zmm0 ^ zmm2))
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>)
  ret <64 x i8> %res
}
declare <64 x i8> @llvm.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)

define <64 x i8> @splatconstant_fshr_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; GFNISSE-LABEL: splatconstant_fshr_v64i8:
; GFNISSE:       # %bb.0:
; GFNISSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm4
; GFNISSE-NEXT:    pmovsxwq {{.*#+}} xmm9 = [258,258]
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm0
; GFNISSE-NEXT:    por %xmm4, %xmm0
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm5
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm1
; GFNISSE-NEXT:    por %xmm5, %xmm1
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm6
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm2
; GFNISSE-NEXT:    por %xmm6, %xmm2
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm8, %xmm7
; GFNISSE-NEXT:    gf2p8affineqb $0, %xmm9, %xmm3
; GFNISSE-NEXT:    por %xmm7, %xmm3
; GFNISSE-NEXT:    retq
;
; GFNIAVX1-LABEL: splatconstant_fshr_v64i8:
; GFNIAVX1:       # %bb.0:
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm2
; GFNIAVX1-NEXT:    vbroadcastsd {{.*#+}} ymm5 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vorps %ymm2, %ymm0, %ymm0
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm2
; GFNIAVX1-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm1
; GFNIAVX1-NEXT:    vorps %ymm2, %ymm1, %ymm1
; GFNIAVX1-NEXT:    retq
;
; GFNIAVX2-LABEL: splatconstant_fshr_v64i8:
; GFNIAVX2:       # %bb.0:
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4,0,0,128,64,32,16,8,4]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm2, %ymm2
; GFNIAVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0]
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm4, %ymm3, %ymm2
; GFNIAVX2-NEXT:    vgf2p8affineqb $0, %ymm5, %ymm1, %ymm1
; GFNIAVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; GFNIAVX2-NEXT:    retq
;
; GFNIAVX512VL-LABEL: splatconstant_fshr_v64i8:
; GFNIAVX512VL:       # %bb.0:
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm1, %zmm1
; GFNIAVX512VL-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; GFNIAVX512VL-NEXT:    retq
;
; GFNIAVX512BW-LABEL: splatconstant_fshr_v64i8:
; GFNIAVX512BW:       # %bb.0:
; GFNIAVX512BW-NEXT:    vpsllw $6, %zmm0, %zmm2
; GFNIAVX512BW-NEXT:    vpsrlw $2, %zmm1, %zmm0
; GFNIAVX512BW-NEXT:    vpternlogd {{.*#+}} zmm0 = zmm0 ^ (m32bcst & (zmm0 ^ zmm2))
; GFNIAVX512BW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshr.v64i8(<64 x i8> %a, <64 x i8> %b, <64 x i8> <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>)
  ret <64 x i8> %res
}
declare <64 x i8> @llvm.fshr.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)
