// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/options/runhcs.proto

package options

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type Options_DebugType int32

const (
	Options_NPIPE Options_DebugType = 0
	Options_FILE  Options_DebugType = 1
	Options_ETW   Options_DebugType = 2
)

var Options_DebugType_name = map[int32]string{
	0: "NPIPE",
	1: "FILE",
	2: "ETW",
}

var Options_DebugType_value = map[string]int32{
	"NPIPE": 0,
	"FILE":  1,
	"ETW":   2,
}

func (x Options_DebugType) String() string {
	return proto.EnumName(Options_DebugType_name, int32(x))
}

func (Options_DebugType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b643df6839c75082, []int{0, 0}
}

type Options_SandboxIsolation int32

const (
	Options_PROCESS    Options_SandboxIsolation = 0
	Options_HYPERVISOR Options_SandboxIsolation = 1
)

var Options_SandboxIsolation_name = map[int32]string{
	0: "PROCESS",
	1: "HYPERVISOR",
}

var Options_SandboxIsolation_value = map[string]int32{
	"PROCESS":    0,
	"HYPERVISOR": 1,
}

func (x Options_SandboxIsolation) String() string {
	return proto.EnumName(Options_SandboxIsolation_name, int32(x))
}

func (Options_SandboxIsolation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b643df6839c75082, []int{0, 1}
}

// Options are the set of customizations that can be passed at Create time.
type Options struct {
	// Enable debug tracing (sets the logrus log level to debug). This may be deprecated in the future, prefer
	// log_level as this will override debug if both of them are set.
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// debug tracing output type
	DebugType Options_DebugType `protobuf:"varint,2,opt,name=debug_type,json=debugType,proto3,enum=containerd.runhcs.v1.Options_DebugType" json:"debug_type,omitempty"`
	// registry key root for storage of the runhcs container state
	RegistryRoot string `protobuf:"bytes,3,opt,name=registry_root,json=registryRoot,proto3" json:"registry_root,omitempty"`
	// sandbox_image is the image to use for the sandbox that matches the
	// sandbox_platform.
	SandboxImage string `protobuf:"bytes,4,opt,name=sandbox_image,json=sandboxImage,proto3" json:"sandbox_image,omitempty"`
	// sandbox_platform is a CRI setting that specifies the platform
	// architecture for all sandbox's in this runtime. Values are
	// 'windows/amd64' and 'linux/amd64'.
	SandboxPlatform string `protobuf:"bytes,5,opt,name=sandbox_platform,json=sandboxPlatform,proto3" json:"sandbox_platform,omitempty"`
	// sandbox_isolation is a CRI setting that specifies the isolation level of
	// the sandbox. For Windows runtime PROCESS and HYPERVISOR are valid. For
	// LCOW only HYPERVISOR is valid and default if omitted.
	SandboxIsolation Options_SandboxIsolation `protobuf:"varint,6,opt,name=sandbox_isolation,json=sandboxIsolation,proto3,enum=containerd.runhcs.v1.Options_SandboxIsolation" json:"sandbox_isolation,omitempty"`
	// boot_files_root_path is the path to the directory containing the LCOW
	// kernel and root FS files.
	BootFilesRootPath string `protobuf:"bytes,7,opt,name=boot_files_root_path,json=bootFilesRootPath,proto3" json:"boot_files_root_path,omitempty"`
	// vm_processor_count is the default number of processors to create for the
	// hypervisor isolated utility vm.
	//
	// The platform default if omitted is 2, unless the host only has a single
	// core in which case it is 1.
	VmProcessorCount int32 `protobuf:"varint,8,opt,name=vm_processor_count,json=vmProcessorCount,proto3" json:"vm_processor_count,omitempty"`
	// vm_memory_size_in_mb is the default amount of memory to assign to the
	// hypervisor isolated utility vm.
	//
	// The platform default is 1024MB if omitted.
	VmMemorySizeInMb int32 `protobuf:"varint,9,opt,name=vm_memory_size_in_mb,json=vmMemorySizeInMb,proto3" json:"vm_memory_size_in_mb,omitempty"`
	// GPUVHDPath is the path to the gpu vhd to add to the uvm
	// when a container requests a gpu
	GPUVHDPath string `protobuf:"bytes,10,opt,name=GPUVHDPath,proto3" json:"GPUVHDPath,omitempty"`
	// scale_cpu_limits_to_sandbox indicates that container CPU limits should
	// be adjusted to account for the difference in number of cores between the
	// host and UVM.
	ScaleCpuLimitsToSandbox bool `protobuf:"varint,11,opt,name=scale_cpu_limits_to_sandbox,json=scaleCpuLimitsToSandbox,proto3" json:"scale_cpu_limits_to_sandbox,omitempty"`
	// default_container_scratch_size_in_gb is the default scratch size (sandbox.vhdx)
	// to be used for containers. Every container will get a sandbox of `size_in_gb` assigned
	// instead of the default of 20GB.
	DefaultContainerScratchSizeInGb int32 `protobuf:"varint,12,opt,name=default_container_scratch_size_in_gb,json=defaultContainerScratchSizeInGb,proto3" json:"default_container_scratch_size_in_gb,omitempty"`
	// default_vm_scratch_size_in_gb is the default scratch size (sandbox.vhdx)
	// to be used for the UVM. This only applies to WCOW as LCOW doesn't mount a scratch
	// specifically for the UVM.
	DefaultVmScratchSizeInGb int32 `protobuf:"varint,13,opt,name=default_vm_scratch_size_in_gb,json=defaultVmScratchSizeInGb,proto3" json:"default_vm_scratch_size_in_gb,omitempty"`
	// share_scratch specifies if we'd like to reuse scratch space between multiple containers.
	// This currently only affects LCOW. The sandbox containers scratch space is re-used for all
	// subsequent containers launched in the pod.
	ShareScratch bool `protobuf:"varint,14,opt,name=share_scratch,json=shareScratch,proto3" json:"share_scratch,omitempty"`
	// NCProxyAddr is the address of the network configuration proxy service. If omitted
	// the network is setup locally.
	NCProxyAddr string `protobuf:"bytes,15,opt,name=NCProxyAddr,proto3" json:"NCProxyAddr,omitempty"`
	// log_level specifies the logrus log level for the shim. Supported values are a string representation of the
	// logrus log levels: "trace", "debug", "info", "warn", "error", "fatal", "panic". This setting will override
	// the `debug` field if both are specified, unless the level specified is also "debug", as these are equivalent.
	LogLevel string `protobuf:"bytes,16,opt,name=log_level,json=logLevel,proto3" json:"log_level,omitempty"`
	// io_retry_timeout_in_sec is the timeout in seconds for how long to try and reconnect to an upstream IO provider if a connection is lost.
	// The typical example is if Containerd has restarted but is expected to come back online. A 0 for this field is interpreted as an infinite
	// timeout.
	IoRetryTimeoutInSec int32 `protobuf:"varint,17,opt,name=io_retry_timeout_in_sec,json=ioRetryTimeoutInSec,proto3" json:"io_retry_timeout_in_sec,omitempty"`
	// default_container_annotations specifies a set of annotations that should be set for every workload container
	DefaultContainerAnnotations map[string]string `protobuf:"bytes,18,rep,name=default_container_annotations,json=defaultContainerAnnotations,proto3" json:"default_container_annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// no_inherit_host_timezone specifies to skip inheriting the hosts time zone for WCOW UVMs and instead default to
	// UTC.
	NoInheritHostTimezone bool `protobuf:"varint,19,opt,name=no_inherit_host_timezone,json=noInheritHostTimezone,proto3" json:"no_inherit_host_timezone,omitempty"`
	// scrub_logs enables removing environment variables and other potentially sensitive information from logs
	ScrubLogs            bool     `protobuf:"varint,20,opt,name=scrub_logs,json=scrubLogs,proto3" json:"scrub_logs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Options) Reset()      { *m = Options{} }
func (*Options) ProtoMessage() {}
func (*Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_b643df6839c75082, []int{0}
}
func (m *Options) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Options.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Options.Merge(m, src)
}
func (m *Options) XXX_Size() int {
	return m.Size()
}
func (m *Options) XXX_DiscardUnknown() {
	xxx_messageInfo_Options.DiscardUnknown(m)
}

var xxx_messageInfo_Options proto.InternalMessageInfo

// ProcessDetails contains additional information about a process. This is the additional
// info returned in the Pids query.
type ProcessDetails struct {
	ImageName                    string    `protobuf:"bytes,1,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	CreatedAt                    time.Time `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3,stdtime" json:"created_at"`
	KernelTime_100Ns             uint64    `protobuf:"varint,3,opt,name=kernel_time_100_ns,json=kernelTime100Ns,proto3" json:"kernel_time_100_ns,omitempty"`
	MemoryCommitBytes            uint64    `protobuf:"varint,4,opt,name=memory_commit_bytes,json=memoryCommitBytes,proto3" json:"memory_commit_bytes,omitempty"`
	MemoryWorkingSetPrivateBytes uint64    `protobuf:"varint,5,opt,name=memory_working_set_private_bytes,json=memoryWorkingSetPrivateBytes,proto3" json:"memory_working_set_private_bytes,omitempty"`
	MemoryWorkingSetSharedBytes  uint64    `protobuf:"varint,6,opt,name=memory_working_set_shared_bytes,json=memoryWorkingSetSharedBytes,proto3" json:"memory_working_set_shared_bytes,omitempty"`
	ProcessID                    uint32    `protobuf:"varint,7,opt,name=process_id,json=processId,proto3" json:"process_id,omitempty"`
	UserTime_100Ns               uint64    `protobuf:"varint,8,opt,name=user_time_100_ns,json=userTime100Ns,proto3" json:"user_time_100_ns,omitempty"`
	ExecID                       string    `protobuf:"bytes,9,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}  `json:"-"`
	XXX_unrecognized             []byte    `json:"-"`
	XXX_sizecache                int32     `json:"-"`
}

func (m *ProcessDetails) Reset()      { *m = ProcessDetails{} }
func (*ProcessDetails) ProtoMessage() {}
func (*ProcessDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_b643df6839c75082, []int{1}
}
func (m *ProcessDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessDetails.Merge(m, src)
}
func (m *ProcessDetails) XXX_Size() int {
	return m.Size()
}
func (m *ProcessDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessDetails.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessDetails proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("containerd.runhcs.v1.Options_DebugType", Options_DebugType_name, Options_DebugType_value)
	proto.RegisterEnum("containerd.runhcs.v1.Options_SandboxIsolation", Options_SandboxIsolation_name, Options_SandboxIsolation_value)
	proto.RegisterType((*Options)(nil), "containerd.runhcs.v1.Options")
	proto.RegisterMapType((map[string]string)(nil), "containerd.runhcs.v1.Options.DefaultContainerAnnotationsEntry")
	proto.RegisterType((*ProcessDetails)(nil), "containerd.runhcs.v1.ProcessDetails")
}

func init() {
	proto.RegisterFile("github.com/Microsoft/hcsshim/cmd/containerd-shim-runhcs-v1/options/runhcs.proto", fileDescriptor_b643df6839c75082)
}

var fileDescriptor_b643df6839c75082 = []byte{
	// 1072 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x4b, 0x6f, 0xe3, 0x36,
	0x17, 0xb5, 0xf2, 0xb4, 0x98, 0x97, 0xc3, 0xf8, 0xc3, 0x08, 0xc9, 0x37, 0xb6, 0x91, 0x29, 0x30,
	0x19, 0x74, 0x22, 0x27, 0x69, 0x81, 0x16, 0x6d, 0xd1, 0x22, 0xb1, 0x9d, 0x89, 0x8b, 0x3c, 0x0c,
	0xd9, 0xcd, 0xf4, 0xb1, 0x20, 0xf4, 0x60, 0x64, 0x22, 0x92, 0x28, 0x90, 0x94, 0x1b, 0x67, 0x55,
	0xf4, 0x17, 0xf4, 0x67, 0x65, 0xd9, 0x65, 0x8b, 0x02, 0x69, 0xc7, 0xbf, 0xa4, 0x20, 0x45, 0x25,
	0x33, 0x41, 0xda, 0x59, 0x74, 0x65, 0xf2, 0x9c, 0xc3, 0xc3, 0x7b, 0xaf, 0x78, 0xaf, 0xc1, 0x59,
	0x48, 0xc4, 0x30, 0xf3, 0x6c, 0x9f, 0xc6, 0xcd, 0x13, 0xe2, 0x33, 0xca, 0xe9, 0x85, 0x68, 0x0e,
	0x7d, 0xce, 0x87, 0x24, 0x6e, 0xfa, 0x71, 0xd0, 0xf4, 0x69, 0x22, 0x5c, 0x92, 0x60, 0x16, 0x6c,
	0x4b, 0x6c, 0x9b, 0x65, 0xc9, 0xd0, 0xe7, 0xdb, 0xa3, 0xdd, 0x26, 0x4d, 0x05, 0xa1, 0x09, 0x6f,
	0xe6, 0x88, 0x9d, 0x32, 0x2a, 0x28, 0xac, 0xde, 0xeb, 0x6d, 0x4d, 0x8c, 0x76, 0xd7, 0xab, 0x21,
	0x0d, 0xa9, 0x12, 0x34, 0xe5, 0x2a, 0xd7, 0xae, 0xd7, 0x43, 0x4a, 0xc3, 0x08, 0x37, 0xd5, 0xce,
	0xcb, 0x2e, 0x9a, 0x82, 0xc4, 0x98, 0x0b, 0x37, 0x4e, 0x73, 0xc1, 0xe6, 0xef, 0x26, 0x98, 0x3f,
	0xcb, 0x6f, 0x81, 0x55, 0x30, 0x1b, 0x60, 0x2f, 0x0b, 0x2d, 0xa3, 0x61, 0x6c, 0x95, 0x9d, 0x7c,
	0x03, 0x0f, 0x01, 0x50, 0x0b, 0x24, 0xc6, 0x29, 0xb6, 0xa6, 0x1a, 0xc6, 0xd6, 0xf2, 0xde, 0x73,
	0xfb, 0xb1, 0x18, 0x6c, 0x6d, 0x64, 0xb7, 0xa5, 0x7e, 0x30, 0x4e, 0xb1, 0x63, 0x06, 0xc5, 0x12,
	0x3e, 0x03, 0x4b, 0x0c, 0x87, 0x84, 0x0b, 0x36, 0x46, 0x8c, 0x52, 0x61, 0x4d, 0x37, 0x8c, 0x2d,
	0xd3, 0x59, 0x2c, 0x40, 0x87, 0x52, 0x21, 0x45, 0xdc, 0x4d, 0x02, 0x8f, 0x5e, 0x21, 0x12, 0xbb,
	0x21, 0xb6, 0x66, 0x72, 0x91, 0x06, 0xbb, 0x12, 0x83, 0x2f, 0x40, 0xa5, 0x10, 0xa5, 0x91, 0x2b,
	0x2e, 0x28, 0x8b, 0xad, 0x59, 0xa5, 0x5b, 0xd1, 0x78, 0x4f, 0xc3, 0xf0, 0x07, 0xb0, 0x7a, 0xe7,
	0xc7, 0x69, 0xe4, 0xca, 0xf8, 0xac, 0x39, 0x95, 0x83, 0xfd, 0xef, 0x39, 0xf4, 0xf5, 0x8d, 0xc5,
	0x29, 0xa7, 0xb8, 0xf3, 0x0e, 0x81, 0x4d, 0x50, 0xf5, 0x28, 0x15, 0xe8, 0x82, 0x44, 0x98, 0xab,
	0x9c, 0x50, 0xea, 0x8a, 0xa1, 0x35, 0xaf, 0x62, 0x59, 0x95, 0xdc, 0xa1, 0xa4, 0x64, 0x66, 0x3d,
	0x57, 0x0c, 0xe1, 0x4b, 0x00, 0x47, 0x31, 0x4a, 0x19, 0xf5, 0x31, 0xe7, 0x94, 0x21, 0x9f, 0x66,
	0x89, 0xb0, 0xca, 0x0d, 0x63, 0x6b, 0xd6, 0xa9, 0x8c, 0xe2, 0x5e, 0x41, 0xb4, 0x24, 0x0e, 0x6d,
	0x50, 0x1d, 0xc5, 0x28, 0xc6, 0x31, 0x65, 0x63, 0xc4, 0xc9, 0x35, 0x46, 0x24, 0x41, 0xb1, 0x67,
	0x99, 0x85, 0xfe, 0x44, 0x51, 0x7d, 0x72, 0x8d, 0xbb, 0xc9, 0x89, 0x07, 0x6b, 0x00, 0xbc, 0xea,
	0x7d, 0x73, 0x7e, 0xd4, 0x96, 0x77, 0x59, 0x40, 0x05, 0xf1, 0x16, 0x02, 0xbf, 0x00, 0x1b, 0xdc,
	0x77, 0x23, 0x8c, 0xfc, 0x34, 0x43, 0x11, 0x89, 0x89, 0xe0, 0x48, 0x50, 0xa4, 0xd3, 0xb2, 0x16,
	0xd4, 0x47, 0x7f, 0xa2, 0x24, 0xad, 0x34, 0x3b, 0x56, 0x82, 0x01, 0xd5, 0x75, 0x80, 0x27, 0xe0,
	0x83, 0x00, 0x5f, 0xb8, 0x59, 0x24, 0xd0, 0x5d, 0xdd, 0x10, 0xf7, 0x99, 0x2b, 0xfc, 0xe1, 0x5d,
	0x74, 0xa1, 0x67, 0x2d, 0xaa, 0xe8, 0xea, 0x5a, 0xdb, 0x2a, 0xa4, 0xfd, 0x5c, 0x99, 0x07, 0xfb,
	0xca, 0x83, 0x5f, 0x81, 0xa7, 0x85, 0xdd, 0x28, 0x7e, 0xcc, 0x67, 0x49, 0xf9, 0x58, 0x5a, 0x74,
	0x1e, 0x3f, 0x34, 0x90, 0x2f, 0x65, 0xe8, 0x32, 0x5c, 0x9c, 0xb5, 0x96, 0x55, 0xfc, 0x8b, 0x0a,
	0xd4, 0x62, 0xd8, 0x00, 0x0b, 0xa7, 0xad, 0x1e, 0xa3, 0x57, 0xe3, 0xfd, 0x20, 0x60, 0xd6, 0x8a,
	0xaa, 0xc9, 0xdb, 0x10, 0xdc, 0x00, 0x66, 0x44, 0x43, 0x14, 0xe1, 0x11, 0x8e, 0xac, 0x8a, 0xe2,
	0xcb, 0x11, 0x0d, 0x8f, 0xe5, 0x1e, 0x7e, 0x0c, 0x9e, 0x10, 0x8a, 0x18, 0x96, 0x4f, 0x56, 0x36,
	0x0e, 0xcd, 0x84, 0x8c, 0x8e, 0x63, 0xdf, 0x5a, 0x55, 0xe1, 0xad, 0x11, 0xea, 0x48, 0x76, 0x90,
	0x93, 0xdd, 0xa4, 0x8f, 0x7d, 0xf8, 0xb3, 0x71, 0x9f, 0xdb, 0x7d, 0xa9, 0xdc, 0x24, 0xa1, 0x42,
	0xbd, 0x1b, 0x6e, 0xc1, 0xc6, 0xf4, 0xd6, 0xc2, 0xde, 0x97, 0xef, 0x6b, 0xa2, 0x77, 0x2b, 0xb8,
	0x7f, 0x6f, 0xd0, 0x49, 0x64, 0xbf, 0x6c, 0x04, 0xff, 0xac, 0x80, 0x9f, 0x00, 0x2b, 0xa1, 0x88,
	0x24, 0x43, 0xcc, 0x88, 0x40, 0x43, 0xca, 0x85, 0xca, 0xe0, 0x9a, 0x26, 0xd8, 0x5a, 0x53, 0x95,
	0xfa, 0x5f, 0x42, 0xbb, 0x39, 0x7d, 0x44, 0xb9, 0x18, 0x68, 0x12, 0x3e, 0x05, 0x80, 0xfb, 0x2c,
	0xf3, 0x50, 0x44, 0x43, 0x6e, 0x55, 0x95, 0xd4, 0x54, 0xc8, 0x31, 0x0d, 0xf9, 0xfa, 0x29, 0x68,
	0xbc, 0x2f, 0x30, 0x58, 0x01, 0xd3, 0x97, 0x78, 0xac, 0xa6, 0x88, 0xe9, 0xc8, 0xa5, 0x9c, 0x2c,
	0x23, 0x37, 0xca, 0xf2, 0xf1, 0x61, 0x3a, 0xf9, 0xe6, 0xb3, 0xa9, 0x4f, 0x8d, 0xcd, 0x17, 0xc0,
	0xbc, 0x9b, 0x16, 0xd0, 0x04, 0xb3, 0xa7, 0xbd, 0x6e, 0xaf, 0x53, 0x29, 0xc1, 0x32, 0x98, 0x39,
	0xec, 0x1e, 0x77, 0x2a, 0x06, 0x9c, 0x07, 0xd3, 0x9d, 0xc1, 0xeb, 0xca, 0xd4, 0x66, 0x13, 0x54,
	0x1e, 0x36, 0x25, 0x5c, 0x00, 0xf3, 0x3d, 0xe7, 0xac, 0xd5, 0xe9, 0xf7, 0x2b, 0x25, 0xb8, 0x0c,
	0xc0, 0xd1, 0x77, 0xbd, 0x8e, 0x73, 0xde, 0xed, 0x9f, 0x39, 0x15, 0x63, 0xf3, 0x8f, 0x69, 0xb0,
	0xac, 0x7b, 0xaa, 0x8d, 0x85, 0x4b, 0x22, 0x2e, 0xb3, 0x53, 0x73, 0x05, 0x25, 0x6e, 0x8c, 0x75,
	0x84, 0xa6, 0x42, 0x4e, 0xdd, 0x18, 0xc3, 0x16, 0x00, 0x3e, 0xc3, 0xae, 0xc0, 0x01, 0x72, 0x85,
	0x0a, 0x76, 0x61, 0x6f, 0xdd, 0xce, 0x67, 0xa8, 0x5d, 0xcc, 0x50, 0x7b, 0x50, 0xcc, 0xd0, 0x83,
	0xf2, 0xcd, 0x6d, 0xbd, 0xf4, 0xcb, 0x9f, 0x75, 0xc3, 0x31, 0xf5, 0xb9, 0x7d, 0x01, 0x3f, 0x04,
	0xf0, 0x12, 0xb3, 0x04, 0x47, 0xaa, 0xe2, 0x68, 0x77, 0x67, 0x07, 0x25, 0x5c, 0x4d, 0xbb, 0x19,
	0x67, 0x25, 0x67, 0xa4, 0xc3, 0xee, 0xce, 0xce, 0x29, 0x87, 0x36, 0x58, 0xd3, 0x1d, 0xee, 0xd3,
	0x38, 0x26, 0x02, 0x79, 0x63, 0x81, 0xb9, 0x1a, 0x7b, 0x33, 0xce, 0x6a, 0x4e, 0xb5, 0x14, 0x73,
	0x20, 0x09, 0x78, 0x08, 0x1a, 0x5a, 0xff, 0x23, 0x65, 0x97, 0x24, 0x09, 0x11, 0xc7, 0x02, 0xa5,
	0x8c, 0x8c, 0x5c, 0x81, 0xf5, 0xe1, 0x59, 0x75, 0xf8, 0xff, 0xb9, 0xee, 0x75, 0x2e, 0xeb, 0x63,
	0xd1, 0xcb, 0x45, 0xb9, 0x4f, 0x1b, 0xd4, 0x1f, 0xf1, 0x51, 0xcd, 0x13, 0x68, 0x9b, 0x39, 0x65,
	0xb3, 0xf1, 0xd0, 0xa6, 0xaf, 0x34, 0xb9, 0xcb, 0x4b, 0x00, 0xf4, 0x34, 0x43, 0x24, 0x50, 0x73,
	0x6f, 0xe9, 0x60, 0x69, 0x72, 0x5b, 0x37, 0x75, 0xd9, 0xbb, 0x6d, 0xc7, 0xd4, 0x82, 0x6e, 0x00,
	0x9f, 0x83, 0x4a, 0xc6, 0x31, 0x7b, 0xa7, 0x2c, 0x65, 0x75, 0xc9, 0x92, 0xc4, 0xef, 0x8b, 0xf2,
	0x0c, 0xcc, 0xe3, 0x2b, 0xec, 0x4b, 0x4f, 0x39, 0xec, 0xcc, 0x03, 0x30, 0xb9, 0xad, 0xcf, 0x75,
	0xae, 0xb0, 0xdf, 0x6d, 0x3b, 0x73, 0x92, 0xea, 0x06, 0x07, 0xc1, 0xcd, 0x9b, 0x5a, 0xe9, 0xb7,
	0x37, 0xb5, 0xd2, 0x4f, 0x93, 0x9a, 0x71, 0x33, 0xa9, 0x19, 0xbf, 0x4e, 0x6a, 0xc6, 0x5f, 0x93,
	0x9a, 0xf1, 0xfd, 0xd7, 0xff, 0xfd, 0x1f, 0xf7, 0x73, 0xfd, 0xfb, 0x6d, 0xc9, 0x9b, 0x53, 0xdf,
	0xfd, 0xa3, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xba, 0x6d, 0x7b, 0x04, 0xc8, 0x07, 0x00, 0x00,
}

func (m *Options) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Options) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Options) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ScrubLogs {
		i--
		if m.ScrubLogs {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.NoInheritHostTimezone {
		i--
		if m.NoInheritHostTimezone {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if len(m.DefaultContainerAnnotations) > 0 {
		for k := range m.DefaultContainerAnnotations {
			v := m.DefaultContainerAnnotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintRunhcs(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRunhcs(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRunhcs(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x92
		}
	}
	if m.IoRetryTimeoutInSec != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.IoRetryTimeoutInSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if len(m.LogLevel) > 0 {
		i -= len(m.LogLevel)
		copy(dAtA[i:], m.LogLevel)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.LogLevel)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.NCProxyAddr) > 0 {
		i -= len(m.NCProxyAddr)
		copy(dAtA[i:], m.NCProxyAddr)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.NCProxyAddr)))
		i--
		dAtA[i] = 0x7a
	}
	if m.ShareScratch {
		i--
		if m.ShareScratch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.DefaultVmScratchSizeInGb != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.DefaultVmScratchSizeInGb))
		i--
		dAtA[i] = 0x68
	}
	if m.DefaultContainerScratchSizeInGb != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.DefaultContainerScratchSizeInGb))
		i--
		dAtA[i] = 0x60
	}
	if m.ScaleCpuLimitsToSandbox {
		i--
		if m.ScaleCpuLimitsToSandbox {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.GPUVHDPath) > 0 {
		i -= len(m.GPUVHDPath)
		copy(dAtA[i:], m.GPUVHDPath)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.GPUVHDPath)))
		i--
		dAtA[i] = 0x52
	}
	if m.VmMemorySizeInMb != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.VmMemorySizeInMb))
		i--
		dAtA[i] = 0x48
	}
	if m.VmProcessorCount != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.VmProcessorCount))
		i--
		dAtA[i] = 0x40
	}
	if len(m.BootFilesRootPath) > 0 {
		i -= len(m.BootFilesRootPath)
		copy(dAtA[i:], m.BootFilesRootPath)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.BootFilesRootPath)))
		i--
		dAtA[i] = 0x3a
	}
	if m.SandboxIsolation != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.SandboxIsolation))
		i--
		dAtA[i] = 0x30
	}
	if len(m.SandboxPlatform) > 0 {
		i -= len(m.SandboxPlatform)
		copy(dAtA[i:], m.SandboxPlatform)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.SandboxPlatform)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.SandboxImage) > 0 {
		i -= len(m.SandboxImage)
		copy(dAtA[i:], m.SandboxImage)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.SandboxImage)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RegistryRoot) > 0 {
		i -= len(m.RegistryRoot)
		copy(dAtA[i:], m.RegistryRoot)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.RegistryRoot)))
		i--
		dAtA[i] = 0x1a
	}
	if m.DebugType != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.DebugType))
		i--
		dAtA[i] = 0x10
	}
	if m.Debug {
		i--
		if m.Debug {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcessDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessDetails) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessDetails) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExecID) > 0 {
		i -= len(m.ExecID)
		copy(dAtA[i:], m.ExecID)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.ExecID)))
		i--
		dAtA[i] = 0x4a
	}
	if m.UserTime_100Ns != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.UserTime_100Ns))
		i--
		dAtA[i] = 0x40
	}
	if m.ProcessID != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.ProcessID))
		i--
		dAtA[i] = 0x38
	}
	if m.MemoryWorkingSetSharedBytes != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.MemoryWorkingSetSharedBytes))
		i--
		dAtA[i] = 0x30
	}
	if m.MemoryWorkingSetPrivateBytes != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.MemoryWorkingSetPrivateBytes))
		i--
		dAtA[i] = 0x28
	}
	if m.MemoryCommitBytes != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.MemoryCommitBytes))
		i--
		dAtA[i] = 0x20
	}
	if m.KernelTime_100Ns != 0 {
		i = encodeVarintRunhcs(dAtA, i, uint64(m.KernelTime_100Ns))
		i--
		dAtA[i] = 0x18
	}
	n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.CreatedAt, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.CreatedAt):])
	if err1 != nil {
		return 0, err1
	}
	i -= n1
	i = encodeVarintRunhcs(dAtA, i, uint64(n1))
	i--
	dAtA[i] = 0x12
	if len(m.ImageName) > 0 {
		i -= len(m.ImageName)
		copy(dAtA[i:], m.ImageName)
		i = encodeVarintRunhcs(dAtA, i, uint64(len(m.ImageName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintRunhcs(dAtA []byte, offset int, v uint64) int {
	offset -= sovRunhcs(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Options) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Debug {
		n += 2
	}
	if m.DebugType != 0 {
		n += 1 + sovRunhcs(uint64(m.DebugType))
	}
	l = len(m.RegistryRoot)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	l = len(m.SandboxImage)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	l = len(m.SandboxPlatform)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	if m.SandboxIsolation != 0 {
		n += 1 + sovRunhcs(uint64(m.SandboxIsolation))
	}
	l = len(m.BootFilesRootPath)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	if m.VmProcessorCount != 0 {
		n += 1 + sovRunhcs(uint64(m.VmProcessorCount))
	}
	if m.VmMemorySizeInMb != 0 {
		n += 1 + sovRunhcs(uint64(m.VmMemorySizeInMb))
	}
	l = len(m.GPUVHDPath)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	if m.ScaleCpuLimitsToSandbox {
		n += 2
	}
	if m.DefaultContainerScratchSizeInGb != 0 {
		n += 1 + sovRunhcs(uint64(m.DefaultContainerScratchSizeInGb))
	}
	if m.DefaultVmScratchSizeInGb != 0 {
		n += 1 + sovRunhcs(uint64(m.DefaultVmScratchSizeInGb))
	}
	if m.ShareScratch {
		n += 2
	}
	l = len(m.NCProxyAddr)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	l = len(m.LogLevel)
	if l > 0 {
		n += 2 + l + sovRunhcs(uint64(l))
	}
	if m.IoRetryTimeoutInSec != 0 {
		n += 2 + sovRunhcs(uint64(m.IoRetryTimeoutInSec))
	}
	if len(m.DefaultContainerAnnotations) > 0 {
		for k, v := range m.DefaultContainerAnnotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRunhcs(uint64(len(k))) + 1 + len(v) + sovRunhcs(uint64(len(v)))
			n += mapEntrySize + 2 + sovRunhcs(uint64(mapEntrySize))
		}
	}
	if m.NoInheritHostTimezone {
		n += 3
	}
	if m.ScrubLogs {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ImageName)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.CreatedAt)
	n += 1 + l + sovRunhcs(uint64(l))
	if m.KernelTime_100Ns != 0 {
		n += 1 + sovRunhcs(uint64(m.KernelTime_100Ns))
	}
	if m.MemoryCommitBytes != 0 {
		n += 1 + sovRunhcs(uint64(m.MemoryCommitBytes))
	}
	if m.MemoryWorkingSetPrivateBytes != 0 {
		n += 1 + sovRunhcs(uint64(m.MemoryWorkingSetPrivateBytes))
	}
	if m.MemoryWorkingSetSharedBytes != 0 {
		n += 1 + sovRunhcs(uint64(m.MemoryWorkingSetSharedBytes))
	}
	if m.ProcessID != 0 {
		n += 1 + sovRunhcs(uint64(m.ProcessID))
	}
	if m.UserTime_100Ns != 0 {
		n += 1 + sovRunhcs(uint64(m.UserTime_100Ns))
	}
	l = len(m.ExecID)
	if l > 0 {
		n += 1 + l + sovRunhcs(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRunhcs(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRunhcs(x uint64) (n int) {
	return sovRunhcs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Options) String() string {
	if this == nil {
		return "nil"
	}
	keysForDefaultContainerAnnotations := make([]string, 0, len(this.DefaultContainerAnnotations))
	for k, _ := range this.DefaultContainerAnnotations {
		keysForDefaultContainerAnnotations = append(keysForDefaultContainerAnnotations, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDefaultContainerAnnotations)
	mapStringForDefaultContainerAnnotations := "map[string]string{"
	for _, k := range keysForDefaultContainerAnnotations {
		mapStringForDefaultContainerAnnotations += fmt.Sprintf("%v: %v,", k, this.DefaultContainerAnnotations[k])
	}
	mapStringForDefaultContainerAnnotations += "}"
	s := strings.Join([]string{`&Options{`,
		`Debug:` + fmt.Sprintf("%v", this.Debug) + `,`,
		`DebugType:` + fmt.Sprintf("%v", this.DebugType) + `,`,
		`RegistryRoot:` + fmt.Sprintf("%v", this.RegistryRoot) + `,`,
		`SandboxImage:` + fmt.Sprintf("%v", this.SandboxImage) + `,`,
		`SandboxPlatform:` + fmt.Sprintf("%v", this.SandboxPlatform) + `,`,
		`SandboxIsolation:` + fmt.Sprintf("%v", this.SandboxIsolation) + `,`,
		`BootFilesRootPath:` + fmt.Sprintf("%v", this.BootFilesRootPath) + `,`,
		`VmProcessorCount:` + fmt.Sprintf("%v", this.VmProcessorCount) + `,`,
		`VmMemorySizeInMb:` + fmt.Sprintf("%v", this.VmMemorySizeInMb) + `,`,
		`GPUVHDPath:` + fmt.Sprintf("%v", this.GPUVHDPath) + `,`,
		`ScaleCpuLimitsToSandbox:` + fmt.Sprintf("%v", this.ScaleCpuLimitsToSandbox) + `,`,
		`DefaultContainerScratchSizeInGb:` + fmt.Sprintf("%v", this.DefaultContainerScratchSizeInGb) + `,`,
		`DefaultVmScratchSizeInGb:` + fmt.Sprintf("%v", this.DefaultVmScratchSizeInGb) + `,`,
		`ShareScratch:` + fmt.Sprintf("%v", this.ShareScratch) + `,`,
		`NCProxyAddr:` + fmt.Sprintf("%v", this.NCProxyAddr) + `,`,
		`LogLevel:` + fmt.Sprintf("%v", this.LogLevel) + `,`,
		`IoRetryTimeoutInSec:` + fmt.Sprintf("%v", this.IoRetryTimeoutInSec) + `,`,
		`DefaultContainerAnnotations:` + mapStringForDefaultContainerAnnotations + `,`,
		`NoInheritHostTimezone:` + fmt.Sprintf("%v", this.NoInheritHostTimezone) + `,`,
		`ScrubLogs:` + fmt.Sprintf("%v", this.ScrubLogs) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessDetails) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessDetails{`,
		`ImageName:` + fmt.Sprintf("%v", this.ImageName) + `,`,
		`CreatedAt:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CreatedAt), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`KernelTime_100Ns:` + fmt.Sprintf("%v", this.KernelTime_100Ns) + `,`,
		`MemoryCommitBytes:` + fmt.Sprintf("%v", this.MemoryCommitBytes) + `,`,
		`MemoryWorkingSetPrivateBytes:` + fmt.Sprintf("%v", this.MemoryWorkingSetPrivateBytes) + `,`,
		`MemoryWorkingSetSharedBytes:` + fmt.Sprintf("%v", this.MemoryWorkingSetSharedBytes) + `,`,
		`ProcessID:` + fmt.Sprintf("%v", this.ProcessID) + `,`,
		`UserTime_100Ns:` + fmt.Sprintf("%v", this.UserTime_100Ns) + `,`,
		`ExecID:` + fmt.Sprintf("%v", this.ExecID) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringRunhcs(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Options) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRunhcs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Options: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Options: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Debug", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Debug = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DebugType", wireType)
			}
			m.DebugType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DebugType |= Options_DebugType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegistryRoot", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegistryRoot = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SandboxImage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SandboxImage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SandboxPlatform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SandboxPlatform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SandboxIsolation", wireType)
			}
			m.SandboxIsolation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SandboxIsolation |= Options_SandboxIsolation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BootFilesRootPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BootFilesRootPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VmProcessorCount", wireType)
			}
			m.VmProcessorCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VmProcessorCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VmMemorySizeInMb", wireType)
			}
			m.VmMemorySizeInMb = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VmMemorySizeInMb |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GPUVHDPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GPUVHDPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScaleCpuLimitsToSandbox", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ScaleCpuLimitsToSandbox = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultContainerScratchSizeInGb", wireType)
			}
			m.DefaultContainerScratchSizeInGb = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultContainerScratchSizeInGb |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultVmScratchSizeInGb", wireType)
			}
			m.DefaultVmScratchSizeInGb = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultVmScratchSizeInGb |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShareScratch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ShareScratch = bool(v != 0)
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NCProxyAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NCProxyAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogLevel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogLevel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoRetryTimeoutInSec", wireType)
			}
			m.IoRetryTimeoutInSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IoRetryTimeoutInSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultContainerAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultContainerAnnotations == nil {
				m.DefaultContainerAnnotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRunhcs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRunhcs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRunhcs
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRunhcs
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRunhcs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRunhcs
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthRunhcs
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRunhcs(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRunhcs
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DefaultContainerAnnotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoInheritHostTimezone", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoInheritHostTimezone = bool(v != 0)
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrubLogs", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ScrubLogs = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRunhcs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRunhcs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRunhcs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ImageName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.CreatedAt, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelTime_100Ns", wireType)
			}
			m.KernelTime_100Ns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelTime_100Ns |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryCommitBytes", wireType)
			}
			m.MemoryCommitBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryCommitBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryWorkingSetPrivateBytes", wireType)
			}
			m.MemoryWorkingSetPrivateBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryWorkingSetPrivateBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryWorkingSetSharedBytes", wireType)
			}
			m.MemoryWorkingSetSharedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryWorkingSetSharedBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessID", wireType)
			}
			m.ProcessID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProcessID |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserTime_100Ns", wireType)
			}
			m.UserTime_100Ns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UserTime_100Ns |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRunhcs
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRunhcs
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRunhcs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRunhcs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRunhcs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRunhcs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRunhcs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRunhcs
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRunhcs
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRunhcs
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRunhcs        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRunhcs          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRunhcs = fmt.Errorf("proto: unexpected end of group")
)
