/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

/*
 * These values are used by MediaTek internally.
 * We can find these registers in "MT6363TP_PMIC_Design_Notice_for_MT8196G_V0.2".
 * The setting values are provided by MeidaTek designers.
 */

#include <console/console.h>
#include <soc/mt6363.h>

static const struct pmic_setting init_setting[] = {
	{0x16, 0xA, 0xA},
	{0x19, 0x1F, 0x1F},
	{0x21, 0x1, 0x1},
	{0x22, 0x1, 0x1},
	{0x47, 0x0, 0xFF},
	{0x4A, 0x0, 0x80},
	{0x55, 0x5, 0x5},
	{0x8E, 0x60, 0xFF},
	{0x91, 0xC0, 0xFF},
	{0xAD, 0x0, 0x38},
	{0x10F, 0x10, 0x10},
	{0x112, 0x4, 0x4},
	{0x12D, 0x1, 0x1},
	{0x139, 0x21, 0x21},
	{0x230, 0x0, 0x1},
	{0x413, 0x7, 0xFF},
	{0x416, 0x12, 0xFF},
	{0x417, 0x0, 0x7},
	{0x90D, 0x10, 0x10},
	{0x98A, 0x10, 0x10},
	{0xA08, 0x1, 0x1},
	{0xA0C, 0x78, 0x7F},
	{0xA0E, 0x0, 0x2},
	{0xA0F, 0x1, 0x1},
	{0xA10, 0xE0, 0xE0},
	{0xA14, 0x40, 0x60},
	{0xA22, 0x80, 0x80},
	{0xA26, 0xFF, 0xFF},
	{0xA27, 0xFF, 0xFF},
	{0xA28, 0xFF, 0xFF},
	{0xA29, 0xFF, 0xFF},
	{0xA2A, 0x1, 0x1},
	{0xA39, 0x35, 0xFF},
	{0xA3A, 0x1, 0xFF},
	{0xA3B, 0x2, 0xFF},
	{0xA3C, 0x1C, 0xFF},
	{0xA3D, 0x20, 0xFF},
	{0xA3E, 0x34, 0xFF},
	{0xA3F, 0x34, 0xFF},
	{0xA40, 0x3, 0xFF},
	{0xA41, 0x1E, 0xFF},
	{0xA42, 0x1C, 0xFF},
	{0xA43, 0x2B, 0xFF},
	{0xA44, 0x1F, 0xFF},
	{0xA45, 0x1F, 0xFF},
	{0xA46, 0x2, 0xFF},
	{0xA47, 0x1F, 0xFF},
	{0xA48, 0x22, 0xFF},
	{0xA49, 0x22, 0xFF},
	{0xA4A, 0x22, 0xFF},
	{0xA4B, 0xFF, 0xFF},
	{0xA4C, 0x21, 0xFF},
	{0xA4D, 0x24, 0xFF},
	{0xA4E, 0x34, 0xFF},
	{0xA4F, 0x24, 0xFF},
	{0xA50, 0x30, 0xFF},
	{0xA51, 0x2A, 0xFF},
	{0xA52, 0x2B, 0xFF},
	{0xA53, 0x22, 0xFF},
	{0xA54, 0x23, 0xFF},
	{0xA55, 0xFF, 0xFF},
	{0xA56, 0x34, 0xFF},
	{0xA57, 0x5, 0xFF},
	{0xA58, 0x20, 0xFF},
	{0xA59, 0xFF, 0xFF},
	{0xA5A, 0xFF, 0xFF},
	{0xA5B, 0xFF, 0xFF},
	{0xC88, 0x10, 0x10},
	{0xC89, 0x18, 0xFE},
	{0xC8A, 0x4, 0xFF},
	{0xC90, 0x44, 0x7F},
	{0xD08, 0x0, 0x1},
	{0xDA1, 0x4, 0x7},
	{0xE88, 0x0, 0x40},
	{0xE89, 0x40, 0x40},
	{0xF8C, 0x15, 0x15},
	{0xF8D, 0x5, 0x5},
	{0x1188, 0x0, 0x80},
	{0x140E, 0x0, 0x40},
	{0x1445, 0x0, 0xFF},
	{0x1446, 0x0, 0xFF},
	{0x1447, 0x0, 0xF},
	{0x1487, 0x6C, 0xFF},
	{0x1488, 0x0, 0x1},
	{0x148A, 0x19, 0x7F},
	{0x148B, 0x33, 0x7F},
	{0x1507, 0x40, 0xFF},
	{0x1508, 0x0, 0x1},
	{0x150A, 0x5, 0x7F},
	{0x150B, 0x19, 0x7F},
	{0x1587, 0xA8, 0xFF},
	{0x1588, 0x0, 0x1},
	{0x158A, 0x5, 0x7F},
	{0x158B, 0x19, 0x7F},
	{0x1607, 0x40, 0xFF},
	{0x1608, 0x0, 0x1},
	{0x160A, 0x5, 0x7F},
	{0x160B, 0x19, 0x7F},
	{0x1687, 0x78, 0xFF},
	{0x1688, 0x0, 0x1},
	{0x168A, 0xC, 0x7F},
	{0x168B, 0x19, 0x7F},
	{0x1707, 0x40, 0xFF},
	{0x1708, 0x0, 0x1},
	{0x170A, 0xC, 0x7F},
	{0x1787, 0x40, 0xFF},
	{0x1788, 0x0, 0x1},
	{0x178A, 0x5, 0x7F},
	{0x1807, 0x40, 0xFF},
	{0x1808, 0x0, 0x1},
	{0x180A, 0x5, 0x7F},
	{0x1887, 0x98, 0xFF},
	{0x1888, 0x0, 0x1},
	{0x188A, 0x19, 0x7F},
	{0x188B, 0x33, 0x7F},
	{0x1907, 0xA0, 0xFF},
	{0x1908, 0x0, 0x1},
	{0x190A, 0xC, 0x7F},
	{0x190B, 0x19, 0x7F},
	{0x198A, 0x2E, 0x2F},
	{0x198C, 0xF8, 0xF8},
	{0x198D, 0x32, 0x3F},
	{0x198F, 0xC, 0xC},
	{0x1990, 0xED, 0xFF},
	{0x1991, 0x10, 0xFF},
	{0x1992, 0x0, 0xF},
	{0x1995, 0x60, 0x60},
	{0x1996, 0x45, 0xFF},
	{0x1997, 0x2, 0x2},
	{0x1998, 0x10, 0x10},
	{0x1999, 0x2D, 0x2F},
	{0x199B, 0xF8, 0xF8},
	{0x199C, 0x32, 0x3F},
	{0x199E, 0xC, 0xC},
	{0x199F, 0xED, 0xFF},
	{0x19A0, 0x0, 0xFF},
	{0x19A4, 0x60, 0x60},
	{0x19A5, 0x45, 0xFF},
	{0x19A6, 0x2, 0x2},
	{0x19AC, 0x85, 0x87},
	{0x19AF, 0x0, 0x1},
	{0x19B4, 0x3, 0x87},
	{0x19B7, 0x0, 0x1},
	{0x1A08, 0x10, 0x10},
	{0x1A09, 0x2D, 0x2F},
	{0x1A0B, 0xF8, 0xF8},
	{0x1A0C, 0x32, 0x3F},
	{0x1A0E, 0xC, 0xC},
	{0x1A0F, 0xED, 0xFF},
	{0x1A10, 0x0, 0xFF},
	{0x1A12, 0x10, 0x50},
	{0x1A13, 0x2D, 0x2F},
	{0x1A14, 0xC1, 0xC1},
	{0x1A15, 0xFA, 0xFF},
	{0x1A16, 0x32, 0x3F},
	{0x1A18, 0xC, 0xC},
	{0x1A19, 0x77, 0xFF},
	{0x1A1A, 0xC0, 0xFF},
	{0x1A1B, 0x2B, 0x7F},
	{0x1A1C, 0x10, 0x50},
	{0x1A1D, 0x2D, 0x2F},
	{0x1A1E, 0xC1, 0xC1},
	{0x1A1F, 0xFA, 0xFF},
	{0x1A20, 0x32, 0x3F},
	{0x1A22, 0xC, 0xC},
	{0x1A23, 0x77, 0xFF},
	{0x1A24, 0xC0, 0xFF},
	{0x1A25, 0x2B, 0x7F},
	{0x1A27, 0x2E, 0x2F},
	{0x1A29, 0xF8, 0xF8},
	{0x1A2A, 0x32, 0x3F},
	{0x1A2C, 0xC, 0xC},
	{0x1A2D, 0xED, 0xFF},
	{0x1A2E, 0x10, 0xFF},
	{0x1A2F, 0x0, 0xF},
	{0x1A36, 0x4, 0xC},
	{0x1A37, 0xFE, 0xFF},
	{0x1A39, 0xCD, 0xFF},
	{0x1A3A, 0x7F, 0xFF},
	{0x1A3B, 0x7F, 0xFF},
	{0x1A3C, 0x45, 0xFF},
	{0x1A3D, 0xF0, 0xF0},
	{0x1A45, 0x6, 0x87},
	{0x1A4C, 0x6, 0x87},
	{0x1A53, 0x6, 0x87},
	{0x1A5A, 0x5, 0x87},
	{0x1A5D, 0x0, 0x78},
	{0x1A88, 0x10, 0x50},
	{0x1A89, 0x2D, 0x2F},
	{0x1A8B, 0xF8, 0xF8},
	{0x1A8C, 0x32, 0x3F},
	{0x1A8E, 0xC, 0xC},
	{0x1A8F, 0xED, 0xFF},
	{0x1A90, 0x0, 0xFF},
	{0x1A92, 0x10, 0x50},
	{0x1A93, 0x2D, 0x2F},
	{0x1A94, 0x0, 0x1},
	{0x1A95, 0xFC, 0xFF},
	{0x1A96, 0x32, 0x3F},
	{0x1A98, 0xC, 0xC},
	{0x1A99, 0xED, 0xFF},
	{0x1A9A, 0x0, 0xFF},
	{0x1A9B, 0x0, 0xF},
	{0x1A9C, 0x10, 0x10},
	{0x1A9D, 0x2D, 0x2F},
	{0x1A9E, 0xC1, 0xC1},
	{0x1A9F, 0xFA, 0xFF},
	{0x1AA0, 0x32, 0x3F},
	{0x1AA2, 0xC, 0xC},
	{0x1AA3, 0x77, 0xFF},
	{0x1AA4, 0xC0, 0xFF},
	{0x1AA5, 0x2B, 0x7F},
	{0x1AA6, 0x10, 0x10},
	{0x1AA7, 0x2D, 0x2F},
	{0x1AA8, 0xC1, 0xC1},
	{0x1AA9, 0xFA, 0xFF},
	{0x1AAA, 0x32, 0x3F},
	{0x1AAC, 0xC, 0xC},
	{0x1AAD, 0x77, 0xFF},
	{0x1AAE, 0xC0, 0xFF},
	{0x1AAF, 0x2B, 0x7F},
	{0x1AB7, 0xFC, 0xFE},
	{0x1AB9, 0xCD, 0xFF},
	{0x1ABA, 0xCD, 0xFF},
	{0x1ABB, 0x7F, 0xFF},
	{0x1ABC, 0x7F, 0xFF},
	{0x1ABD, 0xF0, 0xF0},
	{0x1ABE, 0x0, 0x20},
	{0x1AC5, 0x6, 0x87},
	{0x1ACC, 0x6, 0x87},
	{0x1AD3, 0x6, 0x87},
	{0x1ADA, 0x6, 0x87},
	{0x1ADD, 0x10, 0x78},
	{0x1B0D, 0xF, 0xF},
	{0x1B0E, 0x1, 0x1},
	{0x1B11, 0xFF, 0xFF},
	{0x1B14, 0xFF, 0xFF},
	{0x1B17, 0xFF, 0xFF},
	{0x1B1A, 0x1, 0x1},
	{0x1B33, 0x8, 0x8},
	{0x1B88, 0x10, 0x10},
	{0x1B89, 0x0, 0x80},
	{0x1B96, 0x10, 0x10},
	{0x1B97, 0x0, 0x80},
	{0x1BA4, 0x10, 0x10},
	{0x1BA5, 0x0, 0x80},
	{0x1BB2, 0x10, 0x10},
	{0x1BB3, 0x0, 0x80},
	{0x1BC0, 0x10, 0x10},
	{0x1BC1, 0x0, 0x80},
	{0x1BCE, 0x10, 0x10},
	{0x1BCF, 0x0, 0x80},
	{0x1C08, 0x10, 0x10},
	{0x1C09, 0x0, 0x80},
	{0x1C0E, 0x40, 0x40},
	{0x1C16, 0x10, 0x10},
	{0x1C17, 0x0, 0x80},
	{0x1C1C, 0x40, 0x40},
	{0x1C24, 0x10, 0x10},
	{0x1C25, 0x0, 0x80},
	{0x1C32, 0x10, 0x10},
	{0x1C33, 0x0, 0x80},
	{0x1C40, 0x10, 0x10},
	{0x1C41, 0x0, 0x80},
	{0x1C4E, 0x10, 0x10},
	{0x1C4F, 0x0, 0x80},
	{0x1C88, 0x10, 0x10},
	{0x1C89, 0x0, 0x80},
	{0x1C96, 0x10, 0x10},
	{0x1C97, 0x0, 0x80},
	{0x1CA4, 0x10, 0x10},
	{0x1CA5, 0x0, 0x80},
	{0x1CB2, 0x10, 0x10},
	{0x1CB3, 0x0, 0x80},
	{0x1CC0, 0x10, 0x10},
	{0x1CC1, 0x0, 0x80},
	{0x1D08, 0x10, 0x10},
	{0x1D09, 0x0, 0x80},
	{0x1D1E, 0x10, 0x10},
	{0x1D1F, 0x0, 0x80},
	{0x1D23, 0x20, 0x7F},
	{0x1D27, 0xC, 0x7F},
	{0x1D28, 0x19, 0x7F},
	{0x1D88, 0x10, 0x10},
	{0x1D89, 0x0, 0x80},
	{0x1D8D, 0x18, 0x7F},
	{0x1D91, 0x5, 0x7F},
	{0x1D92, 0x19, 0x7F},
	{0x1DA3, 0x10, 0x10},
	{0x1DA4, 0x0, 0x80},
	{0x1DA8, 0x4C, 0x7F},
	{0x1DAC, 0x5, 0x7F},
	{0x1DAD, 0x19, 0x7F},
	{0x1DB8, 0x14, 0x1C},
	{0x1DB9, 0xF, 0xF},
	{0x1DBA, 0xC0, 0xFF},
	{0x1DBC, 0x60, 0xFF},
	{0x1E08, 0x10, 0x10},
	{0x1E09, 0x0, 0x80},
	{0x1E0D, 0x7F, 0x7F},
	{0x1E11, 0xF, 0x7F},
	{0x1E12, 0x14, 0x7F},
	{0x1E1E, 0x10, 0x10},
	{0x1E1F, 0x0, 0x80},
	{0x1E27, 0xF, 0x7F},
	{0x1E28, 0x14, 0x7F},
	{0x1E88, 0x10, 0x10},
	{0x1E89, 0x0, 0x80},
	{0x1E8D, 0x7F, 0x7F},
	{0x1E91, 0x5, 0x7F},
	{0x1E92, 0x19, 0x7F},
	{0x1E9E, 0x10, 0x10},
	{0x1E9F, 0x0, 0x80},
	{0x1EA3, 0x58, 0x7F},
	{0x1EA7, 0xC, 0x7F},
	{0x1EA8, 0xC, 0x7F},
	{0x1F16, 0x2, 0x3},
	{0x1F17, 0x0, 0xF},
	{0x1F1B, 0x2, 0xF},
	{0x1F1E, 0x2, 0x3},
	{0x1F2A, 0x2, 0x3},
	{0x1F2E, 0x2, 0x3},
	{0x1F8A, 0x8, 0xC},
	{0x1F8C, 0x4, 0x6},
	{0x1F8E, 0x4, 0x6},
	{0x1F90, 0x4, 0x6},
	{0x1F94, 0x2, 0x3},
	{0x1F98, 0x1, 0x3},
	{0x1F9C, 0x1, 0x3},
	{0x1FA0, 0x2, 0x3},
	{0x1FA4, 0x8, 0xC},
	{0x1FAB, 0x8, 0xC},
	{0x1FAD, 0x4, 0x6},
	{0x1FB0, 0x0, 0x10},
	{0x2207, 0xE0, 0xE0},
	{0x2208, 0xE0, 0xE0},
	{0x2209, 0xE0, 0xE0},
	{0x220A, 0xE0, 0xE0},
	{0x2214, 0xF0, 0xF0},
	{0x2216, 0x0, 0x7},

	/* Add UVLO 2.0 setting. also need to modify dts setting for main pmic */
	{0xA5E, 0x2, 0x2},
	{0xA89, 0x4, 0xF},
	{0xA8A, 0x4, 0xF},
	{0xA95, 0x40, 0x40},
	/*
	 * 1. Set VS1_VOTER_VOSEL = 1.8875V
	 * 2. Set VS1_VOTER_EN = 0x8 (bit3 for VS1 users)
	 */
	{0x18A0, 0x97, 0xFF},
	{0x189A, 0x8, 0xFF},
	/*
	 * 1. Set VS2_VOTER_VOSEL = 1.275V
	 * 2. Set VS2_VOTER_EN = 0x48 (bit6/3 for VS2 users)
	 */
	{0x14A0, 0x66, 0xFF},
	{0x149A, 0x48, 0xFF},
	/*
	 * 1. Set VS3_VOTER_VOSEL = 0.975V
	 * 2. Set VS3_VOTER_EN = 0x8 (bit3 for VS3 users)
	 */
	{0x1920, 0x9C, 0xFF},
	{0x191A, 0x8, 0xFF},
};

void mt6363_init_setting(void)
{
	for (int i = 0; i < ARRAY_SIZE(init_setting); i++)
		mt6363_write_field(init_setting[i].addr, init_setting[i].val,
				   init_setting[i].mask, 0);

	/*
	 * TODO: Disable unused modem power in a separate function and
	 * call that function from mainboard folder.
	 */
	printk(BIOS_INFO, "%s done\n", __func__);
}
