
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_sstruct_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelax( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelax)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_NodeRelaxCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxDestroy( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxDestroy)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetMaxIter( void *relax_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetMaxIter)( relax_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetNodeset( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetNodeset)( relax_vdata, nodeset, nodeset_size, nodeset_stride, nodeset_indices );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetNodesetRank( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetNodesetRank)( relax_vdata, nodeset, nodeset_rank );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetNumNodesets( void *relax_vdata, HYPRE_Int num_nodesets )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetNumNodesets)( relax_vdata, num_nodesets );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetTempVec( void *relax_vdata, hypre_SStructPVector *t )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetTempVec)( relax_vdata, t );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetTol( void *relax_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetTol)( relax_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetWeight( void *relax_vdata, HYPRE_Real weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetWeight)( relax_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetZeroGuess( void *relax_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetZeroGuess)( relax_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NodeRelaxSetup( void *relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NodeRelaxSetup)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGCoarseSolve( void *ssamg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGCoarseSolve)( ssamg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGCoarseSolverDestroy( void *ssamg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGCoarseSolverDestroy)( ssamg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGCoarseSolverSetup( void *ssamg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGCoarseSolverSetup)( ssamg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGCoarsen( void *ssamg_vdata, hypre_SStructGrid *grid, HYPRE_Int *dxyz_flag, HYPRE_Real **dxyz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGCoarsen)( ssamg_vdata, grid, dxyz_flag, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGComputeDxyz( hypre_SStructMatrix *A, HYPRE_Real **dxyz, HYPRE_Int *dxyz_flag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGComputeDxyz)( A, dxyz, dxyz_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGComputeMaxLevels( hypre_SStructGrid *grid, HYPRE_Int *max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGComputeMaxLevels)( grid, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGComputeRAP( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructGrid **cgrid, HYPRE_Int *cdir_p, HYPRE_Int non_galerkin, hypre_SStructMatrix **Ac_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGComputeRAP)( A, P, cgrid, cdir_p, non_galerkin, Ac_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGComputeRAPNonGlk( hypre_SStructMatrix *A, hypre_SStructMatrix *P, HYPRE_Int *cdir_p, hypre_SStructMatrix **Ac_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGComputeRAPNonGlk)( A, P, cdir_p, Ac_ptr );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SSAMGCreate( hypre_MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGCreate)( comm );
}

/*--------------------------------------------------------------------------*/

hypre_SStructMatrix*
hypre_SSAMGCreateInterpOp( hypre_SStructMatrix *A, hypre_SStructGrid *cgrid, HYPRE_Int *cdir_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGCreateInterpOp)( A, cgrid, cdir_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGDestroy( void *ssamg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGDestroy)( ssamg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGGetFinalRelativeResidualNorm( void *ssamg_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGGetFinalRelativeResidualNorm)( ssamg_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGGetNumIterations( void *ssamg_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGGetNumIterations)( ssamg_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGPrintLogging( void *ssamg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGPrintLogging)( ssamg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGPrintStats( void *ssamg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGPrintStats)( ssamg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelax( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelax)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxCreate( MPI_Comm comm, HYPRE_Int nparts, void **relax_vdata_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxCreate)( comm, nparts, relax_vdata_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxDestroy( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxDestroy)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxGeneric( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxGeneric)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxJacobi( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxJacobi)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetActiveParts( void *relax_vdata, HYPRE_Int *active_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetActiveParts)( relax_vdata, active_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetMatvecData( void *relax_vdata, void *matvec_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetMatvecData)( relax_vdata, matvec_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetMaxIter( void *relax_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetMaxIter)( relax_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetNodeset( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_size, hypre_Index nodeset_stride, hypre_Index *nodeset_indices )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetNodeset)( relax_vdata, nodeset, nodeset_size, nodeset_stride, nodeset_indices );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetNodesetRank( void *relax_vdata, HYPRE_Int nodeset, HYPRE_Int nodeset_rank )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetNodesetRank)( relax_vdata, nodeset, nodeset_rank );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetNumNodesets( void *relax_vdata, HYPRE_Int num_nodesets )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetNumNodesets)( relax_vdata, num_nodesets );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetPostRelax( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetPostRelax)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetPreRelax( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetPreRelax)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetTempVec( void *relax_vdata, hypre_SStructVector *t )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetTempVec)( relax_vdata, t );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetTol( void *relax_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetTol)( relax_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetType( void *relax_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetType)( relax_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetWeights( void *relax_vdata, HYPRE_Real *weights )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetWeights)( relax_vdata, weights );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetZeroGuess( void *relax_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetZeroGuess)( relax_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGRelaxSetup( void *relax_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGRelaxSetup)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetCoarseSolverType( void *ssamg_vdata, HYPRE_Int csolver_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetCoarseSolverType)( ssamg_vdata, csolver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetDxyz( void *ssamg_vdata, HYPRE_Int nparts, HYPRE_Real **dxyz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetDxyz)( ssamg_vdata, nparts, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetInterpType( void *ssamg_vdata, HYPRE_Int interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetInterpType)( ssamg_vdata, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetLogging( void *ssamg_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetLogging)( ssamg_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetMaxCoarseSize( void *ssamg_vdata, HYPRE_Int max_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetMaxCoarseSize)( ssamg_vdata, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetMaxIter( void *ssamg_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetMaxIter)( ssamg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetMaxLevels( void *ssamg_vdata, HYPRE_Int max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetMaxLevels)( ssamg_vdata, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetNonGalerkinRAP( void *ssamg_vdata, HYPRE_Int non_galerkin )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetNonGalerkinRAP)( ssamg_vdata, non_galerkin );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetNumCoarseRelax( void *ssamg_vdata, HYPRE_Int num_coarse_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetNumCoarseRelax)( ssamg_vdata, num_coarse_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetNumPosRelax( void *ssamg_vdata, HYPRE_Int num_pos_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetNumPosRelax)( ssamg_vdata, num_pos_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetNumPreRelax( void *ssamg_vdata, HYPRE_Int num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetNumPreRelax)( ssamg_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetPrintFreq( void *ssamg_vdata, HYPRE_Int print_freq )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetPrintFreq)( ssamg_vdata, print_freq );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetPrintLevel( void *ssamg_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetPrintLevel)( ssamg_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetRelChange( void *ssamg_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetRelChange)( ssamg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetRelaxType( void *ssamg_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetRelaxType)( ssamg_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetRelaxWeight( void *ssamg_vdata, HYPRE_Real relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetRelaxWeight)( ssamg_vdata, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetSkipRelax( void *ssamg_vdata, HYPRE_Int skip_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetSkipRelax)( ssamg_vdata, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetTol( void *ssamg_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetTol)( ssamg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetZeroGuess( void *ssamg_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetZeroGuess)( ssamg_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetup( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetup)( ssamg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetupInterpOp( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetupInterpOp)( A, cdir_p, P, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSetupUInterpOp( hypre_SStructMatrix *A, HYPRE_Int *cdir_p, hypre_SStructMatrix *P, HYPRE_Int interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSetupUInterpOp)( A, cdir_p, P, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SSAMGSolve( void *ssamg_vdata, hypre_SStructMatrix *A, hypre_SStructVector *b, hypre_SStructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SSAMGSolve)( ssamg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovAxpy( HYPRE_Complex alpha, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SStructKrylovCAlloc( size_t count, size_t elt_size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovCAlloc)( count, elt_size, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovClearVector( void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovClearVector)( x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovCommInfo( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovCommInfo)( A, my_id, num_procs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovCopyVector( void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovCopyVector)( x, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SStructKrylovCreateVector( void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovCreateVector)( vvector );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SStructKrylovCreateVectorArray( HYPRE_Int n, void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovCreateVectorArray)( n, vvector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovDestroyVector( void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovDestroyVector)( vvector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovFree( void *ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovFree)( ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovIdentity( void *vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovIdentity)( vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovIdentitySetup( void *vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovIdentitySetup)( vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_SStructKrylovInnerProd( void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovInnerProdTagged( void *x, void *y, HYPRE_Int *num_tags_ptr, HYPRE_Complex **iprod_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovInnerProdTagged)( x, y, num_tags_ptr, iprod_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovMatvec( void *matvec_data, HYPRE_Complex alpha, void *A, void *x, HYPRE_Complex beta, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovMatvec)( matvec_data, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SStructKrylovMatvecCreate( void *A, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovMatvecCreate)( A, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovMatvecDestroy( void *matvec_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovMatvecDestroy)( matvec_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructKrylovScaleVector( HYPRE_Complex alpha, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructKrylovScaleVector)( alpha, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SStructSetRandomValues( void *v, HYPRE_Int seed )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SStructSetRandomValues)( v, seed );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SysPFMGCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGCreate)( comm );
}

/*--------------------------------------------------------------------------*/

hypre_SStructPMatrix *
hypre_SysPFMGCreateInterpOp( hypre_SStructPMatrix *A, HYPRE_Int cdir, hypre_Index stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGCreateInterpOp)( A, cdir, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGDestroy( void *sys_pfmg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGDestroy)( sys_pfmg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGGetFinalRelativeResidualNorm( void *sys_pfmg_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGGetFinalRelativeResidualNorm)( sys_pfmg_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGGetNumIterations( void *sys_pfmg_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGGetNumIterations)( sys_pfmg_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGPrintLogging( void *sys_pfmg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGPrintLogging)( sys_pfmg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelax( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelax)( sys_pfmg_relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SysPFMGRelaxCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxDestroy( void *sys_pfmg_relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxDestroy)( sys_pfmg_relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetJacobiWeight( void *sys_pfmg_relax_vdata, HYPRE_Real weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetJacobiWeight)( sys_pfmg_relax_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetMaxIter( void *sys_pfmg_relax_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetMaxIter)( sys_pfmg_relax_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetPostRelax( void *sys_pfmg_relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetPostRelax)( sys_pfmg_relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetPreRelax( void *sys_pfmg_relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetPreRelax)( sys_pfmg_relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetTempVec( void *sys_pfmg_relax_vdata, hypre_SStructPVector *t )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetTempVec)( sys_pfmg_relax_vdata, t );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetTol( void *sys_pfmg_relax_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetTol)( sys_pfmg_relax_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetType( void *sys_pfmg_relax_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetType)( sys_pfmg_relax_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetZeroGuess( void *sys_pfmg_relax_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetZeroGuess)( sys_pfmg_relax_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGRelaxSetup( void *sys_pfmg_relax_vdata, hypre_SStructPMatrix *A, hypre_SStructPVector *b, hypre_SStructPVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGRelaxSetup)( sys_pfmg_relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetDxyz( void *sys_pfmg_vdata, HYPRE_Real *dxyz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetDxyz)( sys_pfmg_vdata, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetJacobiWeight( void *sys_pfmg_vdata, HYPRE_Real weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetJacobiWeight)( sys_pfmg_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetLogging( void *sys_pfmg_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetLogging)( sys_pfmg_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetMaxIter( void *sys_pfmg_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetMaxIter)( sys_pfmg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetNumPostRelax( void *sys_pfmg_vdata, HYPRE_Int num_post_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetNumPostRelax)( sys_pfmg_vdata, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetNumPreRelax( void *sys_pfmg_vdata, HYPRE_Int num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetNumPreRelax)( sys_pfmg_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetPrintLevel( void *sys_pfmg_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetPrintLevel)( sys_pfmg_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetRelChange( void *sys_pfmg_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetRelChange)( sys_pfmg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetRelaxType( void *sys_pfmg_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetRelaxType)( sys_pfmg_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetSkipRelax( void *sys_pfmg_vdata, HYPRE_Int skip_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetSkipRelax)( sys_pfmg_vdata, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetTol( void *sys_pfmg_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetTol)( sys_pfmg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetZeroGuess( void *sys_pfmg_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetZeroGuess)( sys_pfmg_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetup( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetup)( sys_pfmg_vdata, A_in, b_in, x_in );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSetupInterpOp( hypre_SStructPMatrix *P, hypre_SStructPMatrix *A, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSetupInterpOp)( P, A, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGSolve( void *sys_pfmg_vdata, hypre_SStructMatrix *A_in, hypre_SStructVector *b_in, hypre_SStructVector *x_in )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGSolve)( sys_pfmg_vdata, A_in, b_in, x_in );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SysPFMGZeroDiagonal( hypre_SStructPMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SysPFMGZeroDiagonal)( A );
}


#endif

