/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once
//#pragma message "Entering Application.hpp"


/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QObject>
#include <QApplication>
#include <QSplashScreen>


/////////////////////// pappsomspp includes
#include <pappsomspp/core/processing/combiners/mzintegrationparams.h>


/////////////////////// libXpertMassCore includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


namespace MsXpS
{

namespace MineXpert
{

class ProgramWindow;

class Application: public QApplication
{
  Q_OBJECT

  Q_PROPERTY(
    QString m_description READ description WRITE setDescription USER true)

  ////////////////////////////// public //////////////////////////// /
  ////////////////////////////// public //////////////////////////////

  public:
  Application(int &argc, char **argv, const QString &application_name);
  ~Application();

  static Application *getInstance();

  void setProgramWindow(ProgramWindow *program_window_p);
  ProgramWindow *getProgramWindow();

  QString getApplicationName();

  void setDescription(const QString &desc);
  QString description();

  static void setUserConfigSettingsDirPath(const QString &dir_path);
  static QString getUserConfigSettingsDirPath();
  static void setUserConfigSettingsFilePath(const QString &file_path);
  static QString getUserConfigSettingsFilePath();

  // These settings are crucial throughout the whole program as they allow
  // storing the way bins are created when combining spectra. These config bits
  // are pretty stable because they depend on the mass spectrometer used to
  // acquire the data and, often, one works on lots of data from the same
  // instrument, so these config bits do not change. Store them to allow
  // for defaults.
  void saveMzIntegrationParamsToSettings(
    const pappso::MzIntegrationParams &mz_integration_params);
  void eraseMzIntegrationParamsFromSettings();
  pappso::MzIntegrationParams::InitializationResult
  getMzIntegrationParamsFromSavedSettings(
    pappso::MzIntegrationParams &mz_integration_params);



  ////////////////////////////// private //////////////////////////// /
  ////////////////////////////// private //////////////////////////////

  private:
  QString m_applicationName;
  QString m_organizationName = "MsXpertSuite";
  QString m_description = QString(
    "%1: a program to view and analyze mass spectrometric data").arg(m_applicationName);
  ProgramWindow *mp_programWindow = nullptr;

  // The splash screen, that vanishes after 2 seconds.
  QSplashScreen *mpa_splash;
  static QString m_userConfigSettingsDirPath;
  static QString m_userConfigSettingsFilePath;
};

} // namespace MineXpert

} // namespace MsXpS

// #pragma message "Exiting Application.hpp"
