# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessPolicy(_serialization.Model):
    """An Access policy.

    All required parameters must be populated in order to send to Azure.

    :ivar start: The start datetime from which the policy is active. Required.
    :vartype start: str
    :ivar expiry: The datetime that the policy expires. Required.
    :vartype expiry: str
    :ivar permission: The permissions for the acl policy. Required.
    :vartype permission: str
    """

    _validation = {
        "start": {"required": True},
        "expiry": {"required": True},
        "permission": {"required": True},
    }

    _attribute_map = {
        "start": {"key": "Start", "type": "str", "xml": {"name": "Start"}},
        "expiry": {"key": "Expiry", "type": "str", "xml": {"name": "Expiry"}},
        "permission": {"key": "Permission", "type": "str", "xml": {"name": "Permission"}},
    }
    _xml_map = {"name": "AccessPolicy"}

    def __init__(self, *, start: str, expiry: str, permission: str, **kwargs: Any) -> None:
        """
        :keyword start: The start datetime from which the policy is active. Required.
        :paramtype start: str
        :keyword expiry: The datetime that the policy expires. Required.
        :paramtype expiry: str
        :keyword permission: The permissions for the acl policy. Required.
        :paramtype permission: str
        """
        super().__init__(**kwargs)
        self.start = start
        self.expiry = expiry
        self.permission = permission


class CorsRule(_serialization.Model):
    """CORS is an HTTP feature that enables a web application running under one domain to access
    resources in another domain. Web browsers implement a security restriction known as same-origin
    policy that prevents a web page from calling APIs in a different domain; CORS provides a secure
    way to allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: The origin domains that are permitted to make a request against the
     service via CORS. The origin domain is the domain from which the request originates. Note that
     the origin must be an exact case-sensitive match with the origin that the user age sends to the
     service. You can also use the wildcard character '*' to allow all origin domains to make
     requests via CORS. Required.
    :vartype allowed_origins: str
    :ivar allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a
     CORS request. (comma separated). Required.
    :vartype allowed_methods: str
    :ivar allowed_headers: The request headers that the origin domain may specify on the CORS
     request. Required.
    :vartype allowed_headers: str
    :ivar exposed_headers: The response headers that may be sent in the response to the CORS
     request and exposed by the browser to the request issuer. Required.
    :vartype exposed_headers: str
    :ivar max_age_in_seconds: The maximum amount time that a browser should cache the preflight
     OPTIONS request. Required.
    :vartype max_age_in_seconds: int
    """

    _validation = {
        "allowed_origins": {"required": True},
        "allowed_methods": {"required": True},
        "allowed_headers": {"required": True},
        "exposed_headers": {"required": True},
        "max_age_in_seconds": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "allowed_origins": {"key": "AllowedOrigins", "type": "str", "xml": {"name": "AllowedOrigins"}},
        "allowed_methods": {"key": "AllowedMethods", "type": "str", "xml": {"name": "AllowedMethods"}},
        "allowed_headers": {"key": "AllowedHeaders", "type": "str", "xml": {"name": "AllowedHeaders"}},
        "exposed_headers": {"key": "ExposedHeaders", "type": "str", "xml": {"name": "ExposedHeaders"}},
        "max_age_in_seconds": {"key": "MaxAgeInSeconds", "type": "int", "xml": {"name": "MaxAgeInSeconds"}},
    }
    _xml_map = {"name": "CorsRule"}

    def __init__(
        self,
        *,
        allowed_origins: str,
        allowed_methods: str,
        allowed_headers: str,
        exposed_headers: str,
        max_age_in_seconds: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: The origin domains that are permitted to make a request against the
         service via CORS. The origin domain is the domain from which the request originates. Note that
         the origin must be an exact case-sensitive match with the origin that the user age sends to the
         service. You can also use the wildcard character '*' to allow all origin domains to make
         requests via CORS. Required.
        :paramtype allowed_origins: str
        :keyword allowed_methods: The methods (HTTP request verbs) that the origin domain may use for a
         CORS request. (comma separated). Required.
        :paramtype allowed_methods: str
        :keyword allowed_headers: The request headers that the origin domain may specify on the CORS
         request. Required.
        :paramtype allowed_headers: str
        :keyword exposed_headers: The response headers that may be sent in the response to the CORS
         request and exposed by the browser to the request issuer. Required.
        :paramtype exposed_headers: str
        :keyword max_age_in_seconds: The maximum amount time that a browser should cache the preflight
         OPTIONS request. Required.
        :paramtype max_age_in_seconds: int
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.exposed_headers = exposed_headers
        self.max_age_in_seconds = max_age_in_seconds


class GeoReplication(_serialization.Model):
    """GeoReplication.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The status of the secondary location. Required. Known values are: "live",
     "bootstrap", and "unavailable".
    :vartype status: str or ~azure.table.models.GeoReplicationStatusType
    :ivar last_sync_time: A GMT date/time value, to the second. All primary writes preceding this
     value are guaranteed to be available for read operations at the secondary. Primary writes after
     this point in time may or may not be available for reads. Required.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        "status": {"required": True},
        "last_sync_time": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "Status", "type": "str", "xml": {"name": "Status"}},
        "last_sync_time": {"key": "LastSyncTime", "type": "rfc-1123", "xml": {"name": "LastSyncTime"}},
    }
    _xml_map = {"name": "GeoReplication"}

    def __init__(
        self,
        *,
        status: Union[str, "_models.GeoReplicationStatusType"],
        last_sync_time: datetime.datetime,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the secondary location. Required. Known values are: "live",
         "bootstrap", and "unavailable".
        :paramtype status: str or ~azure.table.models.GeoReplicationStatusType
        :keyword last_sync_time: A GMT date/time value, to the second. All primary writes preceding
         this value are guaranteed to be available for read operations at the secondary. Primary writes
         after this point in time may or may not be available for reads. Required.
        :paramtype last_sync_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.last_sync_time = last_sync_time


class Logging(_serialization.Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to Azure.

    :ivar version: The version of Analytics to configure. Required.
    :vartype version: str
    :ivar delete: Indicates whether all delete requests should be logged. Required.
    :vartype delete: bool
    :ivar read: Indicates whether all read requests should be logged. Required.
    :vartype read: bool
    :ivar write: Indicates whether all write requests should be logged. Required.
    :vartype write: bool
    :ivar retention_policy: The retention policy. Required.
    :vartype retention_policy: ~azure.table.models.RetentionPolicy
    """

    _validation = {
        "version": {"required": True},
        "delete": {"required": True},
        "read": {"required": True},
        "write": {"required": True},
        "retention_policy": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "Version", "type": "str", "xml": {"name": "Version"}},
        "delete": {"key": "Delete", "type": "bool", "xml": {"name": "Delete"}},
        "read": {"key": "Read", "type": "bool", "xml": {"name": "Read"}},
        "write": {"key": "Write", "type": "bool", "xml": {"name": "Write"}},
        "retention_policy": {"key": "RetentionPolicy", "type": "RetentionPolicy"},
    }
    _xml_map = {"name": "Logging"}

    def __init__(
        self,
        *,
        version: str,
        delete: bool,
        read: bool,
        write: bool,
        retention_policy: "_models.RetentionPolicy",
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The version of Analytics to configure. Required.
        :paramtype version: str
        :keyword delete: Indicates whether all delete requests should be logged. Required.
        :paramtype delete: bool
        :keyword read: Indicates whether all read requests should be logged. Required.
        :paramtype read: bool
        :keyword write: Indicates whether all write requests should be logged. Required.
        :paramtype write: bool
        :keyword retention_policy: The retention policy. Required.
        :paramtype retention_policy: ~azure.table.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.version = version
        self.delete = delete
        self.read = read
        self.write = write
        self.retention_policy = retention_policy


class Metrics(_serialization.Model):
    """Metrics.

    All required parameters must be populated in order to send to Azure.

    :ivar version: The version of Analytics to configure.
    :vartype version: str
    :ivar enabled: Indicates whether metrics are enabled for the Table service. Required.
    :vartype enabled: bool
    :ivar include_apis: Indicates whether metrics should generate summary statistics for called API
     operations.
    :vartype include_apis: bool
    :ivar retention_policy: The retention policy.
    :vartype retention_policy: ~azure.table.models.RetentionPolicy
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "Version", "type": "str", "xml": {"name": "Version"}},
        "enabled": {"key": "Enabled", "type": "bool", "xml": {"name": "Enabled"}},
        "include_apis": {"key": "IncludeAPIs", "type": "bool", "xml": {"name": "IncludeAPIs"}},
        "retention_policy": {"key": "RetentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        version: Optional[str] = None,
        include_apis: Optional[bool] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The version of Analytics to configure.
        :paramtype version: str
        :keyword enabled: Indicates whether metrics are enabled for the Table service. Required.
        :paramtype enabled: bool
        :keyword include_apis: Indicates whether metrics should generate summary statistics for called
         API operations.
        :paramtype include_apis: bool
        :keyword retention_policy: The retention policy.
        :paramtype retention_policy: ~azure.table.models.RetentionPolicy
        """
        super().__init__(**kwargs)
        self.version = version
        self.enabled = enabled
        self.include_apis = include_apis
        self.retention_policy = retention_policy


class RetentionPolicy(_serialization.Model):
    """The retention policy.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Indicates whether a retention policy is enabled for the service. Required.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that metrics or logging or soft-deleted data should be
     retained. All data older than this value will be deleted.
    :vartype days: int
    """

    _validation = {
        "enabled": {"required": True},
        "days": {"minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "Enabled", "type": "bool", "xml": {"name": "Enabled"}},
        "days": {"key": "Days", "type": "int", "xml": {"name": "Days"}},
    }
    _xml_map = {"name": "RetentionPolicy"}

    def __init__(self, *, enabled: bool, days: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Indicates whether a retention policy is enabled for the service. Required.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that metrics or logging or soft-deleted data should
         be retained. All data older than this value will be deleted.
        :paramtype days: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class SignedIdentifier(_serialization.Model):
    """A signed identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar id: A unique id. Required.
    :vartype id: str
    :ivar access_policy: The access policy.
    :vartype access_policy: ~azure.table.models.AccessPolicy
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "Id", "type": "str", "xml": {"name": "Id"}},
        "access_policy": {"key": "AccessPolicy", "type": "AccessPolicy"},
    }
    _xml_map = {"name": "SignedIdentifier"}

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        access_policy: Optional["_models.AccessPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: A unique id. Required.
        :paramtype id: str
        :keyword access_policy: The access policy.
        :paramtype access_policy: ~azure.table.models.AccessPolicy
        """
        super().__init__(**kwargs)
        self.id = id
        self.access_policy = access_policy


class TableEntityQueryResponse(_serialization.Model):
    """The properties for the table entity query response.

    :ivar odata_metadata: The metadata response of the table.
    :vartype odata_metadata: str
    :ivar value: List of table entities.
    :vartype value: list[dict[str, any]]
    """

    _attribute_map = {
        "odata_metadata": {"key": "odata\\.metadata", "type": "str"},
        "value": {"key": "value", "type": "[{object}]"},
    }

    def __init__(
        self, *, odata_metadata: Optional[str] = None, value: Optional[List[Dict[str, Any]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword odata_metadata: The metadata response of the table.
        :paramtype odata_metadata: str
        :keyword value: List of table entities.
        :paramtype value: list[dict[str, any]]
        """
        super().__init__(**kwargs)
        self.odata_metadata = odata_metadata
        self.value = value


class TableProperties(_serialization.Model):
    """The properties for creating a table.

    :ivar table_name: The name of the table to create.
    :vartype table_name: str
    """

    _attribute_map = {
        "table_name": {"key": "TableName", "type": "str"},
    }

    def __init__(self, *, table_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword table_name: The name of the table to create.
        :paramtype table_name: str
        """
        super().__init__(**kwargs)
        self.table_name = table_name


class TableQueryResponse(_serialization.Model):
    """The properties for the table query response.

    :ivar odata_metadata: The metadata response of the table.
    :vartype odata_metadata: str
    :ivar value: List of tables.
    :vartype value: list[~azure.table.models.TableResponseProperties]
    """

    _attribute_map = {
        "odata_metadata": {"key": "odata\\.metadata", "type": "str"},
        "value": {"key": "value", "type": "[TableResponseProperties]"},
    }

    def __init__(
        self,
        *,
        odata_metadata: Optional[str] = None,
        value: Optional[List["_models.TableResponseProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword odata_metadata: The metadata response of the table.
        :paramtype odata_metadata: str
        :keyword value: List of tables.
        :paramtype value: list[~azure.table.models.TableResponseProperties]
        """
        super().__init__(**kwargs)
        self.odata_metadata = odata_metadata
        self.value = value


class TableResponseProperties(_serialization.Model):
    """The properties for the table response.

    :ivar table_name: The name of the table.
    :vartype table_name: str
    :ivar odata_type: The odata type of the table.
    :vartype odata_type: str
    :ivar odata_id: The id of the table.
    :vartype odata_id: str
    :ivar odata_edit_link: The edit link of the table.
    :vartype odata_edit_link: str
    """

    _attribute_map = {
        "table_name": {"key": "TableName", "type": "str"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "odata_id": {"key": "odata\\.id", "type": "str"},
        "odata_edit_link": {"key": "odata\\.editLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        odata_type: Optional[str] = None,
        odata_id: Optional[str] = None,
        odata_edit_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: The name of the table.
        :paramtype table_name: str
        :keyword odata_type: The odata type of the table.
        :paramtype odata_type: str
        :keyword odata_id: The id of the table.
        :paramtype odata_id: str
        :keyword odata_edit_link: The edit link of the table.
        :paramtype odata_edit_link: str
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.odata_type = odata_type
        self.odata_id = odata_id
        self.odata_edit_link = odata_edit_link


class TableResponse(TableResponseProperties):
    """The response for a single table.

    :ivar table_name: The name of the table.
    :vartype table_name: str
    :ivar odata_type: The odata type of the table.
    :vartype odata_type: str
    :ivar odata_id: The id of the table.
    :vartype odata_id: str
    :ivar odata_edit_link: The edit link of the table.
    :vartype odata_edit_link: str
    :ivar odata_metadata: The metadata response of the table.
    :vartype odata_metadata: str
    """

    _attribute_map = {
        "table_name": {"key": "TableName", "type": "str"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "odata_id": {"key": "odata\\.id", "type": "str"},
        "odata_edit_link": {"key": "odata\\.editLink", "type": "str"},
        "odata_metadata": {"key": "odata\\.metadata", "type": "str"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        odata_type: Optional[str] = None,
        odata_id: Optional[str] = None,
        odata_edit_link: Optional[str] = None,
        odata_metadata: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: The name of the table.
        :paramtype table_name: str
        :keyword odata_type: The odata type of the table.
        :paramtype odata_type: str
        :keyword odata_id: The id of the table.
        :paramtype odata_id: str
        :keyword odata_edit_link: The edit link of the table.
        :paramtype odata_edit_link: str
        :keyword odata_metadata: The metadata response of the table.
        :paramtype odata_metadata: str
        """
        super().__init__(
            table_name=table_name, odata_type=odata_type, odata_id=odata_id, odata_edit_link=odata_edit_link, **kwargs
        )
        self.odata_metadata = odata_metadata


class TableServiceError(_serialization.Model):
    """Table Service error.

    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "message": {"key": "Message", "type": "str", "xml": {"name": "Message"}},
    }

    def __init__(self, *, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.message = message


class TableServiceProperties(_serialization.Model):
    """Table Service Properties.

    :ivar logging: Azure Analytics Logging settings.
    :vartype logging: ~azure.table.models.Logging
    :ivar hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
     tables.
    :vartype hour_metrics: ~azure.table.models.Metrics
    :ivar minute_metrics: A summary of request statistics grouped by API in minute aggregates for
     tables.
    :vartype minute_metrics: ~azure.table.models.Metrics
    :ivar cors: The set of CORS rules.
    :vartype cors: ~azure.table.models.CorsRule
    """

    _attribute_map = {
        "logging": {"key": "Logging", "type": "Logging"},
        "hour_metrics": {"key": "HourMetrics", "type": "Metrics"},
        "minute_metrics": {"key": "MinuteMetrics", "type": "Metrics"},
        "cors": {
            "key": "Cors",
            "type": "[CorsRule]",
            "xml": {"name": "Cors", "wrapped": True, "itemsName": "CorsRule"},
        },
    }
    _xml_map = {"name": "StorageServiceProperties"}

    def __init__(
        self,
        *,
        logging: Optional["_models.Logging"] = None,
        hour_metrics: Optional["_models.Metrics"] = None,
        minute_metrics: Optional["_models.Metrics"] = None,
        cors: Optional[List["_models.CorsRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword logging: Azure Analytics Logging settings.
        :paramtype logging: ~azure.table.models.Logging
        :keyword hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
         tables.
        :paramtype hour_metrics: ~azure.table.models.Metrics
        :keyword minute_metrics: A summary of request statistics grouped by API in minute aggregates
         for tables.
        :paramtype minute_metrics: ~azure.table.models.Metrics
        :keyword cors: The set of CORS rules.
        :paramtype cors: ~azure.table.models.CorsRule
        """
        super().__init__(**kwargs)
        self.logging = logging
        self.hour_metrics = hour_metrics
        self.minute_metrics = minute_metrics
        self.cors = cors


class TableServiceStats(_serialization.Model):
    """Stats for the service.

    :ivar geo_replication: Geo-Replication information for the Secondary Storage Service.
    :vartype geo_replication: ~azure.table.models.GeoReplication
    """

    _attribute_map = {
        "geo_replication": {"key": "GeoReplication", "type": "GeoReplication"},
    }
    _xml_map = {"name": "StorageServiceStats"}

    def __init__(self, *, geo_replication: Optional["_models.GeoReplication"] = None, **kwargs: Any) -> None:
        """
        :keyword geo_replication: Geo-Replication information for the Secondary Storage Service.
        :paramtype geo_replication: ~azure.table.models.GeoReplication
        """
        super().__init__(**kwargs)
        self.geo_replication = geo_replication
