% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decontam.R
\name{isNotContaminant}
\alias{isNotContaminant}
\alias{isNotContaminant,ANY-method}
\title{Identify non-contaminant sequences.}
\usage{
isNotContaminant(seqtab, ...)

\S4method{isNotContaminant}{ANY}(
  seqtab,
  neg = NULL,
  method = "prevalence",
  threshold = 0.5,
  normalize = TRUE,
  detailed = FALSE
)
}
\arguments{
\item{seqtab}{(Required). Integer matrix.
A feature table recording the observed abundances of each sequence (or OTU) in each sample.
Rows should correspond to samples, and columns to sequences (or OTUs).}

\item{...}{Not used currently}

\item{neg}{(Required). \code{logical}
The negative control samples. Extraction controls give the best results.}

\item{method}{(Optional). Default "prevalence".
The method used to test for contaminants. Currently the only method supported is prevalence.
prevalence: Contaminants are identified by increased prevalence in negative controls.}

\item{threshold}{(Optional). Default \code{0.5}.
The probability threshold below which (strictly less than) the null-hypothesis (a contaminant) should be rejected in favor of the
alternate hypothesis (not a contaminant).}

\item{normalize}{(Optional). Default TRUE.
If TRUE, the input \code{seqtab} is normalized so that each row sums to 1 (converted to frequency).
If FALSE, no normalization is performed (the data should already be frequencies or counts from equal-depth samples).}

\item{detailed}{(Optional). Default FALSE.
If TRUE, the return value is a \code{data.frame} containing diagnostic information on the non-contaminant decision.
If FALSE, the return value is a \code{logical} vector containing the non-contaminant decisions.}
}
\value{
If \code{detailed=FALSE} a \code{logical} vector is returned, with TRUE indicating non-contaminants.
If \code{detailed=TRUE} a \code{data.frame} is returned instead.
}
\description{
The prevalence of each sequence (or OTU) in the input feature table across samples and negative controls
is used to identify non-contaminant sequences. Note that the null hypothesis
here is that sequences **are** contaminants. This function is intended for use on low-biomass samples
in which a large proportion of the sequences are likely to be contaminants.
}
\examples{
st <- readRDS(system.file("extdata", "st.rds", package="decontam"))
samdf <- readRDS(system.file("extdata", "samdf.rds", package="decontam"))
isNotContaminant(st, samdf$quant_reading, threshold=0.05)
}
