% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_frequency}
\alias{plot_frequency}
\title{Plot frequencies as a function of input DNA concentration}
\usage{
plot_frequency(
  seqtab,
  taxa,
  conc,
  neg = NULL,
  normalize = TRUE,
  showModels = TRUE,
  log = TRUE,
  facet = TRUE
)
}
\arguments{
\item{seqtab}{(Required). \code{Integer matrix} or \code{phyloseq} object.
A feature table recording the observed abundances of each sequence feature (e.g. OTUs or ASVs or
or genus or ortholog or...) in each sample.
Rows should correspond to samples, and columns to sequences (or OTUs).
If a phyloseq object is provided, the otu-table component will be extracted.}

\item{taxa}{(Required). \code{character}.
The names of the sequence features to include in this plot. Should match \code{colnames(setab)}
if a \code{matrix} was provided, or \code{taxa_names(seqtab)} if a \code{phyloseq} object was provided.}

\item{conc}{(Required). \code{numeric}.
A quantitative measure of the concentration of amplified DNA in each sample prior to sequencing.
All values must be greater than zero. Zero is assumed to represent the complete absence of DNA.
If \code{seqtab} was provided as a \code{phyloseq} object, the name of the sample variable in the
\code{phyloseq} object can be provided.}

\item{neg}{(Optional). \code{logical}. Default NULL.
TRUE if sample is a negative control, and FALSE if not.
If \code{seqtab} was provided as a phyloseq object, the name of the appropriate sample-variable in that
phyloseq object can be provided. NULL indicates no samples should be condired negative controls.}

\item{normalize}{(Optional). \code{logical}. Default TRUE.
If TRUE, the input \code{seqtab} is normalized so that each row sums to 1 (converted to frequency).
If FALSE, no normalization is performed (the data should already be frequencies or counts from
equal-depth samples).}

\item{showModels}{(Optional). \code{logical}. Default TRUE.
If TRUE, the contaminant (red, dashed line) and non-contaminant (black, solid line) models are
shown in the plot.}

\item{log}{(Optional). \code{logical}. Default TRUE.
If TRUE, the axes are log10-scaled.}

\item{facet}{(Optional). \code{logical}. Default TRUE.
If TRUE, multiple sequence features will be plotted in separate facets.}
}
\value{
A \code{\link{ggplot}2} object.
 Will be rendered to default device if \code{\link{print}ed},
 or can be stored and further modified.
 See \code{\link{ggsave}} for additional options.
}
\description{
Plots the frequencies of selected sequence features vs. each sample's DNA concentration.
}
\examples{
# MUC is a phyloseq object, MUC.conc is the vector of sample concentrations
MUC <- readRDS(system.file("extdata", "MUClite.rds", package="decontam"))
MUC.conc <- readRDS(system.file("extdata", "MUCconc.rds", package="decontam"))
plot_frequency(MUC, "Seq1", conc=MUC.conc)
# The concentration can also be reference directly as the quant_reading sample variable in MUC
plot_frequency(MUC, "Seq1", conc="quant_reading")
plot_frequency(MUC, c("Seq1", "Seq10", "Seq33"), conc="quant_reading", log=FALSE)

}
