% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_linter.R
\name{seq_linter}
\alias{seq_linter}
\title{Sequence linter}
\usage{
seq_linter()
}
\description{
This linter checks for \code{1:length(...)}, \code{1:nrow(...)}, \code{1:ncol(...)},
\code{1:NROW(...)} and \code{1:NCOL(...)} expressions in base-R, or their usage in
conjunction with \code{seq()} (e.g., \code{seq(length(...))}, \code{seq(nrow(...))}, etc.).
}
\details{
Additionally, it checks for \code{1:n()} (from \code{{dplyr}}) and \code{1:.N} (from \code{{data.table}}).

These often cause bugs when the right-hand side is zero.
Instead, it is safer to use \code{\link[base:seq]{base::seq_len()}} (to create a sequence of a specified \emph{length}) or
\code{\link[base:seq]{base::seq_along()}} (to create a sequence \emph{along} an object).
}
\examples{
# will produce lints
lint(
  text = "seq(length(x))",
  linters = seq_linter()
)

lint(
  text = "1:nrow(x)",
  linters = seq_linter()
)

lint(
  text = "dplyr::mutate(x, .id = 1:n())",
  linters = seq_linter()
)

lint(
  text = "seq_len(length(x))",
  linters = seq_linter()
)

lint(
  text = "unlist(lapply(x, seq_len))",
  linters = seq_linter()
)

# okay
lint(
  text = "seq_along(x)",
  linters = seq_linter()
)

lint(
  text = "seq_len(nrow(x))",
  linters = seq_linter()
)

lint(
  text = "dplyr::mutate(x, .id = seq_len(n()))",
  linters = seq_linter()
)

lint(
  text = "seq_along(x)",
  linters = seq_linter()
)

lint(
  text = "sequence(x)",
  linters = seq_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=default_linters]{default}, \link[=efficiency_linters]{efficiency}, \link[=robustness_linters]{robustness}
}
