% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_df_adjust.R
\name{format_df_adjust}
\alias{format_df_adjust}
\title{Format the name of the degrees-of-freedom adjustment methods}
\usage{
format_df_adjust(
  method,
  approx_string = "-approximated",
  dof_string = " degrees of freedom"
)
}
\arguments{
\item{method}{Name of the method.}

\item{approx_string, dof_string}{Suffix added to the name of the method in
the returned string.}
}
\value{
A formatted string.
}
\description{
Format the name of the degrees-of-freedom adjustment methods.
}
\examples{
library(parameters)

format_df_adjust("kenward")
format_df_adjust("kenward", approx_string = "", dof_string = " DoF")
}
