# Using OpenPGP cards with Relic

relic can use GnuPG scdaemon to interface with OpenPGP cards and other types of
smartcard supported by GnuPG. For example, the YubiKey NEO is an inexpensive
way to safeguard a RSA key for code signing purposes.

To do this, you will first need to generate a private key in the token. This can be done using the `gpg2 --edit-card` interface and `generate` command, or by generating a key in software and moving it to the card. It is recommended to make a backup of the private key in a safe location and/or to generate a revocation certificate at the time the key is generated. Once this has been done, relic can use the private key. Either the PGP certificate created by GnuPG can be used, or one or more additional PGP or X509 certificates can be created by relic using the private key on the card. relic only ever uses the private key, so it does not matter whether the configured certificate is the one originally generated by GnuPG as long as the public key is the same.

relic accesses the PGP card by connecting to GnuPG scdaemon over a UNIX socket. A sample systemd unit file `scdaemon@.service` is provided for starting scdaemon. For example, to start a scdaemon to access the first card on the system:

    systemctl enable --now scdaemon@0.service

This will create a UNIX socket at `/run/scdaemon/0/S.scdaemon` which relic can connect to. Place the following in your `relic.yml` in order to access it:

    tokens:
        scd0:
            type: scdaemon
            provider: /run/scdaemon/0/S.scdaemon
            pin: 123456
    keys:
        mykey:
            token: scd0
            id: OPENPGP.1
            pgpcertificate: certs/mykey.pgp

Either place the corresponding PGP certificate in the configured location, or make a new one using the existing private key by running:

    relic -c relic.yml pgp-generate -k mykey -n "My Key" >certs/mykey.pgp

Now you can create signatures:

    echo hello world | relic -c relic.yml sign-pgp -u mykey --clearsign

Information about the IDs of keys in the token, and the serial number of the token itself, can be displayed by running:

    relic -c relic.yml token contents -t scd0
